/* GKrellM Sound Scope
|  Copyright (C) 2002 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gkrellm/gkrellm.h>
#include <math.h>
#include <esd.h>
#include <rfftw.h>

#if  !defined(GKRELLM_VERSION_MAJOR) \
	|| (GKRELLM_VERSION_MAJOR==1 && GKRELLM_VERSION_MINOR==0) \
	|| (GKRELLM_VERSION_MAJOR==1 && GKRELLM_VERSION_MINOR==2 \
		&& GKRELLM_VERSION_REV<9)
#error This GKrellMSS plugin requires GKrellM version >= 1.2.9
#endif


#define	GKRELLMSS_VERSION_MAJOR	0
#define	GKRELLMSS_VERSION_MINOR	4

#define CONFIG_NAME     "Sound Scope"
#define CONFIG_KEYWORD  "sound"
#define STYLE_NAME      "sound"

#define	DEBUG()			(GK.debug == 45)

#define	SAMPLE_RATE		44100
#define	N_SAMPLES		1024
#define N_FFT_SAMPLES	8192

#define	HORIZONTAL_DIVS	5
#define	VERTICAL_DIVS	4

#define	CHANNEL_L	0
#define	CHANNEL_R	1
#define	CHANNEL_LR	2


typedef enum
	{
	Error,
	Standby,
	AutoStandby,
	Running,
	Unavailable
	}
	SoundStatus;


typedef struct
	{
	short		left,
				right;
	}
SoundSample;


#define	SOUND_MODE_OSCOPE	0
#define	SOUND_MODE_SPECTRUM	1
#define N_SOUND_MODES		2


typedef struct
	{
	gint		mode;
	GdkGC		*gc;
	Krell		*krell_left_peak,
				*krell_right_peak,
				*krell_left,
				*krell_right,
				*krell_sensitivity;

	gint		left_value,
				right_value,
				left_peak_value,
				right_peak_value;

	gint		vu_x0,
				x_sensitivity_raw,
				krell_sensitivity_y,
				krell_sensitivity_y_target,
				krell_sensitivity_y_up,
				krell_sensitivity_y_dn;

	gfloat		vert_sensitivity;

	gchar		*host;
	gint		fd;
	gint		input_id;
	gboolean	streaming,
				extra_info,
				mouse_in_chart,
				mode_button_pressed;
	gint		x_mouse;
	SoundStatus	status;

	gint		buf_count;
	gint		buf_len;
	gint		buf_index;
	SoundSample *buffer;
	}
	SoundMonitor;


typedef struct
	{
	gint	start_bar,
			x0_chart,
			x0_bar,
			dx_bar;

	gint	*freq_array;
	gint	array_size;
	double	freq_quantum;

	gint	n_samples;
	fftw_plan *plan;
	}
	SpectrumScale;


typedef struct
	{
	gint		fftw_samples;
	fftw_real	*fftw_data_in,
				*fftw_data_out,
				*fftw_power_spectrum;
	GdkPixmap	*bar,
				*bar_light;
	gint		scale_index;
	SpectrumScale *scale;
	gint		vert_max;
	gint		freq_highlighted,
				x_highlight;
	gboolean	reset;
	}
	Spectrum;


typedef struct
	{
	gint		usec_per_div,
				vert_max,
				dx_per_point;
	gboolean	dirty,
				reset;
	gfloat		vert_trigger;
	gfloat		t_sample,
				t_trace,
				samples_per_point;
	gint		x_append,
				y_append;
	}
Oscope;


#define LOW_SWEEP   100
#define HIGH_SWEEP  50000

#define	FORCE_RESET	1
#define	DRAW_GRID	1

extern SoundMonitor	*sound;
extern Chart		*chart;
extern Oscope		*oscope;
extern Spectrum		*spectrum;

extern Decal		*decal_label0,
					*decal_label1;

extern SoundStatus	sound_status(gchar *);
extern void			sound_open_stream(gchar *);
extern void			sound_close_stream(void);
extern void			oscope_trace(gint);

/* oscope */
void	draw_oscope(gboolean, gboolean);
void	oscope_horizontal_scaling(void);
void	init_oscope(void);


/* Spectrum analyzer */
void	draw_spectrum(gboolean, gboolean);
void	load_spectrum_images(void);
void	change_spectrum_scale(gint);
void	init_spectrum(void);
