
/*
*   GkrellM Internet Time plugin for GkrellM 
*   Copyright (C) 2001 - 2002 Eric Bianchi <eric.bianchi@dim.hcuge.ch> 
*    
*   This library is free software; you can redistribute it and/or
*   modify it under the terms of the GNU Lesser General Public
*   License as published by the Free Software Foundation; either
*   version 2.1 of the License, or (at your option) any later version.
*
*   This library is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with this library; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
* ---------------------------------------------------------------------------
*/

#include <gkrellm2/gkrellm.h>
#include <time.h>
#include <stdio.h>

/* Defines for gtk+-2.0 port */

#define VERSION_MAJOR       GKRELLM_VERSION_MAJOR
#define VERSION_MINOR       GKRELLM_VERSION_MINOR
#define VERSION_REV         GKRELLM_VERSION_REV
#define DEFAULT_STYLE       DEFAULT_STYLE_ID
#define LABEL_MAX           GKRELLM_LABEL_MAX

#define init_plugin         gkrellm_init_plugin

#define Monitor             GkrellmMonitor
#define TextStyle           GkrellmTextstyle
#define Decal               GkrellmDecal
#define Label               GkrellmLabel
#define Margin              GkrellmMargin
#define Style               GkrellmStyle
#define Krell               GkrellmKrell
#define Panel               GkrellmPanel
#define ChartConfig         GkrellmChartconfig
#define ChartLayer          GkrellmChartlayer
#define Chart               GkrellmChart
#define ChartData           GkrellmChartdata
#define DecalButton         GkrellmDecalbutton
#define Launcher            GkrellmLauncher
#define AlertDecal          GkrellmAlertdecal
#define Alert               GkrellmAlert
#define gkrellm_system(c)   g_spawn_command_line_async(c, NULL)

#define gkrellm_configure_panel gkrellm_panel_configure
#define gkrellm_destroy_panel   gkrellm_panel_destroy
#define gkrellm_draw_layers     gkrellm_draw_panel_layers
#define gkrellm_draw_layers_force gkrellm_draw_panel_layers_force

#define gkrellm_render_to_pixmap    gkrellm_scale_piximage_to_pixmap
#define gdk_imlib_set_image_border  gkrellm_set_piximage_border
#define gdk_imlib_create_image_from_xpm_data gkrellm_piximage_new_from_xpm_data 

#define gdk_imlib_load_image    gkrellm_piximage_new_from_file
#define gdk_imlib_kill_image    gkrellm_destroy_piximage
#define gdk_imlib_destroy_image gkrellm_destroy_piximage
#define gdk_imlib_paste_image   gkrellm_paste_piximage
#define GdkImlibBorder          GkrellmBorder
#define GdkImlibImage           GkrellmPiximage

#define gkrellm_chart_bg_image_override gkrellm_chart_bg_piximage_override
#define gkrellm_panel_bg_image_override gkrellm_panel_bg_piximage_override
#define gkrellm_load_image              gkrellm_load_piximage
#define gkrellm_set_image_border        gkrellm_set_gkrellmrc_piximage_border
#define gkrellm_get_gkrellmrc_image_border gkrellm_get_gkrellmrc_piximage_border#define gkrellm_bg_chart_image          gkrellm_bg_chart_piximage
#define gkrellm_bg_grid_image           gkrellm_bg_grid_piximage
#define gkrellm_bg_panel_image          gkrellm_bg_panel_piximage
#define gkrellm_bg_meter_image          gkrellm_bg_meter_piximage
#define gkrellm_krell_panel_image       gkrellm_krell_panel_piximage
#define gkrellm_krell_meter_image       gkrellm_krell_meter_piximage
#define gkrellm_krell_slider_image      gkrellm_krell_slider_piximage
#define gkrellm_krell_mini_image        gkrellm_krell_mini_piximage
#define gkrellm_get_decal_alarm_image   gkrellm_get_decal_alarm_piximage
#define gkrellm_get_decal_warn_image    gkrellm_get_decal_warn_piximage

#define gkrellm_create_tab          gkrellm_gtk_notebook_page
#define gkrellm_create_framed_tab   gkrellm_gtk_framed_notebook_page
#define gkrellm_launcher_table_new  gkrellm_gtk_launcher_table_new
#define gkrellm_entry_get_text      gkrellm_gtk_entry_get_text
#define gkrellm_spin_button         gkrellm_gtk_spin_button
#define gkrellm_check_button        gkrellm_gtk_check_button
#define gkrellm_check_button_connected gkrellm_gtk_check_button_connected
#define gkrellm_button_connected    gkrellm_gtk_button_connected
#define gkrellm_scrolled_vbox       gkrellm_gtk_scrolled_vbox
#define gkrellm_framed_vbox         gkrellm_gtk_framed_vbox
#define gkrellm_framed_vbox_end     gkrellm_gtk_framed_vbox_end
#define gkrellm_scrolled_text       gkrellm_gtk_scrolled_text_view
#define gkrellm_add_info_text       gkrellm_gtk_text_view_append_strings
#define gkrellm_add_info_text_string gkrellm_gtk_text_view_append
#define gkrellm_config_launcher     gkrellm_gtk_config_launcher

#define gkrellm_remove_and_destroy_decal(p,d) gkrellm_destroy_decal(d)
#define gkrellm_remove_and_destroy_krell(p,d) gkrellm_destroy_krell(d)

/* end defines for gtk+-2.0 port */

#define GKRELLM_ITIME_VERSION "1.0"

#define PLUGIN_PLACEMENT MON_CPU

#define TIME_LEN 10

#define TOTAL_NB_HOURS 24

#define STYLE_NAME "itime"

#define CONFIG_KEYWORD "itime"

#define CONFIG_NAME "GkrellMItime"

Monitor *init_plugin(void);

static gchar * itime_info_text[] = 
{
"<b>GKrellMItime -","GKrellM Internet Time.\n\n",
"GKrellMItime displays the Internet Time.\n\n",
"\t* The Internet Time is measured in \".beats\".\n",
"\t* One beat is the equivalent of 1 minute 26.4 seconds and A day is divided in 1000 beats.\n",
"\t* The Internet Time is the same all over the world.\n",
"\t* The Internet Time is based on a new meridian in Biel, Switzerland, the Biel MeanTime (BMT).\n\n",
"<b>Mouse actions :\n\n",
"\t* Left mouse button toggles the 2 digits decimal display .\n\n",
"<b>Configuration :\n\n",
"\t* Long display toggles the 2 digits decimal display.\n",
"\t* Time adjustment allows you to adjust your BMT Time (in hour).\n"
};

static Panel *panel;
static gint style_id, cal_style_id, clock_style_id;
static Monitor *monitor;
static Decal *decal_text1, *decal_symbol;
static gchar s_itime[TIME_LEN];

static GtkWidget *switch_decal_option, *display_type;

static GtkTooltips *itime_tips = 0;

static gint long_display = FALSE;
static gint decal_time = 0;

static void getBeats()
{
	struct tm * my_tm;
	time_t timer;
        double beat;
	int hour;

        time(&timer);
        my_tm = gmtime(&timer);

	/* We convert GMT Time in BMT Time by assuming that it is GMT + 1 */
	hour = (my_tm->tm_hour + 1 + decal_time) % TOTAL_NB_HOURS;

        beat = (hour * 3600) + (my_tm->tm_min * 60) + my_tm->tm_sec;
        beat = (beat  / (24 * 3600)) * 1000;

	sprintf(s_itime, (long_display ? "%3.2f" : "%3.1f"), beat);
}

static gint panel_expose_event( GtkWidget *widget, GdkEventExpose *ev )  {
	gdk_draw_pixmap( widget->window, widget->style->fg_gc[GTK_WIDGET_STATE(widget)], panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y, ev->area.width, ev->area.height );
	return FALSE;
}

static void update_itime()
{
	gint w,w_time;
	GkrellmTicks *g_ticks = gkrellm_ticks();

	if (g_ticks->second_tick) {
		getBeats();
		w = gdk_string_width(decal_symbol->text_style.font, "@");
		w_time = gdk_string_width(decal_text1->text_style.font, s_itime);
		decal_symbol->x_off = ((w + w_time) < decal_symbol->w) ? (decal_text1->w - (w + w_time)) / 2 : 0;
		decal_text1->x_off = decal_symbol->x_off + w + 2;

		gkrellm_draw_decal_text( panel, decal_symbol, "@", -1);
		gkrellm_draw_decal_text( panel, decal_text1, s_itime, -1);
		gkrellm_draw_panel_layers( panel );
	}
}

static gint cb_itime(GtkWidget *widget, GdkEventButton *ev)
{
	if (ev->button == 1 && ev->type == GDK_BUTTON_PRESS) {
		long_display = (long_display) ? FALSE : TRUE;
	}
	return TRUE;
}

static void create_itime(GtkWidget *vbox, gint first_create)
{
	Style *style;

	if( first_create )  {
		panel = gkrellm_panel_new0();
		getBeats();
	}

	style = gkrellm_panel_style( style_id );

	decal_symbol = gkrellm_create_decal_text( panel, "@",
						 gkrellm_meter_textstyle( cal_style_id ), style, -1, -1, -1 );

	decal_text1 = gkrellm_create_decal_text( panel, "0.8",
						 gkrellm_meter_textstyle( clock_style_id ), style,-1, -1, -1 );

	decal_symbol->y = decal_text1->y + decal_text1->h - decal_symbol->h;

	gkrellm_panel_configure( panel, NULL, style );
	gkrellm_panel_create( vbox, monitor, panel);

	if (itime_tips == NULL) {
		itime_tips = gtk_tooltips_new();
		gtk_tooltips_set_tip(itime_tips, panel->drawing_area, "GkrellMItime", NULL);
		gtk_tooltips_set_delay(itime_tips, 1000);
	}
	
	if( first_create )  {
		gtk_signal_connect( GTK_OBJECT (panel->drawing_area), "expose_event",(GtkSignalFunc)panel_expose_event, NULL );
		gtk_signal_connect( GTK_OBJECT (panel->drawing_area), "button_press_event", (GtkSignalFunc) cb_itime, panel);
	}
}

static void create_itime_tab(GtkWidget *tab_vbox)
{
	GtkWidget       *tabs, *text_help, *about_label, *label;
	GtkWidget       *vbox_help, *vbox_about;
	GtkWidget       *vbox;
	gchar 		*about_text = NULL;
	gint 		i;

        tabs = gtk_notebook_new();
        gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tabs), GTK_POS_TOP);
        gtk_box_pack_start(GTK_BOX(tab_vbox), tabs, TRUE, TRUE, 0);

	/* Configuration Tab */

	vbox = gkrellm_create_framed_tab(tabs, _("Options"));
	gkrellm_check_button(vbox, &display_type, long_display, FALSE, 10, _("Long display"));

	gkrellm_spin_button(vbox, &switch_decal_option,
			       (gfloat) decal_time, -12.0, 12.0, 1.0, 2.0, 0, 0,
			       NULL, NULL, FALSE, _("Time adjustment"));

	/* Info Tab */

	vbox_help = gkrellm_create_framed_tab(tabs, "Info");
        text_help = gkrellm_scrolled_text(vbox_help, NULL,GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 
	for (i = 0; i < sizeof(itime_info_text)/sizeof(gchar *); ++i)
                gkrellm_add_info_text_string(text_help, itime_info_text[i]);

	vbox_about = gkrellm_create_framed_tab(tabs, "About");
	label = gtk_label_new("");
        gtk_box_pack_start(GTK_BOX(vbox_about), label, TRUE, TRUE, 0);

	about_text = g_strdup_printf(
        "GKrellM Internet Time  %s\n" \
        "GKrellM Internet Time Plugin\n" \
        "\n" \
        "Copyright (C) 2001-2002 by Eric Bianchi\n" \
        "eric.bianchi@dim.hcuge.ch\n" \
        "\n" \
        "Released under the GNU Public License\n" \
        "GkrellM Internet Time comes with ABSOLUTELY NO WARRANTY\n" \
        , GKRELLM_ITIME_VERSION
	);

	about_label = gtk_label_new(about_text);
	gtk_box_pack_start(GTK_BOX(vbox_about), about_label, FALSE, FALSE, 0);
	g_free(about_text);

	label = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(vbox_about), label, TRUE, TRUE, 0);
}

static void apply_config(void)
{
	decal_time = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON(switch_decal_option));
	long_display = GTK_TOGGLE_BUTTON(display_type)->active;
}

static void save_config(FILE *f)
{
	fprintf(f,"%s long_display %d\n", CONFIG_KEYWORD, long_display);
	fprintf(f,"%s decal_time %d\n", CONFIG_KEYWORD, decal_time); 
}

static void load_config(gchar * arg)
{
	gchar   config[32], item[CFG_BUFSIZE];
        gint    n;

        n = sscanf(arg, "%31s %[^\n]", config, item);
        if (n != 2)
                return;
        if (!strcmp(config, "long_display"))
		sscanf(item, "%d", &long_display);
	else if (!strcmp(config, "decal_time"))
		sscanf(item, "%d", &decal_time);
}

static Monitor itime_mon  =
	{
		CONFIG_NAME,   /* Name, for config tab.        */
		0,             /* Id,  0 if a plugin           */
		create_itime,  /* The create_plugin() function */
		update_itime,  /* The update_plugin() function */
		create_itime_tab, /* The create_plugin_tab() config function */
		apply_config,  /* The apply_plugin_config() function      */
		
		save_config,   /* The save_plugin_config() function  */
		load_config,   /* The load_plugin_config() function  */
		STYLE_NAME,    /* config keyword                     */
		
		NULL,           /* Undefined 2  */
		NULL,           /* Undefined 1  */
		NULL,           /* Undefined 0  */
		
		PLUGIN_PLACEMENT, /* Insert plugin before this monitor.       */
		NULL,           /* Handle if a plugin, filled in by GKrellM */
		NULL            /* path if a plugin, filled in by GKrellM   */
	};

	
Monitor *init_plugin(void)
{ 
	style_id = gkrellm_add_meter_style( &itime_mon, STYLE_NAME );
	cal_style_id = gkrellm_lookup_meter_style_id(CAL_STYLE_NAME);
	clock_style_id = gkrellm_lookup_meter_style_id(CLOCK_STYLE_NAME);

	monitor = &itime_mon;
	return &itime_mon;
}
