/*
    win32 port by Bill Nalen
    bill@nalens.com
*/

// based on

// VolumeControl.cpp: implementation of the CVolumeControl class.
//
// Author:  Bill Oatman
// Version: 1.0
//          http://www.netacc.net/~waterbry/BillsApps.htm
//
//////////////////////////////////////////////////////////////////////


/* GKrellM Volume plugin
 |  Copyright (C) 1999-2000 Sjoerd Simons
 |
 |  Author:  Sjoerd Simons  sjoerd@luon.net
 |
 |  This program is free software which I release under the GNU General Public
 |  License. You may redistribute and/or modify this program under the terms
 |  of that license as published by the Free Software Foundation; either
 |  version 2 of the License, or (at your option) any later version.
 |
 |  This program is distributed in the hope that it will be useful,
 |  but WITHOUT ANY WARRANTY; without even the implied warranty of
 |  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |  GNU General Public License for more details.
 |
 |  To get a copy of the GNU General Puplic License,  write to the
 |  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include "mixer.h"
#include "common_mixer.h"

void fixName(char* name)
{
    unsigned int i;

    for (i = 0; i < strlen(name); i++) {
        if (name[i] == ' ') 
            name[i] = '_';
    }
}

/* tries to open a mixer device, returns NULL on error or otherwise an mixer_t
 * struct */
mixer_t *mixer_open(char *id) {
    mixer_t *result = NULL;
    int nr;
    MIXERCAPS mxCaps;
    int numMixers;
    MIXERLINE mxl;
    MIXERCONTROL mxc;
    MIXERLINECONTROLS mxlc;
    HMIXER hMixer;
    int j, numConn;

    fixName(id);

    numMixers = mixerGetNumDevs();
	if (numMixers != 0)
	{
	    hMixer = NULL;
	    ZeroMemory(&mxCaps, sizeof(MIXERCAPS));

        if (mixerOpen(&hMixer, 0, 0, 0, MIXER_OBJECTF_MIXER) != MMSYSERR_NOERROR) {
			return NULL;
        }

        if (mixerGetDevCaps((UINT)hMixer, &mxCaps, sizeof(MIXERCAPS)) != MMSYSERR_NOERROR) {
			return NULL;
        }

		// get dwLineID
		mxl.cbStruct = sizeof(MIXERLINE);
		mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS;

        if (strcmp(id, "Master") != 0) {
            mxl.dwDestination = 0;
            mixerGetLineInfo((HMIXEROBJ)hMixer,&mxl,MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_DESTINATION);

            numConn = mxl.cConnections;
		    for (j = 0; j < numConn; j++)
		    {
			    // ...get info upon that source line
			    mxl.cbStruct = sizeof(MIXERLINE);
			    mxl.dwDestination = 0;
			    mxl.dwSource = j;

			    mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl, MIXER_GETLINEINFOF_SOURCE);

                fixName(mxl.szShortName);

                if (strcmp(mxl.szShortName, id) == 0) {
                    result = malloc(sizeof(mixer_t));
                    result->name = g_strdup(mxl.szShortName);
                    result->hMixer = hMixer;
                    break;
                }
            }
        }
        else {        
            if(mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl, MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_COMPONENTTYPE) != MMSYSERR_NOERROR)
	    		return NULL;
            result = malloc(sizeof(mixer_t));
            result->name = g_strdup("Master");
            result->hMixer = hMixer;
        }

        if (result == NULL)
            return NULL;

        nr = -1;

        // now retrieve the devices

		// Volume control
		mxlc.cbStruct = sizeof(MIXERLINECONTROLS);
		mxlc.dwLineID = mxl.dwLineID;
		mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
		mxlc.cControls = 1;
		mxlc.cbmxctrl = sizeof(MIXERCONTROL);
		mxlc.pamxctrl = &mxc;
        if(mixerGetLineControls((HMIXEROBJ)hMixer,&mxlc,MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE) == MMSYSERR_NOERROR) {
		    // save record dwControlID
            ++nr;
		    result->minimum[nr] = mxc.Bounds.dwMinimum;
		    result->maximum[nr] = mxc.Bounds.dwMaximum;
		    result->controlID[nr] = mxc.dwControlID;
            result->dev_rnames[nr] = g_strdup("Vol");
            result->dev_names[nr] = g_strdup("Vol");
        }

        // Bass control
		mxlc.cbStruct = sizeof(MIXERLINECONTROLS);
		mxlc.dwLineID = mxl.dwLineID;
		mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_BASS;
		mxlc.cControls = 1;
		mxlc.cbmxctrl = sizeof(MIXERCONTROL);
		mxlc.pamxctrl = &mxc;
        if(mixerGetLineControls((HMIXEROBJ)hMixer,&mxlc,MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE) == MMSYSERR_NOERROR) {
            ++nr;
		    result->minimum[nr] = mxc.Bounds.dwMinimum;
		    result->maximum[nr] = mxc.Bounds.dwMaximum;
		    result->controlID[nr] = mxc.dwControlID;
            result->dev_rnames[nr] = g_strdup("Bass");
            result->dev_names[nr] = g_strdup("Bass");
        }

        // treble control
		mxlc.cbStruct = sizeof(MIXERLINECONTROLS);
		mxlc.dwLineID = mxl.dwLineID;
		mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_TREBLE;
		mxlc.cControls = 1;
		mxlc.cbmxctrl = sizeof(MIXERCONTROL);
		mxlc.pamxctrl = &mxc;
        if(mixerGetLineControls((HMIXEROBJ)hMixer,&mxlc,MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE) == MMSYSERR_NOERROR) {
            ++nr;
		    result->minimum[nr] = mxc.Bounds.dwMinimum;
		    result->maximum[nr] = mxc.Bounds.dwMaximum;
		    result->controlID[nr] = mxc.dwControlID;
            result->dev_rnames[nr] = g_strdup("Treb");
            result->dev_names[nr] = g_strdup("Treb");
        }
	}
	else
		return NULL;

    result->nrdevices = nr + 1;

    return result;
}

void mixer_close(mixer_t *mixer) {
    int i;

	if (mixer->hMixer != NULL)
	{
		mixerClose(mixer->hMixer);
		mixer->hMixer = NULL;
	}

    for (i=0;i < mixer->nrdevices; i++) {
		mixer->controlID[i] = 0;
        g_free(mixer->dev_names[i]);
        g_free(mixer->dev_rnames[i]);
    }
    g_free(mixer->name);
    free(mixer);

	return;
}

/* Returns a pointer to the name of the mixer */
/* Shouldn't be freed */
char *mixer_get_name(mixer_t *mixer) {
  return mixer->name;
}
/* Returns the number of devices a mixer has */
int   mixer_get_nr_devices(mixer_t *mixer) {
  return mixer->nrdevices;
}

/* devid is the number of a device in a mixer */
/* 0 <= devid < mixer_get_nr_devices(mixer) */
/* get the real name of a device */
char *mixer_get_device_real_name(mixer_t *mixer,int devid) {
  return mixer->dev_rnames[devid];
}
/* get and set the user specified name of a device */
char *mixer_get_device_name(mixer_t *mixer,int devid) {
  return mixer->dev_names[devid] != NULL ? 
                            mixer->dev_names[devid] : mixer->dev_rnames[devid];
}

void  mixer_set_device_name(mixer_t *mixer,int devid,char *name) {
  fixName(name);
  g_free(mixer->dev_names[devid]);
  mixer->dev_names[devid] = g_strdup(name);
}

/* get the full scale of a device and get/set the volume */
long mixer_get_device_fullscale(mixer_t *mixer,int devid) {
    return mixer->maximum[devid] - mixer->minimum[devid];
}

void mixer_get_device_volume(mixer_t *mixer, int devid,int *left,int *right) {
    MIXERCONTROLDETAILS_UNSIGNED mxcdVolume;
	MIXERCONTROLDETAILS mxcd;

    if (mixer->hMixer == NULL) {
        *left = 0;
        *right = 0;
		return;
    }

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS);
	mxcd.dwControlID = mixer->controlID[devid];
	mxcd.cChannels = 1;
	mxcd.cMultipleItems = 0;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	mxcd.paDetails = &mxcdVolume;
    if (mixerGetControlDetails((HMIXEROBJ) mixer->hMixer, &mxcd, MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE) != MMSYSERR_NOERROR) {
        *left = 0;
        *right = 0;
		return;
    }

    *left = mxcdVolume.dwValue - mixer->minimum[devid];
    *right = mxcdVolume.dwValue - mixer->minimum[devid];
    //return mxcdVolume.dwValue - mixer->minimum[devid];
}

void  mixer_set_device_volume(mixer_t *mixer, int devid,int left,int right) {
    MIXERCONTROLDETAILS_UNSIGNED mxcdVolume;
	MIXERCONTROLDETAILS mxcd;

	if (mixer->hMixer == NULL)
		return;

    if (left >= right) 
        mxcdVolume.dwValue = left + mixer->minimum[devid];
    else
        mxcdVolume.dwValue = right + mixer->minimum[devid];

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS);
	mxcd.dwControlID = mixer->controlID[devid];
	mxcd.cChannels = 1;
	mxcd.cMultipleItems = 0;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	mxcd.paDetails = &mxcdVolume;
	if (mixerSetControlDetails((HMIXEROBJ)mixer->hMixer, &mxcd, MIXER_OBJECTF_HMIXER | MIXER_SETCONTROLDETAILSF_VALUE) != MMSYSERR_NOERROR)
		return;
}

mixer_idz_t *mixer_get_id_list(void) {
	MIXERLINE mxl;
    HMIXER hMixer;
    MIXERCAPS mxCaps;
    int numMixers;
    mixer_idz_t *result = NULL;
    int j, numConn;

    result = mixer_id_list_add("Master", result); 

    numMixers = mixerGetNumDevs();
	if (numMixers != 0)
	{
	    hMixer = NULL;
	    ZeroMemory(&mxCaps, sizeof(MIXERCAPS));

        if (mixerOpen(&hMixer, 0, 0, 0, MIXER_OBJECTF_MIXER) != MMSYSERR_NOERROR) {
			return NULL;
        }

        if (mixerGetDevCaps((UINT)hMixer, &mxCaps, sizeof(MIXERCAPS)) != MMSYSERR_NOERROR) {
			return NULL;
        }

		// get dwLineID
		mxl.cbStruct = sizeof(MIXERLINE);
		mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS;

        mxl.dwDestination = 0;
        mixerGetLineInfo((HMIXEROBJ)hMixer,&mxl,MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_DESTINATION);

        numConn = mxl.cConnections;
		for (j = 0; j < numConn; j++)
		{
			// ...get info upon that source line
			mxl.cbStruct = sizeof(MIXERLINE);
			mxl.dwDestination = 0;
			mxl.dwSource = j;

			mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl, MIXER_GETLINEINFOF_SOURCE);

            fixName(mxl.szShortName);

            result = mixer_id_list_add(mxl.szShortName, result);
        }
    }

  return result;
}

double rint(double arg)
{
    int iarg = (int) arg;

    if (arg - iarg < 0.5)
        return floor(arg);
    else
        return ceil(arg);
}
