/* GKrellM
|  Copyright (C) 1999-2003 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gkrellmd.h"
#include "../src/gkrellm-sysdeps.h"

#if defined(__linux__)
#include "../src/sysdeps/linux.c"
#endif

#if defined(__APPLE__)
#include "../src/sysdeps/darwin.c"
#include "../src/sysdeps/bsd-common.c"
#endif

#if defined(__FreeBSD__)
#include "../src/sysdeps/freebsd.c"
#include "../src/sysdeps/bsd-common.c"
#endif

#if defined(__NetBSD__)
#include "../src/sysdeps/netbsd.c"
#include "../src/sysdeps/bsd-net-open.c"
#include "../src/sysdeps/bsd-common.c"
#endif

#if defined(__OpenBSD__)
#include "../src/sysdeps/openbsd.c"
#include "../src/sysdeps/bsd-net-open.c"
#include "../src/sysdeps/bsd-common.c"
#endif


#if defined(__solaris__)
#include "../src/sysdeps/solaris.c"
#endif

#if defined(USE_LIBGTOP)
#include "../src/sysdeps/gtop.c"
#endif

#include <sys/utsname.h>

gchar *
gkrellm_sys_get_host_name(void)
	{
	static gboolean	have_it;
	static gchar	buf[128];

	if (!have_it && gethostname(buf, sizeof(buf)))
		strcpy(buf, "unknown");
	have_it = TRUE;
	return buf;
	}

gchar *
gkrellm_sys_get_system_name(void)
	{
	static gchar	*sname;
	struct utsname	utsn;

	if (!sname && uname(&utsn) > -1)
		sname = g_strdup_printf("%s %s", utsn.sysname, utsn.release);
	if (!sname)
		sname = g_strdup("unknown name");
	return sname;
	}


  /* Remove embedded "-i2c-" or "-isa-" from lm_sensors chip names so
  |  there can be a chance for config name sysfs compatibility.  This function
  |  here in sensors.c is a kludge.  Give user configs a chance to get
  |  converted and then move this function to sysdeps/linux.c where it
  |  belongs.
  |  Munge names like w83627hf-isa-0290 to w83627hf-0290
  |                or w83627hf-i2c-0-0290 to w83627hf-0-0290
  */
void
gkrellm_sensors_linux_name_fix(gchar *id_name)
	{
#if defined(__linux__)
	gchar	*s;
	gint	len, bus = 0;
	guint	addr = 0;

	len = strlen(id_name) + 1;
	if ((s = strstr(id_name, "-i2c-")) != NULL)
		{
		sscanf(s + 5, "%d-%x", &bus, &addr);
		snprintf(s, len - (s - id_name), "-%d-%04x", bus, addr);
		}
	else if ((s = strstr(id_name, "-isa-")) != NULL)
		{
		*(s + 1) = '0';
		memmove(s + 2, s + 4, strlen(s + 4) + 1);
		}
#endif
	}
