/* GKrellM
|  Copyright (C) 1999-2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gkrellm.h"
#include "gkrellm_private_proto.h"

/* ----------------------------------------------------------------------*/
/* Hostname label on the top frame event_box. */

static Panel		*host;
static Decal		*decal_host;

static GtkWidget	*host_pixmapwid;	/* Shown if hostname is not */
static GdkPixmap	*host_pixmap;
static GdkBitmap	*host_mask;
static gint			host_pixmap_height;
static gint			host_pixmap_visible;

static gint			style_id;

static gint			hostname_visible,
					hostname_short;

static gchar		hostname[128];


static gint
host_expose_event(GtkWidget *widget, GdkEventExpose *ev)
	{
	if (widget == host->drawing_area)
		{
		gdk_draw_pixmap(widget->window, GK.draw1_GC, host->pixmap,
			ev->area.x, ev->area.y, ev->area.x, ev->area.y,
			ev->area.width, ev->area.height);
		}
	return FALSE;
	}


static void
draw_hostname()
	{
	TextStyle	*ts;
	gchar		*s, buf[128];
	gint		w;

	if (!hostname_visible)
		return;
	ts = gkrellm_meter_textstyle(style_id);
	strncpy(buf, hostname, sizeof(buf) - 1);
	buf[sizeof(buf) - 1] = '\0';
	if (UC.hostname_short)
		{
		s = strchr(buf, (int) '.');
		if (s)
			*s = '\0';
		}
	w = gdk_string_width(ts->font, buf);
	if (w > decal_host->w)
		{
		ts = gkrellm_meter_alt_textstyle(style_id);
		w = gdk_string_width(ts->font, buf);
		}
	decal_host->x_off = (decal_host->w - w) / 2;
	if (decal_host->x_off < 0)
		decal_host->x_off = 0;
	decal_host->text_style.font = ts->font;
	gkrellm_draw_decal_text(host, decal_host, buf, -1);
	gkrellm_draw_layers(host);
	}

void
create_hostname(GtkWidget *vbox, gint first_create)
	{
	GdkImlibImage	*bg_image;
	Style			*style;

	if (first_create)
		host = gkrellm_panel_new0();
	else
		gkrellm_destroy_decal_list(host);

	if (gethostname(hostname, sizeof(hostname)))
		strcpy(hostname, "unknown");
	style = gkrellm_meter_style(style_id);
	host->textstyle = gkrellm_meter_textstyle(style_id);

	decal_host = gkrellm_create_decal_text(host, hostname,
					host->textstyle, style, -1, -1, -1);

	gkrellm_configure_panel(host, NULL, style);
	bg_image = gkrellm_bg_meter_image(style_id);
	gkrellm_create_panel(vbox, host, bg_image);

	host_pixmap_height = window_decorations ? 5 : 3;
	gkrellm_render_to_pixmap(bg_image, &host_pixmap, &host_mask,
			UC.chart_width, host_pixmap_height);
	if (host_pixmapwid)
		gtk_container_remove(GTK_CONTAINER(vbox), host_pixmapwid);
	host_pixmapwid = gtk_pixmap_new(host_pixmap, host_mask);
	gtk_box_pack_start(GTK_BOX(vbox), host_pixmapwid, FALSE, FALSE, 0);

	if (UC.enable_hostname)
		{
		gtk_widget_hide(host_pixmapwid);
		gkrellm_monitor_height_adjust(host->h);
		hostname_visible = TRUE;
		host_pixmap_visible = FALSE;
		}
	else
		{
		gtk_widget_hide(host->hbox);
		hostname_visible = FALSE;
		gtk_widget_show(host_pixmapwid);
		gkrellm_monitor_height_adjust(host_pixmap_height);
		host_pixmap_visible = TRUE;
		hostname_visible = FALSE;
		}

	if (first_create)
		gtk_signal_connect(GTK_OBJECT(host->drawing_area), "expose_event",
				(GtkSignalFunc) host_expose_event, NULL);

	hostname_short = UC.hostname_short;
	draw_hostname();
	}

void
apply_hostname_config()
	{
	gint	old_vis = hostname_visible;

	gkrellm_enable_visibility(UC.enable_hostname, &hostname_visible,
			host->hbox, host->h);
	if (hostname_visible == host_pixmap_visible)
		gkrellm_enable_visibility(! hostname_visible, &host_pixmap_visible,
				host_pixmapwid, host_pixmap_height);


	if (old_vis != hostname_visible || UC.hostname_short != hostname_short)
		{
		hostname_short = UC.hostname_short;
		draw_hostname();
		}
	}


static Monitor	monitor_host =
	{
	NULL,		/* Name, for config tab. Done in General config */
	MON_HOST,	/* Id,  0 if a plugin		*/
	NULL,		/* The create function.  Special call because of event box.*/
	NULL,		/* The update function		*/
	NULL,		/* The config tab create function	*/
	apply_hostname_config,

	NULL,		/* Save user conifg			*/
	NULL,		/* Load user config			*/
	NULL,		/* config keyword			*/

	NULL,				/* Undef 2	*/
	NULL,				/* Undef 1	*/
	NULL,				/* Undef 0	*/

	0,					/* insert_before_id - place plugin before this mon */

	NULL,				/* Handle if a plugin, filled in by GKrellM		*/
	NULL				/* path if a plugin, filled in by GKrellM		*/
	};

Monitor *
init_host_monitor(void)
	{
	style_id = gkrellm_add_meter_style(&monitor_host, HOST_STYLE_NAME);
	return &monitor_host;
	}
