/* GKrellM
|  Copyright (C) 1999-2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Private global extern declarations and function prototypes.
*/

extern struct tm	current_tm;
extern time_t		time_now;

extern gint			smp_cpus;
extern gint			w_display, h_display;
extern gint			window_decorations;
extern gint			n_system_plugins;

extern GdkImlibBorder zero_border;

void load_plugin_monitors(void);

void	create_plugin_config(GtkWidget *);
void	save_plugins_enable_list(void);

/* hostname?? */
Monitor *init_host_monitor(void);
Monitor *init_cal_monitor(void);
Monitor *init_clock_monitor(void);
Monitor *init_cpu_monitor(void);
Monitor *init_proc_monitor(void);
Monitor *init_voltage_monitor(void);
Monitor *init_disk_monitor(void);
Monitor *init_inet_monitor(void);
Monitor *init_net_monitor(void);
Monitor *init_timer_monitor(void);
Monitor *init_mem_monitor(void);
Monitor *init_swap_monitor(void);
Monitor *init_fs_monitor(void);
Monitor *init_mail_monitor(void);
Monitor *init_apm_monitor(void);
Monitor *init_uptime_monitor(void);
Monitor *init_sensors_monitor(void);

Monitor *init_demo_monitor(void);

void	init_hostname_monitor(void);	/* XXX */

#if defined(__linux__)
void	read_stat_swap(gulong *, gulong *);
#endif

void	destroy_decal_button_list(void);

void	create_hostname(GtkWidget *, gint);
void	insert_spacer(GtkWidget *);

void	store_proc_chart_data(Chart *, gint, gint);
void	draw_proc_chart(Chart *);

void	build_gkrellm(void);
void	gkrellmrc_theme_config();
void	read_user_config(void);
void	save_user_config(void);
void	save_theme_config(void);
void	load_theme_images(void);
void	read_theme_event(gint);
void	make_themes_list(void);

gint	x_label_position(gint, gint, gint, gint);

void	load_inet_data(void);
void	save_inet_data(void);

gint	effect_string_value(gchar *);

void	map_color_string(gchar *, GdkColor *);

void	add_plugin_config_page(Monitor *);
void	remove_plugin_config_page(Monitor *);

void	make_spin_button(GtkWidget *, GtkWidget **, gfloat, gfloat, gfloat,
			gfloat, gfloat, gint, gint, void (*func)(), gpointer, gchar *);

void	make_check_button(GtkWidget *, GtkWidget **, gint, gint, gchar *);
void	make_check_button_shrink(GtkWidget *, GtkWidget **, gint, gint, gchar *);
void	insert_expanded_filler(GtkWidget *);


void	set_theme_alternatives_label(void);

void	start_timer(gint);

GtkItemFactory *create_item_factory_popup(void);

int		map_1_2_5(gint, gint *, gint);
gint	computed_index(Chart *, gint);


/* utils.c */
gint	strcmp_basename(gchar *, gchar *);
gboolean dup_string(gchar **, gchar *);
gchar	*cut_quoted_string(gchar *, gchar **);
gboolean getline_from_gstring(GString **, gchar *, gint);

void	free_glist_and_data(GList **);
GList	*basename_in_list(GList *, gchar *);
GList	*string_in_list(GList *, gchar *);

gint	isdir(gchar *, gchar *);
gint	isfile(gchar *);
gboolean make_home_subdir(gchar *);
void	dup_home_pathname(gchar **, gchar *, gchar *);
gchar	*entry_get_alpha_text(GtkWidget **);

gint	format_size_abbrev(gchar *, size_t, gfloat,
						size_abbrev_table *, size_t);
gfloat	locale_float_fix(gchar *);

/* sensors.c */
gpointer get_mapped_sensor(gchar *, gint);
void	sensor_create_decals(Panel *, gint, Decal **, Decal **);

