/* GKrellM
|  Copyright (C) 1999-2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
|
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Demo monitor just puts up new or builtin monitor unused features if
|  gkrellm -demo is run.  This is so themers can see all the elements
|  of their themes.
|  This is similar to the plugin_example.c
*/

#include "gkrellm.h"

#define GKRELLM_DEMO

#ifdef GKRELLM_DEMO

static Chart	*demo_chart;
static Panel	*demo_meter;

typedef struct
	{
	Krell	*krell;
	gint	value;
	}
	Slider;

static Slider	kslider[3];

static Krell	*demo_krell,
				*slider_in_motion;

static Style	*slider_style;

static Decal		*button_decal;
static DecalButton	*button;

static gint
expose_event(GtkWidget *widget, GdkEventExpose *ev)
    {
	GdkPixmap	*pixmap	= NULL;

    if (widget == demo_chart->panel->drawing_area)
		pixmap = demo_chart->panel->pixmap;
	else if (widget == demo_meter->drawing_area)
		pixmap = demo_meter->pixmap;
	else if (widget == demo_chart->drawing_area)
		pixmap = demo_chart->pixmap;
	if (pixmap)
        gdk_draw_pixmap(widget->window, GK.draw1_GC, pixmap,
				ev->area.x, ev->area.y, ev->area.x, ev->area.y,
				ev->area.width, ev->area.height);
    return FALSE;
    }

/* Just a demo here, make the krell slide across the panel in 15 seconds.
*/
static void
update_demo()
	{
	static gint	t;
	Krell		*krell;

	if (GK.second_tick)
		{
		++t;
		krell = demo_krell;
		krell->previous = 0;
		gkrellm_update_krell(demo_chart->panel, demo_krell, t % 15);
		gkrellm_draw_layers(demo_chart->panel);	/* Draws krells/decals */
		}
	}

static void
slider_motion(GtkWidget *widget, GdkEventMotion *ev, gpointer data)
	{
	Krell			*k;
	gint			x;
	GdkModifierType	state;

	if (slider_in_motion)
		{
		/* Check if button is still pressed, in case missed button_release
		*/
		state = ev->state;
		if (!(state & GDK_BUTTON1_MASK))
			{
			slider_in_motion = NULL;
			return;
			}
		k = slider_in_motion;
		x = ev->x * k->full_scale / (gkrellm_chart_width() - 1);
		if (x < 0)
			x = 0;
		k->previous = 0;
		if (k == KRELL(demo_meter))
			{
			gkrellm_update_krell(demo_meter, k, (gulong) x);
			gkrellm_draw_layers(demo_meter);
			}
		else
			{
			gkrellm_update_krell(demo_chart->panel, k, (gulong) x);
			gkrellm_draw_layers(demo_chart->panel);
			}

		if (kslider[0].krell == k)
			kslider[0].value = x;
		else if (kslider[1].krell == k)
			kslider[1].value = x;
		else if (kslider[2].krell == k)
			kslider[2].value = x;
		}
	}

static void
panel_button_release(GtkWidget *widget, GdkEventButton *ev, gpointer data)
	{
	slider_in_motion = NULL;
	}

static void
panel_button_press(GtkWidget *widget, GdkEventButton *ev, gpointer data)
	{
	GList	*list;
	Krell	*k;


    if (widget == demo_chart->panel->drawing_area)
		for (list = demo_chart->panel->krell; list; list = list->next)
			{
			k = (Krell *) list->data;
			if (k != kslider[0].krell && k != kslider[1].krell)
				continue;
			if (ev->y >= k->y0 && ev->y <= k->y0 + k->h_frame)
				{
				slider_in_motion = k;
				break;
				}
			}
	else if (widget == demo_meter->drawing_area)
		{
		k = KRELL(demo_meter);
		if (ev->y >= k->y0 && ev->y <= k->y0 + k->h_frame)
			slider_in_motion = k;
		}
	}


static void
create_slider_krells()
	{
	Panel			*p;
	GdkImlibImage	*krell_image;

	p = demo_chart->panel;
	if (slider_style == NULL)	/* NNN */
		slider_style = gkrellm_style_new0();
	*slider_style = *gkrellm_krell_slider_style();
	slider_style->krell_yoff = 2;
	krell_image = gkrellm_krell_slider_image();

	kslider[0].krell = gkrellm_create_krell(p, krell_image, slider_style);
	kslider[0].krell->full_scale = 100;		/* Whatever makes sense. */

	/* Change the style yoff to place the second slider somewhere else.
	|  Here it is placed just below the first slider.
	*/
	slider_style->krell_yoff = kslider[0].krell->y0
						+ kslider[0].krell->h_frame;
	kslider[1].krell = gkrellm_create_krell(p, krell_image, slider_style);
	kslider[1].krell->full_scale = 100;

	p = demo_meter;
	slider_style->krell_yoff = button_decal->y + button_decal->h;
	kslider[2].krell = gkrellm_create_krell(p, krell_image, slider_style);
	kslider[2].krell->full_scale = 100;
	}


static void
create_demo(GtkWidget *vbox, gint first_create)
	{
	Panel			*p;
	Krell			*k;
	Style			*demo_style;
	GdkImlibImage	*bg_image, *krell_image;
	gint			w;

	/* Allocate the chart and panel.  Make the panel belong to the chart.
	*/
	if (first_create)	/* or if demo_chart == NULL */
		{
		demo_chart = gkrellm_chart_new0();
		demo_meter = gkrellm_panel_new0();
		p = gkrellm_panel_new0();	/* Allocates label and textstyle structs */
		demo_chart->panel = p;
		}
	else
		{
		gkrellm_destroy_krell_list(demo_chart->panel);
		gkrellm_destroy_decal_list(demo_chart->panel);
		gkrellm_destroy_krell_list(demo_meter);
		gkrellm_destroy_decal_list(demo_meter);
		}
	demo_style = gkrellm_meter_style(DEFAULT_STYLE_ID);

	p = demo_meter;
	button_decal = gkrellm_create_decal_pixmap(p, GK.decal_misc_pixmap,
			GK.decal_misc_mask, N_MISC_DECALS, demo_style, -1, -1);

	create_slider_krells();

	gkrellm_configure_panel(p, NULL, demo_style);
	p->label->h_panel += demo_style->border.bottom;
	gkrellm_create_panel(vbox, p, gkrellm_bg_meter_image(DEFAULT_STYLE_ID));
	gkrellm_monitor_height_adjust(p->h);

	button = gkrellm_make_decal_button(p, button_decal,
			NULL, NULL, D_MISC_BUTTON_OUT, D_MISC_BUTTON_IN);

	p = demo_chart->panel;
	demo_chart->h = 20;
	gkrellm_create_chart(vbox, demo_chart, DEFAULT_STYLE_ID);


	/* Create a standard meter krell for the demo_krell
	*/
	krell_image = gkrellm_krell_meter_image(DEFAULT_STYLE_ID);
	demo_krell = gkrellm_create_krell(p, krell_image, demo_style);
	demo_krell->full_scale = 15;	/* will scan in 15 seconds  */

	demo_style = gkrellm_panel_style(DEFAULT_STYLE_ID);
	p->textstyle = gkrellm_panel_textstyle(DEFAULT_STYLE_ID);

    gkrellm_configure_panel(p, NULL /* No label */, demo_style);

	p->label->h_panel += demo_style->border.bottom;

	bg_image = gkrellm_bg_panel_image(DEFAULT_STYLE_ID);
    gkrellm_create_panel(vbox, p, bg_image);

	bg_image = gkrellm_bg_slider_image(CHART_PANEL_TYPE);
		w = gkrellm_chart_width();
	if (bg_image)
		{
		k = kslider[0].krell;
		gdk_imlib_paste_image(bg_image, p->bg_pixmap,0, k->y0, w, k->h_frame);
		gdk_imlib_paste_image(bg_image, p->pixmap, 0, k->y0, w, k->h_frame);

		k = kslider[1].krell;
		gdk_imlib_paste_image(bg_image, p->bg_pixmap,0, k->y0, w, k->h_frame);
		gdk_imlib_paste_image(bg_image, p->pixmap, 0, k->y0, w, k->h_frame);
		}
	bg_image = gkrellm_bg_slider_image(METER_PANEL_TYPE);
	if (bg_image)
		{
		k = kslider[2].krell;
		gdk_imlib_paste_image(bg_image, demo_meter->bg_pixmap,0, k->y0, w, k->h_frame);
		gdk_imlib_paste_image(bg_image, demo_meter->pixmap, 0, k->y0, w, k->h_frame);
		}

    gkrellm_monitor_height_adjust(p->h + demo_chart->h);

	if (first_create)
		{
	    gtk_signal_connect(GTK_OBJECT (demo_meter->drawing_area),
			"expose_event", (GtkSignalFunc) expose_event, NULL);
	    gtk_signal_connect(GTK_OBJECT (p->drawing_area), "expose_event",
			(GtkSignalFunc) expose_event, NULL);
		gtk_signal_connect(GTK_OBJECT (demo_chart->drawing_area),"expose_event",
			(GtkSignalFunc) expose_event, NULL);

		gtk_signal_connect(GTK_OBJECT(demo_meter->drawing_area), "button_press_event",
			GTK_SIGNAL_FUNC(panel_button_press), NULL );
		gtk_signal_connect(GTK_OBJECT(demo_meter->drawing_area), "button_release_event",
			GTK_SIGNAL_FUNC(panel_button_release), NULL );
    	gtk_signal_connect(GTK_OBJECT (demo_meter->drawing_area), "motion_notify_event",
            (GtkSignalFunc) slider_motion, NULL);

		gtk_signal_connect(GTK_OBJECT(p->drawing_area), "button_press_event",
			GTK_SIGNAL_FUNC(panel_button_press), NULL );
		gtk_signal_connect(GTK_OBJECT(p->drawing_area), "button_release_event",
			GTK_SIGNAL_FUNC(panel_button_release), NULL );
		 gtk_signal_connect(GTK_OBJECT (p->drawing_area), "motion_notify_event",
            (GtkSignalFunc) slider_motion, NULL);
		}

	gkrellm_update_krell(p, kslider[0].krell, (gulong) kslider[0].value);
	gkrellm_update_krell(p, kslider[1].krell, (gulong) kslider[1].value);
	gkrellm_update_krell(demo_meter, kslider[2].krell,
				(gulong) kslider[2].value);
	gkrellm_draw_layers(demo_meter);

	}

#else  /* GKRELLM_DEMO */

static void
create_demo()
	{
	}

static void
update_demo()
	{
	}

#endif

/* --------------------------------------------------------------------	*/

/* The monitor structure tells GKrellM how to call the demo routines.
*/
static Monitor	demo_mon	=
	{
	N_("Demo"),			/* Name, for config tab.    */
	0,					/* Id,  0 if a demo       */
	create_demo,		/* The create function      */
	update_demo,		/* The update function      */
	NULL,				/* The config tab create function   */
	NULL,				/* Apply the config function        */

	NULL,				/* Save user config			*/
	NULL,				/* Load user config			*/
	NULL,					/* config keyword			*/

	NULL,				/* Undefined 2	*/
	NULL,				/* Undefined 1	*/
	NULL,				/* Undefined 0	*/

	0,					/* Insert plugin before this monitor.  Choose	*/
						/*   MON_CLOCK, MON_CPU, MON_PROC, MON_DISK,	*/
						/*   MON_INET, MON_NET, MON_FS, MON_MAIL,		*/
						/*   MON_APM, or MON_UPTIME						*/

	NULL,				/* Handle if a plugin, filled in by GKrellM     */
	NULL				/* path if a plugin, filled in by GKrellM       */
	};


Monitor *
init_demo_monitor(void)
	{
#ifdef GKRELLM_DEMO
	return &demo_mon;
#else
	return NULL;
#endif
	}
