/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "libgimpbase/gimpbase.h"
#include "libgimpcolor/gimpcolor.h"
#include "libgimpmath/gimpmath.h"

#include "pdb-types.h"
#include "procedural_db.h"

#include "base/temp-buf.h"
#include "config/gimpcoreconfig.h"
#include "core/gimp.h"
#include "core/gimpchannel.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage-colormap.h"
#include "core/gimpimage-crop.h"
#include "core/gimpimage-duplicate.h"
#include "core/gimpimage-flip.h"
#include "core/gimpimage-merge.h"
#include "core/gimpimage-pick-color.h"
#include "core/gimpimage-resize.h"
#include "core/gimpimage-rotate.h"
#include "core/gimpimage-scale.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimplayermask.h"
#include "core/gimplist.h"
#include "core/gimpprojection.h"
#include "core/gimpunit.h"
#include "gimp-intl.h"

static ProcRecord image_list_proc;
static ProcRecord image_new_proc;
static ProcRecord image_duplicate_proc;
static ProcRecord image_delete_proc;
static ProcRecord image_base_type_proc;
static ProcRecord image_width_proc;
static ProcRecord image_height_proc;
static ProcRecord image_free_shadow_proc;
static ProcRecord image_resize_proc;
static ProcRecord image_resize_to_layers_proc;
static ProcRecord image_scale_proc;
static ProcRecord image_crop_proc;
static ProcRecord image_flip_proc;
static ProcRecord image_rotate_proc;
static ProcRecord image_get_layers_proc;
static ProcRecord image_get_channels_proc;
static ProcRecord image_get_active_drawable_proc;
static ProcRecord image_unset_active_channel_proc;
static ProcRecord image_get_floating_sel_proc;
static ProcRecord image_floating_sel_attached_to_proc;
static ProcRecord image_pick_color_proc;
static ProcRecord image_pick_correlate_layer_proc;
static ProcRecord image_add_layer_proc;
static ProcRecord image_remove_layer_proc;
static ProcRecord image_raise_layer_proc;
static ProcRecord image_lower_layer_proc;
static ProcRecord image_raise_layer_to_top_proc;
static ProcRecord image_lower_layer_to_bottom_proc;
static ProcRecord image_add_channel_proc;
static ProcRecord image_remove_channel_proc;
static ProcRecord image_raise_channel_proc;
static ProcRecord image_lower_channel_proc;
static ProcRecord image_flatten_proc;
static ProcRecord image_merge_visible_layers_proc;
static ProcRecord image_merge_down_proc;
static ProcRecord image_add_layer_mask_proc;
static ProcRecord image_remove_layer_mask_proc;
static ProcRecord image_get_colormap_proc;
static ProcRecord image_set_colormap_proc;
static ProcRecord image_clean_all_proc;
static ProcRecord image_is_dirty_proc;
static ProcRecord image_thumbnail_proc;
static ProcRecord image_get_active_layer_proc;
static ProcRecord image_set_active_layer_proc;
static ProcRecord image_get_active_channel_proc;
static ProcRecord image_set_active_channel_proc;
static ProcRecord image_get_selection_proc;
static ProcRecord image_get_component_active_proc;
static ProcRecord image_set_component_active_proc;
static ProcRecord image_get_component_visible_proc;
static ProcRecord image_set_component_visible_proc;
static ProcRecord image_get_filename_proc;
static ProcRecord image_set_filename_proc;
static ProcRecord image_get_name_proc;
static ProcRecord image_get_resolution_proc;
static ProcRecord image_set_resolution_proc;
static ProcRecord image_get_unit_proc;
static ProcRecord image_set_unit_proc;
static ProcRecord image_get_tattoo_state_proc;
static ProcRecord image_set_tattoo_state_proc;
static ProcRecord image_get_layer_by_tattoo_proc;
static ProcRecord image_get_channel_by_tattoo_proc;

void
register_image_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &image_list_proc);
  procedural_db_register (gimp, &image_new_proc);
  procedural_db_register (gimp, &image_duplicate_proc);
  procedural_db_register (gimp, &image_delete_proc);
  procedural_db_register (gimp, &image_base_type_proc);
  procedural_db_register (gimp, &image_width_proc);
  procedural_db_register (gimp, &image_height_proc);
  procedural_db_register (gimp, &image_free_shadow_proc);
  procedural_db_register (gimp, &image_resize_proc);
  procedural_db_register (gimp, &image_resize_to_layers_proc);
  procedural_db_register (gimp, &image_scale_proc);
  procedural_db_register (gimp, &image_crop_proc);
  procedural_db_register (gimp, &image_flip_proc);
  procedural_db_register (gimp, &image_rotate_proc);
  procedural_db_register (gimp, &image_get_layers_proc);
  procedural_db_register (gimp, &image_get_channels_proc);
  procedural_db_register (gimp, &image_get_active_drawable_proc);
  procedural_db_register (gimp, &image_unset_active_channel_proc);
  procedural_db_register (gimp, &image_get_floating_sel_proc);
  procedural_db_register (gimp, &image_floating_sel_attached_to_proc);
  procedural_db_register (gimp, &image_pick_color_proc);
  procedural_db_register (gimp, &image_pick_correlate_layer_proc);
  procedural_db_register (gimp, &image_add_layer_proc);
  procedural_db_register (gimp, &image_remove_layer_proc);
  procedural_db_register (gimp, &image_raise_layer_proc);
  procedural_db_register (gimp, &image_lower_layer_proc);
  procedural_db_register (gimp, &image_raise_layer_to_top_proc);
  procedural_db_register (gimp, &image_lower_layer_to_bottom_proc);
  procedural_db_register (gimp, &image_add_channel_proc);
  procedural_db_register (gimp, &image_remove_channel_proc);
  procedural_db_register (gimp, &image_raise_channel_proc);
  procedural_db_register (gimp, &image_lower_channel_proc);
  procedural_db_register (gimp, &image_flatten_proc);
  procedural_db_register (gimp, &image_merge_visible_layers_proc);
  procedural_db_register (gimp, &image_merge_down_proc);
  procedural_db_register (gimp, &image_add_layer_mask_proc);
  procedural_db_register (gimp, &image_remove_layer_mask_proc);
  procedural_db_register (gimp, &image_get_colormap_proc);
  procedural_db_register (gimp, &image_set_colormap_proc);
  procedural_db_register (gimp, &image_clean_all_proc);
  procedural_db_register (gimp, &image_is_dirty_proc);
  procedural_db_register (gimp, &image_thumbnail_proc);
  procedural_db_register (gimp, &image_get_active_layer_proc);
  procedural_db_register (gimp, &image_set_active_layer_proc);
  procedural_db_register (gimp, &image_get_active_channel_proc);
  procedural_db_register (gimp, &image_set_active_channel_proc);
  procedural_db_register (gimp, &image_get_selection_proc);
  procedural_db_register (gimp, &image_get_component_active_proc);
  procedural_db_register (gimp, &image_set_component_active_proc);
  procedural_db_register (gimp, &image_get_component_visible_proc);
  procedural_db_register (gimp, &image_set_component_visible_proc);
  procedural_db_register (gimp, &image_get_filename_proc);
  procedural_db_register (gimp, &image_set_filename_proc);
  procedural_db_register (gimp, &image_get_name_proc);
  procedural_db_register (gimp, &image_get_resolution_proc);
  procedural_db_register (gimp, &image_set_resolution_proc);
  procedural_db_register (gimp, &image_get_unit_proc);
  procedural_db_register (gimp, &image_set_unit_proc);
  procedural_db_register (gimp, &image_get_tattoo_state_proc);
  procedural_db_register (gimp, &image_set_tattoo_state_proc);
  procedural_db_register (gimp, &image_get_layer_by_tattoo_proc);
  procedural_db_register (gimp, &image_get_channel_by_tattoo_proc);
}

#if defined (HAVE_FINITE)
#define FINITE(x) finite(x)
#elif defined (HAVE_ISFINITE)
#define FINITE(x) isfinite(x)
#elif defined (G_OS_WIN32)
#define FINITE(x) _finite(x)
#else
#error "no FINITE() implementation available?!"
#endif

static Argument *
image_list_invoker (Gimp         *gimp,
                    GimpContext  *context,
                    GimpProgress *progress,
                    Argument     *args)
{
  Argument *return_args;
  gint32 num_images = 0;
  gint32 *image_ids = NULL;
  GList *list = NULL;
  gint i;

  list = GIMP_LIST (gimp->images)->list;
  num_images = g_list_length (list);

  if (num_images)
    {
      image_ids = g_new (gint32, num_images);
      for (i = 0; i < num_images; i++, list = g_list_next (list))
        image_ids[i] = gimp_image_get_ID (GIMP_IMAGE (list->data));
    }

  return_args = procedural_db_return_args (&image_list_proc, TRUE);

  return_args[1].value.pdb_int = num_images;
  return_args[2].value.pdb_pointer = image_ids;

  return return_args;
}

static ProcArg image_list_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num_images",
    "The number of images currently open"
  },
  {
    GIMP_PDB_INT32ARRAY,
    "image_ids",
    "The list of images currently open"
  }
};

static ProcRecord image_list_proc =
{
  "gimp_image_list",
  "Returns the list of images currently open.",
  "This procedure returns the list of images currently open in the GIMP.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  0,
  NULL,
  2,
  image_list_outargs,
  { { image_list_invoker } }
};

static Argument *
image_new_invoker (Gimp         *gimp,
                   GimpContext  *context,
                   GimpProgress *progress,
                   Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gint32 width;
  gint32 height;
  gint32 type;
  GimpImage *image = NULL;

  width = args[0].value.pdb_int;
  if (width <= 0)
    success = FALSE;

  height = args[1].value.pdb_int;
  if (height <= 0)
    success = FALSE;

  type = args[2].value.pdb_int;
  if (type < GIMP_RGB || type > GIMP_INDEXED)
    success = FALSE;

  if (success)
    {
      image = gimp_create_image (gimp, width, height, type, FALSE);
      success = (image != NULL);
    }

  return_args = procedural_db_return_args (&image_new_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_image_get_ID (image);

  return return_args;
}

static ProcArg image_new_inargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The width of the image"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The height of the image"
  },
  {
    GIMP_PDB_INT32,
    "type",
    "The type of image: { GIMP_RGB (0), GIMP_GRAY (1), GIMP_INDEXED (2) }"
  }
};

static ProcArg image_new_outargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The ID of the newly created image"
  }
};

static ProcRecord image_new_proc =
{
  "gimp_image_new",
  "Creates a new image with the specified width, height, and type.",
  "Creates a new image, undisplayed with the specified extents and type. A layer should be created and added before this image is displayed, or subsequent calls to 'gimp_display_new' with this image as an argument will fail. Layers can be created using the 'gimp_layer_new' commands. They can be added to an image using the 'gimp_image_add_layer' command.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_new_inargs,
  1,
  image_new_outargs,
  { { image_new_invoker } }
};

static Argument *
image_duplicate_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpImage *new_image = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    success = (new_image = gimp_image_duplicate (gimage)) != NULL;

  return_args = procedural_db_return_args (&image_duplicate_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_image_get_ID (new_image);

  return return_args;
}

static ProcArg image_duplicate_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_duplicate_outargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "new_image",
    "The new, duplicated image"
  }
};

static ProcRecord image_duplicate_proc =
{
  "gimp_image_duplicate",
  "Duplicate the specified image",
  "This procedure duplicates the specified image, copying all layers, channels, and image information.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1997",
  NULL,
  GIMP_INTERNAL,
  1,
  image_duplicate_inargs,
  1,
  image_duplicate_outargs,
  { { image_duplicate_invoker } }
};

static Argument *
image_delete_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      if (gimage->disp_count == 0)
        g_object_unref (gimage);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&image_delete_proc, success);
}

static ProcArg image_delete_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcRecord image_delete_proc =
{
  "gimp_image_delete",
  "Delete the specified image.",
  "If there are no displays associated with this image it will be deleted. This means that you can not delete an image through the PDB that was created by the user. If the associated display was however created through the PDB and you know the display ID, you may delete the display. Removal of the last associated display will then delete the image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_delete_inargs,
  0,
  NULL,
  { { image_delete_invoker } }
};

static Argument *
image_base_type_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 base_type = 0;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    base_type = gimp_image_base_type (gimage);

  return_args = procedural_db_return_args (&image_base_type_proc, success);

  if (success)
    return_args[1].value.pdb_int = base_type;

  return return_args;
}

static ProcArg image_base_type_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_base_type_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "base_type",
    "The image's base type: { GIMP_RGB (0), GIMP_GRAY (1), GIMP_INDEXED (2) }"
  }
};

static ProcRecord image_base_type_proc =
{
  "gimp_image_base_type",
  "Get the base type of the image.",
  "This procedure returns the image's base type. Layers in the image must be of this subtype, but can have an optional alpha channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_base_type_inargs,
  1,
  image_base_type_outargs,
  { { image_base_type_invoker } }
};

static Argument *
image_width_invoker (Gimp         *gimp,
                     GimpContext  *context,
                     GimpProgress *progress,
                     Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  return_args = procedural_db_return_args (&image_width_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimage->width;

  return return_args;
}

static ProcArg image_width_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_width_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The image's width"
  }
};

static ProcRecord image_width_proc =
{
  "gimp_image_width",
  "Return the width of the image",
  "This procedure returns the image's width. This value is independent of any of the layers in this image. This is the \"canvas\" width.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_width_inargs,
  1,
  image_width_outargs,
  { { image_width_invoker } }
};

static Argument *
image_height_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  return_args = procedural_db_return_args (&image_height_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimage->height;

  return return_args;
}

static ProcArg image_height_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_height_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "height",
    "The image's height"
  }
};

static ProcRecord image_height_proc =
{
  "gimp_image_height",
  "Return the height of the image",
  "This procedure returns the image's height. This value is independent of any of the layers in this image. This is the \"canvas\" height.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_height_inargs,
  1,
  image_height_outargs,
  { { image_height_invoker } }
};

static Argument *
image_free_shadow_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    gimp_image_free_shadow (gimage);

  return procedural_db_return_args (&image_free_shadow_proc, success);
}

static ProcArg image_free_shadow_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcRecord image_free_shadow_proc =
{
  "gimp_image_free_shadow",
  "Free the specified image's shadow data (if it exists).",
  "This procedure is intended as a memory saving device. If any shadow memory has been allocated, it will be freed automatically on a call to 'gimp_image_delete'.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_free_shadow_inargs,
  0,
  NULL,
  { { image_free_shadow_invoker } }
};

static Argument *
image_resize_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 new_width;
  gint32 new_height;
  gint32 offx;
  gint32 offy;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  new_width = args[1].value.pdb_int;
  if (new_width <= 0)
    success = FALSE;

  new_height = args[2].value.pdb_int;
  if (new_height <= 0)
    success = FALSE;

  offx = args[3].value.pdb_int;

  offy = args[4].value.pdb_int;

  if (success)
    {
      gimp_image_resize (gimage, context,
                         new_width, new_height, offx, offy, NULL);
    }

  return procedural_db_return_args (&image_resize_proc, success);
}

static ProcArg image_resize_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "new_width",
    "New image width: 0 < new_width"
  },
  {
    GIMP_PDB_INT32,
    "new_height",
    "New image height: 0 < new_height"
  },
  {
    GIMP_PDB_INT32,
    "offx",
    "x offset between upper left corner of old and new images: (new - old)"
  },
  {
    GIMP_PDB_INT32,
    "offy",
    "y offset between upper left corner of old and new images: (new - old)"
  }
};

static ProcRecord image_resize_proc =
{
  "gimp_image_resize",
  "Resize the image to the specified extents.",
  "This procedure resizes the image so that it's new width and height are equal to the supplied parameters. Offsets are also provided which describe the position of the previous image's content. No bounds checking is currently provided, so don't supply parameters that are out of bounds. All channels within the image are resized according to the specified parameters; this includes the image selection mask. All layers within the image are repositioned according to the specified offsets.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  5,
  image_resize_inargs,
  0,
  NULL,
  { { image_resize_invoker } }
};

static Argument *
image_resize_to_layers_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      gimp_image_resize_to_layers (gimage, context, NULL);
    }

  return procedural_db_return_args (&image_resize_to_layers_proc, success);
}

static ProcArg image_resize_to_layers_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcRecord image_resize_to_layers_proc =
{
  "gimp_image_resize_to_layers",
  "Resize the image to fit all layers.",
  "This procedure resizes the image to the bounding box of all layers of the image. All channels within the image are resized to the new size; this includes the image selection mask. All layers within the image are repositioned to the new image area.",
  "Simon Budig",
  "Simon Budig",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  image_resize_to_layers_inargs,
  0,
  NULL,
  { { image_resize_to_layers_invoker } }
};

static Argument *
image_scale_invoker (Gimp         *gimp,
                     GimpContext  *context,
                     GimpProgress *progress,
                     Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 new_width;
  gint32 new_height;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  new_width = args[1].value.pdb_int;
  if (new_width <= 0)
    success = FALSE;

  new_height = args[2].value.pdb_int;
  if (new_height <= 0)
    success = FALSE;

  if (success)
    {
      gimp_image_scale (gimage, new_width, new_height,
                        gimp->config->interpolation_type,
                        NULL);
    }

  return procedural_db_return_args (&image_scale_proc, success);
}

static ProcArg image_scale_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "new_width",
    "New image width: 0 < new_width"
  },
  {
    GIMP_PDB_INT32,
    "new_height",
    "New image height: 0 < new_height"
  }
};

static ProcRecord image_scale_proc =
{
  "gimp_image_scale",
  "Scale the image to the specified extents.",
  "This procedure scales the image so that its new width and height are equal to the supplied parameters. Offsets are also provided which describe the position of the previous image's content. No bounds checking is currently provided, so don't supply parameters that are out of bounds. All channels within the image are scaled according to the specified parameters; this includes the image selection mask. All layers within the image are repositioned according to the specified offsets.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_scale_inargs,
  0,
  NULL,
  { { image_scale_invoker } }
};

static Argument *
image_crop_invoker (Gimp         *gimp,
                    GimpContext  *context,
                    GimpProgress *progress,
                    Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 new_width;
  gint32 new_height;
  gint32 offx;
  gint32 offy;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  new_width = args[1].value.pdb_int;
  if (new_width <= 0)
    success = FALSE;

  new_height = args[2].value.pdb_int;
  if (new_height <= 0)
    success = FALSE;

  offx = args[3].value.pdb_int;
  if (offx < 0)
    success = FALSE;

  offy = args[4].value.pdb_int;
  if (offy < 0)
    success = FALSE;

  if (success)
    {
      if (new_width  > gimage->width          ||
          new_height > gimage->height         ||
          offx > (gimage->width  - new_width) ||
          offy > (gimage->height - new_height))
        success = FALSE;
      else
        gimp_image_crop (gimage, context,
                         offx, offy, offx + new_width, offy + new_height,
                         FALSE, TRUE);
    }

  return procedural_db_return_args (&image_crop_proc, success);
}

static ProcArg image_crop_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "new_width",
    "New image width: (0 < new_width <= width)"
  },
  {
    GIMP_PDB_INT32,
    "new_height",
    "New image height: (0 < new_height <= height)"
  },
  {
    GIMP_PDB_INT32,
    "offx",
    "x offset: (0 <= offx <= (width - new_width))"
  },
  {
    GIMP_PDB_INT32,
    "offy",
    "y offset: (0 <= offy <= (height - new_height))"
  }
};

static ProcRecord image_crop_proc =
{
  "gimp_image_crop",
  "Crop the image to the specified extents.",
  "This procedure crops the image so that it's new width and height are equal to the supplied parameters. Offsets are also provided which describe the position of the previous image's content. All channels and layers within the image are cropped to the new image extents; this includes the image selection mask. If any parameters are out of range, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  5,
  image_crop_inargs,
  0,
  NULL,
  { { image_crop_invoker } }
};

static Argument *
image_flip_invoker (Gimp         *gimp,
                    GimpContext  *context,
                    GimpProgress *progress,
                    Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 flip_type;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  flip_type = args[1].value.pdb_int;
  if (flip_type < GIMP_ORIENTATION_HORIZONTAL || flip_type > GIMP_ORIENTATION_VERTICAL)
    success = FALSE;

  if (success)
    {
      gimp_image_flip (gimage, context, flip_type, NULL);
    }

  return procedural_db_return_args (&image_flip_proc, success);
}

static ProcArg image_flip_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "flip_type",
    "Type of flip: GIMP_ORIENTATION_HORIZONTAL (0) or GIMP_ORIENTATION_VERTICAL (1)"
  }
};

static ProcRecord image_flip_proc =
{
  "gimp_image_flip",
  "Flips the image horizontally or vertically.",
  "This procedure flips (mirrors) the image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_flip_inargs,
  0,
  NULL,
  { { image_flip_invoker } }
};

static Argument *
image_rotate_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 rotate_type;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  rotate_type = args[1].value.pdb_int;
  if (rotate_type < GIMP_ROTATE_90 || rotate_type > GIMP_ROTATE_270)
    success = FALSE;

  if (success)
    {
      gimp_image_rotate (gimage, context, rotate_type, NULL);
    }

  return procedural_db_return_args (&image_rotate_proc, success);
}

static ProcArg image_rotate_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "rotate_type",
    "Angle of rotation: GIMP_ROTATE_90 (0), GIMP_ROTATE_180 (1), GIMP_ROTATE_270 (2)"
  }
};

static ProcRecord image_rotate_proc =
{
  "gimp_image_rotate",
  "Rotates the image by the specified degrees.",
  "This procedure rotates the image.",
  "Michael Natterer",
  "Michael Natterer",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  image_rotate_inargs,
  0,
  NULL,
  { { image_rotate_invoker } }
};

static Argument *
image_get_layers_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 num_layers = 0;
  gint32 *layer_ids = NULL;
  GList *list = NULL;
  gint i;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      list = GIMP_LIST (gimage->layers)->list;
      num_layers = g_list_length (list);

      if (num_layers)
        {
          layer_ids = g_new (gint32, num_layers);
          for (i = 0; i < num_layers; i++, list = g_list_next (list))
            layer_ids[i] = gimp_item_get_ID (GIMP_ITEM (list->data));
        }
    }

  return_args = procedural_db_return_args (&image_get_layers_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_layers;
      return_args[2].value.pdb_pointer = layer_ids;
    }

  return return_args;
}

static ProcArg image_get_layers_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_layers_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num_layers",
    "The number of layers contained in the image"
  },
  {
    GIMP_PDB_INT32ARRAY,
    "layer_ids",
    "The list of layers contained in the image"
  }
};

static ProcRecord image_get_layers_proc =
{
  "gimp_image_get_layers",
  "Returns the list of layers contained in the specified image.",
  "This procedure returns the list of layers contained in the specified image. The order of layers is from topmost to bottommost.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_layers_inargs,
  2,
  image_get_layers_outargs,
  { { image_get_layers_invoker } }
};

static Argument *
image_get_channels_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 num_channels = 0;
  gint32 *channel_ids = NULL;
  GList *list = NULL;
  gint i;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      list = GIMP_LIST (gimage->channels)->list;
      num_channels = g_list_length (list);

      if (num_channels)
        {
          channel_ids = g_new (gint32, num_channels);
          for (i = 0; i < num_channels; i++, list = g_list_next (list))
            channel_ids[i] = gimp_item_get_ID (GIMP_ITEM (list->data));
        }
    }

  return_args = procedural_db_return_args (&image_get_channels_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_channels;
      return_args[2].value.pdb_pointer = channel_ids;
    }

  return return_args;
}

static ProcArg image_get_channels_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_channels_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num_channels",
    "The number of channels contained in the image"
  },
  {
    GIMP_PDB_INT32ARRAY,
    "channel_ids",
    "The list of channels contained in the image"
  }
};

static ProcRecord image_get_channels_proc =
{
  "gimp_image_get_channels",
  "Returns the list of channels contained in the specified image.",
  "This procedure returns the list of channels contained in the specified image. This does not include the selection mask, or layer masks. The order is from topmost to bottommost.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_channels_inargs,
  2,
  image_get_channels_outargs,
  { { image_get_channels_invoker } }
};

static Argument *
image_get_active_drawable_invoker (Gimp         *gimp,
                                   GimpContext  *context,
                                   GimpProgress *progress,
                                   Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpDrawable *drawable = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    success = (drawable = gimp_image_active_drawable (gimage)) != NULL;

  return_args = procedural_db_return_args (&image_get_active_drawable_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (drawable));

  return return_args;
}

static ProcArg image_get_active_drawable_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_active_drawable_outargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The active drawable"
  }
};

static ProcRecord image_get_active_drawable_proc =
{
  "gimp_image_get_active_drawable",
  "Get the image's active drawable",
  "This procedure returns the ID of the image's active drawable. This can be either a layer, a channel, or a layer mask. The active drawable is specified by the active image channel. If that is -1, then by the active image layer. If the active image layer has a layer mask and the layer mask is in edit mode, then the layer mask is the active drawable.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_active_drawable_inargs,
  1,
  image_get_active_drawable_outargs,
  { { image_get_active_drawable_invoker } }
};

static Argument *
image_unset_active_channel_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    gimp_image_unset_active_channel (gimage);

  return procedural_db_return_args (&image_unset_active_channel_proc, success);
}

static ProcArg image_unset_active_channel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcRecord image_unset_active_channel_proc =
{
  "gimp_image_unset_active_channel",
  "Unsets the active channel in the specified image.",
  "If an active channel exists, it is unset. There then exists no active channel, and if desired, one can be set through a call to 'Set Active Channel'. No error is returned in the case of no existing active channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_unset_active_channel_inargs,
  0,
  NULL,
  { { image_unset_active_channel_invoker } }
};

static Argument *
image_get_floating_sel_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpLayer *floating_sel = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    floating_sel = gimp_image_floating_sel (gimage);

  return_args = procedural_db_return_args (&image_get_floating_sel_proc, success);

  if (success)
    return_args[1].value.pdb_int = floating_sel ? gimp_item_get_ID (GIMP_ITEM (floating_sel)) : -1;

  return return_args;
}

static ProcArg image_get_floating_sel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_floating_sel_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "floating_sel",
    "The image's floating selection"
  }
};

static ProcRecord image_get_floating_sel_proc =
{
  "gimp_image_get_floating_sel",
  "Return the floating selection of the image.",
  "This procedure returns the image's floating selection, if it exists. If it doesn't exist, -1 is returned as the layer ID.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_floating_sel_inargs,
  1,
  image_get_floating_sel_outargs,
  { { image_get_floating_sel_invoker } }
};

static Argument *
image_floating_sel_attached_to_invoker (Gimp         *gimp,
                                        GimpContext  *context,
                                        GimpProgress *progress,
                                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpDrawable *drawable = NULL;
  GimpLayer *floating_sel;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      floating_sel = gimp_image_floating_sel (gimage);

      if (floating_sel)
        drawable = GIMP_DRAWABLE (GIMP_LAYER (floating_sel)->fs.drawable);
      else
        drawable = NULL;
    }

  return_args = procedural_db_return_args (&image_floating_sel_attached_to_proc, success);

  if (success)
    return_args[1].value.pdb_int = drawable ? gimp_item_get_ID (GIMP_ITEM (drawable)) : -1;

  return return_args;
}

static ProcArg image_floating_sel_attached_to_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_floating_sel_attached_to_outargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable the floating selection is attached to"
  }
};

static ProcRecord image_floating_sel_attached_to_proc =
{
  "gimp_image_floating_sel_attached_to",
  "Return the drawable the floating selection is attached to.",
  "This procedure returns the drawable the image's floating selection is attached to, if it exists. If it doesn't exist, -1 is returned as the drawable ID.",
  "Wolfgang Hofer",
  "Wolfgang Hofer",
  "1998",
  NULL,
  GIMP_INTERNAL,
  1,
  image_floating_sel_attached_to_inargs,
  1,
  image_floating_sel_attached_to_outargs,
  { { image_floating_sel_attached_to_invoker } }
};

static Argument *
image_pick_color_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpDrawable *drawable;
  gdouble x;
  gdouble y;
  gboolean sample_merged;
  gboolean sample_average;
  gdouble average_radius;
  GimpRGB color;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);

  x = args[2].value.pdb_float;

  y = args[3].value.pdb_float;

  sample_merged = args[4].value.pdb_int ? TRUE : FALSE;

  sample_average = args[5].value.pdb_int ? TRUE : FALSE;

  average_radius = args[6].value.pdb_float;
  if (sample_average && (average_radius <= 0.0))
    success = FALSE;

  if (success)
    {
      if (!sample_merged)
        if (!drawable || (gimp_item_get_image (GIMP_ITEM (drawable)) != gimage))
          success = FALSE;

      if (success)
        {
          if (sample_merged)
            {
              gimp_projection_finish_draw (gimage->projection);
              gimp_projection_flush_now (gimage->projection);
            }

          success = gimp_image_pick_color (gimage,
                                           drawable,
                                           (gint) x, (gint) y,
                                             sample_merged,
                                           sample_average,
                                           average_radius,
                                           NULL,
                                           &color,
                                           NULL);
        }
    }

  return_args = procedural_db_return_args (&image_pick_color_proc, success);

  if (success)
    return_args[1].value.pdb_color = color;

  return return_args;
}

static ProcArg image_pick_color_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable to pick from"
  },
  {
    GIMP_PDB_FLOAT,
    "x",
    "x coordinate of upper-left corner of rectangle"
  },
  {
    GIMP_PDB_FLOAT,
    "y",
    "y coordinate of upper-left corner of rectangle"
  },
  {
    GIMP_PDB_INT32,
    "sample_merged",
    "Use the composite image, not the drawable"
  },
  {
    GIMP_PDB_INT32,
    "sample_average",
    "Average the color of all the pixels in a specified radius"
  },
  {
    GIMP_PDB_FLOAT,
    "average_radius",
    "The radius of pixels to average"
  }
};

static ProcArg image_pick_color_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "color",
    "The return color"
  }
};

static ProcRecord image_pick_color_proc =
{
  "gimp_image_pick_color",
  "Determine the color at the given drawable coordinates",
  "This tool determines the color at the specified coordinates. The returned color is an RGB triplet even for grayscale and indexed drawables. If the coordinates lie outside of the extents of the specified drawable, then an error is returned. If the drawable has an alpha channel, the algorithm examines the alpha value of the drawable at the coordinates. If the alpha value is completely transparent (0), then an error is returned. If the sample_merged parameter is non-zero, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of a merged sampling, the supplied drawable is ignored except for finding the image it belongs to.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  7,
  image_pick_color_inargs,
  1,
  image_pick_color_outargs,
  { { image_pick_color_invoker } }
};

static Argument *
image_pick_correlate_layer_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 x;
  gint32 y;
  GimpLayer *layer = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  x = args[1].value.pdb_int;

  y = args[2].value.pdb_int;

  if (success)
    layer = gimp_image_pick_correlate_layer (gimage, x, y);

  return_args = procedural_db_return_args (&image_pick_correlate_layer_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer));

  return return_args;
}

static ProcArg image_pick_correlate_layer_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "x",
    "The x coordinate for the pick"
  },
  {
    GIMP_PDB_INT32,
    "y",
    "The y coordinate for the pick"
  }
};

static ProcArg image_pick_correlate_layer_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer found at the specified coordinates"
  }
};

static ProcRecord image_pick_correlate_layer_proc =
{
  "gimp_image_pick_correlate_layer",
  "Find the layer visible at the specified coordinates.",
  "This procedure finds the layer which is visible at the specified coordinates. Layers which do not qualify are those whose extents do not pass within the specified coordinates, or which are transparent at the specified coordinates. This procedure will return -1 if no layer is found.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_pick_correlate_layer_inargs,
  1,
  image_pick_correlate_layer_outargs,
  { { image_pick_correlate_layer_invoker } }
};

static Argument *
image_add_layer_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;
  gint32 position;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  position = args[2].value.pdb_int;

  if (success)
    {
      if (! gimp_item_is_floating (GIMP_ITEM (layer)) ||
          GIMP_IMAGE_TYPE_BASE_TYPE (gimp_drawable_type (GIMP_DRAWABLE (layer))) !=
          gimp_image_base_type (gimage))
        {
          success = FALSE;
        }
      else
        {
          success = gimp_image_add_layer (gimage, layer, MAX (position, -1));
        }
    }

  return procedural_db_return_args (&image_add_layer_proc, success);
}

static ProcArg image_add_layer_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "position",
    "The layer position"
  }
};

static ProcRecord image_add_layer_proc =
{
  "gimp_image_add_layer",
  "Add the specified layer to the image.",
  "This procedure adds the specified layer to the gimage at the given position. If the position is specified as -1, then the layer is inserted at the top of the layer stack. If the layer to be added has no alpha channel, it must be added at position 0. The layer type must be compatible with the image base type.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_add_layer_inargs,
  0,
  NULL,
  { { image_add_layer_invoker } }
};

static Argument *
image_remove_layer_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    gimp_image_remove_layer (gimage, layer);

  return procedural_db_return_args (&image_remove_layer_proc, success);
}

static ProcArg image_remove_layer_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcRecord image_remove_layer_proc =
{
  "gimp_image_remove_layer",
  "Remove the specified layer from the image.",
  "This procedure removes the specified layer from the image. If the layer doesn't exist, an error is returned. If there are no layers left in the image, this call will fail. If this layer is the last layer remaining, the image will become empty and have no active layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_remove_layer_inargs,
  0,
  NULL,
  { { image_remove_layer_invoker } }
};

static Argument *
image_raise_layer_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    success = gimp_image_raise_layer (gimage, layer);

  return procedural_db_return_args (&image_raise_layer_proc, success);
}

static ProcArg image_raise_layer_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to raise"
  }
};

static ProcRecord image_raise_layer_proc =
{
  "gimp_image_raise_layer",
  "Raise the specified layer in the image's layer stack",
  "This procedure raises the specified layer one step in the existing layer stack. It will not move the layer if there is no layer above it, or the layer has no alpha channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_raise_layer_inargs,
  0,
  NULL,
  { { image_raise_layer_invoker } }
};

static Argument *
image_lower_layer_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    success = gimp_image_lower_layer (gimage, layer);

  return procedural_db_return_args (&image_lower_layer_proc, success);
}

static ProcArg image_lower_layer_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to lower"
  }
};

static ProcRecord image_lower_layer_proc =
{
  "gimp_image_lower_layer",
  "Lower the specified layer in the image's layer stack",
  "This procedure lowers the specified layer one step in the existing layer stack. It will not move the layer if there is no layer below it, or the layer has no alpha channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_lower_layer_inargs,
  0,
  NULL,
  { { image_lower_layer_invoker } }
};

static Argument *
image_raise_layer_to_top_invoker (Gimp         *gimp,
                                  GimpContext  *context,
                                  GimpProgress *progress,
                                  Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    success = gimp_image_raise_layer_to_top (gimage, layer);

  return procedural_db_return_args (&image_raise_layer_to_top_proc, success);
}

static ProcArg image_raise_layer_to_top_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to raise to top"
  }
};

static ProcRecord image_raise_layer_to_top_proc =
{
  "gimp_image_raise_layer_to_top",
  "Raise the specified layer in the image's layer stack to top of stack",
  "This procedure raises the specified layer to top of the existing layer stack. It will not move the layer if there is no layer above it, or the layer has no alpha channel.",
  "Wolfgang Hofer, Sven Neumann",
  "Wolfgang Hofer",
  "1998",
  NULL,
  GIMP_INTERNAL,
  2,
  image_raise_layer_to_top_inargs,
  0,
  NULL,
  { { image_raise_layer_to_top_invoker } }
};

static Argument *
image_lower_layer_to_bottom_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    success = gimp_image_lower_layer_to_bottom (gimage, layer);

  return procedural_db_return_args (&image_lower_layer_to_bottom_proc, success);
}

static ProcArg image_lower_layer_to_bottom_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to lower to bottom"
  }
};

static ProcRecord image_lower_layer_to_bottom_proc =
{
  "gimp_image_lower_layer_to_bottom",
  "Lower the specified layer in the image's layer stack to bottom of stack",
  "This procedure lowers the specified layer to bottom of the existing layer stack. It will not move the layer if there is no layer below it, or the layer has no alpha channel.",
  "Wolfgang Hofer, Sven Neumann",
  "Wolfgang Hofer",
  "1998",
  NULL,
  GIMP_INTERNAL,
  2,
  image_lower_layer_to_bottom_inargs,
  0,
  NULL,
  { { image_lower_layer_to_bottom_invoker } }
};

static Argument *
image_add_channel_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpChannel *channel;
  gint32 position;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  channel = (GimpChannel *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_CHANNEL (channel) && ! gimp_item_is_removed (GIMP_ITEM (channel))))
    success = FALSE;

  position = args[2].value.pdb_int;

  if (success)
    {
      success = gimp_item_is_floating (GIMP_ITEM (channel));

      if (success)
        success = gimp_image_add_channel (gimage, channel, MAX (position, -1));
    }

  return procedural_db_return_args (&image_add_channel_proc, success);
}

static ProcArg image_add_channel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_CHANNEL,
    "channel",
    "The channel"
  },
  {
    GIMP_PDB_INT32,
    "position",
    "The channel position"
  }
};

static ProcRecord image_add_channel_proc =
{
  "gimp_image_add_channel",
  "Add the specified channel to the image.",
  "This procedure adds the specified channel to the image. The position channel is not currently used, so the channel is always inserted at the top of the channel stack.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_add_channel_inargs,
  0,
  NULL,
  { { image_add_channel_invoker } }
};

static Argument *
image_remove_channel_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpChannel *channel;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  channel = (GimpChannel *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_CHANNEL (channel) && ! gimp_item_is_removed (GIMP_ITEM (channel))))
    success = FALSE;

  if (success)
    gimp_image_remove_channel (gimage, channel);

  return procedural_db_return_args (&image_remove_channel_proc, success);
}

static ProcArg image_remove_channel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_CHANNEL,
    "channel",
    "The channel"
  }
};

static ProcRecord image_remove_channel_proc =
{
  "gimp_image_remove_channel",
  "Remove the specified channel from the image.",
  "This procedure removes the specified channel from the image. If the channel doesn't exist, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_remove_channel_inargs,
  0,
  NULL,
  { { image_remove_channel_invoker } }
};

static Argument *
image_raise_channel_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpChannel *channel;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  channel = (GimpChannel *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_CHANNEL (channel) && ! gimp_item_is_removed (GIMP_ITEM (channel))))
    success = FALSE;

  if (success)
    success = gimp_image_raise_channel (gimage, channel);

  return procedural_db_return_args (&image_raise_channel_proc, success);
}

static ProcArg image_raise_channel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_CHANNEL,
    "channel",
    "The channel to raise"
  }
};

static ProcRecord image_raise_channel_proc =
{
  "gimp_image_raise_channel",
  "Raise the specified channel in the image's channel stack",
  "This procedure raises the specified channel one step in the existing channel stack. It will not move the channel if there is no channel above it.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_raise_channel_inargs,
  0,
  NULL,
  { { image_raise_channel_invoker } }
};

static Argument *
image_lower_channel_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    success = gimp_image_lower_layer (gimage, layer);

  return procedural_db_return_args (&image_lower_channel_proc, success);
}

static ProcArg image_lower_channel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to lower"
  }
};

static ProcRecord image_lower_channel_proc =
{
  "gimp_image_lower_channel",
  "Lower the specified layer in the image's layer stack",
  "This procedure lowers the specified layer one step in the existing layer stack. It will not move the layer if there is no layer below it, or the layer has no alpha channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_lower_channel_inargs,
  0,
  NULL,
  { { image_lower_channel_invoker } }
};

static Argument *
image_flatten_invoker (Gimp         *gimp,
                       GimpContext  *context,
                       GimpProgress *progress,
                       Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpLayer *layer = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    success = (layer = gimp_image_flatten (gimage, context)) != NULL;

  return_args = procedural_db_return_args (&image_flatten_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer));

  return return_args;
}

static ProcArg image_flatten_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_flatten_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The resulting layer"
  }
};

static ProcRecord image_flatten_proc =
{
  "gimp_image_flatten",
  "Flatten all visible layers into a single layer. Discard all invisible layers.",
  "This procedure combines the visible layers in a manner analogous to merging with the CLIP_TO_IMAGE merge type. Non-visible layers are discarded, and the resulting image is stripped of its alpha channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_flatten_inargs,
  1,
  image_flatten_outargs,
  { { image_flatten_invoker } }
};

static Argument *
image_merge_visible_layers_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 merge_type;
  GimpLayer *layer = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  merge_type = args[1].value.pdb_int;
  if (merge_type < GIMP_EXPAND_AS_NECESSARY || merge_type > GIMP_CLIP_TO_BOTTOM_LAYER)
    success = FALSE;

  if (success)
    {
      layer = gimp_image_merge_visible_layers (gimage, context, merge_type);
      success = layer != NULL;
    }

  return_args = procedural_db_return_args (&image_merge_visible_layers_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer));

  return return_args;
}

static ProcArg image_merge_visible_layers_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "merge_type",
    "The type of merge: { GIMP_EXPAND_AS_NECESSARY (0), GIMP_CLIP_TO_IMAGE (1), GIMP_CLIP_TO_BOTTOM_LAYER (2) }"
  }
};

static ProcArg image_merge_visible_layers_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The resulting layer"
  }
};

static ProcRecord image_merge_visible_layers_proc =
{
  "gimp_image_merge_visible_layers",
  "Merge the visible image layers into one.",
  "This procedure combines the visible layers into a single layer using the specified merge type. A merge type of EXPAND_AS_NECESSARY expands the final layer to encompass the areas of the visible layers. A merge type of CLIP_TO_IMAGE clips the final layer to the extents of the image. A merge type of CLIP_TO_BOTTOM_LAYER clips the final layer to the size of the bottommost layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_merge_visible_layers_inargs,
  1,
  image_merge_visible_layers_outargs,
  { { image_merge_visible_layers_invoker } }
};

static Argument *
image_merge_down_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpLayer *merge_layer;
  gint32 merge_type;
  GimpLayer *layer = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  merge_layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (merge_layer) && ! gimp_item_is_removed (GIMP_ITEM (merge_layer))))
    success = FALSE;

  merge_type = args[2].value.pdb_int;
  if (merge_type < GIMP_EXPAND_AS_NECESSARY || merge_type > GIMP_CLIP_TO_BOTTOM_LAYER)
    success = FALSE;

  if (success)
    {
      layer = gimp_image_merge_down (gimage, merge_layer, context, merge_type);
      success = layer != NULL;
    }

  return_args = procedural_db_return_args (&image_merge_down_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer));

  return return_args;
}

static ProcArg image_merge_down_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "merge_layer",
    "The layer to merge down from"
  },
  {
    GIMP_PDB_INT32,
    "merge_type",
    "The type of merge: { GIMP_EXPAND_AS_NECESSARY (0), GIMP_CLIP_TO_IMAGE (1), GIMP_CLIP_TO_BOTTOM_LAYER (2) }"
  }
};

static ProcArg image_merge_down_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The resulting layer"
  }
};

static ProcRecord image_merge_down_proc =
{
  "gimp_image_merge_down",
  "Merge the layer passed and the first visible layer below.",
  "This procedure combines the passed layer and the first visible layer below it using the specified merge type. A merge type of EXPAND_AS_NECESSARY expands the final layer to encompass the areas of the visible layers. A merge type of CLIP_TO_IMAGE clips the final layer to the extents of the image. A merge type of CLIP_TO_BOTTOM_LAYER clips the final layer to the size of the bottommost layer.",
  "Larry Ewing",
  "Larry Ewing",
  "1998",
  NULL,
  GIMP_INTERNAL,
  3,
  image_merge_down_inargs,
  1,
  image_merge_down_outargs,
  { { image_merge_down_invoker } }
};

static Argument *
image_add_layer_mask_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;
  GimpLayerMask *mask;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  mask = (GimpLayerMask *) gimp_item_get_by_ID (gimp, args[2].value.pdb_int);
  if (! (GIMP_IS_LAYER_MASK (mask) && ! gimp_item_is_removed (GIMP_ITEM (mask))))
    success = FALSE;

  if (success)
    {
      success = gimp_layer_add_mask (layer, mask, TRUE) != NULL;
    }

  return procedural_db_return_args (&image_add_layer_mask_proc, success);
}

static ProcArg image_add_layer_mask_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to receive the mask"
  },
  {
    GIMP_PDB_CHANNEL,
    "mask",
    "The mask to add to the layer"
  }
};

static ProcRecord image_add_layer_mask_proc =
{
  "gimp_image_add_layer_mask",
  "This procedure is deprecated! Use 'gimp_layer_add_mask' instead.",
  "This procedure is deprecated! Use 'gimp_layer_add_mask' instead.",
  "",
  "",
  "",
  "gimp_layer_add_mask",
  GIMP_INTERNAL,
  3,
  image_add_layer_mask_inargs,
  0,
  NULL,
  { { image_add_layer_mask_invoker } }
};

static Argument *
image_remove_layer_mask_invoker (Gimp         *gimp,
                                 GimpContext  *context,
                                 GimpProgress *progress,
                                 Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *layer;
  gint32 mode;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  mode = args[2].value.pdb_int;
  if (mode < GIMP_MASK_APPLY || mode > GIMP_MASK_DISCARD)
    success = FALSE;

  if (success)
    gimp_layer_apply_mask (layer, mode, TRUE);

  return procedural_db_return_args (&image_remove_layer_mask_proc, success);
}

static ProcArg image_remove_layer_mask_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer from which to remove mask"
  },
  {
    GIMP_PDB_INT32,
    "mode",
    "Removal mode: { GIMP_MASK_APPLY (0), GIMP_MASK_DISCARD (1) }"
  }
};

static ProcRecord image_remove_layer_mask_proc =
{
  "gimp_image_remove_layer_mask",
  "This procedure is deprecated! Use 'gimp_layer_remove_mask' instead.",
  "This procedure is deprecated! Use 'gimp_layer_remove_mask' instead.",
  "",
  "",
  "",
  "gimp_layer_remove_mask",
  GIMP_INTERNAL,
  3,
  image_remove_layer_mask_inargs,
  0,
  NULL,
  { { image_remove_layer_mask_invoker } }
};

static Argument *
image_get_colormap_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 num_bytes = 0;
  guint8 *colormap = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      num_bytes = 3 * gimp_image_get_colormap_size (gimage);
      colormap = g_memdup (gimp_image_get_colormap (gimage), num_bytes);
    }

  return_args = procedural_db_return_args (&image_get_colormap_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_bytes;
      return_args[2].value.pdb_pointer = colormap;
    }

  return return_args;
}

static ProcArg image_get_colormap_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_colormap_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num_bytes",
    "Number of bytes in the colormap array: 0 < num_bytes"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "colormap",
    "The image's colormap"
  }
};

static ProcRecord image_get_colormap_proc =
{
  "gimp_image_get_colormap",
  "Returns the image's colormap",
  "This procedure returns an actual pointer to the image's colormap, as well as the number of bytes contained in the colormap. The actual number of colors in the transmitted colormap will be \"num_bytes\" / 3. If the image is not of base type GIMP_INDEXED, this pointer will be NULL.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_colormap_inargs,
  2,
  image_get_colormap_outargs,
  { { image_get_colormap_invoker } }
};

static Argument *
image_set_colormap_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 num_bytes;
  guint8 *colormap;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  num_bytes = args[1].value.pdb_int;
  if (num_bytes < 0 || num_bytes > 768)
    success = FALSE;

  colormap = (guint8 *) args[2].value.pdb_pointer;

  if (success)
    gimp_image_set_colormap (gimage, colormap, num_bytes / 3, TRUE);

  return procedural_db_return_args (&image_set_colormap_proc, success);
}

static ProcArg image_set_colormap_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "num_bytes",
    "Number of bytes in the colormap array: 0 <= num_bytes <= 768"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "colormap",
    "The new colormap values"
  }
};

static ProcRecord image_set_colormap_proc =
{
  "gimp_image_set_colormap",
  "Sets the entries in the image's colormap.",
  "This procedure sets the entries in the specified image's colormap. The number of entries is specified by the \"num_bytes\" parameter and corresponds to the number of INT8 triples that must be contained in the \"colormap\" array. The actual number of colors in the transmitted colormap is \"num_bytes\" / 3.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_set_colormap_inargs,
  0,
  NULL,
  { { image_set_colormap_invoker } }
};

static Argument *
image_clean_all_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    gimp_image_clean_all (gimage);

  return procedural_db_return_args (&image_clean_all_proc, success);
}

static ProcArg image_clean_all_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcRecord image_clean_all_proc =
{
  "gimp_image_clean_all",
  "Set the image dirty count to 0.",
  "This procedure sets the specified image's dirty count to 0, allowing operations to occur without having a 'dirtied' image. This is especially useful for creating and loading images which should not initially be considered dirty, even though layers must be created, filled, and installed in the image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_clean_all_inargs,
  0,
  NULL,
  { { image_clean_all_invoker } }
};

static Argument *
image_is_dirty_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gboolean dirty = FALSE;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    dirty = (gimage->dirty != 0);

  return_args = procedural_db_return_args (&image_is_dirty_proc, success);

  if (success)
    return_args[1].value.pdb_int = dirty;

  return return_args;
}

static ProcArg image_is_dirty_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_is_dirty_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "dirty",
    "True if the image has unsaved changes."
  }
};

static ProcRecord image_is_dirty_proc =
{
  "gimp_image_is_dirty",
  "Checks if the image has unsaved changes.",
  "This procedure checks the specified image's dirty count to see if it needs to be saved.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_is_dirty_inargs,
  1,
  image_is_dirty_outargs,
  { { image_is_dirty_invoker } }
};

static Argument *
image_thumbnail_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 req_width;
  gint32 req_height;
  gint32 width = 0;
  gint32 height = 0;
  gint32 bpp = 0;
  gint32 num_bytes = 0;
  guint8 *thumbnail_data = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  req_width = args[1].value.pdb_int;
  if (req_width <= 0 || req_width > 1024)
    success = FALSE;

  req_height = args[2].value.pdb_int;
  if (req_height <= 0 || req_height > 1024)
    success = FALSE;

  if (success)
    {
      TempBuf *buf;
      gint     dwidth, dheight;

      g_assert (GIMP_VIEWABLE_MAX_PREVIEW_SIZE >= 1024);

      /* Adjust the width/height ratio */
      dwidth  = gimp_image_get_width  (gimage);
      dheight = gimp_image_get_height (gimage);

      if (dwidth > dheight)
        req_height = MAX (1, (req_width * dheight) / dwidth);
      else
        req_width  = MAX (1, (req_height * dwidth) / dheight);

      if (gimage->gimp->config->layer_previews)
        buf = gimp_viewable_get_new_preview (GIMP_VIEWABLE (gimage),
                                             req_width, req_height);
      else
        buf = gimp_viewable_get_dummy_preview (GIMP_VIEWABLE (gimage),
                                               req_width, req_height,
                                               gimp_image_has_alpha (gimage) ?
                                               4 : 3);

      if (buf)
        {
          num_bytes      = buf->height * buf->width * buf->bytes;
          thumbnail_data = g_memdup (temp_buf_data (buf), num_bytes);
          width          = buf->width;
          height         = buf->height;
          bpp            = buf->bytes;

          temp_buf_free (buf);
        }
      else
        {
          success = FALSE;
        }
    }

  return_args = procedural_db_return_args (&image_thumbnail_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = width;
      return_args[2].value.pdb_int = height;
      return_args[3].value.pdb_int = bpp;
      return_args[4].value.pdb_int = num_bytes;
      return_args[5].value.pdb_pointer = thumbnail_data;
    }

  return return_args;
}

static ProcArg image_thumbnail_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "width",
    "The thumbnail width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The thumbnail height"
  }
};

static ProcArg image_thumbnail_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The previews width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The previews height"
  },
  {
    GIMP_PDB_INT32,
    "bpp",
    "The previews bpp"
  },
  {
    GIMP_PDB_INT32,
    "thumbnail_data_count",
    "The number of bytes in thumbnail data"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "thumbnail_data",
    "The thumbnail data"
  }
};

static ProcRecord image_thumbnail_proc =
{
  "gimp_image_thumbnail",
  "Get a thumbnail of an image.",
  "This function gets data from which a thumbnail of an image preview can be created. Maximum x or y dimension is 1024 pixels. The pixels are returned in RGB[A] or GRAY[A] format. The bpp return value gives the number of bits per pixel in the image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  NULL,
  GIMP_INTERNAL,
  3,
  image_thumbnail_inargs,
  5,
  image_thumbnail_outargs,
  { { image_thumbnail_invoker } }
};

static Argument *
image_get_active_layer_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpLayer *active_layer = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    active_layer = gimp_image_get_active_layer (gimage);

  return_args = procedural_db_return_args (&image_get_active_layer_proc, success);

  if (success)
    return_args[1].value.pdb_int = active_layer ? gimp_item_get_ID (GIMP_ITEM (active_layer)) : -1;

  return return_args;
}

static ProcArg image_get_active_layer_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_active_layer_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "active_layer",
    "The active layer"
  }
};

static ProcRecord image_get_active_layer_proc =
{
  "gimp_image_get_active_layer",
  "Returns the specified image's active layer.",
  "If there is an active layer, its ID will be returned, otherwise, -1. If a channel is currently active, then no layer will be. If a layer mask is active, then this will return the associated layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_active_layer_inargs,
  1,
  image_get_active_layer_outargs,
  { { image_get_active_layer_invoker } }
};

static Argument *
image_set_active_layer_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpLayer *active_layer;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  active_layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER (active_layer) && ! gimp_item_is_removed (GIMP_ITEM (active_layer))))
    success = FALSE;

  if (success)
    success = (gimp_image_set_active_layer (gimage, active_layer) == active_layer);

  return procedural_db_return_args (&image_set_active_layer_proc, success);
}

static ProcArg image_set_active_layer_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_LAYER,
    "active_layer",
    "The new image active layer"
  }
};

static ProcRecord image_set_active_layer_proc =
{
  "gimp_image_set_active_layer",
  "Sets the specified image's active layer.",
  "If the layer exists, it is set as the active layer in the image. Any previous active layer or channel is set to inactive. An exception is a previously existing floating selection, in which case this procedure will return an execution error.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_set_active_layer_inargs,
  0,
  NULL,
  { { image_set_active_layer_invoker } }
};

static Argument *
image_get_active_channel_invoker (Gimp         *gimp,
                                  GimpContext  *context,
                                  GimpProgress *progress,
                                  Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpChannel *active_channel = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    active_channel = gimp_image_get_active_channel (gimage);

  return_args = procedural_db_return_args (&image_get_active_channel_proc, success);

  if (success)
    return_args[1].value.pdb_int = active_channel ? gimp_item_get_ID (GIMP_ITEM (active_channel)) : -1;

  return return_args;
}

static ProcArg image_get_active_channel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_active_channel_outargs[] =
{
  {
    GIMP_PDB_CHANNEL,
    "active_channel",
    "The active channel"
  }
};

static ProcRecord image_get_active_channel_proc =
{
  "gimp_image_get_active_channel",
  "Returns the specified image's active channel.",
  "If there is an active channel, this will return the channel ID, otherwise, -1.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_active_channel_inargs,
  1,
  image_get_active_channel_outargs,
  { { image_get_active_channel_invoker } }
};

static Argument *
image_set_active_channel_invoker (Gimp         *gimp,
                                  GimpContext  *context,
                                  GimpProgress *progress,
                                  Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpChannel *active_channel;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  active_channel = (GimpChannel *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_CHANNEL (active_channel) && ! gimp_item_is_removed (GIMP_ITEM (active_channel))))
    success = FALSE;

  if (success)
    success = (gimp_image_set_active_channel (gimage, active_channel) == active_channel);

  return procedural_db_return_args (&image_set_active_channel_proc, success);
}

static ProcArg image_set_active_channel_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_CHANNEL,
    "active_channel",
    "The new image active channel"
  }
};

static ProcRecord image_set_active_channel_proc =
{
  "gimp_image_set_active_channel",
  "Sets the specified image's active channel.",
  "If the channel exists, it is set as the active channel in the image. Any previous active channel or channel is set to inactive. An exception is a previously existing floating selection, in which case this procedure will return an execution error.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_set_active_channel_inargs,
  0,
  NULL,
  { { image_set_active_channel_invoker } }
};

static Argument *
image_get_selection_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpChannel *selection = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    success = (selection = gimp_image_get_mask (gimage)) != NULL;

  return_args = procedural_db_return_args (&image_get_selection_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (selection));

  return return_args;
}

static ProcArg image_get_selection_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_selection_outargs[] =
{
  {
    GIMP_PDB_SELECTION,
    "selection",
    "The selection channel"
  }
};

static ProcRecord image_get_selection_proc =
{
  "gimp_image_get_selection",
  "Returns the specified image's selection.",
  "This will always return a valid ID for a selection -- which is represented as a channel internally.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_selection_inargs,
  1,
  image_get_selection_outargs,
  { { image_get_selection_invoker } }
};

static Argument *
image_get_component_active_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 component;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  component = args[1].value.pdb_int;
  if (component < GIMP_RED_CHANNEL || component > GIMP_ALPHA_CHANNEL)
    success = FALSE;

  if (success)
    {
      if (component == GIMP_GRAY_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_GRAY;
      else if (component == GIMP_INDEXED_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_INDEXED;
      else
        success = gimp_image_base_type (gimage) == GIMP_RGB;
    }

  return_args = procedural_db_return_args (&image_get_component_active_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_image_get_component_active (gimage, component);

  return return_args;
}

static ProcArg image_get_component_active_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "component",
    "The image component: { GIMP_RED_CHANNEL (0), GIMP_GREEN_CHANNEL (1), GIMP_BLUE_CHANNEL (2), GIMP_GRAY_CHANNEL (3), GIMP_INDEXED_CHANNEL (4), GIMP_ALPHA_CHANNEL (5) }"
  }
};

static ProcArg image_get_component_active_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "active",
    "Component is active (TRUE or FALSE)"
  }
};

static ProcRecord image_get_component_active_proc =
{
  "gimp_image_get_component_active",
  "Returns if the specified image's image component is active.",
  "This procedure returns if the specified image's image component (i.e. Red, Green, Blue intensity channels in an RGB image) is active or inactive -- whether or not it can be modified. If the specified component is not valid for the image type, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_get_component_active_inargs,
  1,
  image_get_component_active_outargs,
  { { image_get_component_active_invoker } }
};

static Argument *
image_set_component_active_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 component;
  gboolean active;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  component = args[1].value.pdb_int;
  if (component < GIMP_RED_CHANNEL || component > GIMP_ALPHA_CHANNEL)
    success = FALSE;

  active = args[2].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      if (component == GIMP_GRAY_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_GRAY;
      else if (component == GIMP_INDEXED_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_INDEXED;
      else
        success = gimp_image_base_type (gimage) == GIMP_RGB;

      if (success)
        gimp_image_set_component_active (gimage, component, active);
    }

  return procedural_db_return_args (&image_set_component_active_proc, success);
}

static ProcArg image_set_component_active_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "component",
    "The image component: { GIMP_RED_CHANNEL (0), GIMP_GREEN_CHANNEL (1), GIMP_BLUE_CHANNEL (2), GIMP_GRAY_CHANNEL (3), GIMP_INDEXED_CHANNEL (4), GIMP_ALPHA_CHANNEL (5) }"
  },
  {
    GIMP_PDB_INT32,
    "active",
    "Component is active (TRUE or FALSE)"
  }
};

static ProcRecord image_set_component_active_proc =
{
  "gimp_image_set_component_active",
  "Sets if the specified image's image component is active.",
  "This procedure sets if the specified image's image component (i.e. Red, Green, Blue intensity channels in an RGB image) is active or inactive -- whether or not it can be modified. If the specified component is not valid for the image type, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_set_component_active_inargs,
  0,
  NULL,
  { { image_set_component_active_invoker } }
};

static Argument *
image_get_component_visible_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 component;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  component = args[1].value.pdb_int;
  if (component < GIMP_RED_CHANNEL || component > GIMP_ALPHA_CHANNEL)
    success = FALSE;

  if (success)
    {
      if (component == GIMP_GRAY_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_GRAY;
      else if (component == GIMP_INDEXED_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_INDEXED;
      else
        success = gimp_image_base_type (gimage) == GIMP_RGB;
    }

  return_args = procedural_db_return_args (&image_get_component_visible_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_image_get_component_visible (gimage, component);

  return return_args;
}

static ProcArg image_get_component_visible_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "component",
    "The image component: { GIMP_RED_CHANNEL (0), GIMP_GREEN_CHANNEL (1), GIMP_BLUE_CHANNEL (2), GIMP_GRAY_CHANNEL (3), GIMP_INDEXED_CHANNEL (4), GIMP_ALPHA_CHANNEL (5) }"
  }
};

static ProcArg image_get_component_visible_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "visible",
    "Component is visible (TRUE or FALSE)"
  }
};

static ProcRecord image_get_component_visible_proc =
{
  "gimp_image_get_component_visible",
  "Returns if the specified image's image component is visible.",
  "This procedure returns if the specified image's image component (i.e. Red, Green, Blue intensity channels in an RGB image) is visible or invisible -- whether or not it can be seen. If the specified component is not valid for the image type, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_get_component_visible_inargs,
  1,
  image_get_component_visible_outargs,
  { { image_get_component_visible_invoker } }
};

static Argument *
image_set_component_visible_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 component;
  gboolean visible;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  component = args[1].value.pdb_int;
  if (component < GIMP_RED_CHANNEL || component > GIMP_ALPHA_CHANNEL)
    success = FALSE;

  visible = args[2].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      if (component == GIMP_GRAY_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_GRAY;
      else if (component == GIMP_INDEXED_CHANNEL)
        success = gimp_image_base_type (gimage) == GIMP_INDEXED;
      else
        success = gimp_image_base_type (gimage) == GIMP_RGB;

      if (success)
        gimp_image_set_component_visible (gimage, component, visible);
    }

  return procedural_db_return_args (&image_set_component_visible_proc, success);
}

static ProcArg image_set_component_visible_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "component",
    "The image component: { GIMP_RED_CHANNEL (0), GIMP_GREEN_CHANNEL (1), GIMP_BLUE_CHANNEL (2), GIMP_GRAY_CHANNEL (3), GIMP_INDEXED_CHANNEL (4), GIMP_ALPHA_CHANNEL (5) }"
  },
  {
    GIMP_PDB_INT32,
    "visible",
    "Component is visible (TRUE or FALSE)"
  }
};

static ProcRecord image_set_component_visible_proc =
{
  "gimp_image_set_component_visible",
  "Sets if the specified image's image component is visible.",
  "This procedure sets if the specified image's image component (i.e. Red, Green, Blue intensity channels in an RGB image) is visible or invisible -- whether or not it can be seen. If the specified component is not valid for the image type, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  image_set_component_visible_inargs,
  0,
  NULL,
  { { image_set_component_visible_invoker } }
};

static Argument *
image_get_filename_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  return_args = procedural_db_return_args (&image_get_filename_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = gimp_image_get_filename (gimage);

  return return_args;
}

static ProcArg image_get_filename_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_filename_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "filename",
    "The filename"
  }
};

static ProcRecord image_get_filename_proc =
{
  "gimp_image_get_filename",
  "Returns the specified image's filename.",
  "This procedure returns the specified image's filename in the filesystem encoding. The image has a filename only if it was loaded or has since been saved. Otherwise, this function returns %NULL.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_filename_inargs,
  1,
  image_get_filename_outargs,
  { { image_get_filename_invoker } }
};

static Argument *
image_set_filename_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gchar *filename;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  filename = (gchar *) args[1].value.pdb_pointer;
  if (filename == NULL)
    success = FALSE;

  if (success)
    {
      /*  verify that the filename can be converted to UTF-8 and back  */
      gchar *utf8 = g_filename_to_utf8 (filename, -1, NULL, NULL, NULL);

      if (utf8)
        {
          gchar *tmp = g_filename_from_utf8 (utf8, -1, NULL, NULL, NULL);

          if (tmp)
            g_free (tmp);
          else
            success = FALSE;

          g_free (utf8);
        }
      else
        success = FALSE;

      if (success)
        gimp_image_set_filename (gimage, filename);
    }

  return procedural_db_return_args (&image_set_filename_proc, success);
}

static ProcArg image_set_filename_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_STRING,
    "filename",
    "The new image filename"
  }
};

static ProcRecord image_set_filename_proc =
{
  "gimp_image_set_filename",
  "Sets the specified image's filename.",
  "This procedure sets the specified image's filename. The filename should be in the filesystem encoding.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  image_set_filename_inargs,
  0,
  NULL,
  { { image_set_filename_invoker } }
};

static Argument *
image_get_name_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gchar *name = NULL;
  gchar *filename;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      filename = gimp_image_get_filename (gimage);

      if (filename)
        {
          gchar *basename = g_path_get_basename (filename);
          name = g_filename_to_utf8 (basename, -1, NULL, NULL, NULL);
          g_free (basename);

          if (! name)
            name = g_strdup (_("(invalid UTF-8 string)"));
        }
      else
        {
          name = g_strdup (_("Untitled"));
        }
    }

  return_args = procedural_db_return_args (&image_get_name_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = name;

  return return_args;
}

static ProcArg image_get_name_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_name_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The name"
  }
};

static ProcRecord image_get_name_proc =
{
  "gimp_image_get_name",
  "Returns the specified image's name.",
  "This procedure returns the specified image's name.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_name_inargs,
  1,
  image_get_name_outargs,
  { { image_get_name_invoker } }
};

static Argument *
image_get_resolution_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  return_args = procedural_db_return_args (&image_get_resolution_proc, success);

  if (success)
    {
      return_args[1].value.pdb_float = gimage->xresolution;
      return_args[2].value.pdb_float = gimage->yresolution;
    }

  return return_args;
}

static ProcArg image_get_resolution_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_resolution_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "xresolution",
    "The resolutionin the x-axis, in dots per inch"
  },
  {
    GIMP_PDB_FLOAT,
    "yresolution",
    "The resolutionin the y-axis, in dots per inch"
  }
};

static ProcRecord image_get_resolution_proc =
{
  "gimp_image_get_resolution",
  "Returns the specified image's resolution.",
  "This procedure returns the specified image's resolution in dots per inch. This value is independent of any of the layers in this image.",
  "Austin Donnelly",
  "Austin Donnelly",
  "1998",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_resolution_inargs,
  2,
  image_get_resolution_outargs,
  { { image_get_resolution_invoker } }
};

static Argument *
image_set_resolution_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gdouble xresolution;
  gdouble yresolution;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  xresolution = args[1].value.pdb_float;

  yresolution = args[2].value.pdb_float;

  if (success)
    {
      if (! FINITE (xresolution) ||
          xresolution < GIMP_MIN_RESOLUTION || xresolution > GIMP_MAX_RESOLUTION ||
          ! FINITE (yresolution) ||
          yresolution < GIMP_MIN_RESOLUTION || yresolution > GIMP_MAX_RESOLUTION)
        {
          g_message (_("Image resolution is out of bounds, "
                       "using the default resolution instead."));
          success = FALSE;
        }
      else
        {
          gimp_image_set_resolution (gimage, xresolution, yresolution);
        }
    }

  return procedural_db_return_args (&image_set_resolution_proc, success);
}

static ProcArg image_set_resolution_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_FLOAT,
    "xresolution",
    "The new image resolution (xresolution)in the x-axis, in dots per inch"
  },
  {
    GIMP_PDB_FLOAT,
    "yresolution",
    "The new image resolution (yresolution)in the y-axis, in dots per inch"
  }
};

static ProcRecord image_set_resolution_proc =
{
  "gimp_image_set_resolution",
  "Sets the specified image's resolution.",
  "This procedure sets the specified image's resolution in dots per inch. This value is independent of any of the layers in this image. No scaling or resizing is performed.",
  "Austin Donnelly",
  "Austin Donnelly",
  "1998",
  NULL,
  GIMP_INTERNAL,
  3,
  image_set_resolution_inargs,
  0,
  NULL,
  { { image_set_resolution_invoker } }
};

static Argument *
image_get_unit_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  return_args = procedural_db_return_args (&image_get_unit_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_image_get_unit (gimage);

  return return_args;
}

static ProcArg image_get_unit_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_unit_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "unit",
    "The unit"
  }
};

static ProcRecord image_get_unit_proc =
{
  "gimp_image_get_unit",
  "Returns the specified image's unit.",
  "This procedure returns the specified image's unit. This value is independent of any of the layers in this image. See the gimp_unit_* procedure definitions for the valid range of unit IDs and a description of the unit system.",
  "Michael Natterer",
  "Michael Natterer",
  "1998",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_unit_inargs,
  1,
  image_get_unit_outargs,
  { { image_get_unit_invoker } }
};

static Argument *
image_set_unit_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpUnit unit;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  unit = args[1].value.pdb_int;
  if (unit < GIMP_UNIT_INCH || unit >= _gimp_unit_get_number_of_units (gimp))
    success = FALSE;

  if (success)
    gimp_image_set_unit (gimage, unit);

  return procedural_db_return_args (&image_set_unit_proc, success);
}

static ProcArg image_set_unit_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "unit",
    "The new image unit"
  }
};

static ProcRecord image_set_unit_proc =
{
  "gimp_image_set_unit",
  "Sets the specified image's unit.",
  "This procedure sets the specified image's unit. No scaling or resizing is performed. This value is independent of any of the layers in this image. See the gimp_unit_* procedure definitions for the valid range of unit IDs and a description of the unit system.",
  "Michael Natterer",
  "Michael Natterer",
  "1998",
  NULL,
  GIMP_INTERNAL,
  2,
  image_set_unit_inargs,
  0,
  NULL,
  { { image_set_unit_invoker } }
};

static Argument *
image_get_tattoo_state_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  return_args = procedural_db_return_args (&image_get_tattoo_state_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_image_get_tattoo_state (gimage);

  return return_args;
}

static ProcArg image_get_tattoo_state_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_get_tattoo_state_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "tattoo_state",
    "The tattoo_state"
  }
};

static ProcRecord image_get_tattoo_state_proc =
{
  "gimp_image_get_tattoo_state",
  "Returns the tattoo state associated with the image.",
  "This procedure returns the tattoo state of the image. Use only by save/load plugins that wish to preserve an images tattoo state. Using this function at other times will produce unexpected results.",
  "Andy Thomas",
  "Andy Thomas",
  "2000",
  NULL,
  GIMP_INTERNAL,
  1,
  image_get_tattoo_state_inargs,
  1,
  image_get_tattoo_state_outargs,
  { { image_get_tattoo_state_invoker } }
};

static Argument *
image_set_tattoo_state_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 tattoo_state;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  tattoo_state = args[1].value.pdb_int;

  if (success)
    gimp_image_set_tattoo_state (gimage, tattoo_state);

  return procedural_db_return_args (&image_set_tattoo_state_proc, success);
}

static ProcArg image_set_tattoo_state_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "tattoo_state",
    "The new image tattoo_state"
  }
};

static ProcRecord image_set_tattoo_state_proc =
{
  "gimp_image_set_tattoo_state",
  "Set the tattoo state associated with the image.",
  "This procedure sets the tattoo state of the image. Use only by save/load plugins that wish to preserve an images tattoo state. Using this function at other times will produce unexpected results. A full check of uniqueness of states in layers, channels and paths will be performed by this procedure and a execution failure will be returned if this fails. A failure will also be returned if the new tattoo state value is less than the maximum tattoo value from all of the tattoos from the paths, layers and channels. After the image data has been loaded and all the tattoos have been set then this is the last procedure that should be called. If effectively does a status check on the tattoo values that have been set to make sure that all is OK.",
  "Andy Thomas",
  "Andy Thomas",
  "2000",
  NULL,
  GIMP_INTERNAL,
  2,
  image_set_tattoo_state_inargs,
  0,
  NULL,
  { { image_set_tattoo_state_invoker } }
};

static Argument *
image_get_layer_by_tattoo_invoker (Gimp         *gimp,
                                   GimpContext  *context,
                                   GimpProgress *progress,
                                   Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 tattoo;
  GimpLayer *layer = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  tattoo = args[1].value.pdb_int;
  if (tattoo == 0)
    success = FALSE;

  if (success)
    {
      layer = gimp_image_get_layer_by_tattoo (gimage, tattoo);
      success = layer != NULL;
    }

  return_args = procedural_db_return_args (&image_get_layer_by_tattoo_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer));

  return return_args;
}

static ProcArg image_get_layer_by_tattoo_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "tattoo",
    "The tattoo of the layer to find"
  }
};

static ProcArg image_get_layer_by_tattoo_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer with the specified tattoo"
  }
};

static ProcRecord image_get_layer_by_tattoo_proc =
{
  "gimp_image_get_layer_by_tattoo",
  "Find a layer with a given tattoo in an image.",
  "This procedure returns the layer with the given tattoo in the specified image.",
  "Jay Cox",
  "Jay Cox",
  "1998",
  NULL,
  GIMP_INTERNAL,
  2,
  image_get_layer_by_tattoo_inargs,
  1,
  image_get_layer_by_tattoo_outargs,
  { { image_get_layer_by_tattoo_invoker } }
};

static Argument *
image_get_channel_by_tattoo_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 tattoo;
  GimpChannel *channel = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  tattoo = args[1].value.pdb_int;
  if (tattoo == 0)
    success = FALSE;

  if (success)
    {
      channel = gimp_image_get_channel_by_tattoo (gimage, tattoo);
      success = channel != NULL;
    }

  return_args = procedural_db_return_args (&image_get_channel_by_tattoo_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (channel));

  return return_args;
}

static ProcArg image_get_channel_by_tattoo_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "tattoo",
    "The tattoo of the channel to find"
  }
};

static ProcArg image_get_channel_by_tattoo_outargs[] =
{
  {
    GIMP_PDB_CHANNEL,
    "channel",
    "The channel with the specified tattoo"
  }
};

static ProcRecord image_get_channel_by_tattoo_proc =
{
  "gimp_image_get_channel_by_tattoo",
  "Find a channel with a given tattoo in an image.",
  "This procedure returns the channel with the given tattoo in the specified image.",
  "Jay Cox",
  "Jay Cox",
  "1998",
  NULL,
  GIMP_INTERNAL,
  2,
  image_get_channel_by_tattoo_inargs,
  1,
  image_get_channel_by_tattoo_outargs,
  { { image_get_channel_by_tattoo_invoker } }
};
