/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2000 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include "appenv.h"

static ProcRecord message_proc;
static ProcRecord message_get_handler_proc;
static ProcRecord message_set_handler_proc;

void
register_message_procs (void)
{
  procedural_db_register (&message_proc);
  procedural_db_register (&message_get_handler_proc);
  procedural_db_register (&message_set_handler_proc);
}

static Argument *
message_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *message;

  message = (gchar *) args[0].value.pdb_pointer;
  if (message == NULL)
    success = FALSE;

  if (success)
    g_message (message, NULL, NULL);

  return procedural_db_return_args (&message_proc, success);
}

static ProcArg message_inargs[] =
{
  {
    PDB_STRING,
    "message",
    "Message to display in the dialog"
  }
};

static ProcRecord message_proc =
{
  "gimp_message",
  "Displays a dialog box with a message.",
  "Displays a dialog box with a message. Useful for status or error reporting.",
  "Manish Singh",
  "Manish Singh",
  "1998",
  PDB_INTERNAL,
  1,
  message_inargs,
  0,
  NULL,
  { { message_invoker } }
};

static Argument *
message_get_handler_invoker (Argument *args)
{
  Argument *return_args;

  return_args = procedural_db_return_args (&message_get_handler_proc, TRUE);
  return_args[1].value.pdb_int = message_handler;

  return return_args;
}

static ProcArg message_get_handler_outargs[] =
{
  {
    PDB_INT32,
    "handler",
    "The current handler type: { MESSAGE_BOX (0), CONSOLE (1), ERROR_CONSOLE (2) }"
  }
};

static ProcRecord message_get_handler_proc =
{
  "gimp_message_get_handler",
  "Returns the current state of where warning messages are displayed.",
  "This procedure returns the way g_message warnings are displayed. They can be shown in a dialog box or printed on the console where gimp was started.",
  "Manish Singh",
  "Manish Singh",
  "1998",
  PDB_INTERNAL,
  0,
  NULL,
  1,
  message_get_handler_outargs,
  { { message_get_handler_invoker } }
};

static Argument *
message_set_handler_invoker (Argument *args)
{
  gboolean success = TRUE;
  gint32 handler;

  handler = args[0].value.pdb_int;
  if (handler < MESSAGE_BOX || handler > ERROR_CONSOLE)
    success = FALSE;

  if (success)
    message_handler = handler;

  return procedural_db_return_args (&message_set_handler_proc, success);
}

static ProcArg message_set_handler_inargs[] =
{
  {
    PDB_INT32,
    "handler",
    "The new handler type: { MESSAGE_BOX (0), CONSOLE (1), ERROR_CONSOLE (2) }"
  }
};

static ProcRecord message_set_handler_proc =
{
  "gimp_message_set_handler",
  "Controls where warning messages are displayed.",
  "This procedure controls how g_message warnings are displayed. They can be shown in a dialog box or printed on the console where gimp was started.",
  "Manish Singh",
  "Manish Singh",
  "1998",
  PDB_INTERNAL,
  1,
  message_set_handler_inargs,
  0,
  NULL,
  { { message_set_handler_invoker } }
};
