/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpconvert_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

void
gimp_convert_rgb (gint32 image_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_convert_rgb",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_convert_grayscale (gint32 image_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_convert_grayscale",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_convert_indexed (gint32                  image_ID,
		      GimpConvertDitherType   dither_type,
		      GimpConvertPaletteType  palette_type,
		      gint                    num_cols,
		      gboolean                alpha_dither,
		      gboolean                remove_unused,
		      gchar                  *palette)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_convert_indexed",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_INT32, dither_type,
				    GIMP_PDB_INT32, palette_type,
				    GIMP_PDB_INT32, num_cols,
				    GIMP_PDB_INT32, alpha_dither,
				    GIMP_PDB_INT32, remove_unused,
				    GIMP_PDB_STRING, palette,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}
