/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimptools_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

void
gimp_airbrush (gint32   drawable_ID,
	       gdouble  pressure,
	       gint     num_strokes,
	       gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_airbrush",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_FLOAT, pressure,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_airbrush_default (gint32   drawable_ID,
		       gint     num_strokes,
		       gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_airbrush_default",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_blend (gint32               drawable_ID,
	    GimpBlendMode        blend_mode,
	    GimpLayerModeEffects paint_mode,
	    GimpGradientType     gradient_type,
	    gdouble              opacity,
	    gdouble              offset,
	    GimpRepeatMode       repeat,
	    gboolean             supersample,
	    gint                 max_depth,
	    gdouble              threshold,
	    gdouble              x1,
	    gdouble              y1,
	    gdouble              x2,
	    gdouble              y2)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_blend",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, blend_mode,
				    PARAM_INT32, paint_mode,
				    PARAM_INT32, gradient_type,
				    PARAM_FLOAT, opacity,
				    PARAM_FLOAT, offset,
				    PARAM_INT32, repeat,
				    PARAM_INT32, supersample,
				    PARAM_INT32, max_depth,
				    PARAM_FLOAT, threshold,
				    PARAM_FLOAT, x1,
				    PARAM_FLOAT, y1,
				    PARAM_FLOAT, x2,
				    PARAM_FLOAT, y2,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_bucket_fill (gint32               drawable_ID,
		  GimpBucketFillMode   fill_mode,
		  GimpLayerModeEffects paint_mode,
		  gdouble              opacity,
		  gdouble              threshold,
		  gboolean             sample_merged,
		  gdouble              x,
		  gdouble              y)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_bucket_fill",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, fill_mode,
				    PARAM_INT32, paint_mode,
				    PARAM_FLOAT, opacity,
				    PARAM_FLOAT, threshold,
				    PARAM_INT32, sample_merged,
				    PARAM_FLOAT, x,
				    PARAM_FLOAT, y,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_by_color_select (gint32         drawable_ID,
		      guchar         red,
		      guchar         green,
		      guchar         blue,
		      gint           threshold,
		      GimpChannelOps operation,
		      gboolean       antialias,
		      gboolean       feather,
		      gdouble        feather_radius,
		      gboolean       sample_merged)
{
  GParam *return_vals;
  gint nreturn_vals;
  guchar color[3];

  color[0] = red;
  color[1] = green;
  color[2] = blue;

  return_vals = gimp_run_procedure ("gimp_by_color_select",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_COLOR, color,
				    PARAM_INT32, threshold,
				    PARAM_INT32, operation,
				    PARAM_INT32, antialias,
				    PARAM_INT32, feather,
				    PARAM_FLOAT, feather_radius,
				    PARAM_INT32, sample_merged,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_clone (gint32         drawable_ID,
	    gint32         src_drawable_ID,
	    GimpCloneType  clone_type,
	    gdouble        src_x,
	    gdouble        src_y,
	    gint           num_strokes,
	    gdouble       *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_clone",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_DRAWABLE, src_drawable_ID,
				    PARAM_INT32, clone_type,
				    PARAM_FLOAT, src_x,
				    PARAM_FLOAT, src_y,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_clone_default (gint32   drawable_ID,
		    gint     num_strokes,
		    gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_clone_default",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_color_picker (gint32    image_ID,
		   gint32    drawable_ID,
		   gdouble   x,
		   gdouble   y,
		   gboolean  sample_merged,
		   gboolean  sample_average,
		   gdouble   average_radius,
		   gboolean  save_color,
		   guchar   *red,
		   guchar   *green,
		   guchar   *blue)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_color_picker",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_FLOAT, x,
				    PARAM_FLOAT, y,
				    PARAM_INT32, sample_merged,
				    PARAM_INT32, sample_average,
				    PARAM_FLOAT, average_radius,
				    PARAM_INT32, save_color,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *red = return_vals[1].data.d_color.red;
      *green = return_vals[1].data.d_color.green;
      *blue = return_vals[1].data.d_color.blue;
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_convolve (gint32            drawable_ID,
	       gdouble           pressure,
	       GimpConvolveType  convolve_type,
	       gint              num_strokes,
	       gdouble          *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_convolve",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_FLOAT, pressure,
				    PARAM_INT32, convolve_type,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_convolve_default (gint32   drawable_ID,
		       gint     num_strokes,
		       gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_convolve_default",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_crop (gint32 image_ID,
	   gint   new_width,
	   gint   new_height,
	   gint   offx,
	   gint   offy)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_crop",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, new_width,
				    PARAM_INT32, new_height,
				    PARAM_INT32, offx,
				    PARAM_INT32, offy,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_dodgeburn (gint32             drawable_ID,
		gdouble            exposure,
		GimpDodgeBurnType  dodgeburn_type,
		GimpDodgeBurnMode  dodgeburn_mode,
		gint               num_strokes,
		gdouble           *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_dodgeburn",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_FLOAT, exposure,
				    PARAM_INT32, dodgeburn_type,
				    PARAM_INT32, dodgeburn_mode,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_dodgeburn_default (gint32   drawable_ID,
			gint     num_strokes,
			gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_dodgeburn_default",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_ellipse_select (gint32         image_ID,
		     gdouble        x,
		     gdouble        y,
		     gdouble        width,
		     gdouble        height,
		     GimpChannelOps operation,
		     gboolean       antialias,
		     gboolean       feather,
		     gdouble        feather_radius)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_ellipse_select",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_FLOAT, x,
				    PARAM_FLOAT, y,
				    PARAM_FLOAT, width,
				    PARAM_FLOAT, height,
				    PARAM_INT32, operation,
				    PARAM_INT32, antialias,
				    PARAM_INT32, feather,
				    PARAM_FLOAT, feather_radius,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_eraser (gint32                    drawable_ID,
	     gint                      num_strokes,
	     gdouble                  *strokes,
	     GimpBrushApplicationMode  hardness,
	     GimpPaintApplicationMode  method)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_eraser",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_INT32, hardness,
				    PARAM_INT32, method,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_eraser_default (gint32   drawable_ID,
		     gint     num_strokes,
		     gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_eraser_default",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_flip (gint32              drawable_ID,
	   GimpOrientationType flip_type)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_flip",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, flip_type,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

void
gimp_free_select (gint32          image_ID,
		  gint            num_segs,
		  gdouble        *segs,
		  GimpChannelOps  operation,
		  gboolean        antialias,
		  gboolean        feather,
		  gdouble         feather_radius)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_free_select",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, num_segs,
				    PARAM_FLOATARRAY, segs,
				    PARAM_INT32, operation,
				    PARAM_INT32, antialias,
				    PARAM_INT32, feather,
				    PARAM_FLOAT, feather_radius,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_fuzzy_select (gint32         drawable_ID,
		   gdouble        x,
		   gdouble        y,
		   gint           threshold,
		   GimpChannelOps operation,
		   gboolean       antialias,
		   gboolean       feather,
		   gdouble        feather_radius,
		   gboolean       sample_merged)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_fuzzy_select",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_FLOAT, x,
				    PARAM_FLOAT, y,
				    PARAM_INT32, threshold,
				    PARAM_INT32, operation,
				    PARAM_INT32, antialias,
				    PARAM_INT32, feather,
				    PARAM_FLOAT, feather_radius,
				    PARAM_INT32, sample_merged,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_paintbrush (gint32                    drawable_ID,
		 gdouble                   fade_out,
		 gint                      num_strokes,
		 gdouble                  *strokes,
		 GimpPaintApplicationMode  method,
		 gdouble                   gradient_length)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_paintbrush",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_FLOAT, fade_out,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_INT32, method,
				    PARAM_FLOAT, gradient_length,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_paintbrush_default (gint32   drawable_ID,
			 gint     num_strokes,
			 gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_paintbrush_default",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_pencil (gint32   drawable_ID,
	     gint     num_strokes,
	     gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_pencil",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_perspective (gint32   drawable_ID,
		  gboolean interpolation,
		  gdouble  x0,
		  gdouble  y0,
		  gdouble  x1,
		  gdouble  y1,
		  gdouble  x2,
		  gdouble  y2,
		  gdouble  x3,
		  gdouble  y3)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_perspective",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, interpolation,
				    PARAM_FLOAT, x0,
				    PARAM_FLOAT, y0,
				    PARAM_FLOAT, x1,
				    PARAM_FLOAT, y1,
				    PARAM_FLOAT, x2,
				    PARAM_FLOAT, y2,
				    PARAM_FLOAT, x3,
				    PARAM_FLOAT, y3,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

void
gimp_rect_select (gint32         image_ID,
		  gdouble        x,
		  gdouble        y,
		  gdouble        width,
		  gdouble        height,
		  GimpChannelOps operation,
		  gboolean       feather,
		  gdouble        feather_radius)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_rect_select",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_FLOAT, x,
				    PARAM_FLOAT, y,
				    PARAM_FLOAT, width,
				    PARAM_FLOAT, height,
				    PARAM_INT32, operation,
				    PARAM_INT32, feather,
				    PARAM_FLOAT, feather_radius,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_rotate (gint32   drawable_ID,
	     gboolean interpolation,
	     gdouble  angle)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_rotate",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, interpolation,
				    PARAM_FLOAT, angle,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

gint32
gimp_scale (gint32   drawable_ID,
	    gboolean interpolation,
	    gdouble  x0,
	    gdouble  y0,
	    gdouble  x1,
	    gdouble  y1)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_scale",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, interpolation,
				    PARAM_FLOAT, x0,
				    PARAM_FLOAT, y0,
				    PARAM_FLOAT, x1,
				    PARAM_FLOAT, y1,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

gint32
gimp_shear (gint32              drawable_ID,
	    gboolean            interpolation,
	    GimpOrientationType shear_type,
	    gdouble             magnitude)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_shear",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, interpolation,
				    PARAM_INT32, shear_type,
				    PARAM_FLOAT, magnitude,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

void
gimp_smudge (gint32   drawable_ID,
	     gdouble  pressure,
	     gint     num_strokes,
	     gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_smudge",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_FLOAT, pressure,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_smudge_default (gint32   drawable_ID,
		     gint     num_strokes,
		     gdouble *strokes)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_smudge_default",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, num_strokes,
				    PARAM_FLOATARRAY, strokes,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_transform_2d (gint32   drawable_ID,
		   gboolean interpolation,
		   gdouble  source_x,
		   gdouble  source_y,
		   gdouble  scale_x,
		   gdouble  scale_y,
		   gdouble  angle,
		   gdouble  dest_x,
		   gdouble  dest_y)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_transform_2d",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, interpolation,
				    PARAM_FLOAT, source_x,
				    PARAM_FLOAT, source_y,
				    PARAM_FLOAT, scale_x,
				    PARAM_FLOAT, scale_y,
				    PARAM_FLOAT, angle,
				    PARAM_FLOAT, dest_x,
				    PARAM_FLOAT, dest_y,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}
