/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpimage_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

gint *
gimp_image_list (gint *num_images)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint *image_ids = NULL;

  return_vals = gimp_run_procedure ("gimp_image_list",
				    &nreturn_vals,
				    PARAM_END);

  *num_images = 0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *num_images = return_vals[1].data.d_int32;
      image_ids = g_new (gint32, *num_images);
      memcpy (image_ids, return_vals[2].data.d_int32array,
	      *num_images * sizeof (gint32));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return image_ids;
}

gint32
gimp_image_new (gint              width,
		gint              height,
		GimpImageBaseType type)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 image_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_new",
				    &nreturn_vals,
				    PARAM_INT32, width,
				    PARAM_INT32, height,
				    PARAM_INT32, type,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    image_ID = return_vals[1].data.d_image;

  gimp_destroy_params (return_vals, nreturn_vals);

  return image_ID;
}

void
gimp_image_resize (gint32 image_ID,
		   gint   new_width,
		   gint   new_height,
		   gint   offx,
		   gint   offy)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_resize",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, new_width,
				    PARAM_INT32, new_height,
				    PARAM_INT32, offx,
				    PARAM_INT32, offy,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_scale (gint32 image_ID,
		  gint   new_width,
		  gint   new_height)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_scale",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, new_width,
				    PARAM_INT32, new_height,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_delete (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_delete",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_free_shadow (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_free_shadow",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint *
gimp_image_get_layers (gint32  image_ID,
		       gint   *num_layers)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint *layer_ids = NULL;

  return_vals = gimp_run_procedure ("gimp_image_get_layers",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  *num_layers = 0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *num_layers = return_vals[1].data.d_int32;
      layer_ids = g_new (gint32, *num_layers);
      memcpy (layer_ids, return_vals[2].data.d_int32array,
	      *num_layers * sizeof (gint32));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_ids;
}

gint *
gimp_image_get_channels (gint32  image_ID,
			 gint   *num_channels)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint *channel_ids = NULL;

  return_vals = gimp_run_procedure ("gimp_image_get_channels",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  *num_channels = 0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *num_channels = return_vals[1].data.d_int32;
      channel_ids = g_new (gint32, *num_channels);
      memcpy (channel_ids, return_vals[2].data.d_int32array,
	      *num_channels * sizeof (gint32));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return channel_ids;
}

void
gimp_image_unset_active_channel (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_unset_active_channel",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_image_pick_correlate_layer (gint32 image_ID,
				 gint   x,
				 gint   y)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_pick_correlate_layer",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, x,
				    PARAM_INT32, y,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_ID;
}

void
gimp_image_raise_layer (gint32 image_ID,
			gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_raise_layer",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_lower_layer (gint32 image_ID,
			gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_lower_layer",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_raise_layer_to_top (gint32 image_ID,
			       gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_raise_layer_to_top",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_lower_layer_to_bottom (gint32 image_ID,
				  gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_lower_layer_to_bottom",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_image_merge_visible_layers (gint32        image_ID,
				 GimpMergeType merge_type)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_merge_visible_layers",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, merge_type,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_ID;
}

gint32
gimp_image_merge_down (gint32        image_ID,
		       gint32        merge_layer_ID,
		       GimpMergeType merge_type)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_merge_down",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, merge_layer_ID,
				    PARAM_INT32, merge_type,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_ID;
}

gint32
gimp_image_flatten (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_flatten",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_ID;
}

void
gimp_image_add_layer (gint32 image_ID,
		      gint32 layer_ID,
		      gint   position)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_add_layer",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, position,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_remove_layer (gint32 image_ID,
			 gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_remove_layer",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_add_layer_mask (gint32 image_ID,
			   gint32 layer_ID,
			   gint32 mask_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_add_layer_mask",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_CHANNEL, mask_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_remove_layer_mask (gint32            image_ID,
			      gint32            layer_ID,
			      GimpMaskApplyMode mode)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_remove_layer_mask",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, mode,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_raise_channel (gint32 image_ID,
			  gint32 channel_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_raise_channel",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_CHANNEL, channel_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_lower_channel (gint32 image_ID,
			  gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_lower_channel",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_add_channel (gint32 image_ID,
			gint32 channel_ID,
			gint   position)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_add_channel",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_CHANNEL, channel_ID,
				    PARAM_INT32, position,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_remove_channel (gint32 image_ID,
			   gint32 channel_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_remove_channel",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_CHANNEL, channel_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_image_active_drawable (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_active_drawable",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return drawable_ID;
}

GimpImageBaseType
gimp_image_base_type (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  GimpImageBaseType base_type = 0;

  return_vals = gimp_run_procedure ("gimp_image_base_type",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    base_type = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return base_type;
}

guint8 *
_gimp_image_get_cmap (gint32  image_ID,
		      gint   *num_bytes)
{
  GParam *return_vals;
  gint nreturn_vals;
  guint8 *cmap = NULL;

  return_vals = gimp_run_procedure ("gimp_image_get_cmap",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  *num_bytes = 0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *num_bytes = return_vals[1].data.d_int32;
      cmap = g_new (guint8, *num_bytes);
      memcpy (cmap, return_vals[2].data.d_int8array,
	      *num_bytes * sizeof (guint8));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return cmap;
}

void
_gimp_image_set_cmap (gint32  image_ID,
		      gint    num_bytes,
		      guint8 *cmap)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_cmap",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, num_bytes,
				    PARAM_INT8ARRAY, cmap,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_image_undo_is_enabled (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean enabled = FALSE;

  return_vals = gimp_run_procedure ("gimp_image_undo_is_enabled",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    enabled = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return enabled;
}

gboolean
gimp_image_undo_enable (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean enabled = FALSE;

  return_vals = gimp_run_procedure ("gimp_image_undo_enable",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    enabled = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return enabled;
}

gboolean
gimp_image_undo_disable (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean disabled = FALSE;

  return_vals = gimp_run_procedure ("gimp_image_undo_disable",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    disabled = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return disabled;
}

gboolean
gimp_image_undo_freeze (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean frozen = FALSE;

  return_vals = gimp_run_procedure ("gimp_image_undo_freeze",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    frozen = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return frozen;
}

gboolean
gimp_image_undo_thaw (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean thawed = FALSE;

  return_vals = gimp_run_procedure ("gimp_image_undo_thaw",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    thawed = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return thawed;
}

void
gimp_image_clean_all (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_clean_all",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_image_floating_selection (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 floating_sel_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_floating_selection",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    floating_sel_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return floating_sel_ID;
}

gint32
gimp_image_floating_sel_attached_to (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_floating_sel_attached_to",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return drawable_ID;
}

void
_gimp_image_thumbnail (gint32   image_ID,
		       gint     width,
		       gint     height,
		       gint    *ret_width,
		       gint    *ret_height,
		       gint    *bpp,
		       gint    *thumbnail_data_count,
		       guint8 **thumbnail_data)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_thumbnail",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, width,
				    PARAM_INT32, height,
				    PARAM_END);

  *ret_width = 0;
  *ret_height = 0;
  *bpp = 0;
  *thumbnail_data_count = 0;
  *thumbnail_data = NULL;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *ret_width = return_vals[1].data.d_int32;
      *ret_height = return_vals[2].data.d_int32;
      *bpp = return_vals[3].data.d_int32;
      *thumbnail_data_count = return_vals[4].data.d_int32;
      *thumbnail_data = g_new (guint8, *thumbnail_data_count);
      memcpy (*thumbnail_data, return_vals[5].data.d_int8array,
	      *thumbnail_data_count * sizeof (guint8));
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_set_tattoo_state (gint32 image_ID,
			     gint   tattoo)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_tattoo_state",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, tattoo,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint
gimp_image_get_tattoo_state (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint tattoo = 0;

  return_vals = gimp_run_procedure ("gimp_image_get_tattoo_state",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    tattoo = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return tattoo;
}

gint
gimp_image_width (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint width = 0;

  return_vals = gimp_run_procedure ("gimp_image_width",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    width = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return width;
}

gint
gimp_image_height (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint height = 0;

  return_vals = gimp_run_procedure ("gimp_image_height",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    height = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return height;
}

gint32
gimp_image_get_active_layer (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 active_layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_get_active_layer",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    active_layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return active_layer_ID;
}

void
gimp_image_set_active_layer (gint32 image_ID,
			     gint32 active_layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_active_layer",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_LAYER, active_layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_image_get_active_channel (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 active_channel_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_get_active_channel",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    active_channel_ID = return_vals[1].data.d_channel;

  gimp_destroy_params (return_vals, nreturn_vals);

  return active_channel_ID;
}

void
gimp_image_set_active_channel (gint32 image_ID,
			       gint32 active_channel_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_active_channel",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_CHANNEL, active_channel_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_image_get_selection (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 selection_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_get_selection",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    selection_ID = return_vals[1].data.d_selection;

  gimp_destroy_params (return_vals, nreturn_vals);

  return selection_ID;
}

gboolean
gimp_image_get_component_active (gint32          image_ID,
				 GimpChannelType component)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean active = FALSE;

  return_vals = gimp_run_procedure ("gimp_image_get_component_active",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, component,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    active = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return active;
}

void
gimp_image_set_component_active (gint32          image_ID,
				 GimpChannelType component,
				 gboolean        active)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_component_active",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, component,
				    PARAM_INT32, active,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_image_get_component_visible (gint32          image_ID,
				  GimpChannelType component)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean visible = FALSE;

  return_vals = gimp_run_procedure ("gimp_image_get_component_visible",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, component,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    visible = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return visible;
}

void
gimp_image_set_component_visible (gint32          image_ID,
				  GimpChannelType component,
				  gboolean        visible)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_component_visible",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, component,
				    PARAM_INT32, visible,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gchar *
gimp_image_get_filename (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *filename = NULL;

  return_vals = gimp_run_procedure ("gimp_image_get_filename",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    filename = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return filename;
}

void
gimp_image_set_filename (gint32  image_ID,
			 gchar  *filename)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_filename",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_STRING, filename,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_get_resolution (gint32   image_ID,
			   gdouble *xresolution,
			   gdouble *yresolution)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_get_resolution",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  *xresolution = 0.0;
  *yresolution = 0.0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *xresolution = return_vals[1].data.d_float;
      *yresolution = return_vals[2].data.d_float;
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_image_set_resolution (gint32  image_ID,
			   gdouble xresolution,
			   gdouble yresolution)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_resolution",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_FLOAT, xresolution,
				    PARAM_FLOAT, yresolution,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

GimpUnit
gimp_image_get_unit (gint32 image_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  GimpUnit unit = 0;

  return_vals = gimp_run_procedure ("gimp_image_get_unit",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    unit = return_vals[1].data.d_unit;

  gimp_destroy_params (return_vals, nreturn_vals);

  return unit;
}

void
gimp_image_set_unit (gint32   image_ID,
		     GimpUnit unit)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_image_set_unit",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, unit,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_image_get_layer_by_tattoo (gint32 image_ID,
				gint   tattoo)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_get_layer_by_tattoo",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, tattoo,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_ID;
}

gint32
gimp_image_get_channel_by_tattoo (gint32 image_ID,
				  gint   tattoo)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 channel_ID = -1;

  return_vals = gimp_run_procedure ("gimp_image_get_channel_by_tattoo",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, tattoo,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    channel_ID = return_vals[1].data.d_channel;

  gimp_destroy_params (return_vals, nreturn_vals);

  return channel_ID;
}
