/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __USER_INFO_H__
#define __USER_INFO_H__

#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define INFO_BOX(obj)        GTK_CHECK_CAST(obj, info_box_get_type(), InfoBox)
#define INFO_BOX_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, info_box_get_type(), InfoBox)
#define IS_INFO_BOX(obj)        GTK_CHECK_TYPE(obj, info_box_get_type())

typedef struct _InfoBox InfoBox;
typedef struct _InfoBoxClass InfoBoxClass;

struct _InfoBox
{
  GtkWindow window;

  GtkWidget* nick, *uin;
  GtkWidget* first, *last;
  GtkWidget* email, *age, *sex;
  GtkWidget* homepage;

  GtkWidget* city, *state;
  GtkWidget* country, *phone;
  
  GtkWidget* info;
  
  GtkWidget* close;

};

struct _InfoBoxClass
{
  GtkWindowClass parent_class;
};

guint info_box_get_type(void);
GtkWidget* info_box_new();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __USER_INFO_H__ */
