/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __SEARCH_H__
#define __SEARCH_H__

#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SEARCH_BOX(obj)        GTK_CHECK_CAST(obj, search_box_get_type(), SearchBox)
#define SEARCH_BOX_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, search_box_get_type(), SearchBox)
#define IS_SEARCH_BOX(obj)        GTK_CHECK_TYPE(obj, search_box_get_type())

typedef struct _SearchBox SearchBox;
typedef struct _SearchBoxClass SearchBoxClass;

struct _SearchBox
{
  GtkWindow window;

  GtkWidget* email;
  GtkWidget* nick, *first, *last;
  GtkWidget* uin;

  GtkWidget* search, *stop, *cancel;

};

struct _SearchBoxClass
{
  GtkWindowClass parent_class;
};

guint search_box_get_type(void);
GtkWidget* search_box_new();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SEARCH_H__ */
