/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include <libicq.h>

#include "rename.h"

extern GtkWidget* contact_list;

static void DoRename(GtkWidget* data)
{
  unsigned long uin;
  gchar* nick;

  uin = RENAME_BOX(data)->uin;
  nick = gtk_entry_get_text(GTK_ENTRY(RENAME_BOX(data)->entry));

  ICQ_Rename_User(uin, nick);
  contact_list_update_user(contact_list, uin, nick, -2);
  gtk_widget_destroy(GTK_WIDGET(data));
}


static void rename_box_init(RenameBox* rb)
{
  GtkWidget* vbox;
  GtkWidget* button_box;

  gtk_window_set_title(GTK_WINDOW(rb), "Rename User");
  
  vbox = gtk_vbox_new(FALSE, 10);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);

  rb->label = gtk_label_new("Enter a new name for this user:");
  gtk_box_pack_start(GTK_BOX(vbox), rb->label, FALSE, FALSE, 0);
    
  rb->entry = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(vbox), rb->entry, FALSE, FALSE, 0);
  
  button_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(button_box), 5);
  gtk_box_pack_start(GTK_BOX(vbox), button_box, FALSE, FALSE, 0);
  
  rb->ok = gtk_button_new_with_label("OK");
  GTK_WIDGET_SET_FLAGS(rb->ok, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), rb->ok, FALSE, FALSE, 0);

  gtk_signal_connect_object(GTK_OBJECT(rb->ok), "clicked",
    GTK_SIGNAL_FUNC(DoRename), GTK_OBJECT(rb));
    
  rb->cancel = gtk_button_new_with_label("Cancel");
  GTK_WIDGET_SET_FLAGS(rb->cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), rb->cancel, FALSE, FALSE, 0);  

  gtk_signal_connect_object(GTK_OBJECT(rb->cancel), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)rb);
  
  gtk_container_add(GTK_CONTAINER(rb), vbox);
  
  gtk_widget_show(rb->label);
  gtk_widget_show(rb->entry);
  gtk_widget_show(rb->ok);
  gtk_widget_show(rb->cancel);
  gtk_widget_show(button_box);
  gtk_widget_show(vbox);
  
  gtk_widget_grab_default(rb->ok);
  gtk_window_set_focus(GTK_WINDOW(rb), rb->entry);
}


guint rename_box_get_type()
{
         static guint rb_type = 0;
  
         if(!rb_type)
  {
    GtkTypeInfo rb_info =
    {
      "RenameBox",
      sizeof(RenameBox),
      sizeof(RenameBoxClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)rename_box_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    rb_type = gtk_type_unique(gtk_window_get_type(), &rb_info);
  }

  return rb_type;
}


GtkWidget* rename_box_new(unsigned long uin, gchar* name)
{
  GtkWidget* RB;
  RB = gtk_type_new(rename_box_get_type());
  gtk_entry_set_text(GTK_ENTRY(RENAME_BOX(RB)->entry), name);
  gtk_entry_select_region(GTK_ENTRY(RENAME_BOX(RB)->entry),
    0, GTK_ENTRY(RENAME_BOX(RB)->entry)->text_length);
  RENAME_BOX(RB)->uin = uin;
  return RB;
}

