/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <../config.h>

#ifdef HAVE_IMLIB
#include <gdk_imlib.h>
#include <gdk/gdk.h>
#endif

#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif

#include <stdlib.h>
#include <libicq.h>

#include "event.h"
#include "contactlist.h"
#include "labeledentry.h"
#include "config.h"
#include "gpl.h"

#include "pixmaps/green_flower.xpm"
#include "pixmaps/red_flower.xpm"
#include "pixmaps/away_flower.xpm"
#include "pixmaps/na_flower.xpm"
#include "pixmaps/occ_flower.xpm"
#include "pixmaps/dnd_flower.xpm"

#include "pixmaps/blank.xpm"
#include "pixmaps/message.xpm"
#include "pixmaps/message_gray.xpm"
#include "pixmaps/message_away.xpm"
#include "pixmaps/message_na.xpm"
#include "pixmaps/message_dnd.xpm"
#include "pixmaps/message_occ.xpm"
#include "pixmaps/world.xpm"
#include "pixmaps/info.xpm"

GdkPixmap* blank_pixmap, *message_pixmap, *gray_message_pixmap, 
  *away_message_pixmap, *na_message_pixmap, *dnd_message_pixmap,
  *occ_message_pixmap, *url_pixmap, *info_pixmap;
GdkBitmap* mask, *blank_mask, *url_mask, *info_mask;
GtkWidget* contact_list;
GtkWidget* status_bar, *status_menu;

int ICQ_Tooltips; 
int ICQ_Status;

#ifdef HAVE_GNOME

static void about_cb(GtkWidget *widget, gpointer data)
{
    GtkWidget* about;
    
    const gchar* authors[] = {
            "Sean Gabriel <gabriel@montana.com>",
            "Andrew Burke <ab012f@uhura.cc.rochester.edu>",
            "Michael Babcock <mbabcock@tyenet.com>",
            NULL
    };

    about = gnome_about_new(_("gicq"), VERSION,
                             _("(C) 1998 Sean Gabriel"),
                             authors,
                             _("An ICQ-compatible instant messaging client"),
                             NULL);
                             
    gtk_widget_show(about);
}


static void ShowOnline(GtkWidget *widget, gpointer data)
{
  static int offlist_vis;
    
  if(GTK_WIDGET_VISIBLE(CONTACT_LIST(contact_list)->online_toggle))
  {
    offlist_vis = GTK_WIDGET_VISIBLE(CONTACT_LIST(contact_list)->offline_list);
    gtk_widget_hide(CONTACT_LIST(contact_list)->online_toggle);
    gtk_widget_hide(CONTACT_LIST(contact_list)->offline_toggle);
    gtk_widget_hide(CONTACT_LIST(contact_list)->offline_scroll_win);
  }
  else
  {
    gtk_widget_show(CONTACT_LIST(contact_list)->online_toggle);
    gtk_widget_show(CONTACT_LIST(contact_list)->offline_toggle);
    if(offlist_vis) gtk_widget_show(CONTACT_LIST(contact_list)->offline_scroll_win);
  }
}


GnomeUIInfo helpmenu[] = {
  GNOMEUIINFO_HELP("gicq"),

  {GNOME_APP_UI_ITEM, N_("About"), NULL, about_cb, NULL, NULL, 
  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},

  GNOMEUIINFO_END
};

/*  Couldn't make this work....
GnomeUIInfo statusmenu[] = {
  GNOMEUIINFO_ITEM_DATA(N_("Online"), NULL, 
    ChangeStatus, 0, GNOME_APP_PIXMAP_NONE),

  GNOMEUIINFO_ITEM_DATA(N_("Away"), NULL, 
    ChangeStatus, GINT_TO_POINTER(1), GNOME_APP_PIXMAP_NONE),

  GNOMEUIINFO_ITEM_DATA(N_("Not Available"), NULL, 
    ChangeStatus, 2, GNOME_APP_PIXMAP_NONE),

  GNOMEUIINFO_ITEM_DATA(N_("Occupied"), NULL, 
    ChangeStatus, 3, GNOME_APP_PIXMAP_NONE),

  GNOMEUIINFO_ITEM_DATA(N_("Do Not Disturb"), NULL,
    ChangeStatus, 4, GNOME_APP_PIXMAP_NONE),

  GNOMEUIINFO_ITEM_DATA(N_("Offline"), NULL, 
    ChangeStatus, 5, GNOME_APP_PIXMAP_NONE),

  GNOMEUIINFO_END
};
*/

GnomeUIInfo menumenu[] = {
  {GNOME_APP_UI_ITEM, N_("Search/Add Users"), NULL, StartSearch, NULL, NULL, 
  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH, 0, 0, NULL},

  {GNOME_APP_UI_TOGGLEITEM, N_("Show Only Online Users"), NULL, ShowOnline, NULL, NULL, 
  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
/*  GNOMEUIINFO_SUBTREE(N_("Change Status"), statusmenu),
  {GNOME_APP_UI_ITEM, N_("Preferences"), NULL, NULL, NULL, NULL, 
  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP, 0, 0, NULL},
*/
  GNOMEUIINFO_SEPARATOR,
  
  {GNOME_APP_UI_ITEM, N_("Exit"), NULL, Shutdown, NULL, NULL, 
  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 0, 0, NULL},

  GNOMEUIINFO_END
};

GnomeUIInfo mainmenu[] = {
  GNOMEUIINFO_SUBTREE(N_("Menu"), menumenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

#else

void About(GtkWidget* widget, gpointer data)
{
  GtkWidget* window;
  GtkWidget* vbox;
  GtkWidget* label;
  GtkWidget* close;
  char *about;
  
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "About");
  
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(vbox), 5);

  about = (char *)malloc(512);
  sprintf(about, "GICQ Version %s\n\n\
Sean Gabriel <gabriel@montana.com>\n\
Andrew Burke <ab012f@uhura.cc.rochester.edu>\n\
Michael Babcock <mbabcock@tyenet.com>", VERSION);

  label = gtk_label_new(about);
  
  close = gtk_button_new_with_label("Close");
  
  gtk_container_add(GTK_CONTAINER(window), vbox);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), close, FALSE, FALSE, 5);

  gtk_signal_connect_object(GTK_OBJECT(close), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)window);

  gtk_widget_show(label);
  gtk_widget_show(close);
  gtk_widget_show(vbox);
  gtk_widget_show(window);
}


GtkWidget* MakeMenubar()
{
  GtkWidget* menubar, *menubar_menu, *menubar_help;
  GtkWidget* menu, *menu_search_item, *menu_prefs_item, *menu_all_item, *menu_quit_item,
    *help, *help_about_item;

  menubar = gtk_menu_bar_new();
/*  gtk_container_disable_resize(GTK_CONTAINER(menubar)); */
  menubar_menu = gtk_menu_item_new_with_label("Menu");
  menubar_help = gtk_menu_item_new_with_label("Help");
  menu = gtk_menu_new();
  help = gtk_menu_new();
  menu_search_item = gtk_menu_item_new_with_label("Search/Add Users");
/*  menu_prefs_item = gtk_menu_item_new_with_label("Preferences");
  menu_all_item = gtk_menu_item_new_with_label("Show All"); */
  menu_quit_item = gtk_menu_item_new_with_label("Quit");
  help_about_item = gtk_menu_item_new_with_label("About");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubar_menu), menu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubar_help), help);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubar_menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubar_help);
  gtk_menu_item_right_justify(GTK_MENU_ITEM(menubar_help));
  gtk_menu_append(GTK_MENU(menu), menu_search_item);
/*  gtk_menu_append(GTK_MENU(menu), menu_prefs_item);
  gtk_menu_append(GTK_MENU(menu), menu_all_item); */
  gtk_menu_append(GTK_MENU(menu), menu_quit_item);
  gtk_menu_append(GTK_MENU(help), help_about_item);
  gtk_widget_show(menu_search_item);
/*  gtk_widget_show(menu_prefs_item);
  gtk_widget_show(menu_all_item); */
  gtk_widget_show(menu_quit_item);
  gtk_widget_show(help_about_item);
  gtk_widget_show(menubar_menu);
  gtk_widget_show(menubar_help);

  gtk_signal_connect(GTK_OBJECT(menu_search_item), "activate",
    GTK_SIGNAL_FUNC(StartSearch), NULL);

  gtk_signal_connect(GTK_OBJECT(menu_quit_item), "activate", 
    GTK_SIGNAL_FUNC(Shutdown), NULL);
  
  gtk_signal_connect(GTK_OBJECT(help_about_item), "activate", 
    GTK_SIGNAL_FUNC(About), NULL);

  return menubar;
}

#endif

GtkWidget* MakeStatusButton()
{
  GtkWidget* status_button;
  GtkWidget* status_menu_item, *status[6];
  gchar* status_label[6] = {"Online", "Away", "Not Available", "Occupied", "Do Not Distrurb", "Offline"};
  GtkWidget* hbox, *label, *pixmap;
  GdkPixmap* gdk_pixmap;
  GdkBitmap* mask;
  GtkStyle* style;
#ifndef HAVE_IMLIB
  char** status_xpm[6];
#else
  char status_image[6][50];  // 5 x 50 character filenames
#endif
  int x;

#ifdef HAVE_IMLIB
  GdkWindowAttr  imlib_attr;
  GdkWindow  *imlib_win;
  GdkPixmap  *imlib_p, *imlib_m;
  GdkImlibImage  *imlib_image;
  gint w, h;

  status_image[0] = "/usr/local/share/gicq/images/green_flower.png\0";
  status_image[1] = "/usr/local/share/gicq/images/away_flower.png\0";
  status_image[2] = "/usr/local/share/gicq/images/na_flower.png\0";
  status_image[3] = "/usr/local/share/gicq/images/occ_flower.png\0";
  status_image[4] = "/usr/local/share/gicq/images/dnd_flower.png\0";
  status_image[5] = "/usr/local/share/gicq/images/red_flower.png\0";
#else
  status_xpm[0] = green_flower_xpm;
  status_xpm[1] = away_flower_xpm;
  status_xpm[2] = na_flower_xpm;
  status_xpm[3] = occ_flower_xpm;
  status_xpm[4] = dnd_flower_xpm;
  status_xpm[5] = red_flower_xpm;
#endif

  status_menu = gtk_menu_new();
  style = gtk_widget_get_style(status_menu);

  gtk_widget_realize(status_menu);

  for(x = 0; x < 6; x++)
  {
    status_menu_item = gtk_menu_item_new();

#ifdef HAVE_IMLIB
    imlib_image=gdk_imlib_load_image(status_image[x]);
    if(imlib_im == NULL)
    {
#endif

/* This is the result of the above "if" statement AND
 * what should be done if !IMLIB */

    gdk_pixmap = gdk_pixmap_create_from_xpm_d(status_menu->window, &mask,
                 &style->bg[GTK_STATE_NORMAL], (gchar **)status_xpm[x]);

#ifdef HAVE_IMLIB
    }
    else
    {
      gdk_pixmap = gdk_imlib_copy_image(imlib_image);
    }
#endif

    hbox = gtk_hbox_new(FALSE, 6);
    pixmap = gtk_pixmap_new(gdk_pixmap, mask);
    label = gtk_label_new(status_label[x]);
    gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show(pixmap);
    gtk_widget_show(label);
    gtk_widget_show(hbox);
    gtk_widget_show(status_menu_item);
    gtk_container_add(GTK_CONTAINER(status_menu_item), hbox);
    gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
    gtk_signal_connect_object(GTK_OBJECT(status_menu_item), "activate",
      GTK_SIGNAL_FUNC(ChangeStatus), (gpointer)x);
  }

  status_button = gtk_option_menu_new();
  gtk_menu_set_active(GTK_MENU(status_menu), 5);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(status_button), status_menu);

  return status_button;
}

/* Command-line options must be powers of two;
   SetOptions returns a bitfield */

#define OPT_ABOUT  8

int main(int argc, char* argv[])
{
  int i;

  /* Options for Michael's command-line options parser in config.c */
  unsigned long options = 0;
  char *OptStrings[5] = {"", "--warranty", "--conditions", "--about", ""};
  unsigned long OptVals[5] = {OPT_GPL, OPT_GPL | OPT_GPL_WRTY,
    OPT_GPL | OPT_GPL_COPY, OPT_ABOUT, 0};
  /* end of options stuff */

  GtkWidget* window;
  GtkWidget* vbox1, *vbox2, *hbox;

  GtkWidget* menubar;
  GtkWidget* status_button;
  GtkWidget* login_window;

  GtkTooltips* status_tooltip;

  GtkStyle* style;

  /* Check command-line options */
  options = SetOptions(argc, argv, OptStrings, OptVals);

  /* Respond to command-line options */
  if(options | OPT_GPL)
    ShowGPL(argv[0], options);

  if(options | OPT_ABOUT)
    printf("gICQ is an ICQ compatible instant messaging client.\n");

  /* Done responding to command-line options */


#ifdef HAVE_GNOME
  gnome_init("gicq", NULL, argc, argv);
  window = gnome_app_new("gicq", "GICQ");
#else
  gtk_init(&argc, &argv);
  gtk_rc_parse("gtkrc");

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "GICQ");
#endif

#ifdef HAVE_IMLIB
  gdk_imlib_init();
  gtk_widget_push_visual(gdk_imlib_get_visual());
  gtk_widget_push_colormap(gdk_imlib_get_colormap());
#endif

  gtk_signal_connect(GTK_OBJECT(window), "destroy", 
    GTK_SIGNAL_FUNC(Shutdown), NULL);

  vbox1 = gtk_vbox_new(FALSE, 0);
  vbox2 = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(vbox2), 5);

#ifdef HAVE_GNOME
  gnome_app_create_menus(GNOME_APP(window), mainmenu);
  gtk_menu_item_right_justify(GTK_MENU_ITEM(mainmenu[1].widget));
#else
  menubar = MakeMenubar();
#endif
  contact_list = contact_list_new();
  status_button = MakeStatusButton();

#ifdef HAVE_GNOME
  gnome_app_set_contents(GNOME_APP(window), vbox1);
#else
  gtk_container_add(GTK_CONTAINER(window), vbox1);
  gtk_box_pack_start(GTK_BOX(vbox1), menubar, FALSE, FALSE, 0);
#endif

  gtk_container_add(GTK_CONTAINER(vbox1), vbox2);
  gtk_box_pack_start(GTK_BOX(vbox2), contact_list, TRUE, TRUE, 3);
  gtk_box_pack_start(GTK_BOX(vbox2), status_button, FALSE, FALSE, 3);

  /* Create statusbar */
  status_bar = gtk_statusbar_new();
  gtk_box_pack_start(GTK_BOX(vbox1), status_bar, FALSE, FALSE, 3);
  /* gtk_widget_show (status_bar); */

  /* making the list and pixmaps */
  gtk_widget_realize(GTK_WIDGET(contact_list));

  style = gtk_widget_get_style(contact_list);
  blank_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &blank_mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)blank_xpm);
  gray_message_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)message_gray_xpm);
  message_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)message_xpm);
  away_message_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)message_away_xpm);
  na_message_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)message_na_xpm);
  dnd_message_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)message_dnd_xpm);
  occ_message_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)message_occ_xpm);
  url_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &url_mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)world_xpm);
  info_pixmap = gdk_pixmap_create_from_xpm_d(contact_list->window, &info_mask,
    &style->bg[GTK_STATE_NORMAL], (gchar **)info_xpm);

  gtk_clist_set_pixmap(GTK_CLIST(CONTACT_LIST(contact_list)->system), 0, 0,
        gray_message_pixmap, mask);

  /* Create tooltips */
  ICQ_Tooltips = 1;  /* put this in the config file later */

  if (ICQ_Tooltips)
  {
    status_tooltip = gtk_tooltips_new();
    gtk_tooltips_set_tip (status_tooltip,
      status_button, "Click to change status", NULL);
  }

  
#ifndef HAVE_GNOME
  gtk_widget_show(menubar);
#endif
  gtk_widget_show(contact_list);
  gtk_widget_show(status_button);

  gtk_widget_show(vbox1);
  gtk_widget_show(vbox2);

  /* Now displaying ... */
  gtk_widget_show(window);
  
  RegisterCallbacks();

  ICQ_Debug(ICQ_VERB_NONE);  /* see libicq.h */

  ICQ_Read_Config();

  for(i = 0; i < Num_Contacts; i++)
    if(Contacts[i].uin > 0)
      contact_list_update_user(CONTACT_LIST(contact_list),
        Contacts[i].uin, Contacts[i].nick, STATUS_OFFLINE);


  /* fire up the main event loop of gtk */
  gtk_main();
  
  /* we get here after gtk_main_quit() has been called which
   * happens if the main window gets destroyed */
  return 0;
}
