/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __CONTACTLIST_H__
#define __CONTACTLIST_H__

#include <gdk/gdk.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkclist.h>

#ifdef __cplusplus
extern "C" {
#endif

#define CONTACT_LIST(obj)          GTK_CHECK_CAST(obj, contact_list_get_type(), ContactList)
#define CONTACT_LIST_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, contact_list_get_type(), ContactListClass)
#define IS_CONTACT_LIST(obj)       GTK_CHECK_TYPE(obj, contact_list_get_type())

typedef struct _ContactList ContactList;
typedef struct _ContactListClass ContactListClass;

struct _ContactList
{
  GtkVBox vbox;

  GtkWidget* online_toggle;
  GtkWidget* online_scroll_win;
  GtkWidget* online_list;
  
  GtkWidget* offline_toggle;
  GtkWidget* offline_scroll_win;
  GtkWidget* offline_list;
  
  GtkWidget* nil_toggle;
  GtkWidget* nil_scroll_win;
  GtkWidget* nil_list;
  
  GtkWidget* system;
  
  GtkWidget* menu;
  GtkWidget* menu_add;
  GtkWidget* menu_message, *menu_url;
  GtkWidget* menu_info, *menu_away, *menu_rename, *menu_delete;
};

struct _ContactListClass
{
  GtkVBoxClass parent_class;
};


typedef struct _CLInfo
{
  unsigned long uin;
  int status;
  GList* events;
} CLInfo, *CLInfoPtr;


guint contact_list_get_type(void);
GtkWidget* contact_list_new(void);
char* contact_list_get_nickname(ContactList* cl, unsigned long uin);
void contact_list_update_user(ContactList* cl, unsigned long uin, char* nick, long status);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CONTACTLIST_H__ */
