/*
** 1998-09-23 -	No program is complete without an "About" command.
** 1999-03-13 -	Now uses a multi dialog, which allows setting a sensible title. :)
** 1999-03-21 -	Brought the copyright into 1999, and added fun page flipping. :)
** 1999-06-20 -	Adapted for the new dialog module, and made asynchronous for fun.
** 2002-06-07 -	Redid it with a notebook. Cleaner, and required anyway. Heh.
*/

#include "gentoo.h"
#include "dialog.h"
#include "gfam.h"

#include "cmd_about.h"

/* ----------------------------------------------------------------------------------------- */

#include "graphics/icon_gentoo.xpm"

/* ----------------------------------------------------------------------------------------- */

struct body {
	GtkWidget	*notebook;
	GtkWidget	*page[2];
	guint		index;
	guint		handle;
};

/* ----------------------------------------------------------------------------------------- */

static gint timeout_trigger(gpointer user)
{
	struct body	*body = user;

	gtk_notebook_set_page(GTK_NOTEBOOK(body->notebook), body->index ^= 1);
	return TRUE;
}

/* 1999-06-19 -	This gets called as the dialog finally closes. */
static void timeout_remove(gint button, gpointer user)
{
	struct body	*body = user;

	gtk_timeout_remove(GPOINTER_TO_UINT(body->handle));
	g_free(body);
}

gint cmd_about(MainInfo *min, DirPane *src, DirPane *dst, const CmdArg *ca)
{
	gchar		buf[64];
	GtkWidget	*w;
	GdkPixmap	*pmap;
	GdkBitmap	*mask;
	struct body	*body;

	body = g_malloc(sizeof *body);
	body->index = 0U;

	g_snprintf(buf, sizeof buf, _("Version %s (GTK+ version %d.%d.%d)."), VERSION, gtk_major_version, gtk_minor_version, gtk_micro_version);

	body->notebook = gtk_notebook_new();
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(body->notebook), FALSE);
	body->page[0] = gtk_vbox_new(FALSE, 0);
	if((pmap = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(min->gui->window)->window, &mask, NULL, icon_gentoo_xpm)) != NULL)
	{
		w = gtk_pixmap_new(pmap, mask);
		gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 5);
	}
	w = gtk_label_new(buf);
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);
	w = gtk_label_new(_("(c) 1998-2005 by Emil Brink, Obsession Development.\n"));
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);
	w = gtk_label_new(_("This is free software, and there is ABSOLUTELY NO\n"
			"WARRANTY. Read the file COPYING for more details.\n"));
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);

	/* Display something about the FAM support. */
#if defined HAVE_FAM
	if(fam_is_active())
		w = gtk_label_new(_("FAM: Supported and active."));
	else
		w = gtk_label_new(_("FAM: Supported, but not active."));
#else
	w = gtk_label_new(_("FAM: Not supported."));
#endif
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);

	/* Inform user which interface strings are being used. */
#if defined ENABLE_NLS
	w = gtk_label_new(_("NLS: Supported, using built-in English strings."));
#else
	w = gtk_label_new("NLS: Not supported, using built-in English strings.");
#endif
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);

	gtk_notebook_append_page(GTK_NOTEBOOK(body->notebook), body->page[0], NULL);
	body->page[1] = gtk_label_new(	_("The author of gentoo can be reached via Internet\n"
					"e-mail at <emil@obsession.se>; feel free to let\n"
					"me know what you think of this software, give\n"
					"suggestions/bug reports, and so on.\n\n"

					"Custom widgets by J. Hanson <johan@tiq.com>.\n\n"

					"The latest release of gentoo can always be down-\n"
					"loaded from the official gentoo project homepage at\n"
					"<http://www.obsession.se/gentoo/>. New releases are\n"
					"typically announced on the Freshmeat service at\n"
					"<http://freshmeat.net/>."));
	gtk_notebook_append_page(GTK_NOTEBOOK(body->notebook), body->page[1], NULL);

	body->handle = gtk_timeout_add(10000, timeout_trigger, body);
	dlg_dialog_async_new(body->notebook, _("About gentoo"), _("_OK (Wait for More)"), timeout_remove, body);

	return 1;
}
