/*
** 1998-11-25 -	Header for the little command-line options handler.
*/

typedef enum { OPT_ARG_NONE = 0, OPT_ARG_OPT, OPT_ARG_REQ } OptArgMode;

typedef struct {
	gchar		name_short;	/* Single letter name. */
	const gchar	*name_long;	/* Long name, if supported. */
	OptArgMode	arg_mode;	/* This option's argument status. */
	const gchar	*arg;		/* Filled-in with argument, if found. */
	guint32		flag;		/* Single bit for presence-detection. */
	const gchar	*help;		/* Help text for this option. */
} OptDesc;

extern guint32	opt_parse(gint *argc, gchar **argv, OptDesc *desc, gsize num_desc);

extern const gchar *	opt_arg_get(const gchar *name, const OptDesc *desc, gsize num_desc);
