/*
** 1998-05-25 -	Header file for the dirpane module. Deals with all aspects of
**		directory panes. Since those are very central to this program,
**		there's quite a lot to deal with.
*/

#if !defined DIRPANE_H
#define	DIRPANE_H

/* ----------------------------------------------------------------------------------------- */

extern void		dp_initialize(void);

extern DirPane *	dp_mirror(const MainInfo *min, const DirPane *dp);
extern const gchar *	dp_full_name(const DirPane *dp, gint row);
extern const gchar *	dp_name_quoted(const DirPane *dp, gint row, gboolean path);

extern void		dp_show_stats(DirPane *dp);
extern void		dp_update_stats(DirPane *dp);
extern gboolean		dp_activate(DirPane *dp);

extern void		dp_resort(DirPane *dp);
extern void		dp_redisplay(DirPane *dp);
extern void		dp_redisplay_preserve(DirPane *dp);

extern void		dp_unfocus(DirPane *dp);
extern void		dp_focus(DirPane *dp, gint row);

extern gint		dp_has_selection(DirPane *dp);
extern gint		dp_is_selected(DirPane *dp, DirRow *row);

extern GSList *		dp_get_selection(DirPane *dp);
extern GSList *		dp_get_selection_full(const DirPane *dp);
#if 0
extern void		dp_print_selection(DirPane *dp, const gchar *tag);
#endif
extern void		dp_free_selection(GSList *sel);

extern void		dp_enter_dir(DirPane *dp, const gchar *path);
extern void		dp_rescan(DirPane *dp);
extern void		dp_rescan_post_cmd(DirPane *dp);

extern void		dp_freeze(DirPane *dp);
extern void		dp_thaw(DirPane *dp);

extern void		dp_dbclk_row(DirPane *dp, gint row);

extern void		dp_select(DirPane *dp, gint row);
extern void		dp_select_all(DirPane *dp);
extern void		dp_unselect(DirPane *dp, gint row);
extern void		dp_unselect_all(DirPane *dp);
extern void		dp_toggle(DirPane *dp, gint row);

extern GtkWidget *	dp_build(MainInfo *min, DPFormat *fmt, DirPane *dp);

#endif		/* DIRPANE_H */
