/*******************************************
 *
 * $GAMGI/src/mesa/gamgi_mesa_rotate.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_math.h"
#include "gamgi_gtk.h"
#include "gamgi_global.h"

#include "gamgi_mesa_center.h"
#include "gamgi_mesa_rotate_out.h"
#include "gamgi_math_vector.h"
#include "gamgi_math_matrix.h"
#include "gamgi_math_quaternion.h"

void gamgi_mesa_rotate_text (gamgi_text *text,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_text (text, quat, rotate, center);

dlist = text->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_orbital (gamgi_orbital *orbital,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_orbital (orbital, quat, rotate, center);

dlist = orbital->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_bond (gamgi_bond *bond,
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

dlist = bond->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = bond->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_atom (gamgi_atom *atom,  
double *quat, double *rotate, double *center)
{
gamgi_bond *bond;
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_atom (atom, quat, rotate, center);

/*********************************************
 * rotate bond elements only the second time *
 *********************************************/

dlist = atom->bond_start;
while (dlist != NULL)
  {
  bond = GAMGI_CAST_BOND dlist->data;
  dlist = dlist->next;

  if (bond->atom2 == NULL) continue;
  if (bond->first == TRUE) { bond->first = FALSE; continue; }
  else bond->first = TRUE;

  gamgi_mesa_rotate_bond (bond, quat, rotate, center);
  }

dlist = atom->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = atom->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_direction (gamgi_direction *direction,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_direction (direction, quat, rotate, center);

dlist = direction->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = direction->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = direction->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_plane (gamgi_plane *plane,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_plane (plane, quat, rotate, center);

dlist = plane->direction_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_direction (GAMGI_CAST_DIRECTION dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = plane->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = plane->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = plane->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_group (gamgi_group *group,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_group (group, quat, rotate, center);

dlist = group->group_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_group (GAMGI_CAST_GROUP dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = group->plane_start;
while (dlist != NULL) 
  { gamgi_mesa_rotate_plane (GAMGI_CAST_PLANE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = group->direction_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_direction (GAMGI_CAST_DIRECTION dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = group->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = group->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = group->text_start;
while (dlist != NULL) 
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_molecule (gamgi_molecule *molecule,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_molecule (molecule, quat, rotate, center);

dlist = molecule->group_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_group (GAMGI_CAST_GROUP dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = molecule->plane_start;
while (dlist != NULL) 
  { gamgi_mesa_rotate_plane (GAMGI_CAST_PLANE dlist->data, quat, rotate, center);
    dlist = dlist->next; } 

dlist = molecule->direction_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_direction (GAMGI_CAST_DIRECTION dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = molecule->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = molecule->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = molecule->text_start;
while (dlist != NULL) 
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; } 
}

void gamgi_mesa_rotate_cluster (gamgi_cluster *cluster,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_cluster (cluster, quat, rotate, center);

dlist = cluster->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_cluster (GAMGI_CAST_CLUSTER dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cluster->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_molecule (GAMGI_CAST_MOLECULE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cluster->group_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_group (GAMGI_CAST_GROUP dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cluster->plane_start;
while (dlist != NULL) 
  { gamgi_mesa_rotate_plane (GAMGI_CAST_PLANE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cluster->direction_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_direction (GAMGI_CAST_DIRECTION dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cluster->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cluster->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cluster->text_start;
while (dlist != NULL) 
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_cell (gamgi_cell *cell,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_cell (cell, quat, rotate, center);

dlist = cell->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_cluster (GAMGI_CAST_CLUSTER dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cell->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_molecule (GAMGI_CAST_MOLECULE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cell->group_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_group (GAMGI_CAST_GROUP dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cell->plane_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_plane (GAMGI_CAST_PLANE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cell->direction_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_direction (GAMGI_CAST_DIRECTION dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cell->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cell->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = cell->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_arrow (gamgi_arrow *arrow,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_arrow (arrow, quat, rotate, center);

dlist = arrow->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_shape (gamgi_shape *shape,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_shape (shape, quat, rotate, center);

dlist = shape->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_graph (gamgi_graph *graph,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_graph (graph, quat, rotate, center);

dlist = graph->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_assembly (gamgi_assembly *assembly,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_assembly (assembly, quat, rotate, center);

dlist = assembly->assembly_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_assembly (GAMGI_CAST_ASSEMBLY dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->graph_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_graph (GAMGI_CAST_GRAPH dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->shape_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_shape (GAMGI_CAST_SHAPE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->arrow_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_arrow (GAMGI_CAST_ARROW dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->cell_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_cell (GAMGI_CAST_CELL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_cluster (GAMGI_CAST_CLUSTER dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_molecule (GAMGI_CAST_MOLECULE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->group_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_group (GAMGI_CAST_GROUP dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->plane_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_plane (GAMGI_CAST_PLANE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->direction_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_direction (GAMGI_CAST_DIRECTION dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = assembly->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_light (gamgi_light *light,  
double *quat, double *rotate, double *center)
{
gamgi_mesa_rotate_out_light (light, quat, rotate, center);
}

void gamgi_mesa_rotate_layer (gamgi_layer *layer,  
double *quat, double *rotate, double *center)
{
gamgi_dlist *dlist;

gamgi_mesa_rotate_out_layer (layer, quat, rotate, center);

dlist = layer->assembly_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_assembly (GAMGI_CAST_ASSEMBLY dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->graph_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_graph (GAMGI_CAST_GRAPH dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->shape_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_shape (GAMGI_CAST_SHAPE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->arrow_start;
while (dlist != NULL)
  {  gamgi_mesa_rotate_arrow (GAMGI_CAST_ARROW dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->cell_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_cell (GAMGI_CAST_CELL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_cluster (GAMGI_CAST_CLUSTER dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_molecule (GAMGI_CAST_MOLECULE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->group_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_group (GAMGI_CAST_GROUP dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->plane_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_plane (GAMGI_CAST_PLANE dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->direction_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_direction (GAMGI_CAST_DIRECTION dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->atom_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL dlist->data, quat, rotate, center);
    dlist = dlist->next; }

dlist = layer->text_start;
while (dlist != NULL)
  { gamgi_mesa_rotate_text (GAMGI_CAST_TEXT dlist->data, quat, rotate, center);
    dlist = dlist->next; }
}

void gamgi_mesa_rotate_object (gamgi_object *object,  
double *quat, double *rotate, double *center)
{
gamgi_plane *plane;
gamgi_direction *direction;

switch (object->class)
  {
  case GAMGI_ENGINE_TEXT:
  gamgi_mesa_rotate_text (GAMGI_CAST_TEXT object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_ORBITAL:
  gamgi_mesa_rotate_orbital (GAMGI_CAST_ORBITAL object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_BOND:
  gamgi_mesa_rotate_out_bond (GAMGI_CAST_BOND object, quat, rotate, center);
  gamgi_mesa_rotate_bond (GAMGI_CAST_BOND object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_ATOM:
  gamgi_mesa_rotate_atom (GAMGI_CAST_ATOM object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_DIRECTION:
  direction = GAMGI_CAST_DIRECTION object;
  if (direction->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_rotate_object (object->object, quat, rotate, center);
  else
    gamgi_mesa_rotate_direction (direction, quat, rotate, center);
  break;

  case GAMGI_ENGINE_PLANE:
  plane = GAMGI_CAST_PLANE object;
  if (plane->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_rotate_object (object->object, quat, rotate, center);
  else
    gamgi_mesa_rotate_plane (plane, quat, rotate, center);
  break;

  case GAMGI_ENGINE_GROUP:
  gamgi_mesa_rotate_group (GAMGI_CAST_GROUP object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_MOLECULE:
  gamgi_mesa_rotate_molecule (GAMGI_CAST_MOLECULE object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_CLUSTER:
  gamgi_mesa_rotate_cluster (GAMGI_CAST_CLUSTER object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_CELL:
  gamgi_mesa_rotate_cell (GAMGI_CAST_CELL object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_ARROW:
  gamgi_mesa_rotate_arrow (GAMGI_CAST_ARROW object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_SHAPE:
  gamgi_mesa_rotate_shape (GAMGI_CAST_SHAPE object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_GRAPH:
  gamgi_mesa_rotate_graph (GAMGI_CAST_GRAPH object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_ASSEMBLY:
  gamgi_mesa_rotate_assembly (GAMGI_CAST_ASSEMBLY object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_LIGHT:
  gamgi_mesa_rotate_light (GAMGI_CAST_LIGHT object, quat, rotate, center);
  break;

  case GAMGI_ENGINE_LAYER:
  gamgi_mesa_rotate_layer (GAMGI_CAST_LAYER object, quat, rotate, center);
  break;

  default:
  break;
  }
}

void gamgi_mesa_rotate_out (gamgi_layer *layer, 
double angle, double *axis)
{
double rotate_old[9], rotate_new[9], z[3];
double *referential; 
double length;

/******************************
 * get new referential matrix *
 ******************************/

gamgi_math_vector_normal (axis);
gamgi_math_matrix_rotation (angle * GAMGI_MATH_RAD_DEG, axis, rotate_old);

referential = layer->referential;
gamgi_math_matrix_matrix (referential, rotate_old, rotate_new);
gamgi_math_matrix_copy (rotate_new, referential);

/*********************
 * get new up vector *
 *********************/

gamgi_math_vector_absolute (layer->up,
referential[1], referential[4], referential[7]);

/*************************
 * get new center vector *
 *************************/

gamgi_math_vector_sub (layer->eye, layer->center, z);
length = gamgi_math_vector_length (z);

gamgi_math_vector_absolute (z,
referential[2], referential[5], referential[8]);
gamgi_math_vector_scale (z, z, length);
gamgi_math_vector_sub (layer->eye, z, layer->center);
}

void gamgi_mesa_rotate_in (gamgi_layer *layer, 
gamgi_object *object, double angle, double *axis)
{
double rotate[9];
double axis_new[3], center[3];
double quaternion[4];
unsigned int number;

/*******************************************
 * transform axis to the layer referential *
 *******************************************/

gamgi_math_matrix_vector (layer->referential, axis, axis_new);

/**************************************
 * get rotation matrix and quaternion *
 **************************************/

gamgi_math_quaternion_from_axis (angle, axis_new, quaternion);
gamgi_math_quaternion_to_matrix (quaternion, rotate);

/*************************************************
 * get geometric center: when object is an empty *
 * layer, the total number of objects is 0.      *
 *************************************************/

number = 0;
gamgi_math_vector_zero (center);
gamgi_mesa_center_object (object, center, &number);
if (number != 0)
  gamgi_math_vector_scale (center, center, 1.0/number);

/*********************************
 * rotate about geometric center *
 *********************************/

gamgi_mesa_rotate_object (object, quaternion, rotate, center);
}

void gamgi_mesa_rotate (gamgi_window *window,
gamgi_object *object, double angle, double *axis)
{
gamgi_layer *layer;
gamgi_dlist *dlist;

/********************
 * rotate view axes *
 ********************/

if (window->axes == TRUE)
  {
  /************************
   * in all window layers *
   ************************/

  if (object == GAMGI_CAST_OBJECT window)
    {
    for (dlist = window->layer_start; dlist != NULL; dlist = dlist->next)
      {
      layer = GAMGI_CAST_LAYER dlist->data;
      gamgi_mesa_rotate_out (layer, angle, axis);
      }
    }

  /*************************
   * just in current layer *
   *************************/

  else gamgi_mesa_rotate_out (window->layer, angle, axis);
  }
  
/******************
 * rotate objects *
 ******************/

if (window->axes == FALSE)
  {
  /************************
   * in all window layers *
   ************************/

  if (object == GAMGI_CAST_OBJECT window)
    {
    for (dlist = window->layer_start; dlist != NULL; dlist = dlist->next)
      {
      layer = GAMGI_CAST_LAYER dlist->data;
      gamgi_mesa_rotate_in (layer, GAMGI_CAST_OBJECT layer, angle, axis);
      }
    }

  /*************************
   * just in current layer *
   *************************/

  else gamgi_mesa_rotate_in (window->layer, object, angle, axis);
  }

/***********************
 * redraw OpenGL image *
 ***********************/

gtk_widget_queue_draw (window->area);
}
