/********************************************
 *
 * $GAMGI/src/math/gamgi_math_diophantine.c
 *
 * Copyright (C) 2006 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"

int gamgi_math_diophantine_gcd (int a, int b)
{
/*****************************
 * recursive Euler algorithm *
 *****************************/

if (b == 0) return a;
else return (gamgi_math_diophantine_gcd (b, a % b));
}

void gamgi_math_diophantine_gcd_extended (int a, int b, int *x, int *y, int *gcd)
{
int quotient, temp;
int x0 = 1;
int y0 = 0;
int x1 = 0;
int y1 = 1;

/****************************
 * extended Euler algorithm *
 ****************************/

while (b != 0)
  {
  temp = b;
  quotient = a / b;
  b = a % b;
  a = temp;

  temp = x1;
  x1 = x0 - quotient * x1;
  x0 = temp;

  temp = y1;
  y1 = y0 - quotient * y1;
  y0 = temp;
  }

*x = x0;
*y = y0;
*gcd = a;
}

void gamgi_math_diophantine_swap (int *old1, int *old2, 
int *new1, int *new2, int *swap)
{
int zero1, zero2;
int i, temp;

/**********************************************************
 * count number of zero indices in the two sets of planes *
 **********************************************************/

zero1 = 0;
for (i = 0; i < 3; i++)
  if (old1[i] == 0) zero1++;

zero2 = 0;
for (i = 0; i < 3; i++)
  if (old2[i] == 0) zero2++;

/****************************************
 * swap equations, so the equation with *
 * more zero indices is the first one   *
 ****************************************/

if (zero1 >= zero2)
  {
  new1[0] = old1[0]; new1[1] = old1[1]; new1[2] = old1[2];
  new2[0] = old2[0]; new2[1] = old2[1]; new2[2] = old2[2];
  swap[3] = 0;
  }
else
  {
  new1[0] = old2[0]; new1[1] = old2[1]; new1[2] = old2[2];
  new2[0] = old1[0]; new2[1] = old1[1]; new2[2] = old1[2];
  swap[3] = 1;
  }

/******************************************
 * swap equation terms, so the first term *
 * in the first equation is not zero      *
 ******************************************/

swap[0] = 0;
swap[1] = 1;
swap[2] = 2;

/**************************
 * swap initial 1,2 terms *
 **************************/

if (new1[0] == 0)
  {
  temp = new1[0];
  new1[0] = new1[1];
  new1[1] = temp;

  temp = new2[0];
  new2[0] = new2[1];
  new2[1] = temp;

  swap[0] = 1;
  swap[1] = 0;
  }

/**************************
 * swap initial 1,3 terms *
 **************************/

if (new1[0] == 0)
  {
  temp = new1[0];
  new1[0] = new1[2];
  new1[2] = temp;

  temp = new2[0];
  new2[0] = new2[2];
  new2[2] = temp;

  swap[0] = 2;
  swap[2] = 1;
  }
}

gamgi_bool gamgi_math_diophantine_intersect (int *hkl1, int *hkl2, 
int n1, int n2, int *out)
{
int d[3];
int x, y, gcd;
int numerator;

int t;

/*******************************************************
 * solve a linear system of two diophantine equations  *
 * (each one describing a plane of a different family) *
 * with three variables (the coordinates of a node     *
 * belonging to both planes)                           *
 *******************************************************/

d[0] = hkl1[0] * hkl2[1] - hkl2[0] * hkl1[1];
d[1] = hkl1[0] * hkl2[2] - hkl2[0] * hkl1[2];
d[2] = hkl1[0] * n2 - hkl2[0] * n1;
if (d[0] == 0 && d[1] == 0) return FALSE;

/*********************************************************
 * if d[0] == 0 && d[1] == 0 then the two plane families *
 * are the same, for example: (+1+1-1) and (-1-1+1)      *
 *********************************************************/

gamgi_math_diophantine_gcd_extended (d[0], d[1], &x, &y, &gcd);
if (d[2] % gcd != 0) return FALSE;

/******************************************
 * if d[2] % gcd != 0 then no valid node  *
 * belongs simultaneosusly to both planes *
 ******************************************/

out[1] = x * d[2] / gcd;
out[2] = y * d[2] / gcd;
numerator = n1 - out[1] * hkl1[1] - out[2] * hkl1[2];
if (numerator % hkl1[0] != 0)
  {
  printf ("hkl1: %d %d %d\n", hkl1[0], hkl1[1], hkl1[2]);
  printf ("hkl2: %d %d %d\n", hkl2[0], hkl2[1], hkl2[2]);
  printf ("o12: %d %d\n", n1, n2);
  printf ("out: %d %d\n", out[1], out[2]);

    x = out[1] + t * d[1]/gcd;
    y = out[2] - t * d[0]/gcd;
    numerator = n1 - x * hkl1[1] - y * hkl1[2];
    }

  return FALSE;
  }

out[0] = numerator / hkl1[0];
return TRUE;
}
