/*******************************************
 *
 * $GAMGI/src/gtk/gamgi_gtk_file_export.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_expat.h"
#include "gamgi_io.h"
#include "gamgi_global.h"

#include "gamgi_gtk_dialog.h"
#include "gamgi_io_file.h"

static void static_write (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
char *filename;

if (gamgi->question != NULL)
  gamgi_gtk_dialog_remove (gamgi->question, &gamgi->question);

filename = gtk_file_selection_get_filename 
(GTK_FILE_SELECTION (window->dialog0));

if (gamgi_io_file_write (filename, window) == TRUE)
  gamgi_gtk_dialog_task0_remove (widget, window);
}

static void static_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
char *filename;

filename = gtk_file_selection_get_filename 
(GTK_FILE_SELECTION (window->dialog0));

gamgi_io_file_overwrite (filename, static_write, window);
}

void gamgi_gtk_file_export (GtkWidget *widget, void *data)
{
GtkWidget *dialog;
GtkWidget *button;
GtkWidget *label;
GdkColor  color;
gamgi_window *windows, *window = GAMGI_CAST_WINDOW data;
    
windows = gamgi->window_start;
do
  {
  windows->action = FALSE;

  if (windows->dialog0 != NULL)
    gamgi_gtk_dialog_remove (windows->dialog0, &windows->dialog0);

  if (windows->dialog1 != NULL)
    gamgi_gtk_dialog_remove (windows->dialog1, &windows->dialog1);
  }
while ((windows = windows->next) != NULL);

window->dialog0 = dialog = gtk_file_selection_new ("File Export");
window->action = GAMGI_GTK_FILE_EXPORT;

gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
gtk_widget_set_size_request (dialog, 600, 450);
gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, FALSE, TRUE);
gtk_window_set_transient_for (GTK_WINDOW(dialog), GTK_WINDOW(window->window));
g_signal_connect (GTK_OBJECT (dialog), "delete_event",
(GtkSignalFunc) gamgi_gtk_dialog_task0_delete, window);

button = GTK_WIDGET (GTK_FILE_SELECTION (dialog)->cancel_button);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_widget_grab_focus (button);

label = GTK_BIN (button)->child;
gdk_color_parse ("red", &color);
gamgi_gtk_dialog_color_fg (label, color);

g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (dialog)->ok_button), 
"clicked", (GtkSignalFunc) static_ok, window);
g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (dialog)->cancel_button), 
"clicked", (GtkSignalFunc) gamgi_gtk_dialog_task0_remove, window);

gtk_widget_show (dialog);
}
