/******************************************
 *
 * $GAMGI/src/chem/gamgi_chem_polytope.h
 *
 * Copyright (C) 2008 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

/**********************
 * internal functions *
 **********************

static int *static_export_points (gamgi_group *group, gamgi_polytope *polytope);

static void static_export_loops (int *index, 
gamgi_group *group, gamgi_polytope *polytope);

static void static_export (gamgi_atom *atom, gamgi_polytope *polytope);

static int static_before (int offset, int f, gamgi_polytope *polytope);

static double static_mix (int v1, int v2, int v3,
int v_conflict, gamgi_polytope *polytope);

static gamgi_bool static_visible (int v1, int v2, int v3, int v, 
gamgi_polytope *polytope);

static gamgi_bool static_coplanar (int v_before, int v_start, 
int v_end, int v_new, gamgi_polytope *polytope);

static void static_vertex_start (int v, gamgi_polytope *polytope);

static int *static_vertex_create (int v, gamgi_polytope *polytope);

static int static_vertex_conflict_recreate (int v, gamgi_polytope *polytope);

static void static_edge_start (int e, gamgi_polytope *polytope);

static void static_edge_remove (int e, gamgi_polytope *polytope);

static void static_edges_remove (int v_new, gamgi_polytope *polytope);

static int *static_edge_create (int e, gamgi_polytope *polytope);

static int static_edges_create (gamgi_polytope *polytope);

static void static_edges_mark (int v_new, gamgi_polytope *polytope);

static void static_face_start (int f, gamgi_polytope *polytope);

static void static_face_remove (int f, gamgi_polytope *polytope);

static void static_faces_remove (int v_new, gamgi_polytope *polytope);

static void static_face_clean (int f, gamgi_polytope *polytope);

static int static_face_edge_recreate (int f, gamgi_polytope *polytope);

static int static_face_conflict_recreate (int f, gamgi_polytope *polytope);

static void static_conflict_add (int v1, int v2, int v3, 
int v, int f, int *n_conflicts, gamgi_polytope *polytope);

static int static_conflict_face (int f_old, int f, 
int v_start, int v_end, int v_new, gamgi_polytope *polytope);

static int static_conflict_rebuild (int f, int e, int v, gamgi_polytope *polytope);

static void static_conflict_build (gamgi_polytope *polytope);

static int *static_face_create (int f, gamgi_polytope *polytope);

static int static_faces_create (gamgi_polytope *polytope);

static void static_faces_mark (int v_new, gamgi_polytope *polytope);

static void static_face_build (int v_new, int v_start, int v_end,
int e_visible, gamgi_polytope *polytope);

static void static_face_merge (int v_new, int v_start, int v_end,
int e_visible, int before, int next, gamgi_polytope *polytope);

static void static_build_vertex (int v_new, gamgi_polytope *polytope);

static void static_build_reset (gamgi_polytope *polytope);

static void static_build_vertices (int cell_x, int cell_y, int cell_z,
gamgi_slist *start, gamgi_atom *atom, gamgi_polytope *polytope);

static void static_build_tetrahedron (gamgi_polytope *polytope);

static void static_build_central (int cell_x, int cell_y, int cell_z, 
gamgi_slist *start, gamgi_atom *atom, gamgi_polytope *polytope);

static gamgi_bool static_build (gamgi_polytope *polytope);

static void static_start_cells (gamgi_polytope *polytope);

static void static_end_cells (gamgi_polytope *polytope);

static gamgi_polytope *static_start (gamgi_object *parent, gamgi_atom *atom,
gamgi_bool multiple, int element, int number, double radius,  
gamgi_enum style, float *color);

static void static_end (gamgi_polytope *polytope);

 **********************
 * external functions *
 **********************/

gamgi_bool gamgi_chem_polytope (gamgi_object *parent, gamgi_atom *atom,
gamgi_bool global, int element, int number, double radius, 
gamgi_enum style, float *color, GtkWidget *text);

/*************
 * Rationale * 
 *************

Not implemented yet.

 *************
 * Rationale *
 *************/
