/*
 *  Copyright (C) 2002 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/* GSidebarProxy is a thin implementation of nsISidebar that forwards all
 * methods to a single instance of GSidebar. This is because we do not
 * have a 1:1 mapping between instances of nsISidebar and physical sidebar
 * docks. GSidebar handles the creation of docks on a 1 per galeon window
 * basis.
 */

#include <nsString.h>
#include <nsIProgrammingLanguage.h>
#include <nsCOMPtr.h>
#include <nsIDOMWindowInternal.h>

#include "SideBarProxy.h"

/* Implementation file */
NS_IMPL_ISUPPORTS2(GSidebarProxy, nsISidebar, nsIClassInfo)

GSidebarProxy::GSidebarProxy()
{
	NS_INIT_ISUPPORTS();
	if(!GlobalSidebar)
	{
		GlobalSidebar = new GSidebar();
	}
	GlobalSidebar->IncRefCount();
}

GSidebarProxy::~GSidebarProxy()
{
	GlobalSidebar->DecRefCount(); //Self deleting
}

//------------------------------------------------------------------------------
//nsIClassInfo Impl.
//------------------------------------------------------------------------------

/* void getInterfaces (out PRUint32 count, [array, size_is (count), retval] out nsIIDPtr array); */
NS_IMETHODIMP GSidebarProxy::GetInterfaces(PRUint32 *count, nsIID * **aArray)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupports getHelperForLanguage (in PRUint32 language); */
NS_IMETHODIMP GSidebarProxy::GetHelperForLanguage(PRUint32 language, nsISupports **_retval)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string contractID; */
NS_IMETHODIMP GSidebarProxy::GetContractID(char * *aContractID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string classDescription; */
NS_IMETHODIMP GSidebarProxy::GetClassDescription(char * *aClassDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsCIDPtr classID; */
NS_IMETHODIMP GSidebarProxy::GetClassID(nsCID * *aClassID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRUint32 implementationLanguage; */
NS_IMETHODIMP GSidebarProxy::GetImplementationLanguage(PRUint32 *aImplementationLanguage)
{
	*aImplementationLanguage = nsIProgrammingLanguage::CPLUSPLUS;
	return NS_OK;
}

/* readonly attribute PRUint32 flags; */
NS_IMETHODIMP GSidebarProxy::GetFlags(PRUint32 *aFlags)
{
	*aFlags = nsIClassInfo::DOM_OBJECT;
	return NS_OK;
}

/* [notxpcom] readonly attribute nsCID classIDNoAlloc; */
NS_IMETHODIMP GSidebarProxy::GetClassIDNoAlloc(nsCID *aClassIDNoAlloc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
