/*
 *  Copyright (C) 2002 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __sidebar_h
#define __sidebar_h

#include "galeon_types.h"
#include <gtk/gtk.h>
#include <nsISidebar.h>
#include <nsIClassInfo.h>
#include <nsCOMPtr.h>
#include <nsIDOMWindowInternal.h>

class SideBarDock;
class GSidebarProxy;

extern "C"
void sidebar_combo_entry_changed_cb (GtkEditable *entry,
				     SideBarDock *sbd);

extern "C"
void sidebar_close_button_clicked_cb (GtkButton *button, 
				      SideBarDock *sbd);

extern "C"
void sidebar_delete_current_page_cb (GtkButton *button,
				     SideBarDock *sbd);

extern "C"
void sidebar_disconnect_mozembed_cb (GtkWidget *dock,
				     gchar *msg,
				     SideBarDock *sbd);

extern "C"
void sidebar_destroy_cb (GtkWidget *dock,
			 SideBarDock *sbd);

class GSidebar : public nsISidebar
{
  public:
	friend class SideBarDock;
	friend class GSidebarProxy;

	NS_DECL_ISUPPORTS
	NS_DECL_NSISIDEBAR

	GSidebar();
	virtual ~GSidebar();

	NS_METHOD SetWindow(GaleonWindow *aParent, PRBool aCalledByMoz = PR_FALSE);
	void RemoveDock(SideBarDock *aDock);
	void RemovePage(const char *desc);

	void IncRefCount(void) { mRefCount++; }
	void DecRefCount(void) { if(--mRefCount == 0) delete this;}

  private:
	void SaveSidebarPages(void);
	void LoadSidebarPages(void);

	GList *mComboList;
	PRBool mComboListEmpty;
	GHashTable *mUrlTable;
	GList *mDocks;
	SideBarDock *mLastDock;

	PRUint32 mRefCount;
};

struct SideBarDock
{
	explicit SideBarDock(GSidebar *aMozSidebar, GaleonWindow *aParent);
	SideBarDock::~SideBarDock();

	void ShowSidebar(void);
	void LoadUrlFromDesc(gchar *desc);

	GSidebar *mMozSidebar;
	GaleonWindow *mParent;

	/* Sidebar widgets */
	GtkWidget *mSidebar;
	GaleonEmbed *mSidebarEmbed;
	GtkWidget *mComboBox;
	GtkWidget *mComboEntry;
	GtkWidget *mCloseButton;
	GtkWidget *mVBox;
};

#endif //__sidebar_h

