/*
 *  Copyright (C) 2002 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if MOZILLA_SNAPSHOT > 1 //This interface only exists in mozilla 1.1 or greater

#include "galeon.h"
#include "mozilla.h"

#include "nsCOMPtr.h"
#include "nsString.h"
#include "nsIServiceManager.h"

#include "PrintingPromptService.h"

/* Implementation file */
NS_IMPL_ISUPPORTS1(GPrintingPromptService, nsIPrintingPromptService)

GPrintingPromptService::GPrintingPromptService()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

GPrintingPromptService::~GPrintingPromptService()
{
  /* destructor code */
}

/* void showPrintDialog (in nsIDOMWindow parent, in nsIWebBrowserPrint webBrowserPrint, in nsIPrintSettings printSettings); */
NS_IMETHODIMP GPrintingPromptService::ShowPrintDialog(nsIDOMWindow *parent, nsIWebBrowserPrint *webBrowserPrint, nsIPrintSettings *printSettings)
{
	g_print("GPrintingPromptService::ShowPrintDialog called\n");
	GaleonWindow *window = mozilla_find_galeon_parent(parent);
	GaleonEmbed *embed = window->active_embed;
	print_show_dialog(embed);	
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void showProgress (in nsIDOMWindow parent, in nsIWebBrowserPrint webBrowserPrint, in nsIPrintSettings printSettings, in nsIObserver openDialogObserver, in boolean isForPrinting, out nsIWebProgressListener webProgressListener, out nsIPrintProgressParams printProgressParams, out boolean notifyOnOpen); */
NS_IMETHODIMP GPrintingPromptService::ShowProgress(nsIDOMWindow *parent, nsIWebBrowserPrint *webBrowserPrint, nsIPrintSettings *printSettings, nsIObserver *openDialogObserver, PRBool isForPrinting, nsIWebProgressListener **webProgressListener, nsIPrintProgressParams **printProgressParams, PRBool *notifyOnOpen)
{
	g_print("GPrintingPromptService::ShowProgress called\n");
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void showPageSetup (in nsIDOMWindow parent, in nsIPrintSettings printSettings, in nsIObserver aObs); */
NS_IMETHODIMP GPrintingPromptService::ShowPageSetup(nsIDOMWindow *parent, nsIPrintSettings *printSettings, nsIObserver *aObs)
{
	g_print("GPrintingPromptService::ShowPageSetup called\n");
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void showPrinterProperties (in nsIDOMWindow parent, in wstring printerName, in nsIPrintSettings printSettings); */
NS_IMETHODIMP GPrintingPromptService::ShowPrinterProperties(nsIDOMWindow *parent, const PRUnichar *printerName, nsIPrintSettings *printSettings)
{
	g_print("GPrintingPromptService::ShowPrinterProperties called\n");
    return NS_ERROR_NOT_IMPLEMENTED;
}


NS_METHOD GPrintingPromptService::CollatePrintSettings(const PrintInfo *info,
						       nsIPrintSettings *options)
{
	if(!options || !info) return NS_ERROR_FAILURE;

	const static int frame_types[] = {
		nsIPrintSettings::kFramesAsIs,
		nsIPrintSettings::kSelectedFrame,
		nsIPrintSettings::kEachFrameSep
	};

	switch (info->pages)
	{
	case 0:
		break;
	case 1:
		options->SetPrintRange (nsIPrintSettings::kRangeSpecifiedPageRange);
		options->SetStartPageRange (info->from_page);
		options->SetEndPageRange (info->to_page);
		break;
	case 2:
		options->SetPrintRange (nsIPrintSettings::kRangeSelection);
		break;
	}

	options->SetMarginTop (info->top_margin);
	options->SetMarginBottom (info->bottom_margin);
	options->SetMarginLeft (info->left_margin);
	options->SetMarginRight (info->right_margin);

	PRUnichar * tempstr;

	tempstr = mozilla_locale_to_unicode("PostScript/default");
	options->SetPrinterName(tempstr);
	g_free(tempstr);

	tempstr = mozilla_locale_to_unicode(info->header_left_string);
	options->SetHeaderStrLeft(tempstr);
	g_free(tempstr);
	
	tempstr = mozilla_locale_to_unicode(info->header_center_string);
	options->SetHeaderStrCenter(tempstr);
	g_free(tempstr);

	tempstr = mozilla_locale_to_unicode(info->header_right_string);
	options->SetHeaderStrRight(tempstr);
	g_free(tempstr);

	tempstr	= mozilla_locale_to_unicode(info->footer_left_string);
	options->SetFooterStrLeft(tempstr);
	g_free(tempstr);

	tempstr	= mozilla_locale_to_unicode(info->footer_center_string);
	options->SetFooterStrCenter(tempstr);
	g_free(tempstr);

	tempstr = mozilla_locale_to_unicode(info->footer_right_string);
	options->SetFooterStrRight(tempstr);
	g_free(tempstr);

	tempstr = mozilla_locale_to_unicode(info->file);
	options->SetToFileName (tempstr);
	g_free(tempstr);

	options->SetPrintToFile (info->print_to_file);

	tempstr = mozilla_locale_to_unicode(info->printer);
	options->SetPrintCommand (tempstr);
	g_free(tempstr);

	options->SetPrintReversed (info->reversed);
	options->SetPaperSize (info->paper);
	options->SetPrintInColor (info->print_color);
	options->SetOrientation (info->orientation);
	options->SetPrintFrameType (frame_types[info->frame_type]);

	return NS_OK;
}

#endif // MOZILLA_SNAPSHOT > 1
