/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "galeon_types.h"
#include "mozilla.h"
#include "js_console.h"
#include "JSConsoleService.h"

#include "nsIDOMWindow.h"
#include "nsCOMPtr.h"

NS_IMPL_ISUPPORTS1(JSConsoleService, nsIJSConsoleService)


JSConsoleService::JSConsoleService()  
{
	NS_INIT_ISUPPORTS();
}

JSConsoleService::~JSConsoleService()
{
}


NS_IMETHODIMP
JSConsoleService::Open ( nsIDOMWindow *inParent )               
{
    GtkWidget *parent;
    GaleonEmbed *embed;
    GaleonWindow *window;

    parent = mozilla_find_gtk_parent (inParent);
    window = (GaleonWindow *) gtk_object_get_data (GTK_OBJECT (parent), "GaleonWindow");

    return_val_if_not_window (window, NS_ERROR_FAILURE);
    embed = window->active_embed;
    return_val_if_not_embed (embed, NS_ERROR_FAILURE);

    js_console_show (embed);

    return NS_OK;
}
