/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef EVENT_CONTEXT_H
#define EVENT_CONTEXT_H

#include "nsIDOMMouseEvent.h"
#include "nsIDOMKeyEvent.h"
#include "nsIDOMEvent.h"
#include "nsIDOMNode.h"
#include "nsString.h"
#include "nsIDOMHTMLAnchorElement.h"
#include "nsIDOMNSHTMLElement.h"
#include "nsIDOMHTMLAreaElement.h"
#include "nsIDOMHTMLBodyElement.h"
#include "nsIDOMElementCSSInlineStyle.h"
#include "nsIDOMCSSStyleDeclaration.h"
#include "nsIDOMDocument.h"

#include "galeon.h"
#include "mozilla.h"
#include "GaleonWrapper.h"

class EventContext
{
public:
	EventContext();
	~EventContext();

	nsresult Init (nsIDOMEvent *event, GaleonWrapper *wrapper);

	nsresult GetMouseEventInfo (WrapperMouseEventInfo *info);
	nsresult GetKeyEventInfo (WrapperKeyEventInfo *info);
	nsresult GetTargetDocument (nsIDOMDocument **domDoc);

private:
	nsIDOMEvent *mEvent;
	GaleonWrapper *mWrapper;
	nsCOMPtr<nsIDOMDocument> mDOMDocument;

	nsresult GetEventContext (nsIDOMEventTarget *EventTarget,
				  WrapperContextInfo *info);
	nsresult GetCSSBackground (nsIDOMNode *node, nsString& url);
	nsresult IsPageFramed (nsIDOMNode *node, PRBool *Framed);
};

#endif
