/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "mozilla.h"
#include "embed.h"
#include "misc_string.h"
#include "history.h"
#include "eel-gconf-extensions.h"
#include "window.h"

#include <string.h>
#include <gtkmozembed.h>

/* for nautilus dnd desktop items */
#include <libgnome/gnome-mime.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>
#include <libgnomevfs/gnome-vfs-mime.h>

/**
 * embed_selection_get_cb: get selection on copy link location
 */
void
embed_selection_get_cb (GtkWidget *widget, GtkSelectionData *selection_data,
			   guint info, guint time_stamp, gpointer data)
{
	gchar *text;

	text = gtk_object_get_data (GTK_OBJECT(widget), "selection");

	g_return_if_fail (text != NULL);

	gtk_selection_data_set (selection_data, GDK_SELECTION_TYPE_STRING,
				8, text, strlen (text));
}

/** 
 * embed_drag_data_received_cb:
 */
void
embed_drag_data_received_cb (GtkWidget *widget, GdkDragContext *context,
			     gint x, gint y, GtkSelectionData *selection_data,
			     guint info, guint time, GaleonEmbed *embed)
{
	gchar *data = selection_data->data;
	gboolean tabbed;
	GList *uris, *l;	
	gchar *drop_uri;
	gchar *parse_uri;
	gchar *real_uri;
	gchar **tmp;

	/* get tab status */
	tabbed = eel_gconf_get_boolean (CONF_TABS_TABBED);

	switch (info)
	{
	case DND_TARGET_NETSCAPE_URL:
		/* netscape format is: url \n title */
		tmp = g_strsplit(data, "\n", 2);
		if (tmp)
		{
			embed_load_url (embed, tmp[0]);
		}
		else
		{
			embed_load_url (embed, data);
		}
		g_strfreev (tmp);
		break;
	case DND_TARGET_STRING:
	case DND_TARGET_GALEON_URL:
		/* standard types are just strings */
		embed_load_url (embed, data);
		break;

	case DND_TARGET_TEXT_URI_LIST:
		/* list as passed by Nautilus */
		uris = gnome_uri_list_extract_uris (data);
		for (l = uris; l != NULL; l = g_list_next (l))
		{
			/* find the uri to open */
			drop_uri = (gchar *)(l->data);
			parse_uri = misc_string_parse_uri (drop_uri);
			real_uri = (parse_uri == NULL ? drop_uri : parse_uri);

			/* open in first or next embed */
			if (l == uris)
			{
				embed_load_url (embed, real_uri);
			}
			else
			{
				embed_create_after_embed (embed, !tabbed,
					real_uri, 0);
			}
			
			/* free allocated string */
			g_free (drop_uri);
			if (parse_uri != NULL)
			{
				g_free (parse_uri);
			}
		}
		/* free parsed list */
		g_list_free (uris);
		break;

       
	default:
		/* shouldn't happen */
		g_warning ("unexpected drop type %ud\n", info);
		break;
	}
}

/**
 * embed_tab_close_clicked_cb: close a tab
 */
void 
embed_tab_close_button_clicked_cb (GtkWidget *button, GaleonEmbed *embed)
{
	return_if_not_embed (embed);

	if((embed->parent_window) &&
	   (g_list_length (embed->parent_window->embed_list) == 1))
	{
		window_close(embed->parent_window);
	}
	else
	{
		embed_close (embed);
	}
}
