/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __embed_h
#define __embed_h

#include <gtk/gtknotebook.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include "galeon_types.h"

#ifdef __cplusplus
extern "C"
{
#endif

/* embed.c */
GaleonEmbed *embed_create_in_window_chrome (GaleonWindow *window,
					    GaleonEmbed *previous_embed,
					    const gchar *url,
					    EmbedCreateFlags flags,
					    guint32 chrome_mask);
GaleonEmbed *embed_create_in_window (GaleonWindow *window,
				     GaleonEmbed *previous_embed,
				     const gchar *url, 
				     EmbedCreateFlags flags);
GaleonEmbed *embed_create_after_embed_chrome (GaleonEmbed *previous_embed,
					      gboolean new_window,
					      const gchar *url,
					      EmbedCreateFlags flags,
					      guint32 chrome_mask);
GaleonEmbed *embed_create_after_embed (GaleonEmbed *previous_embed,
				       gboolean new_window,
				       const gchar *url,
				       EmbedCreateFlags flags);
GaleonEmbed *embed_create_no_window (void);
gchar *embed_get_vs_url_from_string (const gchar *url);
gchar *embed_get_default_url (GaleonEmbed *previous_embed);
void embed_wrapper_init (GaleonEmbed *embed);
void embed_set_visibility (GaleonEmbed *embed, gboolean visibility);
void embed_load_url (GaleonEmbed *embed, const gchar *url);
gboolean embed_activate_link_mouse (GaleonEmbed *previous, 
				    GaleonEmbed **new_embed,
				    const gchar *url, GdkEventButton *event);
gboolean embed_activate_link_keyboard (GaleonEmbed *previous, 
				       GaleonEmbed **new_embed,
				       const gchar *url, guint evstate);
gboolean embed_activate_link (GaleonEmbed *previous, GaleonEmbed **embed,
			      const gchar *url, LinkState state);
void embed_progress_clear (GaleonEmbed *embed);
void embed_save_image (GaleonEmbed *embed, gchar *url, gboolean ask);
void embed_set_image_as_background (GaleonEmbed *embed, gchar *url);
void embed_save_document (GaleonEmbed *embed, gboolean main);
void embed_show_find_dialog (GaleonEmbed *embed);
void embed_view_source (GaleonEmbed *embed, gboolean main, 
			gboolean new_window);
void embed_close (GaleonEmbed *embed);
void embed_open_frame (GaleonEmbed *embed, gboolean same_embed,
		       gboolean new_window);
void embed_reload (GaleonEmbed *embed, int flags);
void embed_update_title (GaleonEmbed *embed);
void embed_update_tab_title (GaleonEmbed *embed);
void embed_update_tab_size (GaleonEmbed *embed);
void embed_update_tab_status (GaleonEmbed *embed);
void embed_update_tab_close_button (GaleonEmbed *embed);
void embed_go_prev_link (GaleonEmbed *embed);
void embed_go_next_link (GaleonEmbed *embed);
void embed_go_contents_link (GaleonEmbed *embed);
void embed_go_up (GaleonEmbed *embed, gint levels, LinkState state);
gboolean embed_can_go_up (GaleonEmbed *embed);
void embed_set_zoom (GaleonEmbed *embed, gint zoom, gboolean reflow);
GtkMenu *embed_create_back_menu (GaleonEmbed *embed);
GtkMenu *embed_create_forward_menu (GaleonEmbed *embed);
GtkMenu *embed_create_up_menu (GaleonEmbed *embed);
void embed_startup_init (void);
void embed_shift_tab (GaleonEmbed *embed, gint amount);
void embed_move_to_new_window (GaleonEmbed *embed);
void embed_move_to_existing_window (GaleonEmbed *embed, GaleonWindow *window,
				    gint page);
void embed_switch_to_page (GaleonEmbed *embed);
void embed_grab_focus (GaleonEmbed *embed);
void embed_toggle_image_blocking (const gchar *url);
void embed_save_url (GaleonEmbed *embed, char *target, 
		     char *default_dir_pref, gboolean ask,
		     gboolean ask_content, gboolean main, gboolean save_dir,
		     gboolean silent);
void embed_set_temp_statusbar_message (GaleonEmbed *embed,
				       const gchar *message);
void embed_save_modified_location (GaleonEmbed *embed);
gboolean embed_exists (GaleonEmbed *embed);
void embed_copy_text_to_clipboard (gchar *text, GaleonEmbed *embed);

/* embed_callbacks.c */
void embed_drag_data_received_cb (GtkWidget *widget, GdkDragContext *context,
			          gint x, gint y, 
			          GtkSelectionData *selection_data,
			          guint info, guint time, GaleonEmbed *embed);
void embed_tab_close_button_clicked_cb (GtkWidget *button, GaleonEmbed *embed);
void
embed_selection_get_cb (GtkWidget *widget, GtkSelectionData *selection_data,
			guint info, guint time_stamp, gpointer data);

#ifdef __cplusplus
}
#endif

#endif
