/*
 * Copyright (c) 2006 Krzysztof Godlewski <sigsegv@tlen.pl>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef TLEN_CHAT_H
#define TLEN_CHAT_H

// #include "internal.h"

#include "account.h"
#include "accountopt.h"
#include "debug.h"
#include "notify.h"
#include "request.h"
#include "server.h"
#include "util.h"
#include "version.h"
#include "roomlist.h"
#include "xmlnode.h"

#include "tlen.h"
	
GList *tlen_chat_info(GaimConnection *gc);
GHashTable *tlen_chat_info_defaults(GaimConnection *gc, const char *chat_name);
GaimRoomlist *tlen_roomlist_get_list(GaimConnection *gc);
void tlen_roomlist_cancel(GaimRoomlist *list);
void tlen_roomlist_expand_category(GaimRoomlist *list, GaimRoomlistRoom *category);
void tlen_join_chat(GaimConnection *gc, GHashTable *data);
int tlen_chat_send(GaimConnection *gc, int id, const char *msg, GaimMessageFlags flags);
void tlen_chat_leave(GaimConnection *gc, int id);
void tlen_chat_whisper(GaimConnection *gc, int id, const char *who, const char *msg);
char *tlen_chat_get_cb_real_name(GaimConnection *gc, int id, const char *who);
void tlen_chat_invite(GaimConnection *gc, int id, const char *msg, const char *name);

void tlen_chat_start_conference(GaimBlistNode *node, gpointer data);

int tlen_chat_process_iq(TlenSession *tlen, xmlnode *xml, const char *type);
int tlen_chat_process_p(TlenSession *tlen, xmlnode *xml);
int tlen_chat_process_message(TlenSession *s, xmlnode *xml, const char *from);
void tlen_chat_send_privmsg(TlenSession *s, const char *who, char *msg);

#endif
