/*
 * gaim
 *
 * Copyright (C) 1998-1999, Mark Spencer <markster@marko.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <string.h>
#include <sys/time.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "gaim.h"
#include "proxy.h"

struct prefs_data *pd = NULL;
struct debug_window *dw = NULL;

int sounds;
int extrasounds;
int enter_sends;
int show_time;
int show_grp_nums;
int report_idle;
int remember_pass;
int send_links;
int show_smilies;
int ignore_colours;
int striphtml;
int showidle;
int popup_windows;
int button_pix;
int showpix;
int transparent;
int registered;
int show_lagometer;
int web_browser;
int browser_popup;
int auto_login;
int applet_buddy_auto_show;
int log_all_conv;
int debug = 0;
int show_logon;
char debug_buff[BUF_LONG];
char aim_username[80];
char aim_password[16];
char user_info[2048];
char web_command[2048];
char aim_host[512];
int aim_port;
char login_host[512];
int login_port;

GtkWidget * debugbutton;
struct chat_page {
	GtkWidget *list1;
	GtkWidget *list2;
};


void do_chat_page(GtkWidget *page);

void list_clicked( GtkWidget *widget, struct away_message *a);
void list_unclicked( GtkWidget *widget, struct away_message *a);


void load_prefs()
{
	FILE *f;

	char *tmp;
	char *tmp2;
	char buf[BUF_LONG];

	tmp = g_malloc(256);  /* Have to allocate memory to pointers */
        tmp2 = g_malloc(256);

	/* Defaults.  If these are in the .gaimrc they'll be overwritten. */
	striphtml = 0;
	send_links = 1;
	sounds = 1;
	extrasounds = 1;
	showidle = 1;
	enter_sends = 1;
	show_time = 1;
        showpix = 1;
        button_pix = 1;
	registered = 0;
	aim_port = TOC_PORT;
	login_port = AUTH_PORT;
	g_snprintf(aim_host, sizeof(aim_host), "%s", TOC_HOST);
    	g_snprintf(login_host, sizeof(login_host), "%s", AUTH_HOST);
	applet_buddy_auto_show = 0;
        proxy_host[0] = 0;
        proxy_port = 0;
        g_snprintf(web_command, sizeof(web_command), "xterm -e lynx %%s");
	g_snprintf(user_info, sizeof(user_info), "Visit the GAIM website at <A HREF=\"http://www.marko.net/gaim\">http://www.marko.net/gaim</A>."); 
	if (getenv("HOME")) {
		g_snprintf(buf, sizeof(buf), "%s/.gaiminfo", getenv("HOME"));
		if ((f = fopen(buf, "r"))) {
			fgets(user_info, sizeof(user_info), f);
			fclose(f);
		}
	}
        if (getenv("HOME")) {
                g_snprintf(buf, sizeof(buf), "%s/.gaimrc", getenv("HOME"));
                if ((f = fopen(buf,"r"))) {
                        while(fgets(buf, sizeof(buf), f) != NULL) {
                                if (buf[0] == '#')
                                        continue;
                                sscanf(buf, "%s %[A-Za-z =0-9._+!@#$%%^&*()-'\\]\n", tmp, tmp2);

                                if (!strcasecmp(tmp, "username")) {
                                        g_snprintf(aim_username, sizeof(aim_username), "%s", tmp2);
                                } else if (!strcasecmp(tmp, "password")) {
					g_snprintf(aim_password, sizeof(aim_password), "%s", tmp2);
				} else if (!strcasecmp(tmp, "aim_host")) {
					g_snprintf(aim_host, sizeof(aim_host), "%s", tmp2);
				} else if (!strcasecmp(tmp, "login_host")) {
					g_snprintf(login_host, sizeof(login_host), "%s", tmp2);
				} else if (!strcasecmp(tmp, "proxy_host")) {
					g_snprintf(proxy_host, sizeof(proxy_host), "%s", tmp2);
				} else if (!strcasecmp(tmp, "proxy_port")) {
					sscanf(tmp2, "%d", &proxy_port);
				} else if (!strcasecmp(tmp, "aim_port")) {
                                        sscanf(tmp2, "%d", &aim_port);
				} else if (!strcasecmp(tmp, "login_port")) {
					sscanf(tmp2, "%d", &login_port);
                                } else if (!strcasecmp(tmp, "web_command")) {
                                        g_snprintf(web_command, sizeof(web_command), "%s", tmp2);
                                } else if (!strcasecmp(tmp, "sounds")) {
                                        sscanf(tmp2, "%d", &sounds);
				} else if (!strcasecmp(tmp, "showpix")) {
					sscanf(tmp2, "%d", &showpix);
				} else if (!strcasecmp(tmp, "proxy_type")) {
					sscanf(tmp2, "%d", &proxy_type);
                                } else if (!strcasecmp(tmp, "extrasounds")) {
                                        sscanf(tmp2, "%d", &extrasounds);
                                } else if (!strcasecmp(tmp, "enter_sends")) {
                                        sscanf(tmp2, "%d", &enter_sends);
                                } else if (!strcasecmp(tmp, "report_idle")) {
                                        sscanf(tmp2, "%d", &report_idle);
                                } else if (!strcasecmp(tmp, "show_time")) {
                                        sscanf(tmp2, "%d", &show_time);
                                } else if (!strcasecmp(tmp, "remember_pass")) {
                                        sscanf(tmp2, "%d", &remember_pass);
                                } else if (!strcasecmp(tmp, "transparent")) {
                                        sscanf(tmp2, "%d", &transparent);
                                } else if (!strcasecmp(tmp, "web_browser")) {
                                        sscanf(tmp2, "%d", &web_browser);
                                } else if (!strcasecmp(tmp, "browser_popup")) {
                                        sscanf(tmp2, "%d", &browser_popup);
                                } else if (!strcasecmp(tmp, "show_lagometer")) {
                                        sscanf(tmp2, "%d", &show_lagometer);
                                } else if (!strcasecmp(tmp, "showidle")) {
                                        sscanf(tmp2, "%d", &showidle);
                                } else if (!strcasecmp(tmp, "send_links")) {
					sscanf(tmp2, "%d", &send_links);
                                } else if (!strcasecmp(tmp, "button_pix")) {
                                        sscanf(tmp2, "%d", &button_pix);
                                } else if (!strcasecmp(tmp, "auto_login")) {
                                        sscanf(tmp2, "%d", &auto_login);
                                } else if (!strcasecmp(tmp, "log_all")) {
                                        sscanf(tmp2, "%d", &log_all_conv);
				} else if (!strcasecmp(tmp, "strip_html")) {
					sscanf(tmp2, "%d", &striphtml);
                                } else if (!strcasecmp(tmp, "applet_buddy_auto_show")) {
                                        sscanf(tmp2, "%d", &applet_buddy_auto_show);
                                } else if (!strcasecmp(tmp, "show_grp_nums")) {
                                        sscanf(tmp2, "%d", &show_grp_nums);
                                } else if (!strcasecmp(tmp, "show_logon")) {
                                        sscanf(tmp2, "%d", &show_logon);
                                } else if (!strcasecmp(tmp, "show_cat_nums")) {
                                        /* Backwards compat */
                                        sscanf(tmp2, "%d", &show_grp_nums);
                                } else if (!strcasecmp(tmp, "ignore_colours")) {
                                        sscanf(tmp2, "%d", &ignore_colours);
                                } else if (!strcasecmp(tmp, "popup_windows")) {
                                        sscanf(tmp2, "%d", &popup_windows);
				} else if (!strcasecmp(tmp, "registered")) {
					sscanf(tmp2, "%d", &registered);
                                } else if (!strcasecmp(tmp, "away_mess")) {
                                        struct away_message *a;
                                        fgets(buf, sizeof(buf), f);
                                        if (!strlen(buf) || !strlen(tmp2))
                                                continue;
                                        a = (struct away_message *)g_new0(struct away_message, 1);
                                        g_snprintf(a->name, sizeof(a->name), "%s", tmp2);
                                        g_snprintf(a->message, sizeof(a->message), "%s", buf);
					/* Get rid of the \n ya doofus */
                                        a->message[strlen(a->message) - 1] = '\0';
					away_messages = g_list_append(away_messages, a);
				} else if (!strcasecmp(tmp, "chat_room")) {
					struct chat_room *c;
					fgets(buf, sizeof(buf), f);
					if (!strlen(buf) || !strlen(tmp2))
						continue;
					c = (struct chat_room *)g_new0(struct chat_room, 1);
					g_snprintf(c->name, sizeof(c->name), "%s", buf);
					sscanf(tmp2, "%d", &c->exchange);
					c->name[strlen(c->name) - 1] = 0;
                                        chat_rooms = g_list_append(chat_rooms, c);
					
				} else if (!strcasecmp(tmp, "log_name")) {
                                        struct log_conversation *l;
					fgets(buf, sizeof(buf), f);
					if (!strlen(buf) || !strlen(tmp2))
						continue;
					l = (struct log_conversation *)g_new0(struct log_conversation, 1);
					g_snprintf(l->name, sizeof(l->name), "%s", tmp2);
					g_snprintf(l->filename, sizeof(l->filename), "%s", buf);

                                        l->filename[strlen(l->filename) - 1] = '\0';
                                        log_conversations = g_list_append(log_conversations, l);
					sprintf(debug_buff,"Logging: %s\n", l->name);
					debug_print(debug_buff);
				}
			}
			fclose(f);
		}
	}
	

       g_free(tmp);
       g_free(tmp2);
}


void remove_away_message(GtkWidget *widget, void *dummy)
{
	GList *i;
	struct away_message *a;

	i = GTK_LIST(pd->away_list)->selection;

	a = gtk_object_get_user_data(GTK_OBJECT(i->data));

	rem_away_mess(NULL, a);
}

void away_list_clicked( GtkWidget *widget, struct away_message *a)
{
	gchar buffer[2048];
	guint text_len;

	pd->cur_message = a;

	/* Get proper Length */
	text_len = gtk_text_get_length(GTK_TEXT(pd->away_text));
	pd->edited_message = gtk_editable_get_chars(GTK_EDITABLE(pd->away_text), 0, text_len);

	/* Clear the Box */
	gtk_text_set_point(GTK_TEXT(pd->away_text), 0 );
	gtk_text_forward_delete (GTK_TEXT(pd->away_text), text_len); 

	/* Fill the text box with new message */
	strcpy(buffer, a->message);
	gtk_text_insert(GTK_TEXT(pd->away_text), NULL, NULL, NULL, buffer, -1);


}

void away_list_unclicked( GtkWidget *widget, struct away_message *a)
{
        if (pd == NULL)
                return;
	strcpy(a->message, pd->edited_message);
	save_prefs();
}

void save_prefs()
{
	FILE *f;
	struct away_message *a;
        struct conversation *c;
	struct log_conversation *l;
	struct chat_room *cr;
        GList *lcs = log_conversations;
        GList *awy = away_messages;
	GList *cnv = conversations;
	GList *crs = chat_rooms;

	char buf[BUF_LONG];

	if (getenv("HOME")) {
		g_snprintf(buf, sizeof(buf), "%s/.gaiminfo", getenv("HOME"));
		if ((f = fopen(buf, "w"))) {
			fprintf(f, "%s", user_info);
			fclose(f);
		}
	}
	if (getenv("HOME")) {
		g_snprintf(buf, sizeof(buf), "%s/.gaimrc", getenv("HOME"));
		if ((f = fopen(buf,"w"))) {
			fprintf(f, "username %s\n", aim_username);
			if (remember_pass) {
				fprintf(f, "password %s\n",aim_password);
			} else {
				fprintf(f, "password none\n");
			}
			fprintf(f, "sounds %d\n", sounds);
			fprintf(f, "extrasounds %d\n", extrasounds);
			fprintf(f, "enter_sends %d\n", enter_sends);
			fprintf(f, "show_time %d\n", show_time);
			fprintf(f, "remember_pass %d\n", remember_pass);
                        fprintf(f, "auto_login %d\n", auto_login);
                        fprintf(f, "show_lagometer %d\n", show_lagometer);
                        fprintf(f, "report_idle %d\n", report_idle);
			fprintf(f, "proxy_type %d\n", proxy_type);
			fprintf(f, "aim_host %s\n", aim_host);
			fprintf(f, "aim_port %d\n", aim_port);
			fprintf(f, "login_host %s\n", login_host);
			fprintf(f, "login_port %d\n", login_port);
			fprintf(f, "proxy_host %s\n", proxy_host);
			fprintf(f, "proxy_port %d\n", proxy_port);
                        fprintf(f, "send_links %d\n", send_links);
			fprintf(f, "log_all %d\n", log_all_conv);
			fprintf(f, "applet_buddy_auto_show %d\n", applet_buddy_auto_show);
                        fprintf(f, "showidle %d\n", showidle);
                        fprintf(f, "transparent %d\n", transparent);
                        fprintf(f, "web_browser %d\n", web_browser);
                        fprintf(f, "browser_popup %d\n", browser_popup);

                        fprintf(f, "web_command %s\n", web_command);
#if 0
                        fprintf(f, "show_smilies %d\n", show_smilies);
#endif
			fprintf(f, "ignore_colours %d\n", ignore_colours);
			fprintf(f, "showpix %d\n", showpix);
			fprintf(f, "show_logon %d\n", show_logon);
			fprintf(f, "button_pix %d\n", button_pix);
                        fprintf(f, "popup_windows %d\n", popup_windows);
			fprintf(f, "show_grp_nums %d\n", show_grp_nums);
			fprintf(f, "registered %d\n", registered);
			fprintf(f, "strip_html %d\n", striphtml);
                        while(awy) {
                                a = (struct away_message *)awy->data;
				fprintf(f, "away_mess %s\n", a->name);
				fprintf(f, "%s\n", a->message);
				awy = awy->next;
			}
			while(crs) {
				cr = (struct chat_room *)crs->data;
				fprintf(f, "chat_room %d\n", cr->exchange);
				fprintf(f, "%s\n", cr->name);
				crs = crs->next;
			}
                        while(lcs) {
                                l = (struct log_conversation *)lcs->data;
				fprintf(f, "log_name %s\n", l->name);
				fprintf(f, "%s\n", l->filename);
				lcs = lcs->next;
			}
                        fclose(f);
                        chmod(buf, S_IRUSR | S_IWUSR);
                        while (cnv) {
                                c = (struct conversation *)cnv->data;
				if (log_all_conv) {
					g_snprintf(buf, sizeof(buf), LOG_CONVERSATION_TITLE, c->name);
					gtk_window_set_title(GTK_WINDOW(c->window), buf);
				}
				else {
					if (find_log_info(c->name)) {
						g_snprintf(buf, sizeof(buf), LOG_CONVERSATION_TITLE, c->name);
					} else {
						g_snprintf(buf, sizeof(buf), CONVERSATION_TITLE, c->name);
					}
					gtk_window_set_title(GTK_WINDOW(c->window), buf);
				}
				cnv = cnv->next;
			}
                }
                
	}
}

void set_option(GtkWidget *w, int *data)
{
        *data = !(*data);
        if (data == &show_grp_nums)
		update_num_groups();
	if (data == &showidle || data == &showpix)
		update_show_idlepix();
	if (data == &button_pix)
                update_button_pix();
        if (data == &log_all_conv)
                update_log_convs();
        if (data == &transparent)
                update_transparency();
        if (data == &show_lagometer)
                update_lagometer(-1);

        
	save_prefs();
#if 0
	printf("Data %p set to %d\n",data, *data);
#endif
}


static gint debug_delete(GtkWidget *w, GdkEvent *event, void *dummy)
{
	if(debugbutton && debug)
	{
		gtk_button_clicked(GTK_BUTTON(debugbutton));
	}
	g_free(dw);
	dw=NULL;
	debug=FALSE;
	return FALSE;

}

static gint handle_delete(GtkWidget *w, GdkEvent *event, void *dummy)
{
	guint text_len;
	struct away_message *a;


        if (pd->cur_message) {
        
		a = pd->cur_message;


		/* Get proper Length and grab data */
		text_len = gtk_text_get_length(GTK_TEXT(pd->away_text));
		pd->edited_message = gtk_editable_get_chars(GTK_EDITABLE(pd->away_text), 0, text_len);

		/* Store the data for later use */
		strcpy(a->message, pd->edited_message);

	}
	
	save_prefs();

	if (event == NULL)
	{
		gtk_widget_destroy(pd->window);
		debugbutton=NULL;
	}
	g_free(pd);
	pd = NULL;

	
        return FALSE;
}

static int
manualentry_key_pressed(GtkWidget *w, GdkEvent *event, void *dummy)
{
        g_snprintf(web_command, sizeof(web_command), "%s", gtk_entry_get_text(GTK_ENTRY(pd->browser_entry)));
        save_prefs();
	return TRUE;
}

static int
connection_key_pressed(GtkWidget *w, GdkEvent *event, void *dummy)
{
	g_snprintf(aim_host, sizeof(aim_host), "%s", gtk_entry_get_text(GTK_ENTRY(pd->aim_host_entry)));
	sscanf(gtk_entry_get_text(GTK_ENTRY(pd->aim_port_entry)), "%d", &aim_port);
	g_snprintf(proxy_host, sizeof(proxy_host), "%s", gtk_entry_get_text(GTK_ENTRY(pd->http_proxy_host_entry)));
	sscanf(gtk_entry_get_text(GTK_ENTRY(pd->http_proxy_port_entry)), "%d", &proxy_port);

	g_snprintf(login_host, sizeof(login_host), "%s", gtk_entry_get_text(GTK_ENTRY(pd->login_host_entry)));
	sscanf(gtk_entry_get_text(GTK_ENTRY(pd->login_port_entry)), "%d", &login_port);	
	save_prefs();
	return TRUE;
}



                   
static void set_browser(GtkWidget *w, int *data)
{
	web_browser = (int)data;
        if (web_browser != BROWSER_MANUAL) {
                if (pd->browser_entry)
                        gtk_widget_set_sensitive(pd->browser_entry, FALSE);
        } else {
                if (pd->browser_entry)
                        gtk_widget_set_sensitive(pd->browser_entry, TRUE);
        }
        
        if (web_browser != BROWSER_NETSCAPE) {
                if (pd->nwbutton)
                        gtk_widget_set_sensitive(pd->nwbutton, FALSE);
        } else {
                if (pd->nwbutton)
                        gtk_widget_set_sensitive(pd->nwbutton, TRUE);
        }
        

        save_prefs();
}

static void set_connect(GtkWidget *w, int *data)
{
	proxy_type = (int)data;
	if (proxy_type == PROXY_HTTP) {
                if (pd->http_proxy_host_entry)
                        gtk_widget_set_sensitive(pd->http_proxy_host_entry, TRUE);
		if (pd->http_proxy_port_entry)
			gtk_widget_set_sensitive(pd->http_proxy_port_entry, TRUE);

	} else {
                if (pd->http_proxy_host_entry)
                        gtk_widget_set_sensitive(pd->http_proxy_host_entry, FALSE);
		if (pd->http_proxy_port_entry)
			gtk_widget_set_sensitive(pd->http_proxy_port_entry, FALSE);

	}
        
        save_prefs();
}

static void set_idle(GtkWidget *w, int *data)
{
	report_idle = (int)data;
        save_prefs();
}


GtkWidget *gaim_button(const char *text, int *value, GtkWidget *page)
{
	GtkWidget *button;
	button = gtk_check_button_new_with_label(text);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), *value);
	gtk_box_pack_start(GTK_BOX(page), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(set_option), value);
	gtk_widget_show(button);
	return button;
}

void debug_print(char *chars)
{
	if(debug)
            gtk_text_insert(GTK_TEXT(dw->entry),NULL, NULL, NULL, chars, strlen(chars));
#ifdef DEBUG
        printf("%s\n", chars);
#endif
}


void build_debug()
{
	GtkWidget *scroll;
	GtkWidget *box;
	if (!dw)
		dw = g_new0(struct debug_window, 1);

	box = gtk_hbox_new(FALSE,0);
	dw->window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dw->window), "GAIM debug output window");
	gtk_container_add(GTK_CONTAINER(dw->window), box);
	dw->entry = gtk_text_new(NULL,NULL);
	gtk_widget_set_usize(dw->entry, 500, 200);
	scroll = gtk_vscrollbar_new(GTK_TEXT(dw->entry)->vadj);
	gtk_box_pack_start(GTK_BOX(box), dw->entry, TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(box), scroll,FALSE,FALSE,0);
	gtk_widget_show(dw->entry);
	gtk_widget_show(scroll);
	gtk_widget_show(box);
	gtk_signal_connect(GTK_OBJECT(dw->window),"delete_event", GTK_SIGNAL_FUNC(debug_delete), NULL);
	gtk_widget_show(dw->window);
}



void show_debug(GtkObject * object)
{
        if(debug) {
                if(!dw || !dw->window)
                        build_debug();
                gtk_widget_show(dw->window);
        } else {
                gtk_widget_destroy(dw->window);
                dw->window = NULL;
	}
}


void build_prefs()
{
	GtkWidget *bbox;
	GtkWidget *vbox;
	GtkWidget *hbox;
        GtkWidget *hbox2;
        GtkWidget *idlebox;
        GtkWidget *idleframe;
        GtkWidget *genbox;
	GtkWidget *away_topbox;
	GtkWidget *away_botbox;
	GtkWidget *add_away;
	GtkWidget *remove_away;
	GtkWidget *close;
	GtkWidget *notebook;
	GtkWidget *sound_page;
	/* GtkWidget *debug_page; */
	GtkWidget *general_page;
	GtkWidget *appearance_page;
	GtkWidget *chat_page;
        GtkWidget *browser_page;
        GtkWidget *connection_page;
        GtkWidget *label;
        GtkWidget *browseropt;
        GtkWidget *connectopt;
        GtkWidget *idleopt;
        
        GList *awy = away_messages;
        struct away_message *a;
        GtkWidget *sw;
	GtkWidget *sw2;
	GtkWidget *away_page;

	GtkWidget *list_item;

	gchar buffer[64];


	if (!pd)
                pd = g_new0(struct prefs_data, 1);

	pd->window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_container_border_width(GTK_CONTAINER(pd->window), 10);
	gtk_window_set_title(GTK_WINDOW(pd->window), "Gaim - Preferences");
	
        vbox = gtk_vbox_new(FALSE, 5);
        gtk_container_add(GTK_CONTAINER(pd->window), vbox);

	/* Notebooks */
	notebook = gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 5);


	/* General page */
	general_page = gtk_hbox_new(FALSE, 0);
	label = gtk_label_new("General");
	gtk_widget_show(label);
        gtk_notebook_append_page(GTK_NOTEBOOK(notebook), general_page, label);

        genbox = gtk_vbox_new(FALSE, 5);
        idleframe = gtk_frame_new("Idle");
        idlebox = gtk_vbox_new(FALSE, 5);

        gtk_box_pack_start(GTK_BOX(general_page), genbox, TRUE, TRUE, 5);
        gtk_box_pack_start(GTK_BOX(general_page), idleframe, TRUE, TRUE, 5);
        gtk_container_add(GTK_CONTAINER(idleframe), idlebox);

        
	gaim_button("Enter sends message", &enter_sends, genbox);
	gaim_button("Auto-login", &auto_login, genbox);
	gaim_button("Log All Conversations", &log_all_conv, genbox);
	gaim_button("Strip HTML from log files", &striphtml, genbox);
#ifdef USE_APPLET
	gaim_button("Automatically Show Buddy List", &applet_buddy_auto_show, genbox);
#endif
	gaim_button("Raise windows when message recieved", &popup_windows, genbox);
        gaim_button("Send URLs as links", &send_links, genbox);
        gaim_button("Show Lag-O-Meter", &show_lagometer, genbox);
        debugbutton = gaim_button("Enable debug mode", &debug, genbox);


        idleopt = gtk_radio_button_new_with_label(NULL, "No Idle");
        gtk_box_pack_start(GTK_BOX(idlebox), idleopt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(idleopt), "clicked", GTK_SIGNAL_FUNC(set_idle), (void *)IDLE_NONE);
	gtk_widget_show(idleopt);
        if (report_idle == IDLE_NONE)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(idleopt), TRUE);

        idleopt = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(idleopt)), "GAIM Use");
        gtk_box_pack_start(GTK_BOX(idlebox), idleopt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(idleopt), "clicked", GTK_SIGNAL_FUNC(set_idle), (void *)IDLE_GAIM);
	gtk_widget_show(idleopt);
        if (report_idle == IDLE_GAIM)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(idleopt), TRUE);

/*        idleopt = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(idleopt)), "X Use");
        gtk_box_pack_start(GTK_BOX(idlebox), idleopt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(idleopt), "clicked", GTK_SIGNAL_FUNC(set_idle), (void *)IDLE_SYSTEM);
	gtk_widget_show(idleopt);
        if (report_idle == IDLE_SYSTEM)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(idleopt), TRUE);
*/
        
        gtk_widget_show(general_page);
        gtk_widget_show(genbox);
        gtk_widget_show(idlebox);
        gtk_widget_show(idleframe);


        gtk_signal_connect_object( GTK_OBJECT(debugbutton), "clicked", GTK_SIGNAL_FUNC(show_debug), NULL);

        /* Connection */
        
        connection_page = gtk_vbox_new(FALSE, 0);
        label = gtk_label_new("Connection");
        gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), connection_page, label);

	hbox = gtk_hbox_new(FALSE, 0);
	label = gtk_label_new("Host:");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        pd->aim_host_entry = gtk_entry_new();
        gtk_widget_show(pd->aim_host_entry);
	gtk_box_pack_start(GTK_BOX(hbox), pd->aim_host_entry, FALSE, FALSE, 0);

	label = gtk_label_new("Port:");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        pd->aim_port_entry = gtk_entry_new();
        gtk_widget_show(pd->aim_port_entry);
	gtk_box_pack_start(GTK_BOX(hbox), pd->aim_port_entry, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	gtk_box_pack_start(GTK_BOX(connection_page), hbox, FALSE, FALSE, 0);
	gtk_entry_set_text(GTK_ENTRY(pd->aim_host_entry), aim_host);

	g_snprintf(buffer, sizeof(buffer), "%d", aim_port);
	gtk_entry_set_text(GTK_ENTRY(pd->aim_port_entry), buffer);
        
        hbox2 = gtk_hbox_new(FALSE, 0);
        label = gtk_label_new("Host:");
        gtk_widget_show(label);
        gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 5);
        pd->login_host_entry = gtk_entry_new();
        gtk_widget_show(pd->login_host_entry);
        gtk_box_pack_start(GTK_BOX(hbox2), pd->login_host_entry, FALSE, FALSE, 0);

        label = gtk_label_new("Port:");
        gtk_widget_show(label);
        gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 5);
        pd->login_port_entry = gtk_entry_new();
        gtk_widget_show(pd->login_port_entry);
        gtk_box_pack_start(GTK_BOX(hbox2), pd->login_port_entry, FALSE, FALSE, 0);
        gtk_widget_show(hbox2);

        gtk_box_pack_start(GTK_BOX(connection_page), hbox2, FALSE, FALSE, 0);
        gtk_entry_set_text(GTK_ENTRY(pd->login_host_entry), login_host);

        g_snprintf(buffer, sizeof(buffer), "%d", login_port);
        gtk_entry_set_text(GTK_ENTRY(pd->login_port_entry), buffer);

        connectopt = gtk_radio_button_new_with_label(NULL, "No Proxy");
        gtk_box_pack_start(GTK_BOX(connection_page), connectopt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(connectopt), "clicked", GTK_SIGNAL_FUNC(set_connect), (void *)PROXY_NONE);
	gtk_widget_show(connectopt);
        if (proxy_type == PROXY_NONE)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(connectopt), TRUE);

        connectopt = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(connectopt)), "HTTP Proxy");
        gtk_box_pack_start(GTK_BOX(connection_page), connectopt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(connectopt), "clicked", GTK_SIGNAL_FUNC(set_connect), (void *)PROXY_HTTP);
	gtk_widget_show(connectopt);
	if (proxy_type == PROXY_HTTP)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(connectopt), TRUE);


	hbox = gtk_hbox_new(FALSE, 0);
	label = gtk_label_new("Host:");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        pd->http_proxy_host_entry = gtk_entry_new();
        gtk_widget_show(pd->http_proxy_host_entry);
	gtk_box_pack_start(GTK_BOX(hbox), pd->http_proxy_host_entry, FALSE, FALSE, 0);

	label = gtk_label_new("Port:");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
        pd->http_proxy_port_entry = gtk_entry_new();
        gtk_widget_show(pd->http_proxy_port_entry);
	gtk_box_pack_start(GTK_BOX(hbox), pd->http_proxy_port_entry, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	gtk_box_pack_start(GTK_BOX(connection_page), hbox, FALSE, FALSE, 0);
	gtk_entry_set_text(GTK_ENTRY(pd->http_proxy_host_entry), proxy_host);

	g_snprintf(buffer, sizeof(buffer), "%d", proxy_port);
	gtk_entry_set_text(GTK_ENTRY(pd->http_proxy_port_entry), buffer);


	gtk_widget_show(connection_page);


	if (proxy_type == PROXY_HTTP) {
                if (pd->http_proxy_host_entry)
                        gtk_widget_set_sensitive(pd->http_proxy_host_entry, TRUE);
		if (pd->http_proxy_port_entry)
			gtk_widget_set_sensitive(pd->http_proxy_port_entry, TRUE);

	} else {
                if (pd->http_proxy_host_entry)
                        gtk_widget_set_sensitive(pd->http_proxy_host_entry, FALSE);
		if (pd->http_proxy_port_entry)
			gtk_widget_set_sensitive(pd->http_proxy_port_entry, FALSE);

	}

	

	gtk_signal_connect(GTK_OBJECT(pd->aim_host_entry), "focus_out_event", GTK_SIGNAL_FUNC(connection_key_pressed), NULL);
        gtk_signal_connect(GTK_OBJECT(pd->aim_port_entry), "focus_out_event", GTK_SIGNAL_FUNC(connection_key_pressed), NULL);
	gtk_signal_connect(GTK_OBJECT(pd->login_host_entry), "focus_out_event", GTK_SIGNAL_FUNC(connection_key_pressed), NULL);
	gtk_signal_connect(GTK_OBJECT(pd->login_port_entry), "focus_out_event", GTK_SIGNAL_FUNC(connection_key_pressed), NULL);
	gtk_signal_connect(GTK_OBJECT(pd->http_proxy_host_entry), "focus_out_event", GTK_SIGNAL_FUNC(connection_key_pressed), NULL);
        gtk_signal_connect(GTK_OBJECT(pd->http_proxy_port_entry), "focus_out_event", GTK_SIGNAL_FUNC(connection_key_pressed), NULL);

	
	/* Away */
	
        a = awaymessage;
        pd->cur_message = NULL;
        pd->nwbutton = NULL;
        pd->browser_entry = NULL;
        
	away_page = gtk_vbox_new(FALSE, 0);
	away_topbox = gtk_hbox_new(FALSE, 0);
	away_botbox = gtk_hbox_new(FALSE, 0);

	label = gtk_label_new("Away");
	gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), away_page, label);
	gtk_widget_show(away_page);

	sw2 = gtk_scrolled_window_new(NULL, NULL);
    	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw2),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_widget_show(sw2);

	pd->away_list = gtk_list_new();
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw2), pd->away_list);
	gtk_box_pack_start(GTK_BOX(away_topbox), sw2, TRUE, TRUE, 0);

	sw = gtk_scrolled_window_new(NULL, NULL);
    	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_widget_show(sw);
    
	pd->away_text = gtk_text_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(sw), pd->away_text);
	gtk_box_pack_start(GTK_BOX(away_topbox), sw, TRUE, TRUE, 0);
	gtk_text_set_word_wrap(GTK_TEXT(pd->away_text), TRUE);
	gtk_text_set_editable(GTK_TEXT(pd->away_text), TRUE );

	add_away = gtk_button_new_with_label("Create Message");
	gtk_signal_connect(GTK_OBJECT(add_away), "clicked", GTK_SIGNAL_FUNC(create_away_mess), NULL);
	gtk_box_pack_start(GTK_BOX(away_botbox), add_away, TRUE, FALSE, 5);

	remove_away = gtk_button_new_with_label("Remove Message");
	gtk_signal_connect(GTK_OBJECT(remove_away), "clicked", GTK_SIGNAL_FUNC(remove_away_message), NULL);
	gtk_box_pack_start(GTK_BOX(away_botbox), remove_away, TRUE, FALSE, 5);

	gtk_box_pack_start(GTK_BOX(away_page), away_topbox, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(away_page), away_botbox, FALSE, FALSE, 0);

	gtk_widget_show(add_away);
	gtk_widget_show(remove_away);
	gtk_widget_show(pd->away_list);
	gtk_widget_show(pd->away_text);
	gtk_widget_show(away_topbox);
	gtk_widget_show(away_botbox);
    
	if (awy != NULL) {
		a = (struct away_message *)awy->data;
		g_snprintf(buffer, sizeof(buffer), "%s", a->message);
		gtk_text_insert(GTK_TEXT(pd->away_text), NULL, NULL, NULL, buffer, -1);
	}

        while(awy) {
		a = (struct away_message *)awy->data;
		label = gtk_label_new(a->name);
		list_item = gtk_list_item_new();
		gtk_container_add(GTK_CONTAINER(list_item), label);
		gtk_signal_connect(GTK_OBJECT(list_item), "select", GTK_SIGNAL_FUNC(away_list_clicked), a);
		gtk_signal_connect(GTK_OBJECT(list_item), "deselect", GTK_SIGNAL_FUNC(away_list_unclicked), a);
		gtk_object_set_user_data(GTK_OBJECT(list_item), a);
               
		gtk_widget_show(label);
		gtk_container_add(GTK_CONTAINER(pd->away_list), list_item);
		gtk_widget_show(list_item);
	
		awy = awy->next;

	}
       
	/* Sound */
	sound_page = gtk_vbox_new(FALSE, 0);
	label = gtk_label_new("Sounds");
	gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), sound_page, label);
        gaim_button("Enable buddy logon/logoff sounds", &sounds, sound_page);
        gaim_button("Enable send/receive message sounds", &extrasounds, sound_page);
        gtk_widget_show(sound_page);


        /* Browser */
        browser_page = gtk_vbox_new(FALSE, 0);

        label = gtk_label_new("Browser");
        gtk_widget_show(label);
        

        gtk_notebook_append_page(GTK_NOTEBOOK(notebook), browser_page, label);
        browseropt = gtk_radio_button_new_with_label(NULL, "Netscape");
        gtk_box_pack_start(GTK_BOX(browser_page), browseropt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(browseropt), "clicked", GTK_SIGNAL_FUNC(set_browser), (void *)BROWSER_NETSCAPE);
	gtk_widget_show(browseropt);
        if (web_browser == BROWSER_NETSCAPE)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(browseropt), TRUE);

        browseropt = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(browseropt)), "KFM (The KDE browser)");
        gtk_box_pack_start(GTK_BOX(browser_page), browseropt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(browseropt), "clicked", GTK_SIGNAL_FUNC(set_browser), (void *)BROWSER_KFM);
	gtk_widget_show(browseropt);
	if (web_browser == BROWSER_KFM)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(browseropt), TRUE);


        browseropt = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(browseropt)), "Internal HTML widget (Quite likely a bad idea!)");
        gtk_box_pack_start(GTK_BOX(browser_page), browseropt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(browseropt), "clicked", GTK_SIGNAL_FUNC(set_browser), (void *)BROWSER_INTERNAL);
	gtk_widget_show(browseropt);
	if (web_browser == BROWSER_INTERNAL)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(browseropt), TRUE);

        
        browseropt = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(browseropt)), "Manual");
        gtk_box_pack_start(GTK_BOX(browser_page), browseropt, FALSE, FALSE, 0);
        gtk_signal_connect(GTK_OBJECT(browseropt), "clicked", GTK_SIGNAL_FUNC(set_browser), (void *)BROWSER_MANUAL);
        gtk_widget_show(browseropt);
	if (web_browser == BROWSER_MANUAL)
                gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(browseropt), TRUE);


        pd->browser_entry = gtk_entry_new();
        gtk_widget_show(pd->browser_entry);

        gtk_box_pack_start(GTK_BOX(browser_page), pd->browser_entry, FALSE, FALSE, 0);
        gtk_entry_set_text(GTK_ENTRY(pd->browser_entry), web_command);

	pd->nwbutton = gaim_button("Pop up new window by default", &browser_popup, browser_page);
	gtk_widget_show(browser_page);

        gtk_signal_connect(GTK_OBJECT(pd->browser_entry), "focus_out_event", GTK_SIGNAL_FUNC(manualentry_key_pressed), NULL);

        

        if (web_browser != BROWSER_MANUAL) {
                gtk_widget_set_sensitive(pd->browser_entry, FALSE);
        } else {
                gtk_widget_set_sensitive(pd->browser_entry, TRUE);
        }
        
        if (web_browser != BROWSER_NETSCAPE) {
                gtk_widget_set_sensitive(pd->nwbutton, FALSE);
        } else {
                gtk_widget_set_sensitive(pd->nwbutton, TRUE);
        }
        



	/* Appearance */
	appearance_page = gtk_vbox_new(FALSE, 0);
        label = gtk_label_new("Appearance");
        gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), appearance_page, label);
	gaim_button("Show time on messages", &show_time, appearance_page);
	gaim_button("Show numbers in groups", &show_grp_nums, appearance_page);
	gaim_button("Show buddy-type pixmaps", &showpix, appearance_page);
	gaim_button("Show idle times", &showidle, appearance_page);
	gaim_button("Show button pixmaps", &button_pix, appearance_page);
#if 0
	gaim_button("Show smilies in conversation", &show_smilies, appearance_page);
#endif
        gaim_button("Ignore incoming colours", &ignore_colours, appearance_page);
#if 0
        gaim_button("Transparent text window (experimental)", &transparent, appearance_page);
#endif
        gaim_button("Show logon/logoffs in conversation windows", &show_logon, appearance_page);
	gtk_widget_show(appearance_page);
	


	/* Buddy Chats */
	chat_page = gtk_vbox_new(FALSE, 0);
	label = gtk_label_new("Buddy Chats");

	gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), chat_page, label);
	
	do_chat_page(chat_page);
	gtk_widget_show(chat_page);
	

	

	bbox = gtk_hbox_new(FALSE, 5);
	close = gtk_button_new_with_label("Close");
	
	/* Pack the button(s) in the button box */
	gtk_box_pack_end(GTK_BOX(bbox), close, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox),bbox, FALSE, FALSE, 5);

	gtk_widget_show(notebook);
        gtk_widget_show(close);

	gtk_widget_show(bbox);
	gtk_widget_show(vbox);

	gtk_signal_connect(GTK_OBJECT(close), "clicked", GTK_SIGNAL_FUNC(handle_delete), NULL);
        gtk_signal_connect(GTK_OBJECT(pd->window),"delete_event", GTK_SIGNAL_FUNC(handle_delete), NULL);
        aol_icon(pd->window->window);
}

void show_prefs()
{
	if (!pd || !pd->window)
		build_prefs();
	gtk_widget_show(pd->window);
}
void add_chat(GtkWidget *w, struct chat_page *cp)
{
	GList *sel = GTK_LIST(cp->list1)->selection;
	struct chat_room *cr, *cr2;
	GList *crs = chat_rooms;
        GtkWidget *item;

	if (sel) {
		cr = (struct chat_room *)gtk_object_get_user_data(GTK_OBJECT(sel->data));
	} else
		return;

	while(crs) {
		cr2 = (struct chat_room *)crs->data;
		if (!strcasecmp(cr->name, cr2->name))
                        return;
                crs = crs->next;
	}
	item = gtk_list_item_new_with_label(cr->name);
	cr2 = g_new0(struct chat_room, 1);
	strcpy(cr2->name, cr->name);
	cr2->exchange = cr->exchange;
	gtk_object_set_user_data(GTK_OBJECT(item), cr2);
	gtk_widget_show(item);
	sel = g_list_append(NULL, item);
	gtk_list_append_items(GTK_LIST(cp->list2), sel);
	chat_rooms = g_list_append(chat_rooms, cr2);

	setup_buddy_chats();
	save_prefs();
	

}

void remove_chat(GtkWidget *w, struct chat_page *cp)
{
	GList *sel = GTK_LIST(cp->list2)->selection;
	struct chat_room *cr;
	GList *crs;
	GtkWidget *item;
	
	if (sel) {
		item = (GtkWidget *)sel->data;
		cr = (struct chat_room *)gtk_object_get_user_data(GTK_OBJECT(item));
	} else
		return;

	chat_rooms = g_list_remove(chat_rooms, cr);


	gtk_list_clear_items(GTK_LIST(cp->list2), 0, -1);

	if (g_list_length(chat_rooms) == 0)
		chat_rooms = NULL;

	crs = chat_rooms;

	while(crs) {
		cr = (struct chat_room *)crs->data;
		item = gtk_list_item_new_with_label(cr->name);
		gtk_object_set_user_data(GTK_OBJECT(item), cr);
		gtk_widget_show(item);
		gtk_list_append_items(GTK_LIST(cp->list2), g_list_append(NULL, item));

		
		crs = crs->next;
	}

	setup_buddy_chats();
        save_prefs();
}

void refresh_list(GtkWidget *w, struct chat_page *cp)
{
	char *text = grab_url("http://www.aol.com/community/chat/allchats.html");
	char *c;
	int len = strlen(text);
	GtkWidget *item;
	GList *items = GTK_LIST(cp->list1)->children;
	struct chat_room *cr;
	c = text;

	while(items) {
		g_free(gtk_object_get_user_data(GTK_OBJECT(items->data)));
		items = items->next;
	}

	items = NULL;

        gtk_list_clear_items(GTK_LIST(cp->list1), 0, -1);
	
	item = gtk_list_item_new_with_label("Gaim Chat");
	cr = g_new0(struct chat_room, 1);
	strcpy(cr->name, "Gaim Chat");
	cr->exchange = 4;
	gtk_object_set_user_data(GTK_OBJECT(item), cr);
	gtk_widget_show(item);

        items = g_list_append(NULL, item);
	
	while(c) {
		if (c - text > len - 30)
			break; /* assume no chat rooms 30 from end, padding */
		if (!strncasecmp(AOL_SRCHSTR, c, strlen(AOL_SRCHSTR))) {
			char *t;
			int len=0;
			int exchange;
			char *name = NULL;
			
			c += strlen(AOL_SRCHSTR);
                        t = c;
			while(t) {
				len++;
				name = g_realloc(name, len);
				if (*t == '+')
					name[len - 1] = ' ';
				else if (*t == '&') {
					name[len - 1] = 0;
					sscanf(t, "&Exchange=%d", &exchange);
					c = t + strlen("&Exchange=x");
					break;
				} else
					name[len - 1] = *t;
				t++;
			}
			cr = g_new0(struct chat_room, 1);
			strcpy(cr->name, name);
			cr->exchange = exchange;
			item = gtk_list_item_new_with_label(name);
			gtk_widget_show(item);
			items = g_list_append(items, item);
			gtk_object_set_user_data(GTK_OBJECT(item), cr);
                        g_free(name);
		}
		c++;
	}
	gtk_list_append_items(GTK_LIST(cp->list1), items);
	g_free(text);
}



void do_chat_page(GtkWidget *page)
{
	GtkWidget *table;
	GtkWidget *rem_button, *add_button, *ref_button;
	GtkWidget *list1, *list2;
	GtkWidget *label;
	GtkWidget *sw1, *sw2;
	GtkWidget *item;
	struct chat_page *cp = g_new0(struct chat_page, 1);
	GList *crs = chat_rooms;
	GList *items = NULL;
	struct chat_room *cr;

	table = gtk_table_new(4, 2, FALSE);
	gtk_widget_show(table);
	

	gtk_box_pack_start(GTK_BOX(page), table, TRUE, TRUE, 0);


	list1 = gtk_list_new();
	list2 = gtk_list_new();
	sw1 = gtk_scrolled_window_new(NULL, NULL);
	sw2 = gtk_scrolled_window_new(NULL, NULL);
	ref_button = gtk_button_new_with_label("Refresh");
	add_button = gtk_button_new_with_label("Add");
	rem_button = gtk_button_new_with_label("Remove");
	gtk_widget_show(list1);
	gtk_widget_show(sw1);
	gtk_widget_show(list2);
	gtk_widget_show(sw2);
	gtk_widget_show(ref_button);
	gtk_widget_show(add_button);
	gtk_widget_show(rem_button);

	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw1), list1);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw2), list2);

	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw1),
				       GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw2),
				       GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);

	cp->list1 = list1;
	cp->list2 = list2;

	gtk_signal_connect(GTK_OBJECT(ref_button), "clicked",
			   GTK_SIGNAL_FUNC(refresh_list), cp);
	gtk_signal_connect(GTK_OBJECT(rem_button), "clicked",
			   GTK_SIGNAL_FUNC(remove_chat), cp);
	gtk_signal_connect(GTK_OBJECT(add_button), "clicked",
			   GTK_SIGNAL_FUNC(add_chat), cp);


	
	label = gtk_label_new("List of available chats");
	gtk_widget_show(label);

	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
			 GTK_SHRINK, GTK_SHRINK, 0, 0);
	gtk_table_attach(GTK_TABLE(table), ref_button, 0, 1, 1, 2,
			 GTK_SHRINK, GTK_SHRINK, 0, 0);
	gtk_table_attach(GTK_TABLE(table), sw1, 0, 1, 2, 3,
			 GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			 5, 5);
	gtk_table_attach(GTK_TABLE(table), add_button, 0, 1, 3, 4,
			 GTK_SHRINK, GTK_SHRINK, 0, 0);

	
	label = gtk_label_new("List of subscribed chats");
	gtk_widget_show(label);
	
	gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1,
			 GTK_SHRINK, GTK_SHRINK, 0, 0);
	gtk_table_attach(GTK_TABLE(table), sw2, 1, 2, 2, 3,
			 GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			 5, 5);
	gtk_table_attach(GTK_TABLE(table), rem_button, 1, 2, 3, 4,
			 GTK_SHRINK, GTK_SHRINK, 0, 0);


	item = gtk_list_item_new_with_label("Gaim Chat");
	cr = g_new0(struct chat_room, 1);
	strcpy(cr->name, "Gaim Chat");
	cr->exchange = 4;
	gtk_object_set_user_data(GTK_OBJECT(item), cr);
	gtk_widget_show(item);
        gtk_list_append_items(GTK_LIST(list1), g_list_append(NULL, item));

	
	while(crs) {
		cr = (struct chat_room *)crs->data;
		item = gtk_list_item_new_with_label(cr->name);
		gtk_object_set_user_data(GTK_OBJECT(item), cr);
		gtk_widget_show(item);
		items = g_list_append(items, item);

		crs = crs->next;
	}

	gtk_list_append_items(GTK_LIST(list2), items);
}


	


