/*
 * structs.h
 * Thomas Nemeth, le 18.09.1999
 *
 * Types pour les structures de donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 * Types for data structures in gAcc, personal bank accounts manager
 * for GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include <config.h>
#include "defines.h"

/* Dclaration pour ope_elt                                           */
/* Declaration for ope_elt                                            */
struct ope_elt;

/* Structure contenant les oprations de dbit et de crdit           */
/* Structure containing credit & debit operations                     */
typedef struct _t_operation {
    unsigned int id;     /* Operation identifier                      */
    unsigned int parent; /* Parent identifier                         */
    char  *num;          /* Number of the cheque                      */
    char  *object;       /* Operation motive                          */
    char  *date;         /* Date                                      */
    float  amount;       /* Operation's amount                        */
    int    medium;       /* Medium : Cred.Card (0), Check (1),        */
                         /* Standing Order (2), Withdrawal (3),       */
                         /* Transfer (4)                              */
    int    type;         /* Debit (0) or credit (1)                   */
    int    pointed;      /* Pointed ? Y/N                             */
    int    cancelled;    /* Operation canceled ? Y/N                  */
    int    category;     /* Operation's category                      */
    int    tiers;        /* From or To which an operation is done     */
    int    trs_opeid;    /* Operation Id in the 3rd party             */
    struct ope_elt *splits; /* Splits support                         */
} OPERATION;

/* lement de liste contenant les oprations                          */
/* List element for operations                                        */
typedef struct ope_elt {
    OPERATION      *operation;
    struct ope_elt *prev;
    struct ope_elt *next;
} OPE_ELT;

/* Structure contenant la dfinition et les informations d'un compte  */
/* Structure containing accounts definition & informations            */
typedef struct _t_account {
    char    *name;          /* Account name                           */
    char    *num;           /* Account number                         */
    char    *bank;          /* Bank where this account is             */
    char    *date;          /* Creation date                          */
    int      euro;          /* Is it in Euro ? 0 : no, 1 : yes        */
    float    amount;        /* Openning balance                       */
    OPE_ELT *ope_list_head; /* Operations' list on this account       */
} ACCOUNT;

/* lement de liste contenant les comptes                             */
/* List element for accounts                                          */
typedef struct acc_elt {
    ACCOUNT        *account;
    struct acc_elt *next;
} ACC_ELT;

/* Structure contenant les informations d'une catgorie               */
/* Structure containing informations about a catgory                 */
typedef struct _t_category {
    char *name; /* Category's name                                    */
    int   num;  /* Number of the category for use with OPERATION      */
    int   type; /* Category's type : credit (0) / debit (1)           */
} CATEGORY;

/* lement de liste contenant les diffrentes catgories              */
/* List element for categories                                        */
typedef struct cat_elt {
    CATEGORY       *category;
    struct cat_elt *next;
} CAT_ELT;

/* Structure contenant les informations d'un tiers                    */
/* Structure containing informations about a 3rd party (tiers)        */
typedef struct _t_tiers {
    char *name;       /* Tiers' name                                  */
    int   num;        /* Number of the tiers for use with OPERATION   */
    int   is_in_file; /* = VRAI if the tiers is in the wallet file    */
} TIERS;

/* lement de liste contenant les diffrents tiers                    */
/* List element for tiers                                             */
typedef struct trs_elt {
    TIERS          *tiers;
    struct trs_elt *next;
} TRS_ELT;

/* lement de pile pour l'historique de l'aide                        */
/* Stack element for help history                                     */
typedef struct help {
    char        *index;
    struct help *next;
} HELP;

/* Structure de transfert de donnes entre les fonctions              */
/* Transfer data structure                                            */
typedef struct _t_list {
    void           *element;
    struct _t_list *next;
} MY_LIST;

/* Structure de donne pour les labels des graphiques                 */
/* Data structure for graphics labels                                 */
typedef struct _t_glabel {
    int x;
    int month;
} G_LABEL;

/* Structure contenant la configuration                               */
/* Structure containing configuration informations                    */
typedef struct _t_config {
    int      AccDataModified; /* = 1 if modif. in acc. has happened   */
    int      CatDataModified; /* = 1 if modif. in cat. has happened   */
    int      TrsDataModified; /* = 1 if modif. in trs. has happened   */
    int      ConfigModified ; /* = 1 if the config has been modified  */
    int      CurrencyPos;     /* 0 = before amount, 1 = after amount  */
    int      LastOpenedAcc;   /* Last opened acc. for fast re-opening */
    int      UseLastAcc;      /* 0 = don't re-open last account       */
    int      AutoSave;        /* 1 = Auto save the config & accounts  */
    int      TearOff;         /* 1 = Have tear-off menus              */
    int      DateFormat;      /* 1 = dd.mm.yyyy, 2 = mm.dd.yyyy       */
    char     DateSeparator;   /* "/", "." or whatever you want        */
    char     DecimalPoint;    /* ",", "." or whatever you want        */
    float    EuroValue;       /* 1 Euro == #.###### ?                 */
    int      Advanced;        /* > 0 advanced functionnalities        */
    char    *Currency;        /* Currency used                        */
    ACC_ELT *acc_list_head;   /* List of accounts & operations        */
    CAT_ELT *cat_list_head;   /* List of categories for operations    */
    TRS_ELT *trs_list_head;   /* List of tiers for operations         */
    HELP    *help_history;    /* Help history stack                   */
    char    *accfilename;     /* Filename of a set of accounts        */
    char    *catfilename;     /* Filename of the categories def's     */
    char    *trsfilename;     /* Filename of the tiers' def's         */
    char    *help_path;       /* Path to help file                    */
    char    *cat_sys_wide;    /* System wide categories def. file     */
    char    *ps_prn_cmd;      /* PS print command                     */
    char    *ps_prn_opt;      /* PS print options                     */
    char    *asc_prn_cmd;     /* ASCII print command                  */
    char    *asc_prn_opt;     /* ASCII print options                  */
    char    *graph_d0;        /* Start date for graphics              */
    char    *graph_d1;        /* End date for graphics                */
    char    *graph_fnt;       /* Font for graphics                    */
    int      graph_grd;       /* Gird for graphics                    */
} CONFIG;


/* Variables globales                                                 */
/* Global variables                                                   */
CONFIG config;


#endif
