/*
 * usefull.h
 * Thomas Nemeth, le 11.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _USEFULL_H_
#define _USEFULL_H_

#include "structs.h"


/* Arrte le programme en cas d'erreur grave                          */
/* Stop the program in case of fatal error                            */
void fatal_error (char *message);

/* UNUSED FUNCTIONS... */
/* Affiche les informations suivant le niveau de debogage             */
/* Print informations depending the debug level                       */
/*
void my_printf (int affichage, char *format, ...);
*/

/* Alloue de la mmoire avec vrification de l'allocation             */
/* Memory allocation with verification                                */
/* REPLACED BY A MACRO IN defines.h !
void *my_alloc (size_t size);
*/

/* = 1 si (new_date > lst_date)                                       */
/* = 1 if (new_date > lst_date)                                       */
int date_is_superior (char *new_date, char *lst_date);

/* = 1 si (new_date == lst_date)                                      */
/* = 1 if (new_date == lst_date)                                      */
int date_is_equal (char *new_date, char *lst_date);

/* = 1 si (new_num < lst_num)                                         */
/* = 1 if (new_num < lst_num)                                         */
int num_is_inferior (char *new_num, char *lst_num);

/* = TRUE si la boucle d'insertion d'opration doit s'arrter         */
/* = TRUE if the operation insertion loop must stop                   */
int stop_loop (OPERATION *new_ope, OPERATION *lst_ope);

/* Calcule le solde d'un compte ou d'une liste d'oprations           */
/* Compute the balance of an account or an operations list            */
float compute_solde (float initial_amount, OPE_ELT *list_head);

/* Calcule le solde d'un compte ou d'une liste d'oprations pointes  */
/* Compute the balance of an account or a pointed operations list     */
float compute_pointed_solde (float initial_amount, OPE_ELT *list_head);

/* Renvoie le nom du fichier par dfaut (ou celui ouvert)             */
/* Return the default filename (or the opened one)                    */
char *default_filename (int save_as);

/* Renvoie VRAI si on est en mode DEBUG_GACC                          */
/* Return VRAI if the DEBUG_GACC mode is on                           */
int Debug ();

/* Traitement des arguments de la ligne de commande                   */
/* Command line parsing                                               */
void Usage ();
char *traite_argv (int argc, char* argv[]);

/* Renvoie 1 si l'anne est bissextile, 0 sinon                       */
/* Return 1 if the year is leap, 0 otherwise                          */
int bissextile (int year);

/* Renvoie la longueur en jours d'une anne                           */
/* Return the length in days of a year                                */
int year_size (int year);

/* Renvoie la longueur en jours d'un mois  partir d'un jour          */
/* particulier dans l'anne spcifie                                 */
/* Return the length in days of a month from a particular day in a    */
/* specifyed year                                                     */
int month_size (int year, int month, int day);

/* Renvoie le nombre de jours entre 2 dates au format AAAAMMJJ        */
/* Return the number of days between 2 dates in the YYYYMMDD format   */
int diffdays (const char *date1, const char *date0);

/* Renvoie le nombre de graduations horizontales (graphes linaires)  */
/* Return the horizontal graduatings number (linear graphics)         */
int get_hs_nb (const char *first, const char *last);

/* Renvoie les graduations horizontales (graphes linaires)           */
/* Return the horizontal graduatings (linear graphics)                */
void get_hscale (G_LABEL *pts, const char *first, const char *last);

/* Renvoie l'chelle des graduations verticales (graphes linaires)   */
/* Return the scale of vertical graduatings (linear graphics)         */
int get_vscale (int max, int min);


#endif
