/*
 * locale_formats.c
 * Thomas Nemeth, le 10.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <time.h>
#include "locale_formats.h"
#include "structs.h"
#include "usefull.h"


char *format_date (const char *date) {
    char *ret_date;

    MY_ALLOC (ret_date, 11, char);
    if (date != NULL) {
        if (config.DateFormat == FRENCH_DATE)
            sprintf (ret_date, "%c%c%c%c%c%c%c%c%c%c",
                     date[6], date[7],
                     config.DateSeparator,
                     date[4], date[5],
                     config.DateSeparator,
                     date[0], date[1], date[2], date[3]);
        else if (config.DateFormat == ENGLISH_DATE)
            sprintf (ret_date, "%c%c%c%c%c%c%c%c%c%c",
                     date[4], date[5],
                     config.DateSeparator,
                     date[6], date[7],
                     config.DateSeparator,
                     date[0], date[1], date[2], date[3]);
    } else sprintf (ret_date, _("NO DATE !") );

    return ret_date;
}

char *format_short_date (const char *date) {
    char *ret_date;

    MY_ALLOC (ret_date, 11, char);
    if (date != NULL) {
        if (config.DateFormat == FRENCH_DATE)
            sprintf (ret_date, "%c%c%c%c%c%c%c%c",
                     date[6], date[7],
                     config.DateSeparator,
                     date[4], date[5],
                     config.DateSeparator,
                     date[2], date[3]);
        else if (config.DateFormat == ENGLISH_DATE)
            sprintf (ret_date, "%c%c%c%c%c%c%c%c",
                     date[4], date[5],
                     config.DateSeparator,
                     date[6], date[7],
                     config.DateSeparator,
                     date[2], date[3]);
    } else sprintf (ret_date, _("NO DATE !") );

    return ret_date;
}

char *format_very_short_date (const char *date) {
    char *ret_date;

    MY_ALLOC (ret_date, 11, char);
    if (date != NULL) {
        if (config.DateFormat == FRENCH_DATE)
            sprintf (ret_date, "%c%c%c%c%c",
                     date[6], date[7],
                     config.DateSeparator,
                     date[4], date[5]);
        else if (config.DateFormat == ENGLISH_DATE)
            sprintf (ret_date, "%c%c%c%c%c",
                     date[4], date[5],
                     config.DateSeparator,
                     date[6], date[7]);
    } else sprintf (ret_date, _("NO DATE !") );

    return ret_date;
}

char *unformat_date (const char *date) {
    char *ret_date = NULL;
    char *day      = NULL;
    char *month    = NULL;
    char *year     = NULL;
    char *tmpstr   = NULL;
    int   i, j = 0, k = 0;

    if ( (date != NULL) && (strcmp (date, "") != 0) ){
        MY_ALLOC (ret_date, 11, char);
        MY_ALLOC (day,       3, char);
        MY_ALLOC (month,     3, char);
        MY_ALLOC (year,      5, char);
        MY_ALLOC (tmpstr,    6, char);
        #ifdef DEBUG_GACC
            printf ("Format de date de la config : %s (%d)\n",
                    config.DateFormat == FRENCH_DATE ? "FRANAISE" : "ANGLAISE",
                    config.DateFormat);
        #endif
        for (i = 0 ; i < strlen (date) + 1 ; i++ ) {
            if ( (date[i] != config.DateSeparator) && (date[i] != 0) ){
                tmpstr[j] = date[i];
                j++;
            } else {
                tmpstr[j] = 0;
                j         = 0;
                #ifdef DEBUG_GACC
                    printf ("Niveau %s -- ",
                            k == 0 ? "JOUR " :
                            k == 1 ? "MOIS " : "ANNE");
                    printf ("lement reconnu : %s\n", tmpstr);
                #endif
                if ( (strlen (tmpstr) < 2) && (k != 2) ) {
                    tmpstr[2] = 0;
                    tmpstr[1] = tmpstr[0];
                    tmpstr[0] = '0';
                } else if ( (strlen (tmpstr) < 4) && ( k== 2) ) {
                    tmpstr[4] = 0;
                    tmpstr[3] = tmpstr[1];
                    tmpstr[2] = tmpstr[0];
                    tmpstr[1] = '0';
                    tmpstr[0] = '2';
                }
                switch (k) {
                    case  0 : if (config.DateFormat == FRENCH_DATE)
                                strcpy (day, tmpstr);
                              else strcpy (month, tmpstr);
                              break;
                    case  1 : if (config.DateFormat == FRENCH_DATE)
                                strcpy (month, tmpstr);
                              else strcpy (day, tmpstr);
                              break;
                    case  2 : strcpy (year, tmpstr);
                              break;
                    default : MY_STOP;
                }
                k++;
            }
        }
        /*
        sprintf (ret_date, "%c%c%c%c%c%c%c%c",
                 date[6], date[7], date[8], date[9],
                 date[0], date[1],
                 date[3], date[4]);
        */
        sprintf (ret_date, "%s%s%s", year, month, day);
        #ifdef DEBUG_GACC
            printf ("Jour : %s, Mois : %s, Anne : %s\n", day, month, year);
            printf ("Soit : %s\n", ret_date);
        #endif
        free (tmpstr);
        free (day);
        free (month);
        free (year);
    }

    return ret_date;
}

char *format_today () {
    time_t     now;
    struct tm *today;
    char      *ret_date;
    char      *day   = NULL;
    char      *month = NULL;
    char      *year  = NULL;

    time (&now);
    today    = localtime (&now);
    MY_ALLOC (ret_date, 11, char);
    MY_ALLOC (day,       3, char);
    MY_ALLOC (month,     3, char);
    MY_ALLOC (year,      5, char);
    strftime (day,   3, "%d", today);
    strftime (month, 3, "%m", today);
    strftime (year,  5, "%Y", today);
    if (config.DateFormat == FRENCH_DATE)
        sprintf (ret_date, "%s%c%s%c%s",
                 day,
                 config.DateSeparator,
                 month,
                 config.DateSeparator,
                 year);
    else if (config.DateFormat == ENGLISH_DATE)
        sprintf (ret_date, "%s%c%s%c%s",
                 month,
                 config.DateSeparator,
                 day,
                 config.DateSeparator,
                 year);

    free (day);
    free (month);
    free (year);

    return ret_date;
}

char *unformat_today () {
    time_t     now;
    struct tm *today;
    char      *ret_date;
    char      *day   = NULL;
    char      *month = NULL;
    char      *year  = NULL;

    time (&now);
    today    = localtime (&now);
    MY_ALLOC (ret_date, 11, char);
    MY_ALLOC (day,       3, char);
    MY_ALLOC (month,     3, char);
    MY_ALLOC (year,      5, char);
    strftime (day,   3, "%d", today);
    strftime (month, 3, "%m", today);
    strftime (year,  5, "%Y", today);
    sprintf (ret_date, "%s%s%s",
                 year,
                 month,
                 day);

    free (day);
    free (month);
    free (year);

    return ret_date;
}

char *format_amount (float amount) {
    char *ret_amount;

    MY_ALLOC (ret_amount, 18, char);
    if (config.CurrencyPos == CURRENCY_BEFORE)
        sprintf (ret_amount, "%s %1.2f",
                 config.Currency,
                 amount);
    else if (config.CurrencyPos == CURRENCY_AFTER)
        sprintf (ret_amount, "%1.2f %s",
                 amount,
                 config.Currency);

    return ret_amount;
}

char *format_euro_value (float amount) {
    char *ret_amount;

    MY_ALLOC (ret_amount, 18, char);
    if (config.CurrencyPos == CURRENCY_BEFORE)
        sprintf (ret_amount, "%s %1.5f",
                 config.Currency,
                 amount);
    else if (config.CurrencyPos == CURRENCY_AFTER)
        sprintf (ret_amount, "%1.5f %s",
                 amount,
                 config.Currency);

    return ret_amount;
}

char *get_day (const char *date) {
    char *d = NULL;

    if (date != NULL) {
        MY_ALLOC (d, 3, char);
        d [0] = date [6];
        d [1] = date [7];
        d [2] = 0;
    }
    return d;
}

char *get_month_ni (int month) {
    char *MONTHS[12] = { N_("jan"), N_("feb"), N_("mar"), N_("apr"),
                         N_("may"), N_("jun"), N_("jul"), N_("aug"),
                         N_("sep"), N_("oct"), N_("nov"), N_("dec") };
    char *text = NULL;
	if(month>=0 && month<=11) {
		MY_ALLOC (text, 4, char);
		strcpy(text,MONTHS [month]);
	} else {
		printf("erreur get_month_ni month=%d\n",month);
                text="";
	}
    return text;
}

char *get_month_n (const char *date) {
    char  tm [3];
    int   m = 0;
    char *text = NULL;

    if (date != NULL) {
        tm [0] = date [4];
        tm [1] = date [5];
        tm [2] = 0;
        m = atoi (tm);
        text = get_month_ni (m - 1);
    }
    return text;
}

char *get_month (const char *date) {
    char *m = NULL;

    if (date != NULL) {
        MY_ALLOC (m, 3, char);
        m [0] = date [4];
        m [1] = date [5];
        m [2] = 0;
    }
    return m;
}

char *get_year (const char *date) {
    char *y = NULL;

    if (date != NULL) {
        MY_ALLOC (y, 5, char);
        y [0] = date [0];
        y [1] = date [1];
        y [2] = date [2];
        y [3] = date [3];
        y [4] = 0;
    }
    return y;
}

int get_day_i (const char *date) {
    char *d   = NULL;
    int   day = 0;

    if (date != NULL) {
        MY_ALLOC (d, 3, char);
        d [0] = date [6];
        d [1] = date [7];
        d [2] = 0;
        day = atoi (d);
        free (d);
    }
    return day;
}

int get_month_i (const char *date) {
    char *m     = NULL;
    int   month = 0;

    if (date != NULL) {
        MY_ALLOC (m, 3, char);
        m [0] = date [4];
        m [1] = date [5];
        m [2] = 0;
        month = atoi (m);
        free (m);
    }
    return month;
}

int get_year_i (const char *date) {
    char *y    = NULL;
    int   year = 0;

    if (date != NULL) {
        MY_ALLOC (y, 5, char);
        y [0] = date [0];
        y [1] = date [1];
        y [2] = date [2];
        y [3] = date [3];
        y [4] = 0;
        year = atoi (y);
        free (y);
    }
    return year;
}

char *int_to_date_f (long int date) {
    char *sdate, *rdate;

    MY_ALLOC (sdate, 10, char);
    sprintf (sdate, "%ld", date);
    rdate = format_date (sdate);
    free (sdate);

    return rdate;
}

char *int_to_date_uf (long int date) {
    char *sdate;

    MY_ALLOC (sdate, 10, char);
    sprintf (sdate, "%ld", date);

    return sdate;
}
