/*
 * gAcc_msg.c
 * Thomas Nemeth, le 22.03.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "gAcc_msg.h"

/*** Create a message dialog box ********************************************/

GtkWidget *create_msg_dialog (const char *message) {
    GtkWidget *MSG_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;
    char      *texte;

    MSG_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (MSG_Dialog), _("Message...") );
    gtk_signal_connect (GTK_OBJECT (MSG_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (MSG_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label ( _("OK") );
    gtk_signal_connect_object (GTK_OBJECT (bouton), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (MSG_Dialog));

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (MSG_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    MY_ALLOC (texte, strlen (message) + 10, char);
    sprintf (texte, "\n %s \n", message);
    label = gtk_label_new (_(texte));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (MSG_Dialog)->vbox), label, TRUE,
                        TRUE, 18);
    gtk_widget_show (label);

    free (texte);
    return MSG_Dialog;
}
