/*
 * gAcc_menuscb.c
 * Thomas Nemeth, le 05.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "gAcc_menuscb.h"
#include "defines.h"
#include "structs.h" 
#include "cfgmgt.h"
#include "usefull.h"
#include "acclists.h"
#include "accounts.h"
#include "operations.h"
#include "categories.h"
#include "tiers.h"
#include "gAcc.h"
#include "gAcc_editacc.h"
#include "gAcc_file.h"
#include "gAcc_prefs.h"
#include "gAcc_catlist.h"
#include "gAcc_trslist.h"
#include "gAcc_cnv.h"
#include "gAcc_help.h"
#include "gAcc_about.h"
#include "gAcc_opelist.h"
#include "gAcc_nyi.h"
#include "gAcc_msg.h"
#include "gAcc_editope.h"
#include "gAcc_search.h"
#include "gAcc_results.h"
#include "gAcc_editcat.h"
#include "gAcc_trslist.h"
#include "gAcc_edittrs.h"
#include "gAcc_print.h"
#include "gAcc_grlst.h"


/*** Callbacks functions ****************************************************/

/* FILE */
void new_wallet_cb (GtkWidget *widget, void *data) {
    GtkWidget *editacc_dialog;

    if (config.AccDataModified == 1) {
        close_acc (GACC_NEW);
    } else {
        editacc_dialog = create_editacc_dialog (NULL);
        gtk_clist_clear ( GTK_CLIST (acc_clist) );
        new_wallet ();
        gtk_window_set_title (GTK_WINDOW (application), "gAcc");
        gtk_window_set_title (GTK_WINDOW (editacc_dialog), _("New Account") );
        gtk_window_set_modal (GTK_WINDOW (editacc_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (editacc_dialog) );
    }
}

void open_wallet_cb (GtkWidget *widget, void *data) {
    GtkWidget *file_dialog;
    char      *filename;

    if (config.AccDataModified == 1) {
        close_acc (GACC_OPENING);
    } else {
        file_dialog = create_file_dialog (GACC_OPEN);
        filename = default_filename (FAUX);
        gtk_file_selection_set_filename (GTK_FILE_SELECTION (file_dialog),
                                         filename);
        gtk_window_set_modal (GTK_WINDOW (file_dialog), TRUE);
        gtk_widget_show (file_dialog);
    }
}

void save_wallet_cb (GtkWidget *widget, void *data) {
    int        type = GACC_NOTHING;
    int       *p_type = (int *) data;

    if (config.accfilename != NULL) {
        write_accounts_to_file ();
        if (data != NULL) {
            type = (int) *p_type;
            switch (type) {
			case GACC_NEW :
				new_wallet_cb (NULL, NULL);
				break;
			case GACC_CLOSE :
				free_accounts ();
				gtk_clist_clear ( GTK_CLIST (acc_clist) );
				break;
			case GACC_QUIT :
				gtk_main_quit ();
				break;
			case GACC_OPENING :
				open_wallet_cb (NULL, NULL);
				break;
			default :
				break;
            }
        }
    } else
        saveas_wallet_cb (widget, data);
}

void saveas_wallet_cb (GtkWidget *widget, void *data) {
    GtkWidget *file_dialog;
    char      *filename;
    int        type = GACC_NOTHING;
    int       *p_type = (int *) data;

    type = GACC_SAVE;
    if (data != NULL) type = (int) *p_type;
    file_dialog = create_file_dialog (type);
    filename = default_filename (VRAI);
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (file_dialog), filename);
    gtk_window_set_modal (GTK_WINDOW (file_dialog), TRUE);
    gtk_widget_show (file_dialog);
    free (filename);
}

void close_cb (GtkWidget *widget, void *data) {
    if (config.AccDataModified == VRAI) {
        close_acc (GACC_CLOSE);
    } else {
        free_accounts ();
        gtk_clist_clear ( GTK_CLIST (acc_clist) );
    }
}

void quit_cb (GtkWidget *widget, void *data) {
    #if DEBUG_LEVEL > 0
    	printf("quit_cb %d %d %d \n",
            config,
            config.CatDataModified, 
            config.TrsDataModified);
    #endif
    if (config.CatDataModified == VRAI) write_categories_to_file();
    if (config.TrsDataModified == VRAI) write_tiers_to_file();
    if (config.ConfigModified  == VRAI) write_config();
    if (config.AccDataModified == VRAI) {
        close_acc (GACC_QUIT);
    } else {
        gtk_main_quit ();
    }
}


/* SETTINGS */
void prefs_cb (GtkWidget *widget, void *data) {
    GtkWidget *prefs_dialog;

    prefs_dialog = create_prefs_dialog ();
    gtk_widget_show (GTK_WIDGET (prefs_dialog) );
}

void open_cat_cb (GtkWidget *widget, void *data) {
    GtkWidget *catlist_dialog;
    catlist_dialog = create_catlist_dialog ();
    gtk_window_set_modal (GTK_WINDOW (catlist_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (catlist_dialog) );
}

void open_trs_cb (GtkWidget *widget, void *data) {
    GtkWidget *trslist_dialog;
    trslist_dialog = create_trslist_dialog ();
    gtk_window_set_modal (GTK_WINDOW (trslist_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (trslist_dialog) );
}

void sched_ope_cb (GtkWidget *widget, void *data) {
    GtkWidget *nyi_dialog = create_nyi_dialog ();

    gtk_window_set_modal (GTK_WINDOW (nyi_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (nyi_dialog) );
}

void convert_cb (GtkWidget *widget, void *data) {
    GtkWidget *cnv_dialog = create_cnv_dialog ();

    gtk_window_set_modal (GTK_WINDOW (cnv_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (cnv_dialog) );
}


/* HELP */
void help_cb (GtkWidget *widget, void *data) {
    GtkWidget *help_dialog = create_help_dialog ();
/*    gtk_window_set_modal (GTK_WINDOW (help_dialog), TRUE); */
    gtk_widget_show (GTK_WIDGET (help_dialog) );
}

void about_cb (GtkWidget *widget, void *data) {
    GtkWidget *about_dialog = create_about_dialog ();
    gtk_window_set_modal (GTK_WINDOW (about_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (about_dialog) );
}


/* ACCOUNTS */
void open_acc_cb (GtkWidget *widget, void *data) {
    GtkWidget *opelist_dialog;
    char      *titre;
    char      *nom;

    opelist_dialog = create_opelist_dialog ();
    config_set_last_opened_acc (selected_row);
    gtk_widget_show (GTK_WIDGET (opelist_dialog) );

    selected_row = nb_ope (get_account (config.LastOpenedAcc) ) - 1;
    #ifdef DEBUG_GACC
        printf ("Dernire opration du compte : %d\n", selected_row);
    #endif
    selected_row = 0;
    nom = set_ope_list (ope_clist);
    MY_ALLOC (titre, (strlen(_("Operations list : ")) + strlen (nom) + 1), char);
    strcpy (titre, _("Operations list : ") );
    strcat (titre, nom);
    gtk_window_set_title (GTK_WINDOW (opelist_dialog), titre);
    gtk_window_set_modal (GTK_WINDOW (opelist_dialog), TRUE);

    gtk_clist_unselect_all (GTK_CLIST (acc_clist) );
    free (titre);
}

void edit_acc_cb (GtkWidget *widget, void *data) {
    GtkWidget *editacc_dialog;
    ACCOUNT   *account = get_account (selected_row)->account;

    editacc_dialog = create_editacc_dialog (account);
    gtk_window_set_title (GTK_WINDOW (editacc_dialog), _("Edit Account") );
    gtk_window_set_modal (GTK_WINDOW (editacc_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editacc_dialog) );
}

void delete_acc_cb (GtkWidget *widget, void *data) {
    ACC_ELT *acc = get_account (selected_row);
    TRS_ELT *trs = get_tiers_with_name (acc->account->name);
    if (trs != NULL) trs_set_flag (trs->tiers, FALSE);
    del_account (acc);
    set_acc_list (acc_clist);
}

void add_acc_cb (GtkWidget *widget, void *data) {
    GtkWidget *editacc_dialog;

    editacc_dialog = create_editacc_dialog (NULL);
    gtk_window_set_title (GTK_WINDOW (editacc_dialog), _("Add Account") );
    gtk_window_set_modal (GTK_WINDOW (editacc_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editacc_dialog) );
    gtk_clist_unselect_all (GTK_CLIST (acc_clist) );
}

void graph_cb (GtkWidget *widget, void *data) {
/*
    GtkWidget *grln_dialog = create_grln_dialog ();

    gtk_window_set_modal (GTK_WINDOW (grln_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (grln_dialog) );
*/
    GtkWidget *grlst_dialog = create_grlst_dialog ();

    gtk_window_set_modal (GTK_WINDOW (grlst_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (grlst_dialog) );
    /* BEWARE OF THE NEXT LINE ! */
    gtk_clist_unselect_all (GTK_CLIST (acc_clist) );
}


/* OPERATIONS */
void edit_ope_cb (GtkWidget *widget, void *data) {
    GtkWidget *editope_dialog;
    OPERATION *operation;

    #ifdef DEBUG_GACC
        printf("ON SELECTION :\n");
        printf ("---------------------------------------------\n");
        display_all_list (get_account
                          (config.LastOpenedAcc) -> account->ope_list_head);
        printf ("=============================================\n");
    #endif
    if (selected_row > 0) {
        operation = get_operation_by_num (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            selected_row) -> operation;
    } else {
        operation = get_operation_by_id (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            -selected_row) -> operation;
    }
    editope_dialog = create_editope_dialog (operation);
    gtk_window_set_title (GTK_WINDOW (editope_dialog), _("Edit Operation") );
    gtk_window_set_modal (GTK_WINDOW (editope_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editope_dialog) );
}

void mark_ope_cb (GtkWidget *widget, void *data) {
    OPERATION *operation;
    int        status;

    if (selected_row > 0) {
        operation = get_operation_by_num (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            selected_row) -> operation;
    } else {
        operation = get_operation_by_id (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            -selected_row) -> operation;
    }
    status = (operation->pointed == VRAI ? FAUX : VRAI);
    ope_set_pointed (operation, status);
    if (selected_row > 0) {
        set_ope_list (ope_clist);
    } else {
        set_res_list (res_clist);
    }
}

void cancel_ope_cb (GtkWidget *widget, void *data) {
    ACC_ELT   *acc       = config.acc_list_head;
    OPE_ELT   *tiers_ope = NULL;
    OPERATION *operation;
    int        status;
    int        i         = 0;

    if (selected_row > 0) {
        operation = get_operation_by_num (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            selected_row) -> operation;
    } else {
        operation = get_operation_by_id (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            -selected_row) -> operation;
    }
    status = (operation->cancelled == VRAI ? FAUX : VRAI);
    ope_set_cancelled (operation, status);
    if (selected_row > 0) {
        set_ope_list (ope_clist);
    } else {
        set_res_list (res_clist);
    }

    if ( (operation->tiers != UNKNOWN_TIERS) &&
         (advanced_contains (ADVANCED_TIERS) == FAUX) ) {
        while ( (acc != NULL) && (i != operation->tiers) ) {
            i++;
            if (i == operation->tiers) {
                tiers_ope = acc->account->ope_list_head;
                while ( (tiers_ope != NULL) &&
                        ! ( (strcmp (tiers_ope->operation->object,
                                     operation->object) == 0) &&
                            (strcmp (tiers_ope->operation->date,
                                     operation->date) == 0) &&
                            (tiers_ope->operation->amount == operation->amount)
                       ) ) {
                    tiers_ope = tiers_ope->next;
                }
                if (tiers_ope != NULL) {
                    ope_set_cancelled (tiers_ope->operation, status);
                }
            }
        }
    } else if ( (operation->tiers != UNKNOWN_TIERS) &&
                (advanced_contains (ADVANCED_TIERS) == VRAI) &&
                (get_tiers_with_num
                 (operation->tiers)->tiers->is_in_file == VRAI) ) {
        TRS_ELT *trs = get_tiers_with_num (operation->tiers);
        acc          = get_account_with_name (trs->tiers->name);
        tiers_ope    = acc->account->ope_list_head;
        while ( (tiers_ope != NULL) &&
                ! ( (strcmp (tiers_ope->operation->object,
                             operation->object) == 0) &&
                    (strcmp (tiers_ope->operation->date,
                             operation->date) == 0) &&
                    (tiers_ope->operation->amount == operation->amount)
               ) ) {
            tiers_ope = tiers_ope->next;
        }
        if (tiers_ope != NULL) {
            ope_set_cancelled (tiers_ope->operation, status);
        }
    }
}

void delete_ope_cb (GtkWidget *widget, void *data) {
    ACC_ELT   *acc       = config.acc_list_head;
    OPE_ELT   *tiers_ope = NULL;
    OPERATION *operation ;
    int        i         = 0;

    if (selected_row > 0) {
        operation = get_operation_by_num (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            selected_row) -> operation;
    } else {
        operation = get_operation_by_id (
            get_account (config.LastOpenedAcc)->account->ope_list_head,
            -selected_row) -> operation;
    }
    if ( (operation->tiers != UNKNOWN_TIERS) &&
         (advanced_contains (ADVANCED_TIERS) == FAUX) ) {
        while ( (acc != NULL) && (i != operation->tiers) ) {
            i++;
            if (i == operation->tiers) {
                tiers_ope = acc->account->ope_list_head;
                while ( (tiers_ope != NULL) &&
                        ! ( (strcmp (tiers_ope->operation->object,
                                     operation->object) == 0) &&
                            (strcmp (tiers_ope->operation->date,
                                     operation->date) == 0) &&
                            (tiers_ope->operation->amount == operation->amount)
                       ) ) {
                    tiers_ope = tiers_ope->next;
                }
                if (tiers_ope != NULL) {
                    del_operation (acc, tiers_ope);
                }
            }
        }
    } else if ( (operation->tiers != UNKNOWN_TIERS) &&
                (advanced_contains (ADVANCED_TIERS) == VRAI) &&
                (get_tiers_with_num
                 (operation->tiers)->tiers->is_in_file == VRAI) ) {
        TRS_ELT *trs = get_tiers_with_num (operation->tiers);
        acc          = get_account_with_name (trs->tiers->name);
		if(acc != NULL) {
			tiers_ope    = acc->account->ope_list_head;
			while ( (tiers_ope != NULL) &&
					! ( (strcmp (tiers_ope->operation->object,
								 operation->object) == 0) &&
						(strcmp (tiers_ope->operation->date,
								 operation->date) == 0) &&
						(tiers_ope->operation->amount == operation->amount)
						) ) {
				tiers_ope = tiers_ope->next;
			}
			if (tiers_ope != NULL) {
				del_operation (acc, tiers_ope);
			}
		}
    }

    del_operation (get_account (config.LastOpenedAcc),
        get_operation_by_num (
        get_account (config.LastOpenedAcc)->account->ope_list_head,
        selected_row) );
    if (selected_row > 0) {
        set_ope_list (ope_clist);
    } else {
        set_res_list (res_clist);
    }
}

void add_ope_cb (GtkWidget *widget, void *data) {
    GtkWidget *editope_dialog = create_editope_dialog (NULL);

    gtk_window_set_title (GTK_WINDOW (editope_dialog), _("Add Operation") );
    gtk_window_set_modal (GTK_WINDOW (editope_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editope_dialog) );
}

void search_cb (GtkWidget *widget, void *data) {
    GtkWidget *search_dialog = create_search_dialog (get_account
                                (config.LastOpenedAcc)->account->ope_list_head);

    gtk_window_set_modal (GTK_WINDOW (search_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (search_dialog) );
    gtk_clist_unselect_all (GTK_CLIST (ope_clist) );
}

void print_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list = NULL;
    GtkWidget *print_dialog;
    
    list = my_list_add (list, get_account (config.LastOpenedAcc)->account);
    print_dialog = create_print_dialog (list);
    gtk_window_set_modal (GTK_WINDOW (print_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (print_dialog) );
    gtk_clist_unselect_all (GTK_CLIST (ope_clist) );
}


/* CATEGORIES */
void edit_cat_cb (GtkWidget *widget, void *data) {
    GtkWidget *editcat_dialog;
    GtkWidget *cat_clist = (GtkWidget *) data;
    CATEGORY  *category = get_category (selected_row)->category;
    MY_LIST   *list      = NULL;

    list = my_list_add (list, cat_clist);
    list = my_list_add (list, category);
    editcat_dialog = create_editcat_dialog (list);
    gtk_window_set_title (GTK_WINDOW (editcat_dialog), _("Edit Category") );
    gtk_window_set_modal (GTK_WINDOW (editcat_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editcat_dialog) );
}

void add_cat_cb (GtkWidget *widget, void *data) {
    GtkWidget *editcat_dialog;
    GtkWidget *cat_clist = (GtkWidget *) data;
    MY_LIST   *list      = NULL;

    list = my_list_add (list, cat_clist);
    editcat_dialog = create_editcat_dialog (list);
    gtk_window_set_title (GTK_WINDOW (editcat_dialog), _("Add Category") );
    gtk_window_set_modal (GTK_WINDOW (editcat_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editcat_dialog) );
}

void delete_cat_cb (GtkWidget *widget, void *data) {
    del_category (get_category (selected_row) );
    gtk_clist_clear (GTK_CLIST ( (GtkWidget *) data) );
    set_cat_list ( (GtkWidget *) data);
    gtk_clist_unselect_all (GTK_CLIST ( (GtkWidget *) data) );
}


/* TIERS */
void edit_trs_cb (GtkWidget *widget, void *data) {
    GtkWidget *edittrs_dialog;
    GtkWidget *trs_clist = (GtkWidget *) data;
    TIERS     *tiers     = get_tiers (selected_row)->tiers;
    MY_LIST   *list      = NULL;

    list = my_list_add (list, trs_clist); /* 0 */
    list = my_list_add (list, tiers);     /* 1 */
    edittrs_dialog = create_edittrs_dialog (list);
    gtk_window_set_title (GTK_WINDOW (edittrs_dialog), _("Edit 3rd party") );
    gtk_window_set_modal (GTK_WINDOW (edittrs_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (edittrs_dialog) );
}

void add_trs_cb (GtkWidget *widget, void *data) {
    GtkWidget *edittrs_dialog;
    GtkWidget *trs_clist = (GtkWidget *) data;
    MY_LIST   *list      = NULL;

    list = my_list_add (list, trs_clist); /* 0 */
    edittrs_dialog = create_edittrs_dialog (list);
    gtk_window_set_title (GTK_WINDOW (edittrs_dialog), _("Add 3rd party") );
    gtk_window_set_modal (GTK_WINDOW (edittrs_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (edittrs_dialog) );
}

void delete_trs_cb (GtkWidget *widget, void *data) {
    TRS_ELT *trs = get_tiers (selected_row);

    if (trs->tiers->is_in_file == FAUX) {
        del_tiers (trs);
        gtk_clist_clear (GTK_CLIST ( (GtkWidget *) data) );
        set_trs_list ( (GtkWidget *) data);
        gtk_clist_unselect_all (GTK_CLIST ( (GtkWidget *) data) );
    } else {
        GtkWidget *msg_dialog = create_msg_dialog (
            _("Sorry !\n You cannot delete this 3rd-party : \n It is in your accounts lists... ") );
        gtk_window_set_modal (GTK_WINDOW (msg_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (msg_dialog) );
    }
}
