/*
 * gAcc_menus.c
 * Thomas Nemeth, le 05.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <gtk/gtk.h>
#include "gAcc_menus.h"
#include "gAcc_menuscb.h"
#include "structs.h" 
#include "cfgmgt.h"


/*** Menus creation main function *******************************************/

GtkWidget *create_gacc_main_menus (GtkWidget *acc_list_menu) {
    GtkWidget *menubar;
    GtkWidget *menubar_item;
    GtkWidget *menu;
    GtkWidget *menu_item;

    menubar     = gtk_menu_bar_new ();
    /* FILE MENU */
    menubar_item = gtk_menu_item_new_with_label (_("File") );
    menu         = gtk_menu_new ();
    gtk_menu_set_title (GTK_MENU (menu), _("File") );
    if (config.TearOff == 1)
        gtk_menu_set_tearoff_state (GTK_MENU (menu), TRUE);
    else
        gtk_menu_set_tearoff_state (GTK_MENU (menu), FALSE);
    /* New */
    menu_item    = gtk_menu_item_new_with_label (_("New wallet...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (new_wallet_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Open */
    menu_item    = gtk_menu_item_new_with_label (_("Open...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (open_wallet_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Save */
    menu_item    = gtk_menu_item_new_with_label (_("Save") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (save_wallet_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Save As */
    menu_item    = gtk_menu_item_new_with_label (_("Save As...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (saveas_wallet_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_widget_show (menu_item);
    /* Close */
    menu_item    = gtk_menu_item_new_with_label (_("Close") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (close_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Quit */
    menu_item    = gtk_menu_item_new_with_label (_("Quit") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (quit_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /**/
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menubar_item), menu);
    gtk_menu_bar_append (GTK_MENU_BAR (menubar), menubar_item);
    gtk_widget_show (menubar_item);
    /* file menu */

    /* SETTINGS MENU */
    menubar_item = gtk_menu_item_new_with_label (_("Settings") );
    menu         = gtk_menu_new ();
    gtk_menu_set_title (GTK_MENU (menu), _("Settings"));
    if (config.TearOff == 1)
        gtk_menu_set_tearoff_state (GTK_MENU (menu), TRUE);
    else
        gtk_menu_set_tearoff_state (GTK_MENU (menu), FALSE);
    /* Preferences */
    menu_item    = gtk_menu_item_new_with_label (_("Preferences...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (prefs_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_widget_show (menu_item);
    /* Categories */
    menu_item    = gtk_menu_item_new_with_label (_("Categories...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (open_cat_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Tiers */
    trs_menu_item = gtk_menu_item_new_with_label (_("3rd parties...") );
    gtk_menu_append (GTK_MENU (menu), trs_menu_item);
    gtk_signal_connect (GTK_OBJECT (trs_menu_item), "activate",
                        GTK_SIGNAL_FUNC (open_trs_cb),
                        NULL);
    gtk_widget_show (trs_menu_item);
    if (advanced_contains (ADVANCED_TIERS) == VRAI)
        gtk_widget_set_sensitive (trs_menu_item, TRUE);
    else
        gtk_widget_set_sensitive (trs_menu_item, FALSE);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_widget_show (menu_item);
    /* Periodic operations */
    menu_item    = gtk_menu_item_new_with_label (_("Scheduled operations...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (sched_ope_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_widget_show (menu_item);
    /* Convert To Euro */
    menu_item    = gtk_menu_item_new_with_label (_("Convert to Euro") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (convert_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /**/
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menubar_item), menu);
    gtk_menu_bar_append (GTK_MENU_BAR (menubar), menubar_item);
    gtk_widget_show (menubar_item);
    /* settings menu */

    /* ACCOUNTS MENU */
    menubar_item = gtk_menu_item_new_with_label (_("Accounts") );
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menubar_item), acc_list_menu);
    gtk_menu_bar_append (GTK_MENU_BAR (menubar), menubar_item);
    gtk_widget_show (menubar_item);
    /* accounts menu */

    /* HELP MENU */
    menubar_item = gtk_menu_item_new_with_label (_("Help") );
    menu         = gtk_menu_new ();
    gtk_menu_set_title (GTK_MENU (menu), _("Help"));
    if (config.TearOff == 1)
        gtk_menu_set_tearoff_state (GTK_MENU (menu), TRUE);
    else
        gtk_menu_set_tearoff_state (GTK_MENU (menu), FALSE);
    /* Help Index */
    menu_item    = gtk_menu_item_new_with_label (_("Help Index...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (help_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_widget_show (menu_item);
    /* About */
    menu_item    = gtk_menu_item_new_with_label (_("About...") );
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (about_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /**/
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menubar_item), menu);
    gtk_menu_item_right_justify (GTK_MENU_ITEM (menubar_item) );
    gtk_menu_bar_append (GTK_MENU_BAR (menubar), menubar_item);
    gtk_widget_show (menubar_item);
    /* help menu */

    return menubar;
}


/*** Accounts menus creation function ***************************************/

GtkWidget *create_acclist_menus   (GtkWidget **open_acc_menu_item,
                                   GtkWidget **edit_acc_menu_item,
                                   GtkWidget **delete_acc_menu_item,
                                   GtkWidget **graph_acc_menu_item) {
    GtkWidget *acc_list_menu;
    GtkWidget *menu_item;

    /* ACCOUNTS MENU */
    acc_list_menu = gtk_menu_new ();
    gtk_menu_set_title (GTK_MENU (acc_list_menu), _("Accounts") );
    if (config.TearOff == 1)
        gtk_menu_set_tearoff_state (GTK_MENU (acc_list_menu), TRUE);
    else
        gtk_menu_set_tearoff_state (GTK_MENU (acc_list_menu), FALSE);
    /* Open */
    *open_acc_menu_item    = gtk_menu_item_new_with_label (_("Open") );
    gtk_widget_set_sensitive (GTK_WIDGET (*open_acc_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (acc_list_menu), *open_acc_menu_item);
    gtk_signal_connect (GTK_OBJECT (*open_acc_menu_item), "activate",
                        GTK_SIGNAL_FUNC (open_acc_cb),
                        NULL);
    gtk_widget_show (*open_acc_menu_item);
    /* Edit */
    *edit_acc_menu_item    = gtk_menu_item_new_with_label (_("Edit...") );
    gtk_widget_set_sensitive (GTK_WIDGET (*edit_acc_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (acc_list_menu), *edit_acc_menu_item);
    gtk_signal_connect (GTK_OBJECT (*edit_acc_menu_item), "activate",
                        GTK_SIGNAL_FUNC (edit_acc_cb),
                        NULL);
    gtk_widget_show (*edit_acc_menu_item);
    /* Delete */
    *delete_acc_menu_item  = gtk_menu_item_new_with_label (_("Delete") );
    gtk_widget_set_sensitive (GTK_WIDGET (*delete_acc_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (acc_list_menu), *delete_acc_menu_item);
    gtk_signal_connect (GTK_OBJECT (*delete_acc_menu_item), "activate",
                        GTK_SIGNAL_FUNC (delete_acc_cb),
                        NULL);
    gtk_widget_show (*delete_acc_menu_item);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (acc_list_menu), menu_item);
    gtk_widget_show (menu_item);
    /* Add */
    menu_item    = gtk_menu_item_new_with_label (_("Add...") );
    gtk_menu_append (GTK_MENU (acc_list_menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (add_acc_cb),
                        NULL);
    gtk_widget_show (menu_item);
    /* Graph */
    *graph_acc_menu_item   = gtk_menu_item_new_with_label (_("Graph") );
    gtk_widget_set_sensitive (GTK_WIDGET (*graph_acc_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (acc_list_menu), *graph_acc_menu_item);
    gtk_signal_connect (GTK_OBJECT (*graph_acc_menu_item), "activate",
                        GTK_SIGNAL_FUNC (graph_cb),
                        NULL);
    gtk_widget_show (*graph_acc_menu_item);
    /* accounts menu */

    return acc_list_menu;
}


/*** Operations menus creation function *************************************/

GtkWidget *create_opelist_menus   (GtkWidget **edit_ope_menu_item,
                                   GtkWidget **mark_ope_menu_item,
                                   GtkWidget **cancel_ope_menu_item,
                                   GtkWidget **delete_ope_menu_item,
                                   int         std_items) {
    GtkWidget *ope_list_menu;
    GtkWidget *menu_item;

    /* OPERATIONS MENU */
    ope_list_menu = gtk_menu_new ();
    gtk_menu_set_title (GTK_MENU (ope_list_menu), _("Operations") );
    if (config.TearOff == 1)
        gtk_menu_set_tearoff_state (GTK_MENU (ope_list_menu), TRUE);
    else
        gtk_menu_set_tearoff_state (GTK_MENU (ope_list_menu), FALSE);
    /* Edit */
    *edit_ope_menu_item    = gtk_menu_item_new_with_label (_("Edit...") );
    gtk_widget_set_sensitive (GTK_WIDGET (*edit_ope_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (ope_list_menu), *edit_ope_menu_item);
    gtk_signal_connect (GTK_OBJECT (*edit_ope_menu_item), "activate",
                        GTK_SIGNAL_FUNC (edit_ope_cb),
                        NULL);
    gtk_widget_show (*edit_ope_menu_item);
    /* Point */
    *mark_ope_menu_item    = gtk_menu_item_new_with_label (_("(un)Clear") );
    gtk_widget_set_sensitive (GTK_WIDGET (*mark_ope_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (ope_list_menu), *mark_ope_menu_item);
    gtk_signal_connect (GTK_OBJECT (*mark_ope_menu_item), "activate",
                        GTK_SIGNAL_FUNC (mark_ope_cb),
                        NULL);
    gtk_widget_show (*mark_ope_menu_item);
    /* Cancel */
    *cancel_ope_menu_item  = gtk_menu_item_new_with_label (_("(un)Cancel") );
    gtk_widget_set_sensitive (GTK_WIDGET (*cancel_ope_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (ope_list_menu), *cancel_ope_menu_item);
    gtk_signal_connect (GTK_OBJECT (*cancel_ope_menu_item), "activate",
                        GTK_SIGNAL_FUNC (cancel_ope_cb),
                        NULL);
    gtk_widget_show (*cancel_ope_menu_item);
    /* Delete */
    *delete_ope_menu_item  = gtk_menu_item_new_with_label (_("Delete") );
    gtk_widget_set_sensitive (GTK_WIDGET (*delete_ope_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (ope_list_menu), *delete_ope_menu_item);
    gtk_signal_connect (GTK_OBJECT (*delete_ope_menu_item), "activate",
                        GTK_SIGNAL_FUNC (delete_ope_cb),
                        NULL);
    gtk_widget_show (*delete_ope_menu_item);

    if (std_items == TRUE) {
        /* Separator */
        menu_item    = gtk_menu_item_new ();
        gtk_menu_append (GTK_MENU (ope_list_menu), menu_item);
        gtk_widget_show (menu_item);
        /* Add */
        menu_item    = gtk_menu_item_new_with_label (_("Add...") );
        gtk_menu_append (GTK_MENU (ope_list_menu), menu_item);
        gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                            GTK_SIGNAL_FUNC (add_ope_cb),
                            NULL);
        gtk_widget_show (menu_item);
        /* Separator */
        menu_item    = gtk_menu_item_new ();
        gtk_menu_append (GTK_MENU (ope_list_menu), menu_item);
        gtk_widget_show (menu_item);
        /* Search */
        menu_item    = gtk_menu_item_new_with_label (_("Search...") );
        gtk_menu_append (GTK_MENU (ope_list_menu), menu_item);
        gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                            GTK_SIGNAL_FUNC (search_cb),
                            NULL);
        gtk_widget_show (menu_item);
        /* Print */
        menu_item    = gtk_menu_item_new_with_label (_("Print list...") );
        gtk_menu_append (GTK_MENU (ope_list_menu), menu_item);
        gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                            GTK_SIGNAL_FUNC (print_cb),
                            NULL);
        gtk_widget_show (menu_item);
    }
    /* operations menu */

    return ope_list_menu;
}


/*** Categories menus creation function *************************************/

GtkWidget *create_catlist_menus (GtkWidget  *cat_clist,
                                 GtkWidget **edit_cat_menu_item,
                                 GtkWidget **delete_cat_menu_item) {
    GtkWidget *cat_list_menu;
    GtkWidget *menu_item;

    /* CATEGORIES MENU */
    cat_list_menu = gtk_menu_new ();
    gtk_menu_set_title (GTK_MENU (cat_list_menu), _("Categories") );
    if (config.TearOff == 1)
        gtk_menu_set_tearoff_state (GTK_MENU (cat_list_menu), TRUE);
    else
        gtk_menu_set_tearoff_state (GTK_MENU (cat_list_menu), FALSE);
    /* Edit */
    *edit_cat_menu_item    = gtk_menu_item_new_with_label (_("Edit...") );
    gtk_widget_set_sensitive (GTK_WIDGET (*edit_cat_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (cat_list_menu), *edit_cat_menu_item);
    gtk_signal_connect (GTK_OBJECT (*edit_cat_menu_item), "activate",
                        GTK_SIGNAL_FUNC (edit_cat_cb),
                        cat_clist);
    gtk_widget_show (*edit_cat_menu_item);
    /* Add */
    menu_item    = gtk_menu_item_new_with_label (_("Add...") );
    gtk_menu_append (GTK_MENU (cat_list_menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (add_cat_cb),
                        cat_clist);
    gtk_widget_show (menu_item);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (cat_list_menu), menu_item);
    gtk_widget_show (menu_item);
    /* Delete */
    *delete_cat_menu_item  = gtk_menu_item_new_with_label (_("Delete") );
    gtk_widget_set_sensitive (GTK_WIDGET (*delete_cat_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (cat_list_menu), *delete_cat_menu_item);
    gtk_signal_connect (GTK_OBJECT (*delete_cat_menu_item), "activate",
                        GTK_SIGNAL_FUNC (delete_cat_cb),
                        cat_clist);
    gtk_widget_show (*delete_cat_menu_item);
    /* categories menu */

    return cat_list_menu;
}


/*** Tiers menus creation function ******************************************/

GtkWidget *create_trslist_menus (GtkWidget  *trs_clist,
                                 GtkWidget **edit_trs_menu_item,
                                 GtkWidget **delete_trs_menu_item) {
    GtkWidget *trs_list_menu;
    GtkWidget *menu_item;

    /* CATEGORIES MENU */
    trs_list_menu = gtk_menu_new ();
    gtk_menu_set_title (GTK_MENU (trs_list_menu), _("Categories") );
    if (config.TearOff == 1)
        gtk_menu_set_tearoff_state (GTK_MENU (trs_list_menu), TRUE);
    else
        gtk_menu_set_tearoff_state (GTK_MENU (trs_list_menu), FALSE);
    /* Edit */
    *edit_trs_menu_item    = gtk_menu_item_new_with_label (_("Edit...") );
    gtk_widget_set_sensitive (GTK_WIDGET (*edit_trs_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (trs_list_menu), *edit_trs_menu_item);
    gtk_signal_connect (GTK_OBJECT (*edit_trs_menu_item), "activate",
                        GTK_SIGNAL_FUNC (edit_trs_cb),
                        trs_clist);
    gtk_widget_show (*edit_trs_menu_item);
    /* Add */
    menu_item    = gtk_menu_item_new_with_label (_("Add...") );
    gtk_menu_append (GTK_MENU (trs_list_menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
                        GTK_SIGNAL_FUNC (add_trs_cb),
                        trs_clist);
    gtk_widget_show (menu_item);
    /* Separator */
    menu_item    = gtk_menu_item_new ();
    gtk_menu_append (GTK_MENU (trs_list_menu), menu_item);
    gtk_widget_show (menu_item);
    /* Delete */
    *delete_trs_menu_item  = gtk_menu_item_new_with_label (_("Delete") );
    gtk_widget_set_sensitive (GTK_WIDGET (*delete_trs_menu_item), FALSE);
    gtk_menu_append (GTK_MENU (trs_list_menu), *delete_trs_menu_item);
    gtk_signal_connect (GTK_OBJECT (*delete_trs_menu_item), "activate",
                        GTK_SIGNAL_FUNC (delete_trs_cb),
                        trs_clist);
    gtk_widget_show (*delete_trs_menu_item);
    /* categories menu */

    return trs_list_menu;
}
