/*
 * gAcc_editcat.c
 * Thomas Nemeth, le 14.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "structs.h" 
#include "gAcc_editcat.h"
#include "acclists.h"
#include "operations.h"
#include "categories.h"
#include "gAcc_opelist.h"
#include "gAcc_catlist.h"


/*** Create the "Edit Category" dialog box ****************************/

void editcat_ok_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list         = (MY_LIST *)   data;
    GtkWidget *window       = (GtkWidget *) my_list_get_element (list, 0);
    GtkWidget *clist        = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *editcat_name = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *editcat_num  = (GtkWidget *) my_list_get_element (list, 3);
    GtkWidget *editcat_type = (GtkWidget *) my_list_get_element (list, 4);
    CATEGORY  *category     = (CATEGORY  *) my_list_get_element (list, 5);
    OPERATION *operation    = (OPERATION *) my_list_get_element (list, 6);
/*    char      *title        = GTK_WINDOW (window)->title;*/
    char      *name;
    int        number;
    int        type;

    name        = gtk_entry_get_text (GTK_ENTRY (editcat_name) );
    number      = atoi (gtk_entry_get_text (GTK_ENTRY (editcat_num) ) );
    if (GTK_TOGGLE_BUTTON (editcat_type)->active)
        type = CREDIT;
    else
        type = DEBIT;

/*
    if (strcmp (title, _("Edit Category") ) == 0) {
        category = get_category (selected_row)->category;
*/
    if (category != NULL) {
        remove_category (category);
    } else {
        category = category_new ();
    }

    cat_set_name (category, name);
    cat_set_num  (category, number);
    cat_set_type (category, type);

    add_category (category);

    if (operation != NULL) {
        ope_set_category (operation, number);
        if (clist != NULL) set_ope_list (clist);
    } else if ( (operation == NULL) && (clist != NULL) ) {
        gtk_clist_clear (GTK_CLIST (clist) );
        set_cat_list (clist);
        gtk_clist_unselect_all (GTK_CLIST (clist) );
    }
    gtk_widget_destroy (window);
    my_list_free (list);
}

void editcat_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

GtkWidget *create_editcat_dialog (MY_LIST *inlist) {
    GtkWidget *EditCat_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;
    GtkWidget *hbox;
    GtkWidget *clist     = (GtkWidget *) my_list_get_element (inlist, 0);
    CATEGORY  *category  = (CATEGORY  *) my_list_get_element (inlist, 1);
    char      *name      = (char      *) my_list_get_element (inlist, 2);
    char      *num       = (char      *) my_list_get_element (inlist, 3);
    char      *type      = (char      *) my_list_get_element (inlist, 4);
    OPERATION *operation = (OPERATION *) my_list_get_element (inlist, 5);
    char      *number;
    GtkWidget *editcat_name;
    GtkWidget *editcat_num;
    GtkWidget *editcat_type;
    MY_LIST   *list = NULL;

    EditCat_Dialog = gtk_dialog_new ();
    list = my_list_add (list, EditCat_Dialog);
    list = my_list_add (list, clist);
    gtk_signal_connect (GTK_OBJECT (EditCat_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (EditCat_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label ( _("OK") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (editcat_ok_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditCat_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (editcat_cancel_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditCat_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    /* Category Name */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Category name : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    editcat_name = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), editcat_name, TRUE, TRUE, 6);
    gtk_widget_show (editcat_name);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditCat_Dialog)->vbox), hbox,
                        TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    /* Category Number */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Category number : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    editcat_num = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), editcat_num, TRUE, TRUE, 6);
    gtk_widget_show (editcat_num);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditCat_Dialog)->vbox), hbox,
                        TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    /* Category Type */
    hbox = gtk_hbox_new (TRUE, 0);

    editcat_type = gtk_check_button_new_with_label (_("Credit category") );

    gtk_box_pack_start (GTK_BOX (hbox), editcat_type, TRUE, TRUE, 6);
    gtk_widget_show (editcat_type);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditCat_Dialog)->vbox), hbox,
                        TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    if (category != NULL) {
        gtk_entry_set_text (GTK_ENTRY (editcat_name),
                            category->name != NULL ? category->name : "");
        MY_ALLOC (number, 12, char);
        sprintf (number, "%d", category->num);
        gtk_entry_set_text (GTK_ENTRY (editcat_num), number);
        if (category->type == CREDIT)
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editcat_type),
                                          TRUE);
        else
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editcat_type),
                                          FALSE);
        free (number);
    } else if ( (category == NULL) && (name == NULL) &&
                (num == NULL) && (type == NULL) ) {
        gtk_entry_set_text (GTK_ENTRY (editcat_name), "");
        MY_ALLOC (number, 12, char);
        sprintf (number, "%d", get_category_next_num () );
        gtk_entry_set_text (GTK_ENTRY (editcat_num), number);
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editcat_type), FALSE);
        free (number);
    } else {
        gtk_entry_set_text (GTK_ENTRY (editcat_name), name != NULL ? name : "");
        gtk_entry_set_text (GTK_ENTRY (editcat_num), num);
        if (type [0] == 'C')
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editcat_type),
                                          TRUE);
        else
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editcat_type),
                                          FALSE);
        free (num);
    }

    list = my_list_add (list, editcat_name);
    list = my_list_add (list, editcat_num);
    list = my_list_add (list, editcat_type);
    list = my_list_add (list, category);
    list = my_list_add (list, operation);

    my_list_free (inlist);

    #ifdef DEBUG_GACC
        printf ("Affichage de la fentre d'informations de la catgorie\n");
    #endif

    return EditCat_Dialog;
}
