/*
 * defines.h
 * Thomas Nemeth, le 05.02.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _DEFINES_H_
#define _DEFINES_H_

/* IMPORTANT MACROS                                                   */
#define MY_ALLOC(var, nb, type) \
do {\
    if((var = (type *)malloc((nb)*sizeof(type))) == NULL) {\
        int CARAC;\
        printf("Allocation error for "#var" !!!\n");\
        printf("=>\n");\
        CARAC = getchar();\
    }\
} \
while (0)

#define MY_STOP {int CARAC;printf("=>\n");CARAC = getchar();}


/* xgettext preparation                                               */

#define _(String) (String) 
#define N_(String) (String) 
#define textdomain(Domain) 
#define bindtextdomain(Package, Directory) 

/* Dfinitions diverses                                               */
/* Miscelaneous definitions                                           */
#define MAXVERSIONSIZE 6
#define MAXSTRLEN 2048

#define HEADLINES 6
#define KEYLENGTH 8

/* Constantes                                                         */
/* Constants                                                          */
#define CREDCARD 0  /* Carte de crdit     / credit card              */
#define CHEQUE   1  /* Chque              / cheque                   */
#define PRELEVMT 2  /* Prlvement         / standing order           */
#define VIREMENT 3  /* Virement            / transfer                 */
#define BOURSE   4  /* Opration boursire / Stock exchange transact */

#define FAUX 0 /* FALSE */
#define VRAI 1 /* TRUE */

#define DEBIT    0
#define CREDIT   1

#define UNKNOWN_CATEGORY 0
#define UNKNOWN_TIERS    0

#define FRENCH_DATE   0 /* dd.mm.yyyy                                 */
#define ENGLISH_DATE  1 /* mm.dd.yyyy                                 */

#define CURRENCY_AFTER   0 /* ex. : 999,99 F                          */
#define CURRENCY_BEFORE  1 /* ex. : $USD 999.99                       */

#define ADVANCED_BASIC  0
#define ADVANCED_TIERS  1
#define ADVANCED_SPLITS 2

#define PRINT_TO_PRINTER 0
#define PRINT_TO_FILE    1

#define GRAPH_W      600
#define GRAPH_H      320

#endif
