/*
 * xutil.h
 *
 * Utilities for detailing with X
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __XUTIL_H
#define __XUTIL_H

#include <X11/Intrinsic.h>
#include "tvtypes.h"
#include "tvutil.h"

typedef enum { 
            TV_DIALOG_TYPE_OK,
            TV_DIALOG_TYPE_CANCEL,
            TV_DIALOG_TYPE_YES_NO,
            TV_DIALOG_TYPE_NOBUTTONS
        } TV_DIALOG_TYPE;

#define TV_DIALOG_YES 1
#define TV_DIALOG_NO  0

typedef void XUTIL_RUNCMD_DONECB( TV_BOOL aborted, int status, void *cb_data );
            /*  aborted      - O: T = user aborted  (i.e. dismissed dialog)  */
            /*                    F = cmd completed (dialog still mapped)    */
            /*  status       - O: exit status of process                     */

typedef TV_BOOL XUTIL_RUNCMD_CANCELCB( void *cb_data );
            /*  Returns:  T = abort command; F = continue execution          */


extern char G_transl_ovr_ascii_text[];
extern char G_transl_ovr_ascii_text_1line[];


#ifdef __cplusplus
extern "C" {
#endif

void XUTILAugmentXEnv( char *argv0 );

TV_BOOL XUTILBitmapLoad( char   *bitmap_file,
                      Widget  wgt,
                      Pixmap *pixmap );

TV_BOOL XUTILPixmapLoad( char    *pixmap_file,
                      Widget   wgt,
                      Pixel    fg_color,
                      Pixel    bg_color,
                      Pixmap  *pixmap,
                      Pixmap  *pixmap_mask );

void XUTILXawScrollbarSetThumb( Widget w, float top, float shown );

void XUTILGetVisualBpp( Display     *display, 
                        XVisualInfo *vi,
                        TV_INT32    *Bpp_pixmap,
                        TV_INT32    *Bpp_fbuffer );

void XUTILGetVisualSwaps( Display *display, XVisualInfo *vi,
                          TV_BOOL *swap_bytes, TV_BOOL *swap_shorts );

void XUTILGetPixelConvInfo( TV_UINT32 src_rel_mask[3],
                            TV_UINT32 dst_rel_mask[3],
                            TV_INT32  shift       [3],
                            TV_UINT32 mask        [3] );

void XUTILDialogSmartPosition( Widget      main_wgt,
                               Widget      dialog_wgt );

Widget XUTILDialogBuild( Widget toplevel,
                         char title[], char msg[], TV_DIALOG_TYPE type );

TV_INT32 XUTILDialogPause( Widget toplevel,
                           char title[], char msg[], TV_DIALOG_TYPE type );

void XUTILRunCmdAllowCancel( 
                XtAppContext           app_context,
                char                  *cmd[], 
                TVUTIL_PIPE_END        end[3],
                XUTIL_RUNCMD_CANCELCB *cancel_test,
                void                  *cancel_cb_data,
                XUTIL_RUNCMD_DONECB   *done_cb,
                void                  *done_cb_data );

Bool XUTILIsWellFormedXLFDFont( char *name );
Bool XUTILIsScalableFont      ( char *name );

XFontStruct *XUTILLoadQueryScalableFont(
                  Display *dpy,
                  int      screen,
                  char    *name,
                  int      size,
                  char    *new_name,
                  int      new_name_size );

XFontStruct *XUTILLoadPixelSizeFont(
                  Display *dpy,
                  char    *name,
                  int      pixel_size,
                  char    *new_name,
                  int      new_name_size );

void XUTILRegisterWMDelete(
         Widget   shell_wgt );

void XUTILXtPopup( Widget popup_shell, XtGrabKind grab_kind, 
                   Widget toplevel );

TV_BOOL XUTILXServerIsLocal( Display *display );

void XUTILDetermineFrameBufferVisual( Display      *display,
                                      int           screen,
                                      XVisualInfo **fb_visual );

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif
