/*
 * app_rsrc.h
 *
 * Application resources for FXTV
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __APP_RSRC_H
#define __APP_RSRC_H

#include <X11/Intrinsic.h>

/***************************/
/*  APPLICATION RESOURCES  */
/***************************/

typedef struct _AppResources {
    Boolean  driver_defaults;
    Boolean  colorbars;
    float    hue;
    float    brightness;
    float    contrast;
    float    sat_u;
    float    sat_v;
	String   debug;
    int      device_number;
    String   input_format;
    String   tuner_mode;

    String   def_chan;
    String   def_input;
    String   def_audio_input;
    int      display_fps;
    Boolean  aspect_lock;

    String   cable_station_list;
    String   ant_station_list;
    String   cable_freq_set;
    String   ant_freq_set;

    Boolean  do_audio;
    String   dsp_device;
    String   mixer_device;
    String   mixer_channel;

    String   rec_cmd_mpeg2;
    String   rec_cmd_mpeg3;
    String   play_cmd_mpeg2;
    String   play_cmd_mpeg3;

    String   video_cnvt_script;

    Boolean  bswap2Bpp;
    Boolean  bswap3Bpp;
    Boolean  bswap4Bpp;
    Boolean  wswap4Bpp;

    int      Bpp_24bit;
    int      Bpp_32bit;

    Boolean  afc_mode;
    Boolean  disable_direct_v;
    String   remote_type;             /*  Type of Remote Control attached  */

    String   video_cap_file[4];

    String   station_annot_font;
    Pixel    station_annot_color;
    int      station_annot_delay;
    Boolean  station_annot_idonly;

    String   tuner_mode_annot_font;
    Pixel    tuner_mode_annot_color;
    int      tuner_mode_annot_delay;

    String   input_dev_annot_font;
    Pixel    input_dev_annot_color;
    int      input_dev_annot_delay;

    String   volume_annot_font;
    Pixel    volume_annot_color;
    int      volume_annot_delay;

    String   mute_annot_font;
    Pixel    mute_annot_color;
    int      mute_annot_delay;

    Boolean  station_in_win_title;
    Boolean  station_in_win_icon;

    Boolean  help;

} AppResources;

#ifndef DEFINE_APP_RESOURCES

extern AppResources     App_res;

#else

#define RNdeviceNumber      "deviceNumber"
#define RCdeviceNumber      "DeviceNumber"
#define RNcolorbars         "colorbars"
#define RCcolorbars         "Colorbars"
#define RNhue               "hue"
#define RChue               "Hue"
#define RNbrightness        "brightness"
#define RCbrightness        "Brightness"
#define RNcontrast          "contrast"
#define RCcontrast          "Contrast"
#define RNsatU              "satU"
#define RCsatU              "SatU"
#define RNsatV              "satV"
#define RCsatV              "SatV"
#define RNdebug             "debug"
#define RCdebug             "Debug"
#define RNdriverDefaults    "driverDefaults"
#define RCdriverDefaults    "DriverDefaults"
#define RNinputFormat       "inputFormat"
#define RCinputFormat       "InputFormat"
#define RNtunerMode         "tunerMode"
#define RCtunerMode         "TunerMode"
#define RNdefaultChannel    "defaultChannel"
#define RCdefaultChannel    "DefaultChannel"
#define RNdefaultInput      "defaultInput"
#define RCdefaultInput      "DefaultInput"
#define RNdefaultAudioInput "defaultAudioInput"
#define RCdefaultAudioInput "DefaultAudioInput"
#define RNfps               "fps"
#define RCfps               "Fps"
#define RNaspectLock        "aspectLock"
#define RCaspectLock        "AspectLock"
#define RNcableStatList     "cableStationList"
#define RCcableStatList     "StationList"
#define RNantennaStatList   "antennaStationList"
#define RCantennaStatList   "StationList"
#define RNantennaFreqSet    "antennaFreqSet"
#define RCantennaFreqSet    "FreqSet"
#define RNcableFreqSet      "cableFreqSet"
#define RCcableFreqSet      "FreqSet"
                            
#define RNdoAudio           "doAudio"
#define RCdoAudio           "DoAudio"
#define RNdspDevice         "dspDevice"
#define RNmixerDevice       "mixerDevice"
#define RCaudioDevice       "AudioDevice"
#define RNmixerChannel      "mixerChannel"
#define RCmixerChannel      "MixerChannel"
                            
#define RNrecCmdMpeg2       "recCmdMpeg2"
#define RNrecCmdMpeg3       "recCmdMpeg3"
#define RCrecCmd            "recCmd"
#define RNplayCmdMpeg2      "playCmdMpeg2"
#define RNplayCmdMpeg3      "playCmdMpeg3"
#define RCplayCmd           "playCmd"
                            
#define RNvideoCnvtScript   "videoCnvtScript"
#define RCvideoCnvtScript   "VideoCnvtScript"

#define RCswap              "Swap"
#define RNbswap2Bpp         "bswap2Bpp"
#define RNbswap3Bpp         "bswap3Bpp"
#define RNbswap4Bpp         "bswap4Bpp"
#define RNwswap4Bpp         "wswap4Bpp"

#define RCBpp               "Bpp"
#define RNBpp24bit          "Bpp24bit"
#define RNBpp32bit          "Bpp32bit"

#define RNafc               "afc"
#define RCafc               "Afc"

#define RNdisableDirectV    "disableDirectV"
#define RCdisableDirectV    "DisableDirectV"

#define RNremoteType        "remoteType"
#define RCremoteType        "RemoteType"

#define RNhelp              "help"
#define RChelp              "Help"

#define RNvideoCapFile1     "videoCapFile1"
#define RNvideoCapFile2     "videoCapFile2"
#define RNvideoCapFile3     "videoCapFile3"
#define RNvideoCapFile4     "videoCapFile4"
#define RCvideoCapFile      "videoCapFile"

#define RCannotFont            "AnnotFont"
#define RCannotColor           "AnnotColor"
#define RCannotDelay           "AnnotDelay"
#define RNstationAnnotFont     "stationAnnotFont"
#define RNstationAnnotColor    "stationAnnotColor"
#define RNstationAnnotDelay    "stationAnnotDelay"
#define RNstationAnnotIDOnly   "stationAnnotIDOnly"
#define RNtunerModeAnnotFont   "tunerModeAnnotFont"
#define RNtunerModeAnnotColor  "tunerModeAnnotColor"
#define RNtunerModeAnnotDelay  "tunerModeAnnotDelay"
#define RNinputDevAnnotFont    "inputDevAnnotFont"
#define RNinputDevAnnotColor   "inputDevAnnotColor"
#define RNinputDevAnnotDelay   "inputDevAnnotDelay"
#define RNvolumeAnnotFont      "volumeAnnotFont"
#define RNvolumeAnnotColor     "volumeAnnotColor"
#define RNvolumeAnnotDelay     "volumeAnnotDelay"
#define RNmuteAnnotFont        "muteAnnotFont"
#define RNmuteAnnotColor       "muteAnnotColor"
#define RNmuteAnnotDelay       "muteAnnotDelay"

#define RNstationInWinTitle    "stationInWinTitle"
#define RCstationInWinTitle    "StationInWinTitle"

#define RNstationInWinIcon     "stationInWinIcon"
#define RCstationInWinIcon     "StationInWinIcon"

AppResources     App_res;

#define pFALSE  ((caddr_t) "False")
#define pTRUE   ((caddr_t) "True" )

static XrmOptionDescRec Cmd_line_options[] = {
   { "-driverDefaults"     , RNdriverDefaults , XrmoptionNoArg , pTRUE       },
   { "-colorbars"          , RNcolorbars      , XrmoptionNoArg , pTRUE       },
   { "-hue"                , RNhue            , XrmoptionSepArg, NULL        },
   { "-brightness"         , RNbrightness     , XrmoptionSepArg, NULL        },
   { "-contrast"           , RNcontrast       , XrmoptionSepArg, NULL        },
   { "-satU"               , RNsatU           , XrmoptionSepArg, NULL        },
   { "-satV"               , RNsatV           , XrmoptionSepArg, NULL        },
   { "-debug"              , RNdebug          , XrmoptionSepArg, NULL        },
   { "-deviceNumber"       , RNdeviceNumber   , XrmoptionSepArg, NULL        },
   { "-inputFormat"        , RNinputFormat    , XrmoptionSepArg, NULL        },
   { "-noaspectlock"       , RNaspectLock     , XrmoptionNoArg , pFALSE      },
   { "-tunerMode"          , RNtunerMode      , XrmoptionSepArg, NULL        },
   { "-defaultChannel"     , RNdefaultChannel , XrmoptionSepArg, NULL        },
   { "-defaultInput"       , RNdefaultInput   , XrmoptionSepArg, NULL        },
   { "-defaultAudioInput"  , RNdefaultAudioInput, XrmoptionSepArg, NULL      },
   { "-cableStationList"   , RNcableStatList  , XrmoptionSepArg, NULL        },
   { "-antennaStationList" , RNantennaStatList, XrmoptionSepArg, NULL        },
   { "-cableFreqSet"       , RNcableFreqSet   , XrmoptionSepArg, NULL        },
   { "-antennaFreqSet"     , RNantennaFreqSet , XrmoptionSepArg, NULL        },

   { "-noaudio"            , RNdoAudio        , XrmoptionNoArg , pFALSE      },
   { "-noAudio"            , RNdoAudio        , XrmoptionNoArg , pFALSE      },
   { "-doAudio"            , RNdoAudio        , XrmoptionNoArg , pTRUE       },
   { "-dspDevice"          , RNdspDevice      , XrmoptionSepArg, NULL        },
   { "-mixerDevice"        , RNmixerDevice    , XrmoptionSepArg, NULL        },
   { "-mixerChannel"       , RNmixerChannel   , XrmoptionSepArg, NULL        },
                                                                             
   { "-recCmdMpeg2"        , RNrecCmdMpeg2    , XrmoptionSepArg, NULL        },
   { "-recCmdMpeg3"        , RNrecCmdMpeg3    , XrmoptionSepArg, NULL        },
   { "-playCmdMpeg2"       , RNplayCmdMpeg2   , XrmoptionSepArg, NULL        },
   { "-playCmdMpeg3"       , RNplayCmdMpeg3   , XrmoptionSepArg, NULL        },

   { "-videoCnvtScript"    , RNvideoCnvtScript, XrmoptionSepArg, NULL        },
                                                                             
   { "-bswap2Bpp"          , RNbswap2Bpp      , XrmoptionNoArg , pTRUE       },
   { "-nobswap2Bpp"        , RNbswap2Bpp      , XrmoptionNoArg , pFALSE      },
   { "-bswap3Bpp"          , RNbswap3Bpp      , XrmoptionNoArg , pTRUE       },
   { "-nobswap3Bpp"        , RNbswap3Bpp      , XrmoptionNoArg , pFALSE      },
   { "-bswap4Bpp"          , RNbswap4Bpp      , XrmoptionNoArg , pTRUE       },
   { "-nobswap4Bpp"        , RNbswap4Bpp      , XrmoptionNoArg , pFALSE      },
   { "-bwwap4Bpp"          , RNwswap4Bpp      , XrmoptionNoArg , pTRUE       },
                                                                          
   { "-Bpp24bit"           , RNBpp24bit       , XrmoptionSepArg, NULL        },
   { "-Bpp32bit"           , RNBpp32bit       , XrmoptionSepArg, NULL        },
                                                                             
   { "-noafc"              , RNafc            , XrmoptionNoArg , pFALSE      },
   { "-disableDirectV"     , RNdisableDirectV , XrmoptionNoArg , pTRUE       },
   { "-remoteType"         , RNremoteType     , XrmoptionSepArg, NULL        },
                                                                             
   { "-videoCapFile1"      , RNvideoCapFile1  , XrmoptionSepArg, NULL        },
   { "-videoCapFile2"      , RNvideoCapFile2  , XrmoptionSepArg, NULL        },
   { "-videoCapFile3"      , RNvideoCapFile3  , XrmoptionSepArg, NULL        },
   { "-videoCapFile4"      , RNvideoCapFile4  , XrmoptionSepArg, NULL        },
                                                                           
   { "-stationAnnotFont"   , RNstationAnnotFont   , XrmoptionSepArg, NULL    },
   { "-stationAnnotColor"  , RNstationAnnotColor  , XrmoptionSepArg, NULL    },
   { "-stationAnnotDelay"  , RNstationAnnotDelay  , XrmoptionSepArg, NULL    },
   { "-stationAnnotIDOnly" , RNstationAnnotIDOnly , XrmoptionNoArg , pTRUE   },
   { "-tunerModeAnnotFont" , RNtunerModeAnnotFont , XrmoptionSepArg, NULL    },
   { "-tunerModeAnnotColor", RNtunerModeAnnotColor, XrmoptionSepArg, NULL    },
   { "-tunerModeAnnotDelay", RNtunerModeAnnotDelay, XrmoptionSepArg, NULL    },
   { "-inputDevAnnotFont"  , RNinputDevAnnotFont  , XrmoptionSepArg, NULL    },
   { "-inputDevAnnotColor" , RNinputDevAnnotColor , XrmoptionSepArg, NULL    },
   { "-inputDevAnnotDelay" , RNinputDevAnnotDelay , XrmoptionSepArg, NULL    },
   { "-volumeAnnotFont"    , RNvolumeAnnotFont    , XrmoptionSepArg, NULL    },
   { "-volumeAnnotColor"   , RNvolumeAnnotColor   , XrmoptionSepArg, NULL    },
   { "-volumeAnnotDelay"   , RNvolumeAnnotDelay   , XrmoptionSepArg, NULL    },
   { "-muteAnnotFont"      , RNmuteAnnotFont      , XrmoptionSepArg, NULL    },
   { "-muteAnnotColor"     , RNmuteAnnotColor     , XrmoptionSepArg, NULL    },
   { "-muteAnnotDelay"     , RNmuteAnnotDelay     , XrmoptionSepArg, NULL    },

   { "-remoteType"         , RNremoteType     , XrmoptionSepArg, NULL        },

   { "-stationInWinTitle"  , RNstationInWinTitle  , XrmoptionNoArg , pTRUE   },
   { "-stationInWinIcon"   , RNstationInWinIcon   , XrmoptionNoArg , pTRUE   },

   { "-help"          , RNhelp           , XrmoptionNoArg , (caddr_t) "True"  },
#ifdef DEBUG
   { "-fps"           , RNfps            , XrmoptionSepArg, NULL              },
#endif
};

static XtResource Resources[] = {
    { RNdriverDefaults, RCdriverDefaults, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, driver_defaults), XtRImmediate,
        (XtPointer) False },
    { RNcolorbars, RCcolorbars, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, colorbars), XtRImmediate,
        (XtPointer) False },
    { RNhue, RChue, XtRFloat, sizeof(float),
        XtOffsetOf(AppResources, hue), XtRString, 
        "0.0" },
    { RNbrightness, RCbrightness, XtRFloat, sizeof(float),
        XtOffsetOf(AppResources, brightness), XtRString, 
        "0.0" },
    { RNcontrast  , RCcontrast  , XtRFloat, sizeof(float),
        XtOffsetOf(AppResources, contrast  ), XtRString,
        "100.0" },
    { RNsatU  , RCsatU  , XtRFloat, sizeof(float),
        XtOffsetOf(AppResources, sat_u     ), XtRString,
        "100.0" },
    { RNsatV  , RCsatV  , XtRFloat, sizeof(float),
        XtOffsetOf(AppResources, sat_v     ), XtRString,
        "100.0" },
    { RNdebug, RCdebug, XtRString, sizeof(String),
        XtOffsetOf(AppResources, debug     ), XtRImmediate,
        "" },
    { RNdeviceNumber, RCdeviceNumber, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, device_number), XtRString,
        "0" },
    { RNinputFormat, RCinputFormat, XtRString, sizeof(String),
        XtOffsetOf(AppResources, input_format    ), XtRImmediate,
        "ntsc" },
    { RNtunerMode, RCtunerMode, XtRString, sizeof(String),
        XtOffsetOf(AppResources, tuner_mode      ), XtRImmediate,
        "antenna" },
    { RNdefaultChannel, RCdefaultChannel, XtRString, sizeof(String),
        XtOffsetOf(AppResources, def_chan), XtRImmediate,
        "0" /*  0 = Don't change channel */ },   
    { RNdefaultInput, RCdefaultInput, XtRString, sizeof(String),
        XtOffsetOf(AppResources, def_input), XtRImmediate,
        "" },
    { RNdefaultAudioInput, RCdefaultAudioInput, XtRString, sizeof(String),
        XtOffsetOf(AppResources, def_audio_input), XtRImmediate,
        "" },
    { RNfps, RCfps, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, display_fps), XtRString,
        "-1" /* -1 = Max FPS  */ },
    { RNaspectLock, RCaspectLock, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, aspect_lock), XtRImmediate,
        (XtPointer) False },

    { RNcableStatList, RCcableStatList, XtRString, sizeof(String),
        XtOffsetOf(AppResources, cable_station_list ), XtRImmediate,
        ""  },
    { RNantennaStatList, RCantennaStatList, XtRString, sizeof(String),
        XtOffsetOf(AppResources, ant_station_list ), XtRImmediate,
        ""  },
    { RNcableFreqSet, RCcableFreqSet, XtRString, sizeof(String),
        XtOffsetOf(AppResources, cable_freq_set ), XtRImmediate,
        "cableirc"  },
    { RNantennaFreqSet, RCantennaFreqSet, XtRString, sizeof(String),
        XtOffsetOf(AppResources, ant_freq_set ), XtRImmediate,
        "nabcst"  },

    { RNdoAudio, RCdoAudio, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, do_audio), XtRImmediate,
        (XtPointer) True },
    { RNdspDevice, RCaudioDevice, XtRString, sizeof(String),
        XtOffsetOf(AppResources, dsp_device ), XtRImmediate,
        "/dev/dsp"  },
    { RNmixerDevice, RCaudioDevice, XtRString, sizeof(String),
        XtOffsetOf(AppResources, mixer_device ), XtRImmediate,
        "/dev/mixer"  },
    { RNmixerChannel, RCmixerChannel, XtRString, sizeof(String),
        XtOffsetOf(AppResources, mixer_channel ), XtRImmediate,
        "line"  },

    { RNrecCmdMpeg2, RCrecCmd, XtRString, sizeof(String),
        XtOffsetOf(AppResources, rec_cmd_mpeg2 ), XtRImmediate,
        "mpeg_musicin -l 2 -p 1"  },
    { RNrecCmdMpeg3, RCrecCmd, XtRString, sizeof(String),
        XtOffsetOf(AppResources, rec_cmd_mpeg3 ), XtRImmediate,
        "mpeg_musicin -l 3 -p 2"  },
    { RNplayCmdMpeg2, RCplayCmd, XtRString, sizeof(String),
        XtOffsetOf(AppResources, play_cmd_mpeg2 ), XtRImmediate,
        "mpg123"  },
    { RNplayCmdMpeg3, RCplayCmd, XtRString, sizeof(String),
        XtOffsetOf(AppResources, play_cmd_mpeg3 ), XtRImmediate,
        "mpg123"  },

    { RNvideoCnvtScript, RCvideoCnvtScript, XtRString, sizeof(String),
        XtOffsetOf(AppResources, video_cnvt_script ), XtRImmediate,
        X11BASE "/lib/X11/fxtv/fxtv_cnvt.sh"  },

    { RNbswap2Bpp, RCswap, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, bswap2Bpp), XtRImmediate,
        (XtPointer) True },
    { RNbswap3Bpp, RCswap, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, bswap3Bpp), XtRImmediate,
        (XtPointer) False },
    { RNbswap4Bpp, RCswap, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, bswap4Bpp), XtRImmediate,
        (XtPointer) True },
    { RNwswap4Bpp, RCswap, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, wswap4Bpp), XtRImmediate,
        (XtPointer) True },

    { RNBpp24bit, RCBpp, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, Bpp_24bit), XtRString,
        "-1" /*  0 = Guess */ },   
    { RNBpp32bit, RCBpp, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, Bpp_32bit), XtRString,
        "-1" /*  0 = Guess */ },   

    { RNafc, RCafc, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, afc_mode), XtRImmediate,
        (XtPointer) True },
    { RNdisableDirectV, RCdisableDirectV, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, disable_direct_v), XtRImmediate,
        (XtPointer) False },

    { RNremoteType, RCremoteType, XtRString, sizeof(String),
        XtOffsetOf(AppResources, remote_type ), XtRImmediate, 
        "None"  },

    { RNstationInWinTitle, RCstationInWinTitle, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, station_in_win_title), XtRImmediate,
        (XtPointer) False },
    { RNstationInWinIcon, RCstationInWinIcon, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, station_in_win_icon), XtRImmediate,
        (XtPointer) False },

    { RNvideoCapFile1, RCvideoCapFile, XtRString, sizeof(String),
        XtOffsetOf(AppResources, video_cap_file[0] ), XtRImmediate, 
        ""  },
    { RNvideoCapFile2, RCvideoCapFile, XtRString, sizeof(String),
        XtOffsetOf(AppResources, video_cap_file[1] ), XtRImmediate, 
        ""  },
    { RNvideoCapFile3, RCvideoCapFile, XtRString, sizeof(String),
        XtOffsetOf(AppResources, video_cap_file[2] ), XtRImmediate, 
        ""  },
    { RNvideoCapFile4, RCvideoCapFile, XtRString, sizeof(String),
        XtOffsetOf(AppResources, video_cap_file[3] ), XtRImmediate, 
        ""  },

    { RNstationAnnotFont, RCannotFont, XtRString, sizeof(String),
        XtOffsetOf(AppResources, station_annot_font ), XtRImmediate, 
        "-adobe-utopia-regular-r-*-*-0-0-*-*-*-0-iso8859-1"  },
    { RNstationAnnotColor, RCannotColor, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, station_annot_color ), XtRString, 
        "Green"  },
    { RNstationAnnotDelay, RCannotDelay, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, station_annot_delay ), XtRString, 
        "2000" },
    { RNstationAnnotIDOnly, XtCBoolean, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, station_annot_idonly), XtRImmediate,
        (XtPointer) False },

    { RNtunerModeAnnotFont, RCannotFont, XtRString, sizeof(String),
        XtOffsetOf(AppResources, tuner_mode_annot_font ), XtRImmediate, 
        "-adobe-utopia-regular-r-*-*-0-0-*-*-*-0-iso8859-1"  },
    { RNtunerModeAnnotColor, RCannotColor, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, tuner_mode_annot_color ), XtRString, 
        "Green"  },
    { RNtunerModeAnnotDelay, RCannotDelay, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, tuner_mode_annot_delay ), XtRString, 
        "2000" },

    { RNinputDevAnnotFont, RCannotFont, XtRString, sizeof(String),
        XtOffsetOf(AppResources, input_dev_annot_font ), XtRImmediate, 
        "-adobe-utopia-regular-r-*-*-0-0-*-*-*-0-iso8859-1"  },
    { RNinputDevAnnotColor, RCannotColor, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, input_dev_annot_color ), XtRString, 
        "Green"  },
    { RNinputDevAnnotDelay, RCannotDelay, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, input_dev_annot_delay ), XtRString, 
        "2000" },

    { RNvolumeAnnotFont, RCannotFont, XtRString, sizeof(String),
        XtOffsetOf(AppResources, volume_annot_font ), XtRImmediate, 
        "-adobe-utopia-regular-r-*-*-0-0-*-*-*-0-iso8859-1"  },
    { RNvolumeAnnotColor, RCannotColor, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, volume_annot_color ), XtRString, 
        "Green"  },
    { RNvolumeAnnotDelay, RCannotDelay, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, volume_annot_delay ), XtRString, 
        "2000" },

    { RNmuteAnnotFont, RCannotFont, XtRString, sizeof(String),
        XtOffsetOf(AppResources, mute_annot_font ), XtRImmediate, 
        "-adobe-utopia-regular-r-*-*-0-0-*-*-*-0-iso8859-1"  },
    { RNmuteAnnotColor, RCannotColor, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, mute_annot_color ), XtRString, 
        "Red"  },
    { RNmuteAnnotDelay, RCannotDelay, XtRInt, sizeof(int),
        XtOffsetOf(AppResources, mute_annot_delay ), XtRString, 
        "-1" },

    { RNhelp, RChelp, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(AppResources, help), XtRImmediate,
        (XtPointer) False },

};


#define OPTION_HELP_STR "\
                      BSD X TV (fxtv), Version " VERS_STR ".  
                         Written by Randall Hopper

Please mail Fxtv and Bt848 driver-related comments and help requests to the
multimedia@freebsd.org list.  Feel free to subscribe and contribute 
(listserv: majordomo@freebsd.org).

Available options:

-driverDefaults             - Use appearance parms from driver on startup
-colorbars                  - Turn on colorbar display (for testing)
-hue [-90...90]             - Initial Hue           ; def=0
-brightness [-50..50]       - Initial Brightness (%); def=0
-contrast [0..200]          - Initial Contrast   (%); def=100
-satU [0..200]              - U Saturation       (%); def=100
-satV [0..284]              - V Saturation       (%); def=100
-aspectlock                 - Enable 4:3 aspect lock on video window

-deviceNumber <#>           - bktr/tuner device numbers; def=0      
-inputFormat <fmt>          - Tuner signal input format (ntsc,ntscm,ntscj,
                                 palbdghi,pal,palm,paln,secam,palncomb,rsvd)

-tunerMode [cable|antenna]  - Tuner Mode
-defaultInput <input>       - Startup tuner signal input 
                                 [tuner|video|svideo|csvideo|dev3]
-defaultAudioInput <input>  - Startup TV card audio input 
                                 [tuner|external|internal|auto]
-defaultChannel <#>         - Startup Channel Number
-cableStationList   <...>   - List of cable station presets (see rsrc file)
-antennaStationList <...>   - List of antenna station presets
-cableFreqSet   <freqset>   - Freq set for cable   (def = cableirc)
                              [nabcst|cableirc|cablehrc|weurope|jpnbcst|
                               jpncable|xussr|australia|france]
-antennaFreqSet <freqset>   - Freq set for antenna (def = nabcst)

-noAudio                    - Suppress playing audio through soundcard
-dspDevice                  - Override default DSP device   (def=/dev/dsp)
-mixerDevice                - Override default mixer device (def=/dev/mixer)
-mixerChannel               - Audio mixer (line,line1/2/3,cd,mic,video)

-stationInWinTitle          - Display station text in window title
-stationInWinIcon           - Display station text in window icon

-stationAnnotFont <fontpat> - Font pattern for station annot (see rsrc file)
-stationAnnotColor <color>  - Color for station annot
-stationAnnotDelay <msec>   - How long to display (0 = never; -1 = always)
-stationAnnotIDOnly         - Display station ID alone (when available)

-tunerModeAnnot{Font,Color,Delay}
-inputDevAnnot{Font,Color,Delay}
-volumeDevAnnot{Font,Color,Delay}
-muteDevAnnot{Font,Color,Delay}
                            - Other annotation options (see stationAnnot)

-remoteType                 - Type of attached remote control 
                              [None|X10|Hauppauge|PixelView]

-recCmdMpeg2                - MPEG-2 Audio record command 
-recCmdMpeg3                - MPEG-3 Audio record command
-playCmdMpeg2               - MPEG-2 Audio play   command
-playCmdMpeg3               - MPEG-3 Audio play   command

-videoCnvtScript            - Video conversion workhorse script for vid encod.

-bswap2Bpp                  - Byte/word swap options for direct video
-nobswap2Bpp                  (used to match driver's pixel format with
-bswap3Bpp                    the video card's)
-nobswap3Bpp
-bswap4Bpp                        2Bpp - 15/16-bpp modes
-nobswap4Bpp                      3Bpp - packed 24bpp modes
-bwwap4Bpp                        4Bpp - unpacked 24bpp modes
-nowswap4Bpp

-Bpp24bit [3|4]             - Set frame buffer Bytes-per-pixel for 24bpp mode
-Bpp32bit [3|4]             - Set frame buffer Bytes-per-pixel for 32bpp mode

-videoCapFile[1-4]          - Optional paths (0-4) to scratch file paths to 
                              use for video capture; spreads load across disks

-noafc                      - Disable AFC
-disableDirectV             - Disable DMA transfers straight to video card
-debug <area>               - Debug Msgs 
                              {startup,driver,subproc,events,video,frame}
-help                       - Display program options

NOTE:  All command line options are accessible as X resources as well.
       The X resources have the same names as the command-line options.
       See the sample Fxtv class resource file for details.
"

static String fallback_resources[] = { 
 /*"Fxtv.geometry: +10+10",*/
   "Fxtv.title:    BSD TV " VERS_STR,
   "Fxtv.iconName: FXTV",

    /* Menubar appearance */
   "*allowResize: True",
   "*allowShellResize: True",
   "*menuBox*background:                      SteelBlue3",
   "*menuBox*foreground:                      Black",
   "*menuBox*MenuButton.borderWidth:          1",
   "*menuBox.vSpace:                          0",
   "*menuBox*SimpleMenu*Cursor:	              hand2",
   "*menuBox*SimpleMenu*borderWidth:          1",
   "*menuBox*SimpleMenu*borderColor:	      #c0c0c0",
   "*menuBox*SimpleMenu*vertSpace:            10",
   "*menuBox*SimpleMenu*menuLabel.foreground: Gold",
   "*menuBox*SimpleMenu*menuLabel.vertSpace:  100",
   "*menuBox*SimpleMenu*SmeBSB.height:        50",
   "*menuBox*SimpleMenu*SmeLine.foreground:   Black",
   "*menuBox*SimpleMenuCommand.foreground:    Black",
   "*menuBox*SimpleMenu*HorizontalMargins:    20",
   "*menuBox*font:                            *lucida*bold-r-*12*iso8859-1",

   /*  Menubar strings & accelerators  */
   "*menuBox*fileMenu.label:                  File",
   "*menuBox*fileMenu.menu.label:             File",
   "*menuBox*fileMenu*imgSavCmd.label:        Save Image",
   "*menuBox*fileMenu*imgSavAsCmd.label:      Save Image As...",
   "*menuBox*fileMenu*audSavAsCmd.label:      Save Audio As...",
   "*menuBox*fileMenu*vidSavAsCmd.label:      Save Video As...",
   "*menuBox*fileMenu*printCmd.label:         Print",
   "*menuBox*fileMenu*printSetupCmd.label:    Print Setup...",
   "*menuBox*fileMenu*quitCmd.label:          Quit",
   "*menuBox*fileMenu*quitCmd.accelerators:   <Key>q: notify()",

   "*menuBox*inputMenu.label:                 Input",
   "*menuBox*inputMenu.menu.label:            Input",
   "*menuBox*inputMenu*tunerCmd.label:        Tuner",
   "*menuBox*inputMenu*videoCmd.label:        Video",
   "*menuBox*inputMenu*svideoCmd.label:       S-Video",
   "*menuBox*inputMenu*csvideoCmd.label:      CS-Video",
   "*menuBox*inputMenu*dev3.label:            Device 3",
   "*menuBox*inputMenu*tmodeAntenna.label:    Antenna",
   "*menuBox*inputMenu*audInpAuto.label:      Audio Auto",
   "*menuBox*inputMenu*audInpIntern.label:    Audio Internal",
   "*menuBox*inputMenu*appearanceCmd.label:   Appearance...",

   "*menuBox*formatMenu.label:                Format",
   "*menuBox*formatMenu.menu.label:           Format",
   "*menuBox*formatMenu*ntscmFmt.label:       NTSC/M",
   "*menuBox*formatMenu*ntscjFmt.label:       NTSC/J",
   "*menuBox*formatMenu*palbdghiFmt.label:    PAL/BDGHI",
   "*menuBox*formatMenu*palmFmt.label:        PAL/M",
   "*menuBox*formatMenu*palnFmt.label:        PAL/N",
   "*menuBox*formatMenu*secamFmt.label:       SECAM",
   "*menuBox*formatMenu*palncombFmt.label:    PAL/N Comb",

   "*menuBox*optionsMenu.label:               Options",
   "*menuBox*optionsMenu.menu.label:          Options",
   "*menuBox*optionsMenu*aspectLockCmd.label: Aspect Lock",
   "*menuBox*optionsMenu*fieldSkipCmd.label:  Field Skip",
   "*menuBox*optionsMenu*captureToCmd.label:  Capture To...",
   "*menuBox*optionsMenu*saveOptionsCmd.label:Save Options",
   "*menuBox*optionsMenu*setAfcCmd.label:     AFC",

   "*menuBox*helpMenu.label:                  Help",
   "*menuBox*helpMenu.menu.label:             Help",
   "*menuBox*helpMenu*aboutCmd.label:         About",

   /*  Toolbar appearance */
   "*toolBox*background:                      Gray71",
   "*toolBox*channelText*background:          Gray60",
   "*toolBox*channelText*foreground:          Black",
   "*toolBox*foreground:                      Gray71",
   "*toolBox*font:                            *lucida*bold-r-*12*iso8859-1",

   /*  Toolbar pixmaps & accelerators  */
   "*toolBox*freezeToggle.pixmap:             mini-camera.xpm",
   "*toolBox*saveCmd.pixmap:                  mini-ofolder.xpm",
   "*toolBox*fullScreenCmd.pixmap:            mini-resize.xpm",
   "*toolBox*channelDnCmd.pixmap:             mini-down.xbm",
   "*toolBox*channelUpCmd.pixmap:             mini-up.xbm",
   "*toolBox*channelText.width:               50",
   "*toolBox*channelText.height:              22",
   "*toolBox*spacer.width:                    10",
   "*toolBox*spacer.height:                   2",
   "*toolBox*spacer.borderWidth:              0",
   "*toolBox*muteToggle.pixmap:               mini-sound.xbm",
   "*toolBox*muteToggle.state:                True",  /*  FIXME  */
   "*toolBox*volumeForm.vertDistance:         0",
   "*toolBox*volumeForm.horizDistance:        0",
   "*toolBox*volumeScrollbar.width:           75",
   "*toolBox*volumeScrollbar.height:          15",
   "*toolBox*SimpleMenu*Cursor:               hand2",
   "*toolBox*SimpleMenu*HorizontalMargins:    20",

   /*  Video window appearance */
   "*videoWin*background:                     Black",

   "*videoWin.baseTranslations: #override         "
   "<Btn1Down>       : TVToggleZoom( fullscreen ) \\n"
   "<Btn3Down>       : TVToggleZoom( window )     \\n"
   "<Key>z           : TVToggleZoom( fullscreen ) \\n"
   "<Key>Return      : TVToggleZoom( fullscreen ) \\n"
   "<Key>KP_Enter    : TVToggleZoom( fullscreen ) \\n"
   "<Key>F9          : TVSetStation( -f )         \\n"
   "<Key>F10         : TVSetStation( +f )         \\n"
   "<Key>+           : TVSetStation( +1 )         \\n"
   "<Key>-           : TVSetStation( -1 )         \\n"
   "<Key>KP_Add      : TVSetStation( +1 )         \\n"
   "<Key>KP_Subtract : TVSetStation( -1 )         \\n"
   "<Key>KP_Right    : TVSetVolume( +1 )          \\n"
   "<Key>KP_Left     : TVSetVolume( -1 )          \\n"
   "<Key>KP_Insert   : TVToggleMute()             \\n"
   "<Key>KP_Divide   : TVSetCaptureInput( +1 )    \\n"
   "<Key>KP_Multiply : TVSetTunerMode( +1 )       \\n"
   "<Key>F2          : TVSaveImage()",

   /*  "Input Appearance Params" dialog appearance */
   "*inputAppearDialog*background:                 Gray71",
   "*inputAppearDialog*Scrollbar.width:            300",
   "*inputAppearDialog*Scrollbar.height:           15",
   "*inputAppearDialog*borderWidth:                0",
   "*inputAppearDialog*Scrollbar.background:       Gray60",
   "*inputAppearDialog*groupBox.borderWidth:       1",
   "*inputAppearDialog*headerBox.vSpace:           0",
   "*inputAppearDialog*scrollBox.vSpace:           0",
   "*inputAppearDialog*Text*background:            Gray60",
   "*inputAppearDialog*Text*foreground:            Black",
   "*inputAppearDialog*Text.borderWidth:           1",
   "*inputAppearDialog*Text.width:                 40",
   "*inputAppearDialog*okCmd.width:                100",
   "*inputAppearDialog*okCmd.horizDistance:        160",

   /*  "Input Appearance Params" dialog strings */
   "*inputAppearDialog.title:                      FXTV Appearance",
   "*inputAppearDialog.iconName:                   FXTV Appearance",
   "*inputAppearDialog*okCmd.label:                OK",
   "*inputAppearDialog*hueTitleLabel.label:        Hue:",
   "*inputAppearDialog*brightTitleLabel.label:     Brightness:",
   "*inputAppearDialog*contrTitleLabel.label:      Contrast:",
   "*inputAppearDialog*satUTitleLabel.label:       Chroma U:",
   "*inputAppearDialog*satVTitleLabel.label:       Chroma V:",
   "*inputAppearDialog*scrollBox*Label.label:      -200%",

   /*  "Image Save Params" dialog appearance */
   "*imageSaveDialog*background:                   Gray71",
   "*imageSaveDialog*borderWidth:                  0",
   "*imageSaveDialog*groupBox.borderWidth:         1",
   "*imageSaveDialog*headerBox.vSpace:             0",
   "*imageSaveDialog*Text*background:              Gray60",
   "*imageSaveDialog*Text*foreground:              Black",
   "*imageSaveDialog*Text.borderWidth:             1",
   "*imageSaveDialog*Text.width:                   300",
   "*imageSaveDialog*Toggle.width:                 16",
   "*imageSaveDialog*Toggle.height:                16",
   "*imageSaveDialog*Toggle.horizDistance:         40",
   "*imageSaveDialog*formatButton*width:           150",
   "*imageSaveDialog*formatMenu*width:             150",
   "*imageSaveDialog*formatMenu*borderWidth:       1",
   "*imageSaveDialog*formatMenuBox.borderWidth:    0",
   "*imageSaveDialog*formatMenuBox.vSpace:         0",
   "*imageSaveDialog*okCmd.width:                  100",
   "*imageSaveDialog*okCmd.horizDistance:          90",

   /*  "Image Save Params" dialog strings */
   "*imageSaveDialog.title:                        FXTV Save Image As",
   "*imageSaveDialog.iconName:                     FXTV Save Image As",
   "*imageSaveDialog*fileBaseLabel.label:          Filename Base:",
   "*imageSaveDialog*suffixLabel.label:            Append Img # Suffix",
   "*imageSaveDialog*formatLabel.label:            Format:",
   "*imageSaveDialog*formatMenuBox*tiffCmd.label:  TIFF",
   "*imageSaveDialog*formatMenuBox*ppmCmd.label:   PPM",
   "*imageSaveDialog*okCmd.label:                  OK",

   /*  "Audio Save Control" dialog appearance */
   "*audioSaveDialog*background:                   Gray71",
   "*audioSaveDialog*borderWidth:                  0",
   "*audioSaveDialog*groupBox.borderWidth:         1",
   "*audioSaveDialog*headerBox.vSpace:             0",
   "*audioSaveDialog*fileBox*Label.width:          90",
   "*audioSaveDialog*Text*background:              Gray60",
   "*audioSaveDialog*Text*foreground:              Black",
   "*audioSaveDialog*Text.borderWidth:             1",
   "*audioSaveDialog*Text.width:                   150",
   "*audioSaveDialog*MenuButton*borderWidth:       1",
   "*audioSaveDialog*sampFmtMenu.width:            250",
   "*audioSaveDialog*sampFmtMenu*SimpleMenu.width: 250",
   "*audioSaveDialog*chanMenu.width:               100",
   "*audioSaveDialog*chanMenu*SimpleMenu.width:    100",
   "*audioSaveDialog*rateMenu.width:               125",
   "*audioSaveDialog*rateMenu*SimpleMenu.width:    125",
   "*audioSaveDialog*actionForm*Command.width:     83",

   /*  "Audio Save Control" dialog strings */
   "*audioSaveDialog.title:                       FXTV Save Audio Control",
   "*audioSaveDialog.iconName:                    FXTV Save Audio Control",
   "*audioSaveDialog*fileBaseLabel.label:         Filename:",
   "*audioSaveDialog*fileFmtLabel.label:          File Format:",
   "*audioSaveDialog*fileFmtMenu*raw.label:       Raw",
   "*audioSaveDialog*fileFmtMenu*au.label:        AU",
   "*audioSaveDialog*fileFmtMenu*wav.label:       WAV",
   "*audioSaveDialog*fileFmtMenu*voc.label:       VOC",
   "*audioSaveDialog*fileFmtMenu*aiff.label:      AIFF",
   "*audioSaveDialog*fileFmtMenu*mp2.label:       MPEG-2",
   "*audioSaveDialog*fileFmtMenu*mp3.label:       MPEG-3",
   "*audioSaveDialog*sampFmtLabel.label:          Capture:",
   "*audioSaveDialog*sampFmtMenu*mulawU8.label:   8-bit  Mu-law",
   "*audioSaveDialog*sampFmtMenu*linS8.label:     8-bit  Signed",
   "*audioSaveDialog*sampFmtMenu*linU8.label:     8-bit  Unsigned",
   "*audioSaveDialog*sampFmtMenu*linS16LE.label:  16-bit Signed   (LSB)",
   "*audioSaveDialog*sampFmtMenu*linU16LE.label:  16-bit Unsigned (LSB)",
   "*audioSaveDialog*sampFmtMenu*linS16BE.label:  16-bit Unsigned (MSB)",
   "*audioSaveDialog*sampFmtMenu*linU16BE.label:  16-bit Signed   (MSB)",
   "*audioSaveDialog*chanMenu*mono.label:         Mono",
   "*audioSaveDialog*chanMenu*stereo.label:       Stereo",
   "*audioSaveDialog*rateMenu*r8012.label:        8,012  samp/s",
   "*audioSaveDialog*rateMenu*r11025.label:       11,025 samp/s",
   "*audioSaveDialog*rateMenu*r22050.label:       22,050 samp/s",
   "*audioSaveDialog*rateMenu*r44100.label:       44,100 samp/s",
   "*audioSaveDialog*recordCmd.label:             Record",
   "*audioSaveDialog*stopCmd.label:               Stop",
   "*audioSaveDialog*playbackCmd.label:           Playback",
   "*audioSaveDialog*dismissCmd.label:            Dismiss",

   /*  "Video Save Control" dialog appearance */
   "*videoSaveDialog*background:                   Gray71",
   "*videoSaveDialog*borderWidth:                  0",
   "*videoSaveDialog*groupBox.borderWidth:         1",
   "*videoSaveDialog*headerBox.vSpace:             0",
   "*videoSaveDialog*Command.width:                83",
   "*videoSaveDialog*Text*background:              Gray60",
   "*videoSaveDialog*Text*foreground:              Black",
   "*videoSaveDialog*Text.borderWidth:             1",
   "*videoSaveDialog*Text.width:                   150",
   "*videoSaveDialog*fpsText.width:                40",
   "*videoSaveDialog*MenuButton*borderWidth:       1",
   "*videoSaveDialog*Toggle.width:                 16",
   "*videoSaveDialog*Toggle.height:                16",
   "*videoSaveDialog*actionForm*Command.width:     83",
   "*videoSaveDialog*sampFmtMenu.width:            250",
   "*videoSaveDialog*sampFmtMenu*SimpleMenu.width: 250",
   "*videoSaveDialog*chanMenu.width:               100",
   "*videoSaveDialog*chanMenu*SimpleMenu.width:    100",
   "*videoSaveDialog*rateMenu.width:               125",
   "*videoSaveDialog*rateMenu*SimpleMenu.width:    125",
   "*videoSaveDialog*iFileFmtMenu*width:           150",
   "*videoSaveDialog*iFileFmtMenu*borderWidth:     1",
   "*videoSaveDialog*iFileFmtMenuBox.borderWidth:  0",
   "*videoSaveDialog*iFileFmtMenuBox*vSpace:       0",
   "*videoSaveDialog*fileFmtMenu*width:            150",
   "*videoSaveDialog*iCapFmtMenu*width:            150",
   "*videoSaveDialog*iCapFmtMenu*borderWidth:      1",
   "*videoSaveDialog*iCapFmtMenuBox.borderWidth:   0",
   "*videoSaveDialog*iCapFmtMenuBox*vSpace:        0",
   "*videoSaveDialog*iCapFmtMenuBox*hSpace:        0",

   /*  "Video Save Control" dialog strings */
   "*videoSaveDialog.title:                         FXTV Save Video Control",
   "*videoSaveDialog.iconName:                      FXTV Save Video Control",
   "*videoSaveDialog*audCapToggleLabel.label:       Enable",
   "*videoSaveDialog*imageCapLabel.label:           IMAGE CAPTURE",
   "*videoSaveDialog*fileBaseLabel.label:           Filename Base:",
   "*videoSaveDialog*resLabel.label:                Size:",
   "*videoSaveDialog*fpsLabel.label:                Speed (fps):",
   "*videoSaveDialog*optimizeCmd.label:             Optimize",
   "*videoSaveDialog*iCapFmtLabel.label:            Format:",
   "*videoSaveDialog*iCapFmtMenuBox*rgb16Cmd.label: RGB   (16bpp 565)",
   "*videoSaveDialog*iCapFmtMenuBox*iyuvCmd.label:  IYUV  (Pl,122:122)",
   "*videoSaveDialog*iCapFmtMenuBox*yuy2Cmd.label:  YUY2  (Pk,122:111)",
   "*videoSaveDialog*iCapFmtMenuBox*yuy2lCmd.label: YUY2l (Pl,122:111)",

   "*videoSaveDialog*targetLabel.label:             Target:",
   "*videoSaveDialog*fileFmtLabel.label:            Format:",
   "*videoSaveDialog*cleanupLabel.label:            Cleanup Temp Files",
   "*videoSaveDialog*fillFpsLabel.label:            MPEG Prep",

   "*videoSaveDialog*targetMenu*raw.label:          Raw",
   "*videoSaveDialog*targetMenu*images.label:       Images",
   "*videoSaveDialog*targetMenu*mpegready.label:    MPEG Ready",
   "*videoSaveDialog*targetMenu*mpeg.label:         MPEG",

   "*videoSaveDialog*imageEncLabel.label:           IMAGE ENCODE",
   "*videoSaveDialog*iFileFmtLabel.label:           Format:",
   "*videoSaveDialog*iFileFmtMenuBox*tiffCmd.label: TIFF",
   "*videoSaveDialog*iFileFmtMenuBox*ppmCmd.label:  PPM",
   "*videoSaveDialog*iFileFmtMenuBox*yuvCmd.label:  YUV",

   "*videoSaveDialog*audioCapLabel.label:           AUDIO CAPTURE",
   "*videoSaveDialog*fileFmtLabel.label:            Format:",
   "*videoSaveDialog*fileFmtMenu*raw.label:         Raw",
   "*videoSaveDialog*fileFmtMenu*au.label:          AU",
   "*videoSaveDialog*fileFmtMenu*wav.label:         WAV",
   "*videoSaveDialog*fileFmtMenu*voc.label:         VOC",
   "*videoSaveDialog*fileFmtMenu*aiff.label:        AIFF",
   "*videoSaveDialog*fileFmtMenu*mp2.label:         MPEG-2",
   "*videoSaveDialog*fileFmtMenu*mp3.label:         MPEG-3",
   "*videoSaveDialog*sampFmtLabel.label:            Format:",
   "*videoSaveDialog*sampFmtMenu*mulawU8.label:     8-bit  Mu-law",
   "*videoSaveDialog*sampFmtMenu*linS8.label:       8-bit  Signed",
   "*videoSaveDialog*sampFmtMenu*linU8.label:       8-bit  Unsigned",
   "*videoSaveDialog*sampFmtMenu*linS16LE.label:    16-bit Signed   (LSB)",
   "*videoSaveDialog*sampFmtMenu*linU16LE.label:    16-bit Unsigned (LSB)",
   "*videoSaveDialog*sampFmtMenu*linS16BE.label:    16-bit Unsigned (MSB)",
   "*videoSaveDialog*sampFmtMenu*linU16BE.label:    16-bit Signed   (MSB)",
   "*videoSaveDialog*chanMenu*mono.label:           Mono",
   "*videoSaveDialog*chanMenu*stereo.label:         Stereo",
   "*videoSaveDialog*rateMenu*r8012.label:          8,012  samp/s",
   "*videoSaveDialog*rateMenu*r11025.label:         11,025 samp/s",
   "*videoSaveDialog*rateMenu*r22050.label:         22,050 samp/s",
   "*videoSaveDialog*rateMenu*r44100.label:         44,100 samp/s",

   "*videoSaveDialog*audioEncLabel.label:           AUDIO ENCODE",

   "*videoSaveDialog*recordCmd.label:               Record",
   "*videoSaveDialog*stopCmd.label:                 Stop",
   "*videoSaveDialog*dismissCmd.label:              Dismiss",


   /*  "Simple Prompt Dialog" appearance */
   "*simplePromptShell*background:                   Gray71",
   "*simplePromptShell*borderWidth:                  0",
   "*simplePromptShell*Command.width:                100",

   /*  "Simple Prompt Dialog" dialog strings */
   "*simplePromptShell*yes.label:                    Yes",
   "*simplePromptShell*no.label:                     No",
   "*simplePromptShell*ok.label:                     Ok",
   "*simplePromptShell*cancel.label:                 Cancel",

   NULL
};

#endif  /*  ifdef DEFINE_APP_RESOURCES  */

#endif
