/*
 * tvaudio.h
 *
 * API for controlling the sound card audio parameters relevent to capture
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __TVAUDIO_H
#define __TVAUDIO_H

#include "tvtypes.h"

#define TV_VOLUME_MIN     5
#define TV_VOLUME_MAX    95

typedef enum {
            TV_AUDIO_SAMPLE_FMT_MULAW_U8,
            TV_AUDIO_SAMPLE_FMT_LIN_S8,
            TV_AUDIO_SAMPLE_FMT_LIN_U8,
            TV_AUDIO_SAMPLE_FMT_LIN_S16_LE,
            TV_AUDIO_SAMPLE_FMT_LIN_U16_LE,
            TV_AUDIO_SAMPLE_FMT_LIN_S16_BE,
            TV_AUDIO_SAMPLE_FMT_LIN_U16_BE,
            TV_NUM_AUDIO_SAMPLE_FMTS
        } TV_AUDIO_SAMPLE_FMT;

typedef struct {
    TV_BOOL              mute_on;
    TV_INT32             line_vol;                          /* 0-100 */

    int                  mixer_fd;
} TV_AUDIO;

typedef struct {
    TV_AUDIO_SAMPLE_FMT sample_fmt;
    TV_BOOL             stereo;
    TV_UINT32           sample_rate;
    TV_UINT8           *buf;
    TV_INT32            bytes;
} TV_SOUND;

#ifdef __cplusplus
extern "C" {
#endif

void TVAUDIOInit( TV_AUDIO *a );

void TVAUDIOResync( TV_BOOL update_gui );

void TVAUDIOGetMuteState( TV_BOOL      *mute_on );
void TVAUDIOSetMuteState( TV_BOOL       mute_on );

void TVAUDIOGetLineVolume( TV_INT32    *line_vol );
void TVAUDIOSetLineVolume( TV_INT32     line_vol,
                           TV_BOOL      update_slider );

void TVAUDIOSelectLineForRecord();

TV_BOOL TVAUDIOOpenDsp( TV_SOUND    *snd,
                        TV_BOOL      record,
                        int         *dsp_fd,
                        char       **error_msg );

TV_INT32 TVAUDIOGetSampleFmtBps( 
             TV_AUDIO_SAMPLE_FMT  fmt );

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif


#endif
