/*
 * tvdefines.h
 *
 * Misc compiler defines used across all source files.
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __TVDEFINES_H
#define __TVDEFINES_H

#include <stdio.h>
#include <stdlib.h>

static void *Alloc_ptr;

#ifdef MALLOC_DEBUG
#  define malloc(x) \
             ( Alloc_ptr = malloc(x), \
               printf( "malloc ( %6d ) = %p\n", (x), Alloc_ptr ), \
               Alloc_ptr )
                         
#  define realloc(p,x) \
             ( Alloc_ptr = realloc((p),(x)), \
               printf( "realloc( %p, %d ) = %p\n", (p),(x),Alloc_ptr ), \
               Alloc_ptr )
                         
#  define calloc(n,x) \
             ( Alloc_ptr = calloc((n),(x)), \
               printf( "calloc ( %d, %d ) = %p\n", (n),(x), Alloc_ptr ), \
               Alloc_ptr )

#  define free(p) \
             ( printf( "free( %6p )\n", (p) ), \
               free(p) )
#endif

#endif
