/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: execDialog.cpp,v 1.9 2005/04/17 21:58:55 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "execDialog.h"

#include <qdir.h>
#include <qregexp.h>
#include <qtimer.h>
#include <qtextbrowser.h>
#include <qpushbutton.h>

#if defined(Q_OS_WIN32)
#  include <stdio.h>
#  include <sys/timeb.h>
#  include <time.h>
#endif

#include <iostream>

using namespace std;

execDialog::execDialog(QWidget *parent,const QStringList &args, const QString &closeButtonText)
    : execDialog_q(parent), proc(parent)
{
    output->setWordWrap( QTextEdit::NoWrap );
    res=-1;

    if (! closeButtonText.isEmpty()) buttonOk->setText(closeButtonText);

    proc.setCommunication( QProcess::Stdout|QProcess::Stderr|QProcess::DupStderr);

    connect(&proc, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
    connect(&proc, SIGNAL(processExited()),   this, SLOT(processExited()) );

    proc.clearArguments();

    proc.setArguments( args );

    stopButton->hide();
}

void execDialog::readFromStdout()
{
//    output->append( proc.readStdout() );
    output->moveCursor( QTextEdit::MoveEnd , false );
    output->insert( proc.readStdout() );
}

void execDialog::stopProcess()
{
    proc.tryTerminate();
    QTimer::singleShot( 1000, &proc, SLOT( kill() ) );
}

void execDialog::processExited()
{
    stopButton->hide();
    buttonOk->setEnabled( true );
    buttonOk->setFocus();
    res=proc.exitStatus();
}

int execDialog::run()
{
    output->append( proc.arguments().join(" ") );
    output->append("\n");

    if ( !proc.start() )
    {
        output->append( tr("Error: Failed to start program") );
        return exec();
    }
    stopButton->show();
    stopButton->setFocus();
    buttonOk->setEnabled( false );
    exec();
    return res;
}
