/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: FWWindow.h,v 1.52.4.1 2005/09/04 20:49:14 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef  __FWWINDOW_H_
#define  __FWWINDOW_H_

#include "FWBMainWindow_q.h"
#include "RCS.h"

#include "fwbuilder/FWObject.h"

#include <qstring.h>

#include <vector>

namespace libfwbuilder {
    class FWObjectDatabase;
};

class QTabWidget;
class RuleSetView;
class QTimer;
class QPrinter;

class FWWindow : public FWBMainWindow_q {

    Q_OBJECT

    RCS                                    *rcs;
    bool                                    systemFile;
    bool                                    editingStandardLib;
    bool                                    editingTemplateLib;

    std::vector<libfwbuilder::FWObject*>    firewalls;
    std::map<libfwbuilder::FWObject*, RuleSetView*> ruleSetViews;

    libfwbuilder::FWObject                 *visibleFirewall;
    libfwbuilder::FWObjectDatabase         *objdb;

    QTimer                                 *autosaveTimer;
    QString                                 noFirewalls;
    QPrinter                               *printer;
    
    void clearFirewallTabs();

 public slots:

     virtual void search();

     virtual void openFirewall( int idx );
     virtual void reopenFirewall();
     virtual void deleteFirewall(libfwbuilder::FWObject *fw);
     virtual void changeInfoStyle();

     virtual void fileNew();
     virtual void fileOpen();
     virtual void fileClose();
     virtual void fileSave();
     virtual void fileSaveAs();
     virtual void fileDiscard();
     virtual void fileCommit();
     virtual void fileImport();
     virtual void fileExport();
     virtual void filePrint();
     virtual void fileExit();
     virtual void fileProp();
     virtual void fileAddToRCS();
     virtual void editCopy();
     virtual void editCut();
     virtual void editDelete();
     virtual void editPaste();
     virtual void editPrefs();

     virtual void helpAbout();
     virtual void debug();
     
     virtual void compile();
     virtual void install();

     virtual void insertRule();
     virtual void addRuleAfterCurrent();
     virtual void moveRule();
     virtual void moveRuleUp();
     virtual void moveRuleDown();
     virtual void removeRule(); 

     virtual void copyRule();
     virtual void cutRule();
     virtual void pasteRuleAbove();
     virtual void pasteRuleBelow();

     virtual void newObject();
     
 public:
    
    FWWindow();
    ~FWWindow();

    virtual void closeEvent( QCloseEvent * );
    
        
    void load(QWidget *dialogs_parent,RCS *rcs);
    void load(QWidget *dialogs_parent);
    void loadLibrary(const std::string &libfpath);
    void save();
    bool checkin(bool unlock);
    void showFirewalls();
    void showFirewall(libfwbuilder::FWObject *f);
    void addFirewallToList(libfwbuilder::FWObject *f);
    void removeFirewallFromList(libfwbuilder::FWObject *f);
    int  findFirewallInList(libfwbuilder::FWObject *f);

    bool editingLibrary();

    void ensureObjectVisible(libfwbuilder::FWReference *obj);

    QString chooseNewFileName(const QString &fname,
                              bool checkPresence, const QString &title);
    void setFileName(const QString &fname);
    
    bool saveIfModified();
    
    void updateFirewallName(libfwbuilder::FWObject *obj,const QString &oldName);
    void updateRuleSetView();
    void updateRuleOptions();
    
    /**
     * unselects whatever is selected in policy
     */
    void unselectRules();

    /**
     * selects whatever is current in rules
     */
    void selectRules();

    libfwbuilder::FWObjectDatabase* db() { return objdb; }

    libfwbuilder::FWObject* getVisibleFirewall() { return visibleFirewall; }

    void info(libfwbuilder::FWObject *o);
    int  doCompile(const QString &closeButtonText="");

    void setupAutoSave();
    
 protected:

    virtual void showEvent( QShowEvent *ev);
    virtual void hideEvent( QHideEvent *ev);
    
};

#endif


