/* options.c: options dialog boxes
   Copyright (c) 2001-2004 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef USE_WIDGET

#include <stdio.h>

#include "display.h"
#include "fuse.h"
#include "options.h"
#include "periph.h"
#include "widget_internals.h"

static int widget_general_show_all( settings_info *show );

int widget_general_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 12 );
  error = widget_general_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 12 );

  return 0;
}

static int widget_general_show_all( settings_info *show )
{
  int error;

  widget_printstring( 9, 2, WIDGET_COLOUR_FOREGROUND, "General Options" );

  error = widget_options_print_entry( 0, "(E)mulation speed",
				      show->emulation_speed,
				      "%" );
  if( error ) return error;
  error = widget_options_print_entry( 1, "F(r)ame rate (1:n)",
				      show->frame_rate,
				      "frames" );
  if( error ) return error;
  error = widget_options_print_option( 2, "Issue (2) Keyboard",
				       show->issue2 );
  if( error ) return error;

  error = widget_options_print_option( 3, "Use (t)ape traps",
				       show->tape_traps );
  if( error ) return error;

  error = widget_options_print_option( 4, "(A)uto-load media",
				       show->auto_load );
  if( error ) return error;

  error = widget_options_print_option( 5, "Save snaps as .(z)80",
				       show->snaps_as_z80 );
  if( error ) return error;

  error = widget_options_print_option( 6, "Use .(s)lt traps",
				       show->slt_traps );
  if( error ) return error;

  error = widget_options_print_option( 7, "Allow (w)rites to ROM",
				       show->writable_roms );
  if( error ) return error;

  error = widget_options_print_option( 8, "A(u)to-save settings",
				       show->autosave_settings );
  if( error ) return error;

  error = widget_options_print_option( 9, "Black and white T(V)",
				       show->bw_tv );
  if( error ) return error;

  error = widget_options_print_option( 10, "(C)onfirm actions",
				       show->confirm_actions );
  if( error ) return error;

  error = widget_options_print_option( 11, "Show status(b)ar",
				       show->statusbar );
  if( error ) return error;

  return 0;
}

void
widget_general_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 12 );
    widget_general_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_e:
    text_data.title = "Emulation speed";
    snprintf( text_data.text, 40, "%d",
	      widget_options_settings.emulation_speed );
    error = widget_do( WIDGET_TYPE_TEXT, &text_data ); if( error ) return;
    if( widget_text_text ) {
      widget_options_settings.emulation_speed = atoi( widget_text_text );
      error = widget_options_print_entry(
        0, "(E)mulation speed",
	widget_options_settings.emulation_speed, "%"
      );
    }
	    
    break;

  case INPUT_KEY_r:
    text_data.title = "Frame rate 1:n";
    snprintf( text_data.text, 40, "%d",
	      widget_options_settings.frame_rate );
    error = widget_do( WIDGET_TYPE_TEXT, &text_data ); if( error ) return;
    if( widget_text_text ) {
      widget_options_settings.frame_rate = atoi( widget_text_text );
      error = widget_options_print_entry(
        1, "F(r)ame rate (1:n)",
	widget_options_settings.frame_rate, "frames"
      );
    }
	    
    break;

  case INPUT_KEY_2:
    widget_options_settings.issue2 = ! widget_options_settings.issue2;
    error = widget_options_print_value( 2, widget_options_settings.issue2 );
    if( error ) return;
    break;

  case INPUT_KEY_t:
    widget_options_settings.tape_traps = ! widget_options_settings.tape_traps;
    error = widget_options_print_value( 3, widget_options_settings.tape_traps );
    if( error ) return;
    break;

  case INPUT_KEY_a:
    widget_options_settings.auto_load = ! widget_options_settings.auto_load;
    error = widget_options_print_value( 4, widget_options_settings.auto_load );
    if( error ) return;
    break;

  case INPUT_KEY_z:
    widget_options_settings.snaps_as_z80 = ! widget_options_settings.snaps_as_z80;
    error = widget_options_print_value( 5, widget_options_settings.snaps_as_z80 );
    if( error ) return;
    break;

  case INPUT_KEY_s:
    widget_options_settings.slt_traps = ! widget_options_settings.slt_traps;
    error = widget_options_print_value( 6, widget_options_settings.slt_traps );
    if( error ) return;
    break;

  case INPUT_KEY_w:
    widget_options_settings.writable_roms = ! widget_options_settings.writable_roms;
    error = widget_options_print_value( 7, widget_options_settings.writable_roms );
    if( error ) return;
    break;

  case INPUT_KEY_u:
    widget_options_settings.autosave_settings = ! widget_options_settings.autosave_settings;
    error = widget_options_print_value( 8, widget_options_settings.autosave_settings );
    if( error ) return;
    break;

  case INPUT_KEY_v:
    widget_options_settings.bw_tv = ! widget_options_settings.bw_tv;
    error = widget_options_print_value( 9, widget_options_settings.bw_tv );
    if( error ) return;
    break;

  case INPUT_KEY_c:
    widget_options_settings.confirm_actions = ! widget_options_settings.confirm_actions;
    error = widget_options_print_value( 10, widget_options_settings.confirm_actions );
    if( error ) return;
    break;

  case INPUT_KEY_b:
    widget_options_settings.statusbar = ! widget_options_settings.statusbar;
    error = widget_options_print_value( 11, widget_options_settings.statusbar );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
static int widget_peripherals_show_all( settings_info *show );

int widget_peripherals_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 9 );
  error = widget_peripherals_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 9 );

  return 0;
}

static int widget_peripherals_show_all( settings_info *show )
{
  int error;

  widget_printstring( 7, 2, WIDGET_COLOUR_FOREGROUND, "Peripheral Options" );

  error = widget_options_print_option( 0, "(K)empston joystick",
				       show->joy_kempston );
  if( error ) return error;

  error = widget_options_print_option( 1, "(I)nterface II",
				       show->interface2 );
  if( error ) return error;

  error = widget_options_print_option( 2, "Emulate (p)rinters",
				       show->printer );
  if( error ) return error;

  error = widget_options_print_option( 3, "Simple (8)-bit IDE",
				       show->simpleide_active );
  if( error ) return error;

  error = widget_options_print_option( 4, "(Z)XATASP interface",
				       show->zxatasp_active );
  if( error ) return error;

  error = widget_options_print_option( 5, "ZXATASP (u)pload",
				       show->zxatasp_upload );
  if( error ) return error;

  error = widget_options_print_option( 6, "ZXATASP (w)rite protect",
				       show->zxatasp_wp );
  if( error ) return error;

  error = widget_options_print_option( 7, "ZX(C)F interface",
				       show->zxcf_active );
  if( error ) return error;

  error = widget_options_print_option( 8, "ZXCF up(l)oad",
				       show->zxcf_upload );
  if( error ) return error;

  return 0;
}

void
widget_peripherals_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 9 );
    widget_peripherals_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_k:
    widget_options_settings.joy_kempston = ! widget_options_settings.joy_kempston;
    error = widget_options_print_value( 0, widget_options_settings.joy_kempston );
    if( error ) return;
    break;

  case INPUT_KEY_i:
    widget_options_settings.interface2 = ! widget_options_settings.interface2;
    error = widget_options_print_value( 1, widget_options_settings.interface2 );
    if( error ) return;
    break;

  case INPUT_KEY_p:
    widget_options_settings.printer = ! widget_options_settings.printer;
    error = widget_options_print_value( 2, widget_options_settings.printer );
    if( error ) return;
    break;

  case INPUT_KEY_8:
    widget_options_settings.simpleide_active = ! widget_options_settings.simpleide_active;
    error = widget_options_print_value( 3, widget_options_settings.simpleide_active );
    if( error ) return;
    break;

  case INPUT_KEY_z:
    widget_options_settings.zxatasp_active = ! widget_options_settings.zxatasp_active;
    error = widget_options_print_value( 4, widget_options_settings.zxatasp_active );
    if( error ) return;
    break;

  case INPUT_KEY_u:
    widget_options_settings.zxatasp_upload = ! widget_options_settings.zxatasp_upload;
    error = widget_options_print_value( 5, widget_options_settings.zxatasp_upload );
    if( error ) return;
    break;

  case INPUT_KEY_w:
    widget_options_settings.zxatasp_wp = ! widget_options_settings.zxatasp_wp;
    error = widget_options_print_value( 6, widget_options_settings.zxatasp_wp );
    if( error ) return;
    break;

  case INPUT_KEY_c:
    widget_options_settings.zxcf_active = ! widget_options_settings.zxcf_active;
    error = widget_options_print_value( 7, widget_options_settings.zxcf_active );
    if( error ) return;
    break;

  case INPUT_KEY_l:
    widget_options_settings.zxcf_upload = ! widget_options_settings.zxcf_upload;
    error = widget_options_print_value( 8, widget_options_settings.zxcf_upload );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    periph_update();
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
static int widget_rzx_show_all( settings_info *show );

int widget_rzx_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 4 );
  error = widget_rzx_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 4 );

  return 0;
}

static int widget_rzx_show_all( settings_info *show )
{
  int error;

  widget_printstring( 11, 2, WIDGET_COLOUR_FOREGROUND, "RZX Options" );

  error = widget_options_print_option( 0, "(C)ompress RZX data",
				       show->rzx_compression );
  if( error ) return error;

  error = widget_options_print_option( 1, "C(o)mpetition mode",
				       show->competition_mode );
  if( error ) return error;

  error = widget_options_print_entry( 2, "Co(m)petition code",
				      show->competition_code,
				      "" );
  if( error ) return error;
  error = widget_options_print_option( 3, "Always (e)mbed snapshot",
				       show->embed_snapshot );
  if( error ) return error;

  return 0;
}

void
widget_rzx_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 4 );
    widget_rzx_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_c:
    widget_options_settings.rzx_compression = ! widget_options_settings.rzx_compression;
    error = widget_options_print_value( 0, widget_options_settings.rzx_compression );
    if( error ) return;
    break;

  case INPUT_KEY_o:
    widget_options_settings.competition_mode = ! widget_options_settings.competition_mode;
    error = widget_options_print_value( 1, widget_options_settings.competition_mode );
    if( error ) return;
    break;

  case INPUT_KEY_m:
    text_data.title = "Competition code";
    snprintf( text_data.text, 40, "%d",
	      widget_options_settings.competition_code );
    error = widget_do( WIDGET_TYPE_TEXT, &text_data ); if( error ) return;
    if( widget_text_text ) {
      widget_options_settings.competition_code = atoi( widget_text_text );
      error = widget_options_print_entry(
        2, "Co(m)petition code",
	widget_options_settings.competition_code, ""
      );
    }
	    
    break;

  case INPUT_KEY_e:
    widget_options_settings.embed_snapshot = ! widget_options_settings.embed_snapshot;
    error = widget_options_print_value( 3, widget_options_settings.embed_snapshot );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
static int widget_sound_show_all( settings_info *show );

int widget_sound_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 5 );
  error = widget_sound_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 5 );

  return 0;
}

static int widget_sound_show_all( settings_info *show )
{
  int error;

  widget_printstring( 10, 2, WIDGET_COLOUR_FOREGROUND, "Sound Options" );

  error = widget_options_print_option( 0, "(S)ound enabled",
				       show->sound );
  if( error ) return error;

  error = widget_options_print_option( 1, "(L)oading sound",
				       show->sound_load );
  if( error ) return error;

  error = widget_options_print_option( 2, "(A)Y stereo separation",
				       show->stereo_ay );
  if( error ) return error;

  error = widget_options_print_option( 3, "(B)eeper pseudo-stereo",
				       show->stereo_beeper );
  if( error ) return error;

  error = widget_options_print_option( 4, "(F)orce 8-bit",
				       show->sound_force_8bit );
  if( error ) return error;

  return 0;
}

void
widget_sound_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 5 );
    widget_sound_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_s:
    widget_options_settings.sound = ! widget_options_settings.sound;
    error = widget_options_print_value( 0, widget_options_settings.sound );
    if( error ) return;
    break;

  case INPUT_KEY_l:
    widget_options_settings.sound_load = ! widget_options_settings.sound_load;
    error = widget_options_print_value( 1, widget_options_settings.sound_load );
    if( error ) return;
    break;

  case INPUT_KEY_a:
    widget_options_settings.stereo_ay = ! widget_options_settings.stereo_ay;
    error = widget_options_print_value( 2, widget_options_settings.stereo_ay );
    if( error ) return;
    break;

  case INPUT_KEY_b:
    widget_options_settings.stereo_beeper = ! widget_options_settings.stereo_beeper;
    error = widget_options_print_value( 3, widget_options_settings.stereo_beeper );
    if( error ) return;
    break;

  case INPUT_KEY_f:
    widget_options_settings.sound_force_8bit = ! widget_options_settings.sound_force_8bit;
    error = widget_options_print_value( 4, widget_options_settings.sound_force_8bit );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}

#endif				/* #ifdef USE_WIDGET */
