/* options.c: options dialog boxes
   Copyright (c) 2001-2002 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef UI_GTK		/* Use this file iff we're using GTK+ */

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "fuse.h"
#include "settings.h"
#include "gtkui.h"

static void gtkoptions_general_done( GtkWidget *widget, gpointer user_data );

void gtkoptions_general( GtkWidget *widget, gpointer data )
{
  gtkoptions_general_t dialog;
  GtkWidget *ok_button, *cancel_button;
  
  /* Firstly, stop emulation */
  fuse_emulation_pause();

  /* Create the necessary widgets */
  dialog.dialog = gtk_dialog_new();
  gtk_window_set_title( GTK_WINDOW( dialog.dialog ), "Fuse - General Options" );

  /* Create the various widgets */
  dialog.issue2 =
    gtk_check_button_new_with_label( "Issue 2 Keyboard" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.issue2 ),
				settings_current.issue2 );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.issue2 );

  dialog.joy_kempston =
    gtk_check_button_new_with_label( "Kempston joystick" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.joy_kempston ),
				settings_current.joy_kempston );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.joy_kempston );

  dialog.tape_traps =
    gtk_check_button_new_with_label( "Use tape traps" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.tape_traps ),
				settings_current.tape_traps );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.tape_traps );

  dialog.slt_traps =
    gtk_check_button_new_with_label( "Use .slt traps" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.slt_traps ),
				settings_current.slt_traps );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.slt_traps );

  /* Create the OK and Cancel buttons */
  ok_button = gtk_button_new_with_label( "OK" );
  cancel_button = gtk_button_new_with_label( "Cancel" );

  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     ok_button );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     cancel_button );

  /* Add the necessary callbacks */
  gtk_signal_connect( GTK_OBJECT( ok_button ), "clicked",
		      GTK_SIGNAL_FUNC( gtkoptions_general_done ),
		      (gpointer) &dialog );
  gtk_signal_connect_object( GTK_OBJECT( cancel_button ), "clicked",
			     GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
			     GTK_OBJECT( dialog.dialog ) );
  gtk_signal_connect( GTK_OBJECT( dialog.dialog ), "delete_event",
		      GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
		      (gpointer) NULL );

  /* Allow Esc to cancel */
  gtk_widget_add_accelerator( cancel_button, "clicked",
                              gtk_accel_group_get_default(),
                              GDK_Escape, 0, 0 );

  /* Set the window to be modal and display it */
  gtk_window_set_modal( GTK_WINDOW( dialog.dialog ), TRUE );
  gtk_widget_show_all( dialog.dialog );

  /* Process events until the window is done with */
  gtk_main();

  /* And then carry on with emulation again */
  fuse_emulation_unpause();
}

static void gtkoptions_general_done( GtkWidget *widget, gpointer user_data )
{
  gtkoptions_general_t *ptr = (gtkoptions_general_t*)user_data;

  settings_current.issue2 =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->issue2 ) );

  settings_current.joy_kempston =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->joy_kempston ) );

  settings_current.tape_traps =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->tape_traps ) );

  settings_current.slt_traps =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->slt_traps ) );

  gtk_widget_destroy( ptr->dialog );

  gtk_main_quit();
}

static void gtkoptions_sound_done( GtkWidget *widget, gpointer user_data );

void gtkoptions_sound( GtkWidget *widget, gpointer data )
{
  gtkoptions_sound_t dialog;
  GtkWidget *ok_button, *cancel_button;
  
  /* Firstly, stop emulation */
  fuse_emulation_pause();

  /* Create the necessary widgets */
  dialog.dialog = gtk_dialog_new();
  gtk_window_set_title( GTK_WINDOW( dialog.dialog ), "Fuse - Sound Options" );

  /* Create the various widgets */
  dialog.sound =
    gtk_check_button_new_with_label( "Sound enabled" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.sound ),
				settings_current.sound );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.sound );

  dialog.sound_load =
    gtk_check_button_new_with_label( "Loading sound" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.sound_load ),
				settings_current.sound_load );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.sound_load );

  dialog.stereo_ay =
    gtk_check_button_new_with_label( "AY stereo separation" );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( dialog.stereo_ay ),
				settings_current.stereo_ay );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->vbox ),
		     dialog.stereo_ay );

  /* Create the OK and Cancel buttons */
  ok_button = gtk_button_new_with_label( "OK" );
  cancel_button = gtk_button_new_with_label( "Cancel" );

  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     ok_button );
  gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog.dialog )->action_area ),
		     cancel_button );

  /* Add the necessary callbacks */
  gtk_signal_connect( GTK_OBJECT( ok_button ), "clicked",
		      GTK_SIGNAL_FUNC( gtkoptions_sound_done ),
		      (gpointer) &dialog );
  gtk_signal_connect_object( GTK_OBJECT( cancel_button ), "clicked",
			     GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
			     GTK_OBJECT( dialog.dialog ) );
  gtk_signal_connect( GTK_OBJECT( dialog.dialog ), "delete_event",
		      GTK_SIGNAL_FUNC( gtkui_destroy_widget_and_quit ),
		      (gpointer) NULL );

  /* Allow Esc to cancel */
  gtk_widget_add_accelerator( cancel_button, "clicked",
                              gtk_accel_group_get_default(),
                              GDK_Escape, 0, 0 );

  /* Set the window to be modal and display it */
  gtk_window_set_modal( GTK_WINDOW( dialog.dialog ), TRUE );
  gtk_widget_show_all( dialog.dialog );

  /* Process events until the window is done with */
  gtk_main();

  /* And then carry on with emulation again */
  fuse_emulation_unpause();
}

static void gtkoptions_sound_done( GtkWidget *widget, gpointer user_data )
{
  gtkoptions_sound_t *ptr = (gtkoptions_sound_t*)user_data;

  settings_current.sound =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->sound ) );

  settings_current.sound_load =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->sound_load ) );

  settings_current.stereo_ay =
    gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( ptr->stereo_ay ) );

  gtk_widget_destroy( ptr->dialog );

  gtk_main_quit();
}

#endif			/* #ifdef UI_GTK */
