#!/usr/bin/perl -w

# keysyms.pl: generate keysyms.c from keysyms.dat
# Copyright (c) 2000-2001 Philip Kendall, Matan Ziv-Av, Russell Marks

# $Id: keysyms.pl,v 1.5 2001/11/28 19:07:56 pak21 Exp $

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

# Author contact information:

# E-mail: pak21-fuse@srcf.ucam.org
# Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

use strict;

# Some keysyms which don't easily do the Xlib -> SVGAlib conversion
my %svga_keysyms = (

    CAPS_LOCK  => 'CAPSLOCK',
    NUMBERSIGN => 'BACKSLASH',	# That's what `#' returns on a UK keyboard!
    RETURN     => 'ENTER',

    LEFT       => 'CURSORBLOCKLEFT',
    DOWN       => 'CURSORBLOCKDOWN',
    UP         => 'CURSORBLOCKUP',
    RIGHT      => 'CURSORBLOCKRIGHT',

);

my @keys;
while(<>) {

    next if /^\s*$/;
    next if /^\s*\#/;

    chomp;

    my( $keysym, $key1, $key2 ) = split /\s*,\s*/;

    push @keys, [ $keysym, $key1, $key2 ]

}

print << "CODE";
/* keysyms.c: keysym to Spectrum key mappings for both Xlib and GDK
   Copyright (c) 2000-2001 Philip Kendall, Matan Ziv-Av, Russell Marks

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse\@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from keysyms.dat by keysyms.pl.
   Do not edit unless you know what you\'re doing! */

#include <config.h>

#include <stdlib.h>

#include "keysyms.h"

/* Work out which UI we\'re using and get the appropriate header file. As
   GTK+ and Xlib use the same keysyms (only the prefix is different), define
   a small macro to mean I don\'t have to repeat the table...

   However, the svgalib keysyms are different enough that I need a separate
   table.

*/
#if defined( UI_GTK )
#include <gdk/gdkkeysyms.h>
#define KEY(keysym) GDK_ ## keysym
#elif defined( UI_X )
#include <X11/keysym.h>
#define KEY(keysym) XK_ ## keysym
#elif defined( UI_SVGA )
#include <vgakeyboard.h>
#elif defined( UI_FB )
#elif defined( UI_AALIB )
#else
#error No user interface selected
#endif

/* The mappings from keysyms to Spectrum keys. The keysym \`keysym\'
   maps to one or two Spectrum keys, specified by one of the
   keyboard_key_name enum (keyboard.h); unused keys are specified
   by KEYBOARD_NONE.

   These mappings are ordered basically like a standard (English) PC keyboard,
   top to bottom, left to right, but with a few additions for other keys
*/

#if defined( UI_GTK ) || defined( UI_X )

static keysyms_key_info keysyms_data[] = {

CODE

foreach( @keys ) {

    my( $keysym, $key1, $key2 ) = @$_;

    printf "  { KEY(%-12s , KEYBOARD_%-9s KEYBOARD_%-6s },\n",
      "$keysym)", "$key1,", $key2;
}

print << "CODE";

  { 0, 0, 0 }                   /* End marker: DO NOT MOVE! */

};

#elif defined( UI_SVGA )        /* #if defined( UI_GTK ) || defined( UI_X ) */

static keysyms_key_info keysyms_data[] = {

CODE

foreach( @keys ) {

    my( $keysym, $key1, $key2 ) = @$_;

    # svgalib doesn't believe in these keys
    next if( $keysym =~ /^Super_/ or $keysym =~ /^Hyper_/ );

    # General translations

    $keysym =~ tr/a-z/A-Z/;
    $keysym =~ s/(.*)_L$/LEFT$1/;
    $keysym =~ s/(.*)_R$/RIGHT$1/;
    $keysym =~ s/META$/WIN/;		# Fairly sensible mapping
    $keysym =~ s/^PAGE_/PAGE/;

    # Some specific translations
    $keysym = $svga_keysyms{$keysym} if $svga_keysyms{$keysym};

    # All the magic #defines start with `SCANCODE_'
    $keysym = "SCANCODE_$keysym";
    
    # Apart from this one :-)
    $keysym =~ s/SCANCODE_MODE_SWITCH/127/; # `Menu' key

    if( $keysym =~ /WIN$/ ) {
	print "#ifdef $keysym\n";
    }

    printf "  { %-25s , KEYBOARD_%-9s KEYBOARD_%-6s },\n",
      $keysym, "$key1,", $key2;

    if( $keysym =~ /WIN$/ ) {
        print "#endif                          /* #ifdef $keysym */\n";
    }

}

print << "CODE";

  { 0, 0, 0 }                   /* End marker: DO NOT MOVE! */

};

#elif defined( UI_FB )

static keysyms_key_info keysyms_data[] = {

  { 1<<9                  , KEYBOARD_0,     KEYBOARD_NONE },
  { 1<<10                 , KEYBOARD_Enter, KEYBOARD_NONE },
  { 1<<11                 , KEYBOARD_p,     KEYBOARD_NONE },
  { 1<<12                 , KEYBOARD_q,     KEYBOARD_NONE },

  { 0, 0, 0 }                   /* End marker: DO NOT MOVE! */

};

#elif defined( UI_AALIB )

static keysyms_key_info keysyms_data[] = {

  { 0x31                  , KEYBOARD_1,     KEYBOARD_NONE },
  { 0x32                  , KEYBOARD_2,     KEYBOARD_NONE },
  { 0x33                  , KEYBOARD_3,     KEYBOARD_NONE },
  { 0x34                  , KEYBOARD_4,     KEYBOARD_NONE },
  { 0x35                  , KEYBOARD_5,     KEYBOARD_NONE },
  { 0x36                  , KEYBOARD_6,     KEYBOARD_NONE },
  { 0x37                  , KEYBOARD_7,     KEYBOARD_NONE },
  { 0x38                  , KEYBOARD_8,     KEYBOARD_NONE },
  { 0x39                  , KEYBOARD_9,     KEYBOARD_NONE },
  { 0x30                  , KEYBOARD_0,     KEYBOARD_NONE },

  { 0, 0, 0 }                   /* End marker: DO NOT MOVE! */

};

#endif                          /* #if defined( UI_GTK ) || defined( UI_X ) */

keysyms_key_info* keysyms_get_data(unsigned keysym)
{
  keysyms_key_info *ptr;

  for( ptr=keysyms_data; ptr->keysym; ptr++ ) {
    if(keysym==ptr->keysym) {
      return ptr;
    }
  }

  return NULL;

}
CODE
